/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.doremikkokeyboard;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;

public class DoremikkoKeyboardMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][] KEYS = new int[][]{{1, 0}, {2, 2}, {4, 0}, {5, 2}, {7, 0}, {8, 2}, {10, 1}, {13, 0}, {14, 2}, {16, 0}, {17, 2}, {19, 1}};
    private long keys;
    private int register;
    private int part;
    private boolean mode;

    @Override
    public int getInputDevice() {
        return 13;
    }

    @Override
    public void update(int buttons) {
        int value = (buttons & 0xFFFF0000) >>> 14 | (buttons & 0xC00) >>> 10;
        this.keys = Integer.bitCount(value) > 8 ? this.keys & 0x3FFFFL | (long)(~value & 0x3FFFF) << 18 : this.keys & 0xFFFFC0000L | (long)value;
    }

    @Override
    public void writePort(int value) {
        if ((value & 2) > (this.register & 2)) {
            this.part = 0;
            this.mode = false;
        }
        if ((value & 1) > (this.register & 1)) {
            ++this.part;
            this.mode = false;
        }
        this.register = value;
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            int value = this.peekPort(1);
            this.mode = !this.mode;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (portIndex == 1) {
            int value;
            switch (this.part) {
                case 1: {
                    if (this.mode) {
                        value = (int)((this.keys & 3L) << 1);
                        break;
                    }
                    value = 0;
                    break;
                }
                case 2: {
                    if (this.mode) {
                        value = (int)((this.keys & 0xC0L) >> 5);
                        break;
                    }
                    value = (int)((this.keys & 0x3CL) >> 1);
                    break;
                }
                case 3: {
                    if (this.mode) {
                        value = (int)((this.keys & 0x3000L) >> 11);
                        break;
                    }
                    value = (int)((this.keys & 0xF00L) >> 7);
                    break;
                }
                case 4: {
                    if (this.mode) {
                        value = (int)((this.keys & 0xC0000L) >> 17);
                        break;
                    }
                    value = (int)((this.keys & 0x3C000L) >> 13);
                    break;
                }
                case 5: {
                    if (this.mode) {
                        value = (int)((this.keys & 0x3000000L) >> 23);
                        break;
                    }
                    value = (int)((this.keys & 0xF00000L) >> 19);
                    break;
                }
                case 6: {
                    if (this.mode) {
                        value = (int)((this.keys & 0xC0000000L) >> 29);
                        break;
                    }
                    value = (int)((this.keys & 0x3C000000L) >> 25);
                    break;
                }
                case 7: {
                    if (this.mode) {
                        value = 0;
                        break;
                    }
                    value = (int)((this.keys & 0xF00000000L) >> 31);
                    break;
                }
                default: {
                    value = 0;
                }
            }
            return value;
        }
        return 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 160;
        int y = 208;
        InputIcons.Doremikko.render(screen, 160, 208);
        long k = this.keys;
        int o = 0;
        int offset = 0;
        int i = 0;
        while (i < 36) {
            if ((k & 1L) == 1L) {
                int T = KEYS[o][1];
                (T == 0 ? InputIcons.DoremikkoWhite1 : (T == 1 ? InputIcons.DoremikkoWhite2 : InputIcons.DoremikkoBlack)).render(screen, 160 + offset + KEYS[o][0], 209);
            }
            if (o == 11) {
                o = 0;
                offset += 21;
            } else {
                ++o;
            }
            ++i;
            k >>= 1;
        }
    }
}

