/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.dongda;

import java.awt.Toolkit;
import java.io.Serializable;
import nintaco.Machine;
import nintaco.input.DeviceMapper;
import nintaco.input.dongda.DongdaPEC586KeyboardDescriptor;
import nintaco.input.icons.InputIcons;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class DongdaPEC586KeyboardMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][][] KEYS = new int[][][]{new int[][]{{2, 2, 0}}, new int[][]{{14, 18, 2}}, (int[][])null, new int[][]{{2, 12, 4}}, new int[][]{{2, 18, 3}, {43, 18, 3}}, new int[][]{{2, 6, 0}}, new int[][]{{2, 9, 3}}, new int[][]{{2, 15, 5}, {41, 15, 5}}, new int[][]{{24, 2, 0}}, new int[][]{{27, 2, 0}}, new int[][]{{21, 2, 0}}, new int[][]{{16, 2, 0}}, new int[][]{{30, 2, 0}}, new int[][]{{10, 2, 0}}, new int[][]{{7, 2, 0}}, new int[][]{{13, 2, 0}}, new int[][]{{41, 6, 0}}, new int[][]{{58, 18, 5}}, new int[][]{{64, 18, 0}}, new int[][]{{7, 12, 0}}, new int[][]{{40, 9, 1}}, new int[][]{{5, 6, 0}}, new int[][]{{6, 9, 0}}, new int[][]{{8, 15, 0}}, (int[][])null, new int[][]{{64, 15, 0}}, new int[][]{{64, 12, 0}}, new int[][]{{10, 12, 0}}, new int[][]{{64, 9, 0}}, new int[][]{{8, 6, 0}}, new int[][]{{9, 9, 0}}, new int[][]{{11, 15, 0}}, new int[][]{{35, 15, 0}}, new int[][]{{61, 15, 0}}, new int[][]{{61, 12, 0}}, new int[][]{{13, 12, 0}}, new int[][]{{61, 9, 0}}, new int[][]{{11, 6, 0}}, new int[][]{{12, 9, 0}}, new int[][]{{14, 15, 0}}, new int[][]{{54, 2, 0}}, new int[][]{{58, 15, 0}}, new int[][]{{58, 12, 0}}, new int[][]{{16, 12, 0}}, new int[][]{{58, 9, 0}}, new int[][]{{14, 6, 0}}, new int[][]{{15, 9, 0}}, new int[][]{{17, 15, 0}}, new int[][]{{44, 6, 0}}, new int[][]{{41, 6, 0}}, new int[][]{{67, 15, 6}}, new int[][]{{19, 12, 0}}, new int[][]{{39, 9, 0}}, new int[][]{{17, 6, 0}}, new int[][]{{18, 9, 0}}, new int[][]{{20, 15, 0}}, new int[][]{{29, 6, 0}}, new int[][]{{32, 15, 0}}, new int[][]{{31, 12, 0}}, new int[][]{{28, 12, 0}}, new int[][]{{30, 9, 0}}, new int[][]{{26, 6, 0}}, new int[][]{{27, 9, 0}}, new int[][]{{29, 15, 0}}, new int[][]{{32, 6, 0}}, (int[][])null, new int[][]{{34, 12, 0}}, new int[][]{{25, 12, 0}}, new int[][]{{33, 9, 0}}, new int[][]{{23, 6, 0}}, new int[][]{{24, 9, 0}}, new int[][]{{26, 15, 0}}, new int[][]{{35, 6, 0}}, (int[][])null, new int[][]{{37, 12, 0}}, new int[][]{{22, 12, 0}}, new int[][]{{36, 9, 0}}, new int[][]{{20, 6, 0}}, new int[][]{{21, 9, 0}}, new int[][]{{23, 15, 0}}, new int[][]{{41, 2, 0}}, new int[][]{{44, 2, 0}}, new int[][]{{38, 2, 0}}, (int[][])null, (int[][])null, new int[][]{{35, 2, 0}}, (int[][])null, (int[][])null, new int[][]{{51, 15, 0}}, new int[][]{{54, 18, 0}}, new int[][]{{51, 18, 0}}, new int[][]{{54, 9, 0}}, new int[][]{{48, 18, 0}}, new int[][]{{64, 6, 0}}, new int[][]{{67, 6, 0}}, new int[][]{{67, 9, 6}}, new int[][]{{48, 6, 0}}, (int[][])null, new int[][]{{54, 6, 0}}, new int[][]{{51, 6, 0}}, new int[][]{{48, 9, 0}}, new int[][]{{51, 9, 0}}, new int[][]{{61, 6, 0}}, new int[][]{{58, 6, 0}}};
    private static final int CAPS_LOCK_INDICATOR_ADDRESS = 234;
    private final int[] Keys = new int[13];
    private final boolean[] PressedKeys = new boolean[104];
    private int strobe;
    private int row;
    private int column;
    private boolean capsLockInitialized;
    private boolean capsLockOn;
    private volatile Mapper mapper;

    @Override
    public int getInputDevice() {
        return 12;
    }

    @Override
    public void setMachine(Machine machine) {
        this.mapper = machine == null ? null : machine.getMapper();
    }

    @Override
    public void update(int buttons) {
        boolean capsOn;
        int i;
        for (i = 12; i >= 0; --i) {
            this.Keys[i] = 0;
        }
        for (i = 103; i >= 0; --i) {
            this.PressedKeys[i] = false;
        }
        this.setKeyBit(buttons >> 16 & 0x7F);
        this.setKeyBit(buttons >> 23 & 0x7F);
        if ((buttons & Integer.MIN_VALUE) != 0) {
            this.setKeyBit(DongdaPEC586KeyboardDescriptor.KEY_MAP[93]);
        }
        if ((buttons & 0x40000000) != 0) {
            this.setKeyBit(DongdaPEC586KeyboardDescriptor.KEY_MAP[95]);
        }
        if ((capsOn = BitUtil.getBitBool(this.mapper.readMemory(234), 7)) != this.capsLockOn || !this.capsLockInitialized) {
            this.capsLockInitialized = true;
            this.capsLockOn = capsOn;
            this.setCapsLockIndicator(this.capsLockOn);
        }
    }

    private void setCapsLockIndicator(boolean lit) {
        try {
            Toolkit.getDefaultToolkit().setLockingKeyState(20, lit);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setKeyBit(int key) {
        if (key < 104) {
            int n = key >> 3;
            this.Keys[n] = this.Keys[n] | 1 << (key & 7);
            this.PressedKeys[key] = true;
        }
    }

    @Override
    public void writePort(int value) {
        if ((this.strobe & 2) == 0 && (value & 2) != 0) {
            this.row = 0;
        }
        if ((this.strobe & 1) != 0 && (value & 1) == 0) {
            this.column = 0;
        }
        if ((this.strobe & 4) != 0 && (value & 4) == 0 && ++this.row == 13) {
            this.row = 0;
        }
        this.strobe = value;
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            int value = 0;
            if ((this.Keys[this.row] & 1 << 7 - this.column) != 0) {
                value = 2;
            }
            ++this.column;
            this.column &= 7;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (portIndex == 1) {
            int value = 0;
            if ((this.Keys[this.row] & 1 << 7 - this.column) != 0) {
                value = 2;
            }
            return value;
        }
        return 0;
    }

    private void render(int[] screen, int x, int y, int[] K) {
        InputIcons icon;
        switch (K[2]) {
            case 1: {
                icon = InputIcons.SuborKeyboardEnter;
                break;
            }
            case 2: {
                icon = InputIcons.SuborKeyboardSpace;
                break;
            }
            case 3: {
                icon = InputIcons.SuborKeyboard3;
                break;
            }
            case 4: {
                icon = InputIcons.FamilyBasicKeyboardShift;
                break;
            }
            case 5: {
                icon = InputIcons.SuborKeyboard5;
                break;
            }
            case 6: {
                icon = InputIcons.SuborKeyboardVertical;
                break;
            }
            default: {
                icon = InputIcons.FamilyBasicKeyboardKey;
            }
        }
        icon.render(screen, x + K[0], y + K[1]);
    }

    @Override
    public void render(int[] screen) {
        int x = 157;
        int y = 205;
        InputIcons.SuborKeyboard.render(screen, 157, 205);
        for (int i = 103; i >= 0; --i) {
            int[][] K;
            if (!this.PressedKeys[i] || (K = KEYS[i]) == null) continue;
            if (K.length == 2) {
                this.render(screen, 157, 205, K[1]);
            }
            this.render(screen, 157, 205, K[0]);
        }
    }

    @Override
    public void close(boolean saveNonVolatileData) {
        this.setCapsLockIndicator(false);
    }
}

