/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.dipswitches;

import java.util.ArrayList;
import java.util.List;
import nintaco.input.dipswitches.DipSwitchValue;
import nintaco.util.CollectionsUtil;

public class DipSwitch {
    private final List<DipSwitchValue> values = new ArrayList<DipSwitchValue>();
    private final String name;
    private final int defaultValue;

    public DipSwitch(String name, int defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public DipSwitch add(String name, int value) {
        return this.add(new DipSwitchValue(name, value));
    }

    public DipSwitch add(DipSwitchValue value) {
        this.values.add(value);
        return this;
    }

    public List<DipSwitchValue> getValues() {
        return this.values;
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "DipSwitch{values=" + this.values + ", name=" + this.name + ", defaultValue=" + this.defaultValue + '}';
    }

    public static int evaluate(List<DipSwitch> dipSwitches, int[] dipSwitchValues) {
        if (CollectionsUtil.isBlank(dipSwitches) || dipSwitchValues == null) {
            return 0;
        }
        int value = 0;
        for (int i = Math.min(dipSwitches.size(), dipSwitchValues.length) - 1; i >= 0; --i) {
            List<DipSwitchValue> values = dipSwitches.get(i).getValues();
            if (dipSwitchValues[i] >= values.size()) continue;
            value |= values.get(dipSwitchValues[i]).getValue();
        }
        return value;
    }

    public static List<DipSwitch> createDefaultDipSwitches() {
        ArrayList<DipSwitch> dipSwitches = new ArrayList<DipSwitch>();
        for (int i = 0; i < 8; ++i) {
            dipSwitches.add(new DipSwitch("Unknown", 0).add("Off", 0).add("On", 1 << i));
        }
        return dipSwitches;
    }
}

