/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import nintaco.input.DeviceConfig;
import nintaco.input.arkanoid.ArkanoidConfig;
import nintaco.input.bandaihypershot.BandaiHyperShotConfig;
import nintaco.input.barcodebattler.BarcodeBattlerConfig;
import nintaco.input.battlebox.BattleBoxConfig;
import nintaco.input.crazyclimber.CrazyClimberLeftConfig;
import nintaco.input.crazyclimber.CrazyClimberRightConfig;
import nintaco.input.dongda.DongdaPEC586KeyboardConfig;
import nintaco.input.doremikkokeyboard.DoremikkoKeyboardConfig;
import nintaco.input.excitingboxing.ExcitingBoxingConfig;
import nintaco.input.familybasic.datarecorder.DataRecorderConfig;
import nintaco.input.familybasic.keyboard.KeyboardConfig;
import nintaco.input.familybasic.transformer.TransformerConfig;
import nintaco.input.familytrainermat.FamilyTrainerMatConfig;
import nintaco.input.gamepad.Gamepad1Config;
import nintaco.input.gamepad.Gamepad2Config;
import nintaco.input.gamepad.Gamepad3Config;
import nintaco.input.gamepad.Gamepad4Config;
import nintaco.input.glasses.GlassesConfig;
import nintaco.input.horitrack.HoriTrackConfig;
import nintaco.input.konamihypershot.KonamiHyperShotConfig;
import nintaco.input.mahjong.MahjongConfig;
import nintaco.input.miraclepiano.MiraclePianoConfig;
import nintaco.input.oekakids.OekaKidsConfig;
import nintaco.input.pachinko.PachinkoConfig;
import nintaco.input.partytap.PartyTapConfig;
import nintaco.input.powerglove.PowerGloveConfig;
import nintaco.input.powerpad.PowerPadConfig;
import nintaco.input.racermate.RacerMate1Config;
import nintaco.input.racermate.RacerMate2Config;
import nintaco.input.snesmouse.SnesMouseConfig;
import nintaco.input.subor.SuborConfig;
import nintaco.input.taptapmat.TapTapMatConfig;
import nintaco.input.topriderbike.TopRiderBikeConfig;
import nintaco.input.turbofile.TurboFileConfig;
import nintaco.input.uforce.UForceConfig;
import nintaco.input.zapper.ZapperConfig;

public interface InputDevices {
    public static final int None = -1;
    public static final int NESFourScore1 = -2;
    public static final int NESFourScore2 = -3;
    public static final int Famicom4PlayersAdapter1 = -4;
    public static final int Famicom4PlayersAdapter2 = -5;
    public static final int Gamepad1 = 0;
    public static final int Gamepad2 = 1;
    public static final int Gamepad3 = 2;
    public static final int Gamepad4 = 3;
    public static final int Zapper = 4;
    public static final int Arkanoid = 5;
    public static final int BandaiHyperShot = 6;
    public static final int BarcodeBattler = 7;
    public static final int BattleBox = 8;
    public static final int CrazyClimberLeft = 9;
    public static final int CrazyClimberRight = 10;
    public static final int DataRecorder = 11;
    public static final int DongdaPEC586Keyboard = 12;
    public static final int DoremikkoKeyboard = 13;
    public static final int ExcitingBoxing = 14;
    public static final int FamilyTrainerMat = 15;
    public static final int Glasses = 16;
    public static final int HoriTrack = 17;
    public static final int Keyboard = 18;
    public static final int KonamiHyperShot = 19;
    public static final int Mahjong = 20;
    public static final int MiraclePiano = 21;
    public static final int OekaKids = 22;
    public static final int Pachinko = 23;
    public static final int PartyTap = 24;
    public static final int PowerGlove = 25;
    public static final int PowerPad = 26;
    public static final int RacerMate1 = 27;
    public static final int RacerMate2 = 28;
    public static final int SnesMouse = 29;
    public static final int Subor = 30;
    public static final int TapTapMat = 31;
    public static final int TopRiderBike = 32;
    public static final int TransformerKeyboard = 33;
    public static final int TurboFile = 34;
    public static final int UForce = 35;
    public static final int DevicesCount = 36;

    public static boolean isGamepad(int inputDevice) {
        return inputDevice == 0 || inputDevice == 1 || inputDevice == 2 || inputDevice == 3;
    }

    public static DeviceConfig newDeviceConfig(int inputDevice) {
        switch (inputDevice) {
            case 0: {
                return new Gamepad1Config();
            }
            case 1: {
                return new Gamepad2Config();
            }
            case 2: {
                return new Gamepad3Config();
            }
            case 3: {
                return new Gamepad4Config();
            }
            case 4: {
                return new ZapperConfig();
            }
            case 5: {
                return new ArkanoidConfig();
            }
            case 6: {
                return new BandaiHyperShotConfig();
            }
            case 7: {
                return new BarcodeBattlerConfig();
            }
            case 8: {
                return new BattleBoxConfig();
            }
            case 9: {
                return new CrazyClimberLeftConfig();
            }
            case 10: {
                return new CrazyClimberRightConfig();
            }
            case 11: {
                return new DataRecorderConfig();
            }
            case 12: {
                return new DongdaPEC586KeyboardConfig();
            }
            case 13: {
                return new DoremikkoKeyboardConfig();
            }
            case 14: {
                return new ExcitingBoxingConfig();
            }
            case 15: {
                return new FamilyTrainerMatConfig();
            }
            case 16: {
                return new GlassesConfig();
            }
            case 17: {
                return new HoriTrackConfig();
            }
            case 18: {
                return new KeyboardConfig();
            }
            case 19: {
                return new KonamiHyperShotConfig();
            }
            case 20: {
                return new MahjongConfig();
            }
            case 21: {
                return new MiraclePianoConfig();
            }
            case 22: {
                return new OekaKidsConfig();
            }
            case 23: {
                return new PachinkoConfig();
            }
            case 24: {
                return new PartyTapConfig();
            }
            case 25: {
                return new PowerGloveConfig();
            }
            case 26: {
                return new PowerPadConfig();
            }
            case 27: {
                return new RacerMate1Config();
            }
            case 28: {
                return new RacerMate2Config();
            }
            case 30: {
                return new SuborConfig();
            }
            case 29: {
                return new SnesMouseConfig();
            }
            case 31: {
                return new TapTapMatConfig();
            }
            case 32: {
                return new TopRiderBikeConfig();
            }
            case 33: {
                return new TransformerConfig();
            }
            case 34: {
                return new TurboFileConfig();
            }
            case 35: {
                return new UForceConfig();
            }
        }
        return null;
    }
}

