/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.Serializable;
import java.util.Objects;
import nintaco.input.InputDeviceID;
import nintaco.util.CollectionsUtil;
import nintaco.util.StringUtil;

public class ButtonID
implements Serializable,
Comparable<ButtonID> {
    private static final long serialVersionUID = 0L;
    private final InputDeviceID device;
    private final String name;
    private final int value;
    private final String description;

    public ButtonID() {
        this(null, null, 0);
    }

    public ButtonID(InputDeviceID device, String name, int value) {
        this.device = device;
        this.name = name;
        this.value = value;
        StringBuilder sb = new StringBuilder();
        if (device == null) {
            sb.append("...");
        } else {
            if (!StringUtil.isBlank(device.getDescription())) {
                sb.append('(').append(device.getDescription()).append(") ");
            }
            if (value < 0) {
                sb.append('-');
            }
            if (name != null) {
                sb.append(" ".equals(name) ? "Space" : name);
            }
        }
        this.description = sb.toString();
    }

    public InputDeviceID getDevice() {
        return this.device;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return this.value ^ Objects.hashCode(this.name) ^ Objects.hashCode(this.device);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ButtonID b = (ButtonID)obj;
        return this.value == b.value && Objects.equals(this.name, b.name) && Objects.equals(this.device, b.device);
    }

    @Override
    public int compareTo(ButtonID b) {
        if (b == null) {
            return 1;
        }
        if (this == b) {
            return 0;
        }
        int v = Integer.compare(this.value, b.value);
        if (v == 0) {
            v = CollectionsUtil.compare(this.name, b.name);
            if (this.value == 0) {
                return CollectionsUtil.compare(this.device, b.device);
            }
            return v;
        }
        return v;
    }
}

