/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.watchhistory;

import nintaco.App;
import nintaco.Breakpoint;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.apu.SystemAudioProcessor;
import nintaco.cheats.GameCheats;
import nintaco.disassembler.TraceLogger;
import nintaco.gui.historyeditor.tasks.FramePlayedListener;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.gui.rob.RobController;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.util.GuiUtil;
import nintaco.util.StreamUtil;
import nintaco.util.TimeUtil;

public class WatchMovieTask
extends MachineRunner {
    private final int startFrameIndex;
    private final int endFrameIndex;
    private final FramePlayedListener listener;
    private int frameIndex;
    private int renderIndex;

    public WatchMovieTask(Movie movie, int startFrameIndex, int endFrameIndex, FramePlayedListener listener) {
        super(null);
        this.movie = movie;
        this.startFrameIndex = Math.max(0, startFrameIndex);
        this.endFrameIndex = Math.max(0, endFrameIndex);
        this.listener = listener;
    }

    @Override
    public long runFrame(MovieBlock movieBlock, int frameIndex, long next) {
        this.applyInputs(movieBlock, frameIndex);
        while (this.ppu.frameRendering) {
            TraceLogger logger;
            Breakpoint[] bs = this.breakpoints;
            if (bs != null) {
                for (int i = bs.length - 1; i >= 0; --i) {
                    Breakpoint breakpoint = bs[i];
                    if (!breakpoint.hit) continue;
                    breakpoint.hit = false;
                    this.setStepPause(true);
                }
            }
            if ((logger = this.traceLogger) != null) {
                logger.log(true, this.cpu, this.ppu, this.mapper);
            }
            if (this.pauseRequested) {
                next = this.handlePause(next);
            }
            this.cpu.executeInstruction();
            if (logger == null) continue;
            logger.log(false, this.cpu, this.ppu, this.mapper);
        }
        this.ppu.frameRendering = true;
        this.mapper.handleFrameRendered();
        RobController rob = this.machine.getPPU().getRob();
        if (rob != null) {
            rob.scanMemory(this.machine.getMapper());
            if (rob.update()) {
                App.updateRobFrame(rob);
            }
        }
        App.handleFrameRendered(this);
        return next;
    }

    @Override
    public void loop() {
        try {
            this.setTerminated(false);
            this.runningThread = Thread.currentThread();
            if (this.running && this.movie != null && this.startFrameIndex >= 0 && this.endFrameIndex >= this.startFrameIndex) {
                App.fireStepPausedChanged(this.stepPause);
                this.play();
                this.cancel();
                App.setMachineRunner(null);
                App.updateFrames(null);
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    @Override
    public void play() {
        this.renderIndex = this.frameIndex = this.startFrameIndex & 0xFFFFFFC0;
        this.movieBlock = this.movie.movieBlocks.get(this.frameIndex >> Movie.BLOCK_SHIFT);
        if (this.movieBlock.saveState == null) {
            return;
        }
        try {
            this.setMachine((Machine)StreamUtil.readObject(this.movieBlock.saveState));
        }
        catch (Throwable t) {
            return;
        }
        boolean vsDualSystem = this.machine.isVsDualSystem();
        this.mapper.restore(App.getCartFile());
        this.mapper.restore(App.getFdsFile());
        this.mapper.restore(App.getNsfFile());
        this.ppu.setScreenRenderer(this::render);
        if (vsDualSystem) {
            ((MainCPU)this.cpu).getSubPPU().setScreenRenderer(this::render2);
        }
        this.apu.setAudioProcessor(this::processOutputSample);
        ImageFrame imageFrame = App.getImageFrame();
        ImagePane imagePane = imageFrame.getImagePane();
        SystemAudioProcessor systemAudioProcessor = App.getSystemAudioProcessor();
        imagePane.setRewinding(false);
        App.setMachineRunner(this);
        App.updateFrames(this);
        imagePane.setTVSystem(this.mapper.getTVSystem());
        GameCheats.updateMachine();
        long next = System.nanoTime();
        while (this.running && this.frameIndex <= this.endFrameIndex) {
            GuiUtil.suppressScreensaver();
            MovieFrame movieFrame = this.movie.movieFrames[0x7F & this.frameIndex];
            movieFrame.frameIndex = this.frameIndex;
            movieFrame.audioLength = 0;
            next = this.runFrame(this.movieBlock, this.frameIndex & 0x3F, next);
            if (this.frameIndex >= this.startFrameIndex) {
                SubMonitorFrame subMonitorFrame;
                this.listener.framePlayed(this, this.frameIndex, this);
                imagePane.render(movieFrame.screen);
                if (vsDualSystem && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
                    subMonitorFrame.getImagePane().render(movieFrame.screen2);
                }
                if (this.startFrameIndex != this.endFrameIndex) {
                    systemAudioProcessor.processOutputSamples(movieFrame.audioSamples, movieFrame.audioLength);
                }
            }
            if ((++this.frameIndex & 0x3F) == 0) {
                int index = this.frameIndex >> Movie.BLOCK_SHIFT;
                if (index >= this.movie.movieBlocks.size()) break;
                this.movieBlock = this.movie.movieBlocks.get(index);
            }
            if (this.frameIndex < this.startFrameIndex) continue;
            next = TimeUtil.sleep(next, this.mapper);
        }
        App.updateFrames(null);
    }

    private void processOutputSample(int value) {
        this.movie.movieFrames[0x7F & this.frameIndex].processOutputSample(value);
    }

    private int[] render() {
        return this.movie.movieFrames[0x7F & this.renderIndex++].screen;
    }

    private int[] render2() {
        return this.movie.movieFrames[0x7F & this.renderIndex - 1].screen2;
    }
}

