/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.spritesaver;

import nintaco.Machine;
import nintaco.PPU;
import nintaco.gui.spritesaver.MetaspriteSet;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class SpriteSearcher {
    public static final byte TRANSPARENT = 64;
    private final byte[][] screen = new byte[272][264];
    private final MetaspriteSet metaspriteSet = new MetaspriteSet();
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int marginMinX;
    private int marginMinY;
    private int marginMaxX;
    private int marginMaxY;

    public SpriteSearcher() {
        this.setEdgeMargin(16);
    }

    public final void setMinOccurrences(int minOccurrences) {
        this.metaspriteSet.setMinOccurrences(minOccurrences);
    }

    public final void setSweepSeconds(int seconds) {
        this.metaspriteSet.setSweepSeconds(seconds);
    }

    public final void setEdgeMargin(int margin) {
        this.marginMinX = margin;
        this.marginMinY = margin;
        this.marginMaxX = 255 - margin;
        this.marginMaxY = 239 - margin;
    }

    public int save(Machine machine, String outputDir, String filePrefix, String fileFormat, int imageScale, int startIndex) {
        return this.metaspriteSet.save(machine, outputDir, filePrefix, fileFormat, imageScale, startIndex);
    }

    public int search(PPU ppu) {
        if (ppu == null) {
            return 0;
        }
        this.metaspriteSet.sweep();
        this.clearScreen();
        this.renderSpriteTiles(ppu);
        return this.findMetasprites();
    }

    private int findMetasprites() {
        int spritesFound = 0;
        for (int i = 255; i >= 0; --i) {
            byte[] row = this.screen[i];
            for (int j = 255; j >= 0; --j) {
                int hash;
                int height;
                int width;
                if ((row[j] & 0xFF) >= 64) continue;
                this.minX = j;
                this.maxX = j;
                this.minY = i;
                this.maxY = i;
                this.sprawl(j, i);
                if (this.minX < this.marginMinX || this.minY < this.marginMinY || this.maxX > this.marginMaxX || this.maxY > this.marginMaxY || !this.metaspriteSet.add(this.screen, this.minX, this.minY, width = this.maxX - this.minX + 1, height = this.maxY - this.minY + 1, hash = MathUtil.hash(this.screen, this.minX, this.minY, width, height))) continue;
                ++spritesFound;
            }
        }
        return spritesFound;
    }

    private void sprawl(int x, int y) {
        int i;
        byte[] row = this.screen[y];
        int n = x;
        row[n] = (byte)(row[n] | 0x80);
        int e = x - 1;
        while (e >= 0 && (row[e] & 0xFF) < 64) {
            int n2 = e--;
            row[n2] = (byte)(row[n2] | 0x80);
        }
        ++e;
        int w = x + 1;
        while (w <= 255 && (row[w] & 0xFF) < 64) {
            int n3 = w++;
            row[n3] = (byte)(row[n3] | 0x80);
        }
        this.minX = Math.min(this.minX, e);
        this.maxX = Math.max(this.maxX, --w);
        this.minY = Math.min(this.minY, y);
        this.maxY = Math.max(this.maxY, y);
        if (--y >= 0) {
            row = this.screen[y];
            for (i = e; i <= w; ++i) {
                if ((row[i] & 0xFF) >= 64) continue;
                this.sprawl(i, y);
            }
        }
        if ((y += 2) <= 255) {
            row = this.screen[y];
            for (i = e; i <= w; ++i) {
                if ((row[i] & 0xFF) >= 64) continue;
                this.sprawl(i, y);
            }
        }
    }

    private void renderSpriteTiles(PPU ppu) {
        int[] OAM = ppu.getOAM();
        int[] paletteRAM = ppu.getPaletteRAM();
        int patternTableAddress = ppu.getSpritePatternTableAddress();
        boolean size8x16 = ppu.isSpriteSize8x16();
        for (int i = 252; i >= 0; i -= 4) {
            int y = OAM[i];
            int tileIndex = OAM[i + 1];
            int attribute = OAM[i + 2];
            int x = OAM[i + 3];
            int paletteIndex = 0x10 | (attribute & 3) << 2;
            boolean flipHorizontally = BitUtil.getBitBool(attribute, 6);
            boolean flipVertically = BitUtil.getBitBool(attribute, 7);
            if (size8x16) {
                int address0 = (tileIndex & 1) << 12 | (tileIndex & 0xFE) << 4;
                int address1 = address0 | 0x10;
                if (flipVertically) {
                    int temp = address0;
                    address0 = address1;
                    address1 = temp;
                }
                this.renderTile(ppu, address0, paletteIndex, paletteRAM, x, y, flipHorizontally, flipVertically);
                this.renderTile(ppu, address1, paletteIndex, paletteRAM, x, y + 8, flipHorizontally, flipVertically);
                continue;
            }
            this.renderTile(ppu, patternTableAddress | OAM[i + 1] << 4, paletteIndex, paletteRAM, x, y, flipHorizontally, flipVertically);
        }
    }

    private void renderTile(PPU ppu, int patternTableAddress, int paletteIndex, int[] paletteRAM, int x, int y, boolean flipHorizontally, boolean flipVertically) {
        for (int i = 7; i >= 0; --i) {
            int address = patternTableAddress | i;
            int b0 = ppu.peekVRAM(address);
            int b1 = ppu.peekVRAM(address | 8);
            if (flipHorizontally) {
                b0 = BitUtil.reverseBits(b0);
                b1 = BitUtil.reverseBits(b1);
            }
            byte[] row = this.screen[y + (flipVertically ? 7 - i : i)];
            for (int j = 7; j >= 0; --j) {
                int v = (b1 & 1) << 1 | b0 & 1;
                b0 >>= 1;
                b1 >>= 1;
                int index = paletteIndex | v;
                if ((index & 3) == 0) continue;
                row[x + j] = (byte)paletteRAM[index & 0x1F];
            }
        }
    }

    private void clearScreen() {
        for (int i = 255; i >= 0; --i) {
            byte[] row = this.screen[i];
            for (int j = 255; j >= 0; --j) {
                row[j] = 64;
            }
        }
    }
}

