/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.sound.volumemixer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nintaco.App;
import nintaco.apu.APU;
import nintaco.apu.SystemAudioProcessor;
import nintaco.gui.sound.volumemixer.VolumeMixerPrefs;
import nintaco.mappers.konami.vrc6.VRC6Audio;
import nintaco.mappers.konami.vrc7.VRC7Audio;
import nintaco.mappers.namco.Namco163Audio;
import nintaco.mappers.nintendo.fds.FdsAudio;
import nintaco.mappers.nintendo.mmc5.MMC5Audio;
import nintaco.mappers.sunsoft.fme7.Sunsoft5BAudio;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class VolumeMixerFrame
extends JFrame {
    private JButton cancelButton;
    private JPanel channelsPanel;
    private JLabel dmcLabel;
    private JPanel dmcPanel;
    private JSlider dmcSlider;
    private JLabel dmcVolumeLabel;
    private JLabel fdsLabel;
    private JPanel fdsPanel;
    private JSlider fdsSlider;
    private JLabel fdsVolumeLabel;
    private JLabel masterLabel;
    private JPanel masterPanel;
    private JSlider masterSlider;
    private JLabel masterVolumeLabel;
    private JLabel mmc5Label;
    private JPanel mmc5Panel;
    private JSlider mmc5Slider;
    private JLabel mmc5VolumeLabel;
    private JLabel n163Label;
    private JPanel n163Panel;
    private JSlider n163Slider;
    private JLabel n163VolumeLabel;
    private JLabel noiseLabel;
    private JPanel noisePanel;
    private JSlider noiseSlider;
    private JLabel noiseVolumeLabel;
    private JButton okButton;
    private JButton resetButton;
    private JLabel s5bLabel;
    private JPanel s5bPanel;
    private JSlider s5bSlider;
    private JLabel s5bVolumeLabel;
    private JCheckBox smoothDmcCheckBox;
    private JCheckBox soundEnabledCheckBox;
    private JLabel square1Label;
    private JPanel square1Panel;
    private JSlider square1Slider;
    private JLabel square1VolumeLabel;
    private JLabel square2Label;
    private JPanel square2Panel;
    private JSlider square2Slider;
    private JLabel square2VolumeLabel;
    private JLabel triangleLabel;
    private JPanel trianglePanel;
    private JSlider triangleSlider;
    private JLabel triangleVolumeLabel;
    private JLabel vrc6Label;
    private JPanel vrc6Panel;
    private JSlider vrc6Slider;
    private JLabel vrc6VolumeLabel;
    private JLabel vrc7Label;
    private JPanel vrc7Panel;
    private JSlider vrc7Slider;
    private JLabel vrc7VolumeLabel;

    public VolumeMixerFrame() {
        this.initComponents();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void loadFields() {
        this.setVolumeMixerPrefs(AppPrefs.getInstance().getVolumeMixerPrefs());
    }

    private void setVolumeMixerPrefs(VolumeMixerPrefs prefs) {
        this.soundEnabledCheckBox.setSelected(prefs.isSoundEnabled());
        this.smoothDmcCheckBox.setSelected(prefs.isSmoothDMC());
        this.masterSlider.setValue(prefs.getMasterVolume());
        this.square1Slider.setValue(prefs.getSquare1Volume());
        this.square2Slider.setValue(prefs.getSquare2Volume());
        this.triangleSlider.setValue(prefs.getTriangleVolume());
        this.noiseSlider.setValue(prefs.getNoiseVolume());
        this.dmcSlider.setValue(prefs.getDmcVolume());
        this.fdsSlider.setValue(prefs.getFdsVolume());
        this.mmc5Slider.setValue(prefs.getMmc5Volume());
        this.vrc6Slider.setValue(prefs.getVrc6Volume());
        this.vrc7Slider.setValue(prefs.getVrc7Volume());
        this.n163Slider.setValue(prefs.getN163Volume());
        this.s5bSlider.setValue(prefs.getS5bVolume());
    }

    private void saveFields() {
        VolumeMixerPrefs prefs = AppPrefs.getInstance().getVolumeMixerPrefs();
        prefs.setSoundEnabled(this.soundEnabledCheckBox.isSelected());
        prefs.setSmoothDMC(this.smoothDmcCheckBox.isSelected());
        prefs.setMasterVolume(this.masterSlider.getValue());
        prefs.setSquare1Volume(this.square1Slider.getValue());
        prefs.setSquare2Volume(this.square2Slider.getValue());
        prefs.setTriangleVolume(this.triangleSlider.getValue());
        prefs.setNoiseVolume(this.noiseSlider.getValue());
        prefs.setDmcVolume(this.dmcSlider.getValue());
        prefs.setFdsVolume(this.fdsSlider.getValue());
        prefs.setMmc5Volume(this.mmc5Slider.getValue());
        prefs.setVrc6Volume(this.vrc6Slider.getValue());
        prefs.setVrc7Volume(this.vrc7Slider.getValue());
        prefs.setN163Volume(this.n163Slider.getValue());
        prefs.setS5bVolume(this.s5bSlider.getValue());
        AppPrefs.save();
    }

    private void closeFrame() {
        App.destroyVolumeMixerFrame();
    }

    public void destroy() {
        this.dispose();
    }

    private void cancel() {
        VolumeMixerPrefs prefs = AppPrefs.getInstance().getVolumeMixerPrefs();
        this.setMasterVolume(prefs.getMasterVolume());
        APU.setVolumeMixerPrefs(prefs);
        this.closeFrame();
    }

    public void setMasterVolume(int volume) {
        if (this.masterSlider.getValue() != volume) {
            this.masterSlider.setValue(volume);
        }
    }

    private void initComponents() {
        this.channelsPanel = new JPanel();
        this.masterPanel = new JPanel();
        this.masterVolumeLabel = new JLabel();
        this.masterLabel = new JLabel();
        this.masterSlider = new JSlider();
        this.square1Panel = new JPanel();
        this.square1VolumeLabel = new JLabel();
        this.square1Label = new JLabel();
        this.square1Slider = new JSlider();
        this.square2Panel = new JPanel();
        this.square2VolumeLabel = new JLabel();
        this.square2Label = new JLabel();
        this.square2Slider = new JSlider();
        this.trianglePanel = new JPanel();
        this.triangleVolumeLabel = new JLabel();
        this.triangleLabel = new JLabel();
        this.triangleSlider = new JSlider();
        this.noisePanel = new JPanel();
        this.noiseVolumeLabel = new JLabel();
        this.noiseLabel = new JLabel();
        this.noiseSlider = new JSlider();
        this.dmcPanel = new JPanel();
        this.dmcVolumeLabel = new JLabel();
        this.dmcLabel = new JLabel();
        this.dmcSlider = new JSlider();
        this.fdsPanel = new JPanel();
        this.fdsVolumeLabel = new JLabel();
        this.fdsLabel = new JLabel();
        this.fdsSlider = new JSlider();
        this.mmc5Panel = new JPanel();
        this.mmc5VolumeLabel = new JLabel();
        this.mmc5Label = new JLabel();
        this.mmc5Slider = new JSlider();
        this.vrc6Panel = new JPanel();
        this.vrc6VolumeLabel = new JLabel();
        this.vrc6Label = new JLabel();
        this.vrc6Slider = new JSlider();
        this.vrc7Panel = new JPanel();
        this.vrc7VolumeLabel = new JLabel();
        this.vrc7Label = new JLabel();
        this.vrc7Slider = new JSlider();
        this.n163Panel = new JPanel();
        this.n163VolumeLabel = new JLabel();
        this.n163Label = new JLabel();
        this.n163Slider = new JSlider();
        this.s5bPanel = new JPanel();
        this.s5bVolumeLabel = new JLabel();
        this.s5bLabel = new JLabel();
        this.s5bSlider = new JSlider();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.resetButton = new JButton();
        this.soundEnabledCheckBox = new JCheckBox();
        this.smoothDmcCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Volume Mixer");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VolumeMixerFrame.this.formWindowClosing(evt);
            }
        });
        this.masterVolumeLabel.setHorizontalAlignment(0);
        this.masterVolumeLabel.setText("100");
        this.masterLabel.setHorizontalAlignment(0);
        this.masterLabel.setText("Master");
        this.masterSlider.setMajorTickSpacing(10);
        this.masterSlider.setOrientation(1);
        this.masterSlider.setPaintTicks(true);
        this.masterSlider.setValue(100);
        this.masterSlider.setFocusable(false);
        this.masterSlider.setPreferredSize(null);
        this.masterSlider.setRequestFocusEnabled(false);
        this.masterSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.masterSliderStateChanged(evt);
            }
        });
        GroupLayout masterPanelLayout = new GroupLayout(this.masterPanel);
        this.masterPanel.setLayout(masterPanelLayout);
        masterPanelLayout.setHorizontalGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(masterPanelLayout.createSequentialGroup().addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.masterVolumeLabel).addComponent(this.masterSlider, -1, -1, Short.MAX_VALUE).addComponent(this.masterLabel)).addGap(0, 0, 0)));
        masterPanelLayout.setVerticalGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(masterPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.masterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.masterSlider, -1, 93, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.masterVolumeLabel).addGap(0, 0, 0)));
        this.square1VolumeLabel.setHorizontalAlignment(0);
        this.square1VolumeLabel.setText("100");
        this.square1Label.setHorizontalAlignment(0);
        this.square1Label.setText("Square 1");
        this.square1Slider.setMajorTickSpacing(10);
        this.square1Slider.setOrientation(1);
        this.square1Slider.setPaintTicks(true);
        this.square1Slider.setValue(100);
        this.square1Slider.setFocusable(false);
        this.square1Slider.setPreferredSize(null);
        this.square1Slider.setRequestFocusEnabled(false);
        this.square1Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.square1SliderStateChanged(evt);
            }
        });
        GroupLayout square1PanelLayout = new GroupLayout(this.square1Panel);
        this.square1Panel.setLayout(square1PanelLayout);
        square1PanelLayout.setHorizontalGroup(square1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(square1PanelLayout.createSequentialGroup().addGroup(square1PanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.square1Label).addComponent(this.square1Slider, -1, -1, Short.MAX_VALUE).addComponent(this.square1VolumeLabel)).addGap(0, 0, 0)));
        square1PanelLayout.setVerticalGroup(square1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(square1PanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.square1Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.square1Slider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.square1VolumeLabel).addGap(0, 0, 0)));
        this.square2VolumeLabel.setHorizontalAlignment(0);
        this.square2VolumeLabel.setText("100");
        this.square2Label.setHorizontalAlignment(0);
        this.square2Label.setText("Square 2");
        this.square2Slider.setMajorTickSpacing(10);
        this.square2Slider.setOrientation(1);
        this.square2Slider.setPaintTicks(true);
        this.square2Slider.setValue(100);
        this.square2Slider.setFocusable(false);
        this.square2Slider.setPreferredSize(null);
        this.square2Slider.setRequestFocusEnabled(false);
        this.square2Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.square2SliderStateChanged(evt);
            }
        });
        GroupLayout square2PanelLayout = new GroupLayout(this.square2Panel);
        this.square2Panel.setLayout(square2PanelLayout);
        square2PanelLayout.setHorizontalGroup(square2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(square2PanelLayout.createSequentialGroup().addGroup(square2PanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.square2Label).addComponent(this.square2Slider, -1, -1, Short.MAX_VALUE).addComponent(this.square2VolumeLabel)).addGap(0, 0, 0)));
        square2PanelLayout.setVerticalGroup(square2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(square2PanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.square2Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.square2Slider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.square2VolumeLabel).addGap(0, 0, 0)));
        this.triangleVolumeLabel.setHorizontalAlignment(0);
        this.triangleVolumeLabel.setText("100");
        this.triangleLabel.setHorizontalAlignment(0);
        this.triangleLabel.setText("Triangle");
        this.triangleSlider.setMajorTickSpacing(10);
        this.triangleSlider.setOrientation(1);
        this.triangleSlider.setPaintTicks(true);
        this.triangleSlider.setValue(100);
        this.triangleSlider.setFocusable(false);
        this.triangleSlider.setPreferredSize(null);
        this.triangleSlider.setRequestFocusEnabled(false);
        this.triangleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.triangleSliderStateChanged(evt);
            }
        });
        GroupLayout trianglePanelLayout = new GroupLayout(this.trianglePanel);
        this.trianglePanel.setLayout(trianglePanelLayout);
        trianglePanelLayout.setHorizontalGroup(trianglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trianglePanelLayout.createSequentialGroup().addGroup(trianglePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.triangleLabel).addComponent(this.triangleSlider, -1, -1, Short.MAX_VALUE).addComponent(this.triangleVolumeLabel)).addGap(0, 0, 0)));
        trianglePanelLayout.setVerticalGroup(trianglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trianglePanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.triangleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.triangleSlider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.triangleVolumeLabel).addGap(0, 0, 0)));
        this.noiseVolumeLabel.setHorizontalAlignment(0);
        this.noiseVolumeLabel.setText("100");
        this.noiseLabel.setHorizontalAlignment(0);
        this.noiseLabel.setText("Noise");
        this.noiseSlider.setMajorTickSpacing(10);
        this.noiseSlider.setOrientation(1);
        this.noiseSlider.setPaintTicks(true);
        this.noiseSlider.setValue(100);
        this.noiseSlider.setFocusable(false);
        this.noiseSlider.setPreferredSize(null);
        this.noiseSlider.setRequestFocusEnabled(false);
        this.noiseSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.noiseSliderStateChanged(evt);
            }
        });
        GroupLayout noisePanelLayout = new GroupLayout(this.noisePanel);
        this.noisePanel.setLayout(noisePanelLayout);
        noisePanelLayout.setHorizontalGroup(noisePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noisePanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(noisePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.noiseLabel).addComponent(this.noiseSlider, -1, 48, Short.MAX_VALUE).addComponent(this.noiseVolumeLabel)).addGap(0, 0, 0)));
        noisePanelLayout.setVerticalGroup(noisePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noisePanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.noiseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noiseSlider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.noiseVolumeLabel).addGap(0, 0, 0)));
        this.dmcVolumeLabel.setHorizontalAlignment(0);
        this.dmcVolumeLabel.setText("100");
        this.dmcLabel.setHorizontalAlignment(0);
        this.dmcLabel.setText("DMC");
        this.dmcSlider.setMajorTickSpacing(10);
        this.dmcSlider.setOrientation(1);
        this.dmcSlider.setPaintTicks(true);
        this.dmcSlider.setValue(100);
        this.dmcSlider.setFocusable(false);
        this.dmcSlider.setPreferredSize(null);
        this.dmcSlider.setRequestFocusEnabled(false);
        this.dmcSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.dmcSliderStateChanged(evt);
            }
        });
        GroupLayout dmcPanelLayout = new GroupLayout(this.dmcPanel);
        this.dmcPanel.setLayout(dmcPanelLayout);
        dmcPanelLayout.setHorizontalGroup(dmcPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dmcPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(dmcPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dmcLabel).addComponent(this.dmcSlider, -1, 48, Short.MAX_VALUE).addComponent(this.dmcVolumeLabel)).addGap(0, 0, 0)));
        dmcPanelLayout.setVerticalGroup(dmcPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dmcPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.dmcLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dmcSlider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.dmcVolumeLabel).addGap(0, 0, 0)));
        this.fdsVolumeLabel.setHorizontalAlignment(0);
        this.fdsVolumeLabel.setText("100");
        this.fdsLabel.setHorizontalAlignment(0);
        this.fdsLabel.setText("FDS");
        this.fdsSlider.setMajorTickSpacing(10);
        this.fdsSlider.setOrientation(1);
        this.fdsSlider.setPaintTicks(true);
        this.fdsSlider.setValue(100);
        this.fdsSlider.setFocusable(false);
        this.fdsSlider.setPreferredSize(null);
        this.fdsSlider.setRequestFocusEnabled(false);
        this.fdsSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.fdsSliderStateChanged(evt);
            }
        });
        GroupLayout fdsPanelLayout = new GroupLayout(this.fdsPanel);
        this.fdsPanel.setLayout(fdsPanelLayout);
        fdsPanelLayout.setHorizontalGroup(fdsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fdsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(fdsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fdsLabel).addComponent(this.fdsSlider, -1, 43, Short.MAX_VALUE).addComponent(this.fdsVolumeLabel)).addGap(0, 0, 0)));
        fdsPanelLayout.setVerticalGroup(fdsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fdsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.fdsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fdsSlider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.fdsVolumeLabel).addGap(0, 0, 0)));
        this.mmc5VolumeLabel.setHorizontalAlignment(0);
        this.mmc5VolumeLabel.setText("100");
        this.mmc5Label.setHorizontalAlignment(0);
        this.mmc5Label.setText("MMC5");
        this.mmc5Slider.setMajorTickSpacing(10);
        this.mmc5Slider.setOrientation(1);
        this.mmc5Slider.setPaintTicks(true);
        this.mmc5Slider.setValue(100);
        this.mmc5Slider.setFocusable(false);
        this.mmc5Slider.setPreferredSize(null);
        this.mmc5Slider.setRequestFocusEnabled(false);
        this.mmc5Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.mmc5SliderStateChanged(evt);
            }
        });
        GroupLayout mmc5PanelLayout = new GroupLayout(this.mmc5Panel);
        this.mmc5Panel.setLayout(mmc5PanelLayout);
        mmc5PanelLayout.setHorizontalGroup(mmc5PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mmc5PanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(mmc5PanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mmc5Label).addComponent(this.mmc5Slider, -1, 43, Short.MAX_VALUE).addComponent(this.mmc5VolumeLabel)).addGap(0, 0, 0)));
        mmc5PanelLayout.setVerticalGroup(mmc5PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mmc5PanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.mmc5Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mmc5Slider, -1, 93, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.mmc5VolumeLabel).addGap(0, 0, 0)));
        this.vrc6VolumeLabel.setHorizontalAlignment(0);
        this.vrc6VolumeLabel.setText("100");
        this.vrc6Label.setHorizontalAlignment(0);
        this.vrc6Label.setText("VRC6");
        this.vrc6Slider.setMajorTickSpacing(10);
        this.vrc6Slider.setOrientation(1);
        this.vrc6Slider.setPaintTicks(true);
        this.vrc6Slider.setValue(100);
        this.vrc6Slider.setFocusable(false);
        this.vrc6Slider.setPreferredSize(null);
        this.vrc6Slider.setRequestFocusEnabled(false);
        this.vrc6Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.vrc6SliderStateChanged(evt);
            }
        });
        GroupLayout vrc6PanelLayout = new GroupLayout(this.vrc6Panel);
        this.vrc6Panel.setLayout(vrc6PanelLayout);
        vrc6PanelLayout.setHorizontalGroup(vrc6PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vrc6PanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(vrc6PanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.vrc6Label).addComponent(this.vrc6Slider, -1, 43, Short.MAX_VALUE).addComponent(this.vrc6VolumeLabel)).addGap(0, 0, 0)));
        vrc6PanelLayout.setVerticalGroup(vrc6PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vrc6PanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.vrc6Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vrc6Slider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.vrc6VolumeLabel).addGap(0, 0, 0)));
        this.vrc7VolumeLabel.setHorizontalAlignment(0);
        this.vrc7VolumeLabel.setText("100");
        this.vrc7Label.setHorizontalAlignment(0);
        this.vrc7Label.setText("VRC7");
        this.vrc7Slider.setMajorTickSpacing(10);
        this.vrc7Slider.setOrientation(1);
        this.vrc7Slider.setPaintTicks(true);
        this.vrc7Slider.setValue(100);
        this.vrc7Slider.setFocusable(false);
        this.vrc7Slider.setPreferredSize(null);
        this.vrc7Slider.setRequestFocusEnabled(false);
        this.vrc7Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.vrc7SliderStateChanged(evt);
            }
        });
        GroupLayout vrc7PanelLayout = new GroupLayout(this.vrc7Panel);
        this.vrc7Panel.setLayout(vrc7PanelLayout);
        vrc7PanelLayout.setHorizontalGroup(vrc7PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vrc7PanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(vrc7PanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.vrc7Label).addComponent(this.vrc7Slider, -1, 43, Short.MAX_VALUE).addComponent(this.vrc7VolumeLabel)).addGap(0, 0, 0)));
        vrc7PanelLayout.setVerticalGroup(vrc7PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vrc7PanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.vrc7Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vrc7Slider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.vrc7VolumeLabel).addGap(0, 0, 0)));
        this.n163VolumeLabel.setHorizontalAlignment(0);
        this.n163VolumeLabel.setText("100");
        this.n163Label.setHorizontalAlignment(0);
        this.n163Label.setText("N163");
        this.n163Slider.setMajorTickSpacing(10);
        this.n163Slider.setOrientation(1);
        this.n163Slider.setPaintTicks(true);
        this.n163Slider.setValue(100);
        this.n163Slider.setFocusable(false);
        this.n163Slider.setPreferredSize(null);
        this.n163Slider.setRequestFocusEnabled(false);
        this.n163Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.n163SliderStateChanged(evt);
            }
        });
        GroupLayout n163PanelLayout = new GroupLayout(this.n163Panel);
        this.n163Panel.setLayout(n163PanelLayout);
        n163PanelLayout.setHorizontalGroup(n163PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(n163PanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(n163PanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.n163Label).addComponent(this.n163Slider, -1, 43, Short.MAX_VALUE).addComponent(this.n163VolumeLabel)).addGap(0, 0, 0)));
        n163PanelLayout.setVerticalGroup(n163PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(n163PanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.n163Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.n163Slider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.n163VolumeLabel).addGap(0, 0, 0)));
        this.s5bVolumeLabel.setHorizontalAlignment(0);
        this.s5bVolumeLabel.setText("100");
        this.s5bLabel.setHorizontalAlignment(0);
        this.s5bLabel.setText("S5B");
        this.s5bSlider.setMajorTickSpacing(10);
        this.s5bSlider.setOrientation(1);
        this.s5bSlider.setPaintTicks(true);
        this.s5bSlider.setValue(100);
        this.s5bSlider.setFocusable(false);
        this.s5bSlider.setPreferredSize(null);
        this.s5bSlider.setRequestFocusEnabled(false);
        this.s5bSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VolumeMixerFrame.this.s5bSliderStateChanged(evt);
            }
        });
        GroupLayout s5bPanelLayout = new GroupLayout(this.s5bPanel);
        this.s5bPanel.setLayout(s5bPanelLayout);
        s5bPanelLayout.setHorizontalGroup(s5bPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(s5bPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(s5bPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.s5bLabel).addComponent(this.s5bSlider, -1, 43, Short.MAX_VALUE).addComponent(this.s5bVolumeLabel)).addGap(0, 0, 0)));
        s5bPanelLayout.setVerticalGroup(s5bPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(s5bPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.s5bLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.s5bSlider, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.s5bVolumeLabel).addGap(0, 0, 0)));
        GroupLayout channelsPanelLayout = new GroupLayout(this.channelsPanel);
        this.channelsPanel.setLayout(channelsPanelLayout);
        channelsPanelLayout.setHorizontalGroup(channelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(channelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelsPanelLayout.createSequentialGroup().addComponent(this.masterPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.square1Panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.square2Panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.trianglePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noisePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dmcPanel, -1, -1, Short.MAX_VALUE)).addGroup(channelsPanelLayout.createSequentialGroup().addComponent(this.fdsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mmc5Panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.vrc6Panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.vrc7Panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.n163Panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.s5bPanel, -1, -1, Short.MAX_VALUE)))));
        channelsPanelLayout.setVerticalGroup(channelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(channelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.masterPanel, -1, -1, Short.MAX_VALUE).addComponent(this.square1Panel, -1, -1, Short.MAX_VALUE).addComponent(this.square2Panel, -1, -1, Short.MAX_VALUE).addComponent(this.trianglePanel, -1, -1, Short.MAX_VALUE).addComponent(this.noisePanel, -1, -1, Short.MAX_VALUE).addComponent(this.dmcPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(channelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mmc5Panel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fdsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.n163Panel, -1, -1, Short.MAX_VALUE).addComponent(this.s5bPanel, -1, -1, Short.MAX_VALUE).addComponent(this.vrc6Panel, -1, -1, Short.MAX_VALUE).addComponent(this.vrc7Panel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolumeMixerFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolumeMixerFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.resetButton.setMnemonic('R');
        this.resetButton.setText("Reset");
        this.resetButton.setFocusPainted(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolumeMixerFrame.this.resetButtonActionPerformed(evt);
            }
        });
        this.soundEnabledCheckBox.setSelected(true);
        this.soundEnabledCheckBox.setText("Sound Enabled");
        this.soundEnabledCheckBox.setFocusPainted(false);
        this.soundEnabledCheckBox.setFocusable(false);
        this.soundEnabledCheckBox.setMaximumSize(null);
        this.soundEnabledCheckBox.setMinimumSize(null);
        this.soundEnabledCheckBox.setPreferredSize(null);
        this.soundEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolumeMixerFrame.this.soundEnabledCheckBoxActionPerformed(evt);
            }
        });
        this.smoothDmcCheckBox.setSelected(true);
        this.smoothDmcCheckBox.setText("Smooth DMC");
        this.smoothDmcCheckBox.setFocusPainted(false);
        this.smoothDmcCheckBox.setFocusable(false);
        this.smoothDmcCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolumeMixerFrame.this.smoothDmcCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.soundEnabledCheckBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.smoothDmcCheckBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.channelsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton, this.resetButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.soundEnabledCheckBox, -2, -1, -2).addComponent(this.smoothDmcCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.channelsPanel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.resetButton)).addContainerGap()));
    }

    private void masterSliderStateChanged(ChangeEvent evt) {
        this.masterVolumeLabel.setText(Integer.toString(this.masterSlider.getValue()));
        APU.setMasterVolume(this.masterSlider.getValue());
        SystemAudioProcessor.setMasterVolume(this.masterSlider.getValue());
        App.getImageFrame().getNsfPanel().setVolume(this.masterSlider.getValue());
    }

    private void square1SliderStateChanged(ChangeEvent evt) {
        this.square1VolumeLabel.setText(Integer.toString(this.square1Slider.getValue()));
        APU.setPulse1Volume(this.square1Slider.getValue());
    }

    private void square2SliderStateChanged(ChangeEvent evt) {
        this.square2VolumeLabel.setText(Integer.toString(this.square2Slider.getValue()));
        APU.setPulse2Volume(this.square2Slider.getValue());
    }

    private void triangleSliderStateChanged(ChangeEvent evt) {
        this.triangleVolumeLabel.setText(Integer.toString(this.triangleSlider.getValue()));
        APU.setTriangleVolume(this.triangleSlider.getValue());
    }

    private void noiseSliderStateChanged(ChangeEvent evt) {
        this.noiseVolumeLabel.setText(Integer.toString(this.noiseSlider.getValue()));
        APU.setNoiseVolume(this.noiseSlider.getValue());
    }

    private void dmcSliderStateChanged(ChangeEvent evt) {
        this.dmcVolumeLabel.setText(Integer.toString(this.dmcSlider.getValue()));
        APU.setDmcVolume(this.dmcSlider.getValue());
    }

    private void fdsSliderStateChanged(ChangeEvent evt) {
        this.fdsVolumeLabel.setText(Integer.toString(this.fdsSlider.getValue()));
        FdsAudio.setVolume(this.fdsSlider.getValue());
    }

    private void mmc5SliderStateChanged(ChangeEvent evt) {
        this.mmc5VolumeLabel.setText(Integer.toString(this.mmc5Slider.getValue()));
        MMC5Audio.setVolume(this.mmc5Slider.getValue());
    }

    private void vrc6SliderStateChanged(ChangeEvent evt) {
        this.vrc6VolumeLabel.setText(Integer.toString(this.vrc6Slider.getValue()));
        VRC6Audio.setVolume(this.vrc6Slider.getValue());
    }

    private void vrc7SliderStateChanged(ChangeEvent evt) {
        this.vrc7VolumeLabel.setText(Integer.toString(this.vrc7Slider.getValue()));
        VRC7Audio.setVolume(this.vrc7Slider.getValue());
    }

    private void n163SliderStateChanged(ChangeEvent evt) {
        this.n163VolumeLabel.setText(Integer.toString(this.n163Slider.getValue()));
        Namco163Audio.setVolume(this.n163Slider.getValue());
    }

    private void s5bSliderStateChanged(ChangeEvent evt) {
        this.s5bVolumeLabel.setText(Integer.toString(this.s5bSlider.getValue()));
        Sunsoft5BAudio.setVolume(this.s5bSlider.getValue());
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.setVolumeMixerPrefs(new VolumeMixerPrefs());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        this.closeFrame();
    }

    private void soundEnabledCheckBoxActionPerformed(ActionEvent evt) {
        APU.setSoundEnabled(this.soundEnabledCheckBox.isSelected());
    }

    private void smoothDmcCheckBoxActionPerformed(ActionEvent evt) {
        APU.setSmoothDMC(this.smoothDmcCheckBox.isSelected());
    }
}

