/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.screenshots;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import nintaco.App;
import nintaco.files.FileUtil;
import nintaco.gui.exportmedia.ImageConverter;
import nintaco.gui.exportmedia.preferences.ExportMediaFilePrefs;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public final class ScreenshotSaver {
    private static final List<QueueElement> queue = new ArrayList<QueueElement>();
    private static Thread thread;
    private static WeakReference<ImageConverter> weakConverter;

    private ScreenshotSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(int[] screen, TVSystem tvSystem) {
        BufferedImage image = new BufferedImage(256, 240, 1);
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        System.arraycopy(screen, 0, data, 0, screen.length);
        List<QueueElement> list = queue;
        synchronized (list) {
            queue.add(new QueueElement(image, tvSystem));
            if (thread == null) {
                thread = new Thread(ScreenshotSaver::processQueue, "Screenshot Saver Thread");
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        while (true) {
            QueueElement element;
            List<QueueElement> list = queue;
            synchronized (list) {
                if (queue.isEmpty()) {
                    thread = null;
                    return;
                }
                element = queue.remove(0);
            }
            try {
                ScreenshotSaver.processQueueElement(element);
            }
            catch (Throwable throwable) {
            }
        }
    }

    private static void processQueueElement(QueueElement element) throws Throwable {
        String dir = AppPrefs.getInstance().getPaths().getScreenshotsDir();
        FileUtil.mkdir(dir);
        String base = FileUtil.getFileNameWithoutExtension(App.getEntryFileName());
        String fileBase = StringUtil.isBlank(base) ? "image" : base;
        ExportMediaFilePrefs prefs = AppPrefs.getInstance().getScreenshotPrefs();
        String extension = GuiUtil.getWritableImageFileFormats()[prefs.getFileType()];
        File file = FileUtil.createUniqueFile(dir, fileBase, extension, true, prefs.getSuffix());
        ImageConverter imageConverter = null;
        if (weakConverter != null) {
            imageConverter = (ImageConverter)weakConverter.get();
        }
        if (!(imageConverter == null || imageConverter.getPrefs().equals(prefs) && imageConverter.getTvSystem() == element.getTvSystem())) {
            imageConverter.dispose();
            imageConverter = null;
        }
        if (imageConverter == null) {
            imageConverter = new ImageConverter(prefs, element.getTvSystem(), false);
        }
        imageConverter.setImage(element.getImage());
        BufferedImage result = imageConverter.convert();
        weakConverter = new WeakReference<ImageConverter>(imageConverter);
        ImageIO.write((RenderedImage)result, extension, file);
    }

    private static final class QueueElement {
        private final BufferedImage image;
        private final TVSystem tvSystem;

        public QueueElement(BufferedImage image, TVSystem tvSystem) {
            this.image = image;
            this.tvSystem = tvSystem == null ? TVSystem.NTSC : tvSystem;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public TVSystem getTvSystem() {
            return this.tvSystem;
        }
    }
}

