/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import nintaco.gui.rob.GyromitePane;
import nintaco.gui.rob.RobState;
import nintaco.gui.rob.StackUpPane;
import nintaco.util.GuiUtil;

public class RobFrame
extends JFrame {
    private final GyromitePane gyromitePane = new GyromitePane();
    private final StackUpPane stackUpPane = new StackUpPane();
    private volatile int game;

    public RobFrame(int game) {
        this.game = game;
        this.initComponents();
        GuiUtil.scaleFonts(this);
        this.setContentPane(game == 1 ? this.gyromitePane : this.stackUpPane);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    public void setGame(int game) {
        if (this.game != game) {
            this.game = game;
            if (game != 0) {
                this.setContentPane(game == 1 ? this.gyromitePane : this.stackUpPane);
                this.repaint();
            }
        }
    }

    public void render(RobState state) {
        int robGame = state.game;
        if (this.game != robGame) {
            EventQueue.invokeLater(() -> this.setGame(robGame));
        }
        switch (robGame) {
            case 1: {
                this.gyromitePane.render(state);
                break;
            }
            case 2: {
                this.stackUpPane.render(state);
            }
        }
    }

    public void destroy() {
        this.dispose();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Robotic Operating Buddy");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RobFrame.this.formWindowClosing(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }
}

