/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramwatch;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import nintaco.gui.ramwatch.RamWatchRow;
import nintaco.gui.ramwatch.RamWatchTableModel;
import nintaco.gui.ramwatch.Separator;

public class RamWatchRowRenderer
extends DefaultTableCellRenderer {
    private static final Border leftBorder = new EmptyBorder(0, 8, 0, 0);
    private static final Separator separator = new Separator();
    private final Border border;
    private Font monospacedFont;

    public RamWatchRowRenderer(boolean rightJustified) {
        this.setHorizontalAlignment(rightJustified ? 4 : 2);
        this.border = rightJustified ? noFocusBorder : leftBorder;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        RamWatchRow row;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
        RamWatchTableModel tableModel = (RamWatchTableModel)table.getModel();
        if (rowIndex >= 0 && rowIndex < tableModel.getRowCount() && (row = tableModel.getRow(rowIndex)).isSeparator()) {
            separator.setBackground(this.getBackground());
            separator.setForeground(this.getForeground());
            return separator;
        }
        Font tableFont = table.getFont();
        if (this.monospacedFont == null || this.monospacedFont.getSize() != tableFont.getSize()) {
            this.monospacedFont = new Font("Monospaced", 0, tableFont.getSize());
        }
        this.setFont(this.monospacedFont);
        this.setBorder(this.border);
        return this;
    }
}

