/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramwatch;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import nintaco.App;
import nintaco.Machine;
import nintaco.cheats.Cheat;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.cheats.CheatsDialog;
import nintaco.gui.hexeditor.HexEditorFrame;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.ramsearch.RamSearchFrame;
import nintaco.gui.ramwatch.EditRamWatchDialog;
import nintaco.gui.ramwatch.RamWatchRow;
import nintaco.gui.ramwatch.RamWatchRowRenderer;
import nintaco.gui.ramwatch.RamWatchTableModel;
import nintaco.mappers.Mapper;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class RamWatchFrame
extends JFrame {
    private static final FileExtensionFilter[] FILE_FILTERS = new FileExtensionFilter[]{new FileExtensionFilter(0, "Watch list files (*.wch)", "wch"), new FileExtensionFilter(1, "All files (*.*)")};
    private static final int[] SIZES = new int[]{1, 2, 4};
    private static final char[] WORD_SIZES = new char[]{'b', 'w', 'd'};
    private static final char[] FORMATS = new char[]{'s', 'u', 'h'};
    private static final Pattern pattern = Pattern.compile("\\d+\\t(\\p{XDigit}+)\\t(\\D)\\t(\\D)\\t0\\t(.*)");
    private RamWatchTableModel tableModel;
    private volatile Mapper mapper;
    private volatile List<RamWatchRow> ramRows = new ArrayList<RamWatchRow>();
    private JButton addCheatButton;
    private JMenuItem addCheatMenuItem;
    private JPanel buttonsPanel;
    private JMenuItem closeMenuItem;
    private JButton downButton;
    private JButton duplicateButton;
    private JMenuItem duplicateMenuItem;
    private JButton editButton;
    private JMenuItem editMenuItem;
    private JMenuItem exportMenuItem;
    private JMenu fileMenu;
    private JButton hexEditorButton;
    private JMenuItem hexEditorMenuItem;
    private JMenuItem importMenuItem;
    private JPopupMenu.Separator jSeparator3;
    private JMenuBar menuBar;
    private JMenuItem moveDownMenuItem;
    private JMenuItem moveUpMenuItem;
    private JButton newButton;
    private JMenuItem newMenuItem;
    private JButton removeAllButton;
    private JMenuItem removeAllMenuItem;
    private JButton removeButton;
    private JMenuItem removeMenuItem;
    private JScrollPane scrollPane;
    private JButton searchButton;
    private JMenuItem searchMenuItem;
    private JButton separatorButton;
    private JMenuItem separatorMenuItem;
    private JTable table;
    private JButton upButton;
    private JPanel upDownPanel;
    private JMenu watchesMenuItem;
    private JPopupMenu.Separator watchesSeparator1;
    private JPopupMenu.Separator watchesSeparator2;

    public RamWatchFrame(Machine machine) {
        this.initComponents();
        this.initTable();
        this.setMachine(machine);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initTable() {
        this.table.getSelectionModel().addListSelectionListener(e -> this.handleTableSelectionChanged());
        this.tableModel = new RamWatchTableModel();
        this.table.setModel(this.tableModel);
        RamWatchRowRenderer leftRenderer = new RamWatchRowRenderer(false);
        RamWatchRowRenderer rightRenderer = new RamWatchRowRenderer(true);
        for (int i = 0; i < 3; ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(i == 2 ? leftRenderer : rightRenderer);
        }
        GuiUtil.resizeCellSizes(this.table, true, 10, false, "BBBB", "BBBBBBBBBBB", "This is an example description.");
    }

    public void addRamWatch(int address, int wordSizeIndex, int valueFormat) {
        EditRamWatchDialog dialog = new EditRamWatchDialog(this);
        RamWatchRow row = new RamWatchRow();
        row.setAddress(address);
        row.setWordSizeIndex(wordSizeIndex);
        row.setValueFormat(valueFormat);
        dialog.setRamWatchRow(row);
        dialog.setTitle("New RAM Watch");
        dialog.setVisible(true);
        this.insertRow(dialog.getResult());
    }

    private void handleTableSelectionChanged() {
        this.updateButtons();
    }

    public void destroy() {
        this.dispose();
    }

    private void closeFrame() {
        App.destroyRamWatchFrame();
    }

    private void loadGamePrefs() {
        List<RamWatchRow> rows = GamePrefs.getInstance().getRamWatchGamePrefs().getRows();
        EventQueue.invokeLater(() -> {
            Class<GamePrefs> clazz = GamePrefs.class;
            synchronized (GamePrefs.class) {
                this.tableModel.copyRows(rows);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.tableModel.fireTableDataChanged();
                this.onTableRowsChanged();
                return;
            }
        });
    }

    private void moveRowUp() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex > 0 && selectedIndex < this.tableModel.getRowCount()) {
            List<RamWatchRow> rows = this.tableModel.getRows();
            RamWatchRow r0 = rows.get(selectedIndex - 1);
            RamWatchRow r1 = rows.get(selectedIndex);
            rows.set(selectedIndex - 1, r1);
            rows.set(selectedIndex, r0);
            this.tableModel.fireTableRowsUpdated(selectedIndex - 1, selectedIndex);
            this.table.setRowSelectionInterval(selectedIndex - 1, selectedIndex - 1);
            this.onTableRowsChanged();
        }
    }

    private void moveRowDown() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.tableModel.getRowCount() - 1) {
            List<RamWatchRow> rows = this.tableModel.getRows();
            RamWatchRow r0 = rows.get(selectedIndex);
            RamWatchRow r1 = rows.get(selectedIndex + 1);
            rows.set(selectedIndex, r1);
            rows.set(selectedIndex + 1, r0);
            this.tableModel.fireTableRowsUpdated(selectedIndex, selectedIndex + 1);
            this.table.setRowSelectionInterval(selectedIndex + 1, selectedIndex + 1);
            this.onTableRowsChanged();
        }
    }

    private void editRow() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.tableModel.getRowCount()) {
            EditRamWatchDialog dialog = new EditRamWatchDialog(this);
            dialog.setTitle("Edit RAM Watch");
            dialog.setRamWatchRow(this.tableModel.getRows().get(selectedIndex));
            dialog.setVisible(true);
            RamWatchRow row = dialog.getResult();
            if (row != null) {
                List<RamWatchRow> rows = this.tableModel.getRows();
                rows.set(selectedIndex, row);
                this.tableModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
                this.onTableRowsChanged();
            }
        }
    }

    private void removeRow() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.tableModel.getRowCount()) {
            this.tableModel.getRows().remove(selectedIndex);
            this.tableModel.fireTableRowsDeleted(selectedIndex, selectedIndex);
            this.onTableRowsChanged();
        }
    }

    private void removeAllRows() {
        this.clearTable();
    }

    private void newRow() {
        EditRamWatchDialog dialog = new EditRamWatchDialog(this);
        dialog.setTitle("New RAM Watch");
        dialog.setVisible(true);
        this.insertRow(dialog.getResult());
    }

    private void duplicateRow() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.tableModel.getRowCount()) {
            this.insertRow(new RamWatchRow(this.tableModel.getRow(selectedIndex)));
        }
    }

    private void addSeparator() {
        RamWatchRow row = new RamWatchRow();
        row.setSeparator(true);
        this.insertRow(row);
    }

    private void search() {
        App.createRamSearchFrame();
        RamSearchFrame frame = App.getRamSearchFrame();
        if (frame != null) {
            frame.showWatches();
        }
    }

    private void addCheat() {
        int selectedRowIndex = this.table.getSelectedRow();
        if (selectedRowIndex >= 0 && selectedRowIndex < this.tableModel.getRowCount()) {
            RamWatchRow row = this.tableModel.getRow(selectedRowIndex);
            int value = row.getValue() & 0xFF;
            Cheat cheat = new Cheat(row.getAddress(), value, value);
            cheat.generateDescription();
            App.setNoStepPause(true);
            CheatsDialog dialog = new CheatsDialog((Window)this);
            dialog.setNewCheat(cheat);
            dialog.setVisible(true);
            App.setNoStepPause(false);
        }
    }

    private void showHexEditor() {
        int selectedRowIndex = this.table.getSelectedRow();
        if (selectedRowIndex >= 0 && selectedRowIndex < this.tableModel.getRowCount()) {
            RamWatchRow row = this.tableModel.getRow(selectedRowIndex);
            App.createHexEditorFrame();
            HexEditorFrame frame = App.getHexEditorFrame();
            frame.goToAddress(0, row.getAddress());
        }
    }

    private void insertRow(RamWatchRow row) {
        if (row != null) {
            int index;
            List<RamWatchRow> rows = this.tableModel.getRows();
            int selectedIndex = this.table.getSelectedRow();
            if (selectedIndex >= 0 && selectedIndex < rows.size()) {
                index = selectedIndex + 1;
                rows.add(index, row);
            } else {
                rows.add(row);
                index = rows.size() - 1;
            }
            this.tableModel.fireTableRowsInserted(index, index);
            this.table.setRowSelectionInterval(index, index);
            this.onTableRowsChanged();
        }
    }

    private void clearTable() {
        this.tableModel.getRows().clear();
        this.tableModel.fireTableDataChanged();
        this.onTableRowsChanged();
    }

    public final void setMachine(Machine machine) {
        if (machine == null) {
            this.mapper = null;
            EventQueue.invokeLater(this::clearTable);
        } else {
            this.mapper = machine.getMapper();
            this.loadGamePrefs();
        }
        this.updateButtons();
    }

    public void update() {
        Mapper m = this.mapper;
        if (m == null) {
            return;
        }
        List<RamWatchRow> rows = this.ramRows;
        for (int i = rows.size() - 1; i >= 0; --i) {
            int value;
            RamWatchRow row = rows.get(i);
            if (row.isSeparator()) continue;
            int wordSize = SIZES[row.getWordSizeIndex()];
            if (wordSize == 1) {
                value = m.peekCpuMemory(row.getAddress());
            } else {
                value = 0;
                int address = row.getAddress();
                for (int j = wordSize - 1; j >= 0; --j) {
                    value <<= 8;
                    value |= m.peekCpuMemory(address + j);
                }
            }
            if (row.getValue() == value) continue;
            row.setValue(value);
        }
        EventQueue.invokeLater(this::updateTable);
    }

    private void updateTable() {
        List<RamWatchRow> tableRows = this.tableModel.getRows();
        for (int i = tableRows.size() - 1; i >= 0; --i) {
            RamWatchRow tableRow = tableRows.get(i);
            RamWatchRow row = this.ramRows.get(i);
            if (tableRow.isSeparator() || row.getValue() == tableRow.getValue()) continue;
            tableRow.setValue(row.getValue());
            this.tableModel.fireTableCellUpdated(i, 1);
        }
    }

    private void onTableRowsChanged() {
        List<RamWatchRow> tableRows = this.tableModel.getRows();
        ArrayList<RamWatchRow> rows = new ArrayList<RamWatchRow>();
        ArrayList<RamWatchRow> prefRows = new ArrayList<RamWatchRow>();
        for (RamWatchRow row : tableRows) {
            rows.add(new RamWatchRow(row));
            prefRows.add(new RamWatchRow(row));
        }
        this.ramRows = rows;
        this.updateButtons();
        GamePrefs.getInstance().getRamWatchGamePrefs().setRows(prefRows);
        GamePrefs.save();
        RamSearchFrame frame = App.getRamSearchFrame();
        if (frame != null) {
            frame.onWatchesUpdated();
        }
    }

    private boolean hasWatches() {
        for (RamWatchRow row : this.tableModel.getRows()) {
            if (row.isSeparator()) continue;
            return true;
        }
        return false;
    }

    private void updateButtons() {
        if (EventQueue.isDispatchThread()) {
            boolean separatorSelected;
            boolean rowSelected;
            boolean enabled = this.mapper != null;
            int selectedIndex = this.table.getSelectedRow();
            boolean bl = rowSelected = enabled && selectedIndex >= 0 && selectedIndex < this.tableModel.getRowCount();
            if (rowSelected) {
                RamWatchRow row = this.tableModel.getRow(selectedIndex);
                separatorSelected = row.isSeparator();
            } else {
                separatorSelected = false;
            }
            this.upButton.setEnabled(rowSelected && selectedIndex > 0);
            this.downButton.setEnabled(rowSelected && selectedIndex < this.tableModel.getRowCount() - 1);
            this.newButton.setEnabled(enabled);
            this.editButton.setEnabled(rowSelected && !separatorSelected);
            this.removeButton.setEnabled(rowSelected);
            this.removeAllButton.setEnabled(enabled && this.tableModel.getRowCount() > 0);
            this.duplicateButton.setEnabled(rowSelected);
            this.separatorButton.setEnabled(enabled);
            this.searchButton.setEnabled(enabled && this.hasWatches());
            this.addCheatButton.setEnabled(rowSelected && !separatorSelected);
            this.hexEditorButton.setEnabled(rowSelected && !separatorSelected);
            this.moveUpMenuItem.setEnabled(this.upButton.isEnabled());
            this.moveDownMenuItem.setEnabled(this.downButton.isEnabled());
            this.newMenuItem.setEnabled(this.newButton.isEnabled());
            this.editMenuItem.setEnabled(this.editButton.isEnabled());
            this.removeMenuItem.setEnabled(this.removeButton.isEnabled());
            this.removeAllMenuItem.setEnabled(this.removeAllButton.isEnabled());
            this.duplicateMenuItem.setEnabled(this.duplicateButton.isEnabled());
            this.separatorMenuItem.setEnabled(this.separatorButton.isEnabled());
            this.searchMenuItem.setEnabled(this.searchButton.isEnabled());
            this.addCheatMenuItem.setEnabled(this.addCheatButton.isEnabled());
            this.hexEditorMenuItem.setEnabled(this.hexEditorButton.isEnabled());
        } else {
            EventQueue.invokeLater(this::updateButtons);
        }
    }

    private void importWatchList(PleaseWaitDialog pleaseWaitDialog, File file) {
        boolean error = false;
        ArrayList<RamWatchRow> rows = new ArrayList<RamWatchRow>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            br.readLine();
            int rowCount = Integer.parseInt(br.readLine().trim());
            for (int i = 0; i < rowCount; ++i) {
                Matcher matcher = pattern.matcher(br.readLine());
                if (!matcher.find()) continue;
                RamWatchRow row = new RamWatchRow();
                char wordSize = matcher.group(2).charAt(0);
                char format = matcher.group(3).charAt(0);
                if (wordSize == 'S') {
                    row.setSeparator(true);
                    continue;
                }
                row.setAddress(StringUtil.parseInt(matcher.group(1), true, 0L, 65535L));
                switch (wordSize) {
                    case 'b': {
                        row.setWordSizeIndex(0);
                        break;
                    }
                    case 'w': {
                        row.setWordSizeIndex(1);
                        break;
                    }
                    case 'd': {
                        row.setWordSizeIndex(2);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid word size: " + wordSize);
                    }
                }
                switch (format) {
                    case 's': {
                        row.setValueFormat(0);
                        break;
                    }
                    case 'u': {
                        row.setValueFormat(1);
                        break;
                    }
                    case 'h': {
                        row.setValueFormat(2);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid value format: " + format);
                    }
                }
                row.setDescription(matcher.group(4));
                rows.add(row);
            }
        }
        catch (Throwable t) {
            error = true;
        }
        pleaseWaitDialog.dispose();
        if (error) {
            GuiUtil.displayError(this, "Failed to import watch list.");
        } else {
            EventQueue.invokeLater(() -> {
                this.tableModel.setRows(rows);
                this.tableModel.fireTableDataChanged();
                this.onTableRowsChanged();
            });
        }
    }

    private void exportWatchList(PleaseWaitDialog pleaseWaitDialog, File file, List<RamWatchRow> rows) {
        boolean error = false;
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            out.println();
            out.println(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                String description;
                char format;
                char wordSize;
                RamWatchRow row = rows.get(i);
                if (row.isSeparator()) {
                    wordSize = 'S';
                    format = 'S';
                    description = "----------------------------";
                } else {
                    wordSize = WORD_SIZES[row.getWordSizeIndex()];
                    format = FORMATS[row.getValueFormat()];
                    description = row.getDescription();
                }
                out.format("%05d\t%04X\t%c\t%c\t0\t%s%n", i, row.getAddress(), Character.valueOf(wordSize), Character.valueOf(format), description);
            }
        }
        catch (Throwable t) {
            error = true;
        }
        pleaseWaitDialog.dispose();
        if (error) {
            GuiUtil.displayError(this, "Failed to export watch list.");
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.buttonsPanel = new JPanel();
        this.hexEditorButton = new JButton();
        this.addCheatButton = new JButton();
        this.separatorButton = new JButton();
        this.duplicateButton = new JButton();
        this.newButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.upDownPanel = new JPanel();
        this.downButton = new JButton();
        this.upButton = new JButton();
        this.removeAllButton = new JButton();
        this.searchButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.importMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.closeMenuItem = new JMenuItem();
        this.watchesMenuItem = new JMenu();
        this.moveUpMenuItem = new JMenuItem();
        this.moveDownMenuItem = new JMenuItem();
        this.watchesSeparator1 = new JPopupMenu.Separator();
        this.newMenuItem = new JMenuItem();
        this.editMenuItem = new JMenuItem();
        this.removeMenuItem = new JMenuItem();
        this.removeAllMenuItem = new JMenuItem();
        this.duplicateMenuItem = new JMenuItem();
        this.separatorMenuItem = new JMenuItem();
        this.watchesSeparator2 = new JPopupMenu.Separator();
        this.searchMenuItem = new JMenuItem();
        this.addCheatMenuItem = new JMenuItem();
        this.hexEditorMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("RAM Watch");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RamWatchFrame.this.formWindowClosing(evt);
            }
        });
        this.scrollPane.setMaximumSize(null);
        this.scrollPane.setMinimumSize(null);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setSelectionMode(0);
        this.scrollPane.setViewportView(this.table);
        this.hexEditorButton.setMnemonic('x');
        this.hexEditorButton.setText("Hex Editor");
        this.hexEditorButton.setFocusPainted(false);
        this.hexEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.hexEditorButtonActionPerformed(evt);
            }
        });
        this.addCheatButton.setMnemonic('C');
        this.addCheatButton.setText("Add Cheat");
        this.addCheatButton.setFocusPainted(false);
        this.addCheatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.addCheatButtonActionPerformed(evt);
            }
        });
        this.separatorButton.setMnemonic('t');
        this.separatorButton.setText("Separator");
        this.separatorButton.setFocusPainted(false);
        this.separatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.separatorButtonActionPerformed(evt);
            }
        });
        this.duplicateButton.setMnemonic('p');
        this.duplicateButton.setText("Duplicate");
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.duplicateButtonActionPerformed(evt);
            }
        });
        this.newButton.setMnemonic('N');
        this.newButton.setText("New");
        this.newButton.setFocusPainted(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.newButtonActionPerformed(evt);
            }
        });
        this.removeButton.setMnemonic('R');
        this.removeButton.setText("Remove");
        this.removeButton.setFocusPainted(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.removeButtonActionPerformed(evt);
            }
        });
        this.editButton.setMnemonic('E');
        this.editButton.setText("Edit");
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.editButtonActionPerformed(evt);
            }
        });
        this.downButton.setText("<html>&#x25bc;</html>");
        this.downButton.setFocusPainted(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.downButtonActionPerformed(evt);
            }
        });
        this.upButton.setText("<html>&#x25b2;</html>");
        this.upButton.setFocusPainted(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.upButtonActionPerformed(evt);
            }
        });
        GroupLayout upDownPanelLayout = new GroupLayout(this.upDownPanel);
        this.upDownPanel.setLayout(upDownPanelLayout);
        upDownPanelLayout.setHorizontalGroup(upDownPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(upDownPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(upDownPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.upButton, -2, -1, -2).addComponent(this.downButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        upDownPanelLayout.setVerticalGroup(upDownPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(upDownPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.upButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton, -2, -1, -2).addGap(0, 0, 0)));
        this.removeAllButton.setMnemonic('A');
        this.removeAllButton.setText("Remove All");
        this.removeAllButton.setFocusPainted(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.removeAllButtonActionPerformed(evt);
            }
        });
        this.searchButton.setMnemonic('S');
        this.searchButton.setText("Search");
        this.searchButton.setFocusPainted(false);
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.searchButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeAllButton).addComponent(this.removeButton).addComponent(this.duplicateButton).addComponent(this.editButton).addComponent(this.newButton).addComponent(this.separatorButton).addComponent(this.searchButton).addComponent(this.addCheatButton).addComponent(this.hexEditorButton).addComponent(this.upDownPanel, -1, -1, Short.MAX_VALUE));
        buttonsPanelLayout.linkSize(0, this.addCheatButton, this.duplicateButton, this.editButton, this.hexEditorButton, this.newButton, this.removeAllButton, this.removeButton, this.searchButton, this.separatorButton);
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.upDownPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.duplicateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorButton).addGap(18, 18, 18).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addCheatButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexEditorButton).addGap(0, 0, 0)));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                RamWatchFrame.this.fileMenuMenuSelected(evt);
            }
        });
        this.importMenuItem.setMnemonic('I');
        this.importMenuItem.setText("Import Watch List...");
        this.importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.exportMenuItem.setMnemonic('E');
        this.exportMenuItem.setText("Export Watch List...");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportMenuItem);
        this.fileMenu.add(this.jSeparator3);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.closeMenuItem.setMnemonic('C');
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.menuBar.add(this.fileMenu);
        this.watchesMenuItem.setMnemonic('W');
        this.watchesMenuItem.setText("Watches");
        this.moveUpMenuItem.setMnemonic('U');
        this.moveUpMenuItem.setText("Move Up");
        this.moveUpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.moveUpMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.moveUpMenuItem);
        this.moveDownMenuItem.setMnemonic('D');
        this.moveDownMenuItem.setText("Move Down");
        this.moveDownMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.moveDownMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.moveDownMenuItem);
        this.watchesMenuItem.add(this.watchesSeparator1);
        this.newMenuItem.setText("New...");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.newMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.newMenuItem);
        this.editMenuItem.setMnemonic('E');
        this.editMenuItem.setText("Edit...");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.editMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.editMenuItem);
        this.removeMenuItem.setMnemonic('R');
        this.removeMenuItem.setText("Remove");
        this.removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.removeMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.removeMenuItem);
        this.removeAllMenuItem.setMnemonic('A');
        this.removeAllMenuItem.setText("Remove All");
        this.removeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.removeAllMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.removeAllMenuItem);
        this.duplicateMenuItem.setMnemonic('p');
        this.duplicateMenuItem.setText("Duplicate");
        this.duplicateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.duplicateMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.duplicateMenuItem);
        this.separatorMenuItem.setMnemonic('t');
        this.separatorMenuItem.setText("Separator");
        this.separatorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.separatorMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.separatorMenuItem);
        this.watchesMenuItem.add(this.watchesSeparator2);
        this.searchMenuItem.setMnemonic('S');
        this.searchMenuItem.setText("Search...");
        this.searchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.searchMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.searchMenuItem);
        this.addCheatMenuItem.setMnemonic('C');
        this.addCheatMenuItem.setText("Add Cheat...");
        this.addCheatMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.addCheatMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.addCheatMenuItem);
        this.hexEditorMenuItem.setMnemonic('x');
        this.hexEditorMenuItem.setText("Hex Editor...");
        this.hexEditorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamWatchFrame.this.hexEditorMenuItemActionPerformed(evt);
            }
        });
        this.watchesMenuItem.add(this.hexEditorMenuItem);
        this.menuBar.add(this.watchesMenuItem);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonsPanel, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonsPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.moveRowUp();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.moveRowDown();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editRow();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeRow();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.newRow();
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        this.duplicateRow();
    }

    private void separatorButtonActionPerformed(ActionEvent evt) {
        this.addSeparator();
    }

    private void addCheatButtonActionPerformed(ActionEvent evt) {
        this.addCheat();
    }

    private void hexEditorButtonActionPerformed(ActionEvent evt) {
        this.showHexEditor();
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.removeAllRows();
    }

    private void moveUpMenuItemActionPerformed(ActionEvent evt) {
        this.moveRowUp();
    }

    private void moveDownMenuItemActionPerformed(ActionEvent evt) {
        this.moveRowDown();
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        this.newRow();
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        this.editRow();
    }

    private void removeMenuItemActionPerformed(ActionEvent evt) {
        this.removeRow();
    }

    private void removeAllMenuItemActionPerformed(ActionEvent evt) {
        this.removeAllRows();
    }

    private void duplicateMenuItemActionPerformed(ActionEvent evt) {
        this.duplicateRow();
    }

    private void separatorMenuItemActionPerformed(ActionEvent evt) {
        this.addSeparator();
    }

    private void addCheatMenuItemActionPerformed(ActionEvent evt) {
        this.addCheat();
    }

    private void hexEditorMenuItemActionPerformed(ActionEvent evt) {
        this.showHexEditor();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        Paths paths = AppPrefs.getInstance().getPaths();
        FileUtil.mkdir(paths.getWatchesDir());
        JFileChooser chooser = GuiUtil.createFileChooser("Import Watch List", paths.getWatchesDir(), (FileFilter[])FILE_FILTERS);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setWatchesDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.importWatchList(pleaseWaitDialog, selectedFile)).start();
            pleaseWaitDialog.showAfterDelay();
        }
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        Paths paths = AppPrefs.getInstance().getPaths();
        FileUtil.mkdir(paths.getWatchesDir());
        File file = GuiUtil.showSaveAsDialog(this, paths.getWatchesDir(), FileUtil.getFileNameWithoutExtension(App.getEntryFileName()) + ".wch", "wch", FILE_FILTERS[0], true, "Export Watch List");
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setWatchesDir(dir);
            AppPrefs.save();
            List<RamWatchRow> rows = this.ramRows;
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.exportWatchList(pleaseWaitDialog, file, rows)).start();
            pleaseWaitDialog.showAfterDelay();
        }
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        boolean enabled = this.mapper != null;
        this.importMenuItem.setEnabled(enabled);
        this.exportMenuItem.setEnabled(enabled && this.ramRows.size() > 0);
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void searchMenuItemActionPerformed(ActionEvent evt) {
        this.search();
    }
}

