/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramsearch;

import nintaco.gui.ramsearch.RamRow;

public class RamSearchTableRow
extends RamRow {
    public static final String[] HEX_FORMATS = new String[]{"%02X", "%04X", "%08X"};
    protected int address;
    private String addressStr;
    private String currentStr;
    private String priorStr;
    private String changesStr;
    private int wordSizeIndex;
    private int valueFormat;
    private String hexFormat;

    public RamSearchTableRow() {
    }

    public RamSearchTableRow(RamRow row) {
        this.setChanges(row.changes);
        this.setCurrent(row.current);
        this.setFlagged(row.flagged);
        this.setPrior(row.prior);
    }

    public RamSearchTableRow(RamSearchTableRow row) {
        this.address = row.address;
        this.addressStr = row.addressStr;
        this.current = row.current;
        this.currentStr = row.currentStr;
        this.prior = row.prior;
        this.priorStr = row.priorStr;
        this.changes = row.changes;
        this.changesStr = row.changesStr;
        this.flagged = row.flagged;
        this.valueFormat = row.valueFormat;
        this.hexFormat = row.hexFormat;
    }

    public RamSearchTableRow(int address, int current, int prior, int changes, int valueFormat, int wordSizeIndex) {
        this.address = address;
        this.current = current;
        this.prior = prior;
        this.changes = changes;
        this.valueFormat = valueFormat;
        this.setWordSizeIndex(wordSizeIndex);
    }

    public int getWordSizeIndex() {
        return this.wordSizeIndex;
    }

    public int getValueFormat() {
        return this.valueFormat;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
        this.addressStr = null;
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public final void setCurrent(int current) {
        this.current = current;
        this.currentStr = null;
    }

    @Override
    public int getPrior() {
        return this.prior;
    }

    @Override
    public final void setPrior(int prior) {
        this.prior = prior;
        this.priorStr = null;
    }

    @Override
    public int getChanges() {
        return this.changes;
    }

    @Override
    public final void setChanges(int changes) {
        this.changes = changes;
        this.changesStr = null;
    }

    public String getAddressStr() {
        if (this.addressStr == null) {
            this.addressStr = String.format("%04X", this.address);
        }
        return this.addressStr;
    }

    public String getCurrentStr() {
        if (this.currentStr == null) {
            this.currentStr = RamSearchTableRow.formatValue(this.current, this.valueFormat, this.wordSizeIndex, this.hexFormat);
        }
        return this.currentStr;
    }

    public String getPriorStr() {
        if (this.priorStr == null) {
            this.priorStr = RamSearchTableRow.formatValue(this.prior, this.valueFormat, this.wordSizeIndex, this.hexFormat);
        }
        return this.priorStr;
    }

    public String getChangesStr() {
        if (this.changesStr == null) {
            this.changesStr = Integer.toString(this.changes);
        }
        return this.changesStr;
    }

    public void setValueFormat(int valueFormat) {
        this.valueFormat = valueFormat;
        this.currentStr = null;
        this.priorStr = null;
    }

    public final void setWordSizeIndex(int wordSizeIndex) {
        this.wordSizeIndex = wordSizeIndex;
        this.hexFormat = HEX_FORMATS[wordSizeIndex];
        this.currentStr = null;
        this.priorStr = null;
    }

    public static String formatValue(int value, int valueFormat, int wordSizeIndex, String hexFormat) {
        switch (valueFormat) {
            case 0: {
                switch (wordSizeIndex) {
                    case 0: {
                        return Byte.toString((byte)value);
                    }
                    case 1: {
                        return Short.toString((short)value);
                    }
                    case 2: {
                        return Integer.toString(value);
                    }
                }
            }
            case 1: {
                return Integer.toUnsignedString(value);
            }
            case 2: {
                return String.format(hexFormat, value);
            }
        }
        return null;
    }
}

