/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramsearch;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import nintaco.App;
import nintaco.Machine;
import nintaco.PauseStepType;
import nintaco.cheats.Cheat;
import nintaco.gui.cheats.CheatsDialog;
import nintaco.gui.hexeditor.HexEditorFrame;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.QuickSaveListener;
import nintaco.gui.image.QuickSaveStateInfo;
import nintaco.gui.ramsearch.MemoryRange;
import nintaco.gui.ramsearch.RamRow;
import nintaco.gui.ramsearch.RamRowFilter;
import nintaco.gui.ramsearch.RamRowRenderer;
import nintaco.gui.ramsearch.RamSearchPrefs;
import nintaco.gui.ramsearch.RamSearchTableModel;
import nintaco.gui.ramsearch.RamSearchTableRow;
import nintaco.gui.ramwatch.RamWatchFrame;
import nintaco.gui.ramwatch.RamWatchRow;
import nintaco.mappers.Mapper;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class RamSearchFrame
extends JFrame {
    private static final int[] SIZES = new int[]{1, 2, 4};
    private static final int[] MASKS = new int[]{255, 65535, -1};
    private static final MemoryRange[][] RANGES = new MemoryRange[][]{{new MemoryRange(0, 2047)}, {new MemoryRange(0, 2047), new MemoryRange(24576, Short.MAX_VALUE)}, {new MemoryRange(32768, 65535)}};
    private static final RamRowFilter[] FILTERS1 = new RamRowFilter[]{(c, p, s, a, A, B) -> (byte)(c - p) != 0, (c, p, s, a, A, B) -> (byte)(c - p) < 0, (c, p, s, a, A, B) -> (byte)(c - p) > 0, (c, p, s, a, A, B) -> (byte)(c - p) <= 0, (c, p, s, a, A, B) -> (byte)(c - p) >= 0, (c, p, s, a, A, B) -> (byte)(c - A) == 0, (c, p, s, a, A, B) -> (byte)(c - A) == 0 && (byte)(p - B) == 0, (c, p, s, a, A, B) -> (byte)(c - A) == 0 && (byte)(c - p - B) == 0, (c, p, s, a, A, B) -> (byte)(c - p - B) == 0, (c, p, s, a, A, B) -> (byte)(Math.abs(c - p) - B) == 0, (c, p, s, a, A, B) -> A == 0 ? false : (byte)(Math.abs(c % A) - B) == 0, (c, p, s, a, A, B) -> a == A, (c, p, s, a, A, B) -> s >= A};
    private static final RamRowFilter[] FILTERS2 = new RamRowFilter[]{(c, p, s, a, A, B) -> (short)(c - p) != 0, (c, p, s, a, A, B) -> (short)(c - p) < 0, (c, p, s, a, A, B) -> (short)(c - p) > 0, (c, p, s, a, A, B) -> (short)(c - p) <= 0, (c, p, s, a, A, B) -> (short)(c - p) >= 0, (c, p, s, a, A, B) -> (short)(c - A) == 0, (c, p, s, a, A, B) -> (short)(c - A) == 0 && (short)(p - B) == 0, (c, p, s, a, A, B) -> (short)(c - A) == 0 && (short)(c - p - B) == 0, (c, p, s, a, A, B) -> (short)(c - p - B) == 0, (c, p, s, a, A, B) -> (short)(Math.abs(c - p) - B) == 0, (c, p, s, a, A, B) -> A == 0 ? false : (short)(Math.abs(c % A) - B) == 0, (c, p, s, a, A, B) -> a == A, (c, p, s, a, A, B) -> s >= A};
    private static final RamRowFilter[] FILTERS4 = new RamRowFilter[]{(c, p, s, a, A, B) -> c - p != 0, (c, p, s, a, A, B) -> c - p < 0, (c, p, s, a, A, B) -> c - p > 0, (c, p, s, a, A, B) -> c - p <= 0, (c, p, s, a, A, B) -> c - p >= 0, (c, p, s, a, A, B) -> c - A == 0, (c, p, s, a, A, B) -> c - A == 0 && p - B == 0, (c, p, s, a, A, B) -> c - A == 0 && c - p - B == 0, (c, p, s, a, A, B) -> c - p - B == 0, (c, p, s, a, A, B) -> Math.abs(c - p) - B == 0, (c, p, s, a, A, B) -> A == 0 ? false : Math.abs(c % A) - B == 0, (c, p, s, a, A, B) -> a == A, (c, p, s, a, A, B) -> s >= A};
    private static final RamRowFilter[][] FILTERS = new RamRowFilter[][]{FILTERS1, FILTERS2, FILTERS4};
    private static final RamRowFilter ALL_PASS_FILTER = (c, p, s, a, A, B) -> true;
    private final RamRow[] rows = new RamRow[65536];
    private final int[] memory = new int[65536];
    private final ImageFrame imageFrame;
    private final QuickSaveListener quickSaveListener = this::onQuickSaveChanged;
    private List<QuickSaveStateInfo> quickSaveStateInfos;
    private RamSearchTableModel tableModel;
    private int selectedRowIndex = -1;
    private int saveSlotIndex;
    private int alignIndex;
    private boolean aValueAvailable;
    private boolean bValueAvailable;
    private boolean autofilter;
    private JRadioButton[] filterRadioButtons;
    private JRadioButton[] wordSizeRadioButtons;
    private JRadioButton[] formatRadioButtons;
    private JRadioButton[] memoryRangeRadioButtons;
    private volatile Mapper mapper;
    private volatile boolean resetCountsRequest;
    private volatile int memoryRange;
    private volatile int wordSizeIndex;
    private volatile int alignment = 1;
    private volatile int valueFormat;
    private volatile int aValue;
    private volatile int bValue;
    private volatile int filterIndex;
    private volatile RamRowFilter filter = ALL_PASS_FILTER;
    private volatile int[] watchAddresses;
    private JLabel aLabel;
    private JTextField aTextField;
    private JRadioButton abscModaEbRadioButton;
    private JRadioButton abscMpEbRadioButton;
    private JButton addCheatButton;
    private JRadioButton addressEaRadioButton;
    private JComboBox alignComboBox;
    private JLabel alignLabel;
    private JCheckBox autofilterCheckBox;
    private JLabel bLabel;
    private JTextField bTextField;
    private JRadioButton byte1RadioButton;
    private JRadioButton byte2RadioButton;
    private JRadioButton byte4RadioButton;
    private JRadioButton cEaRadioButton;
    private JRadioButton cEacMpEbRadioButton;
    private JRadioButton cEapEbRadioButton;
    private JRadioButton cGEpRadioButton;
    private JRadioButton cGTpRadioButton;
    private JRadioButton cLEpRadioButton;
    private JRadioButton cLTpRadioButton;
    private JRadioButton cMpEbRadioButton;
    private JRadioButton cNEpRadioButton;
    private JRadioButton changesGEaRadioButton;
    private JButton filterButton;
    private ButtonGroup filterCriteriaButtonGroup;
    private ButtonGroup formatButtonGroup;
    private JButton hexEditorButton;
    private JRadioButton hexRadioButton;
    private JButton hideRowButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton loadButton;
    private ButtonGroup memoryButtonGroup;
    private JButton nextFrameButton;
    private JToggleButton pauseButton;
    private JRadioButton ramNvramRadioButton;
    private JRadioButton ramRadioButton;
    private JButton resetCountsButton;
    private JRadioButton romRadioButton;
    private JButton saveButton;
    private JComboBox saveSlotComboBox;
    private JLabel saveSlotLabel;
    private JScrollPane scrollPane;
    private JButton showAllButton;
    private JButton showWatchesButton;
    private JRadioButton signedRadioButton;
    private JTable table;
    private JRadioButton unsignedRadioButton;
    private JButton watchButton;
    private ButtonGroup wordSizeButtonGroup;

    public RamSearchFrame(Machine machine) {
        this.initComponents();
        this.initRadioButtons();
        this.initTable();
        this.loadFields();
        this.setMachine(machine);
        this.imageFrame = App.getImageFrame();
        this.imageFrame.addQuickSaveListener(this.quickSaveListener);
        this.initDocumentListeners();
        this.showAllRows();
        GuiUtil.scaleFonts(this);
        this.updateButtons();
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    public void destroy() {
        this.imageFrame.removeQuickSaveListener(this.quickSaveListener);
        if (this.pauseButton.isSelected()) {
            App.setStepPause(false);
        }
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        App.destroyRamSearchFrame();
    }

    private void initRadioButtons() {
        int index;
        int i;
        this.filterRadioButtons = new JRadioButton[]{this.cNEpRadioButton, this.cLTpRadioButton, this.cGTpRadioButton, this.cLEpRadioButton, this.cGEpRadioButton, this.cEaRadioButton, this.cEapEbRadioButton, this.cEacMpEbRadioButton, this.cMpEbRadioButton, this.abscMpEbRadioButton, this.abscModaEbRadioButton, this.addressEaRadioButton, this.changesGEaRadioButton};
        for (i = this.filterRadioButtons.length - 1; i >= 0; --i) {
            index = i;
            this.filterRadioButtons[i].addActionListener(e -> this.setFilterIndex(index));
        }
        this.wordSizeRadioButtons = new JRadioButton[]{this.byte1RadioButton, this.byte2RadioButton, this.byte4RadioButton};
        for (i = this.wordSizeRadioButtons.length - 1; i >= 0; --i) {
            index = i;
            this.wordSizeRadioButtons[i].addActionListener(e -> this.setWordSizeIndex(index));
        }
        this.formatRadioButtons = new JRadioButton[]{this.signedRadioButton, this.unsignedRadioButton, this.hexRadioButton};
        for (i = this.formatRadioButtons.length - 1; i >= 0; --i) {
            int format = i;
            this.formatRadioButtons[i].addActionListener(e -> this.setValueFormat(format));
        }
        this.memoryRangeRadioButtons = new JRadioButton[]{this.ramRadioButton, this.ramNvramRadioButton, this.romRadioButton};
        for (i = this.memoryRangeRadioButtons.length - 1; i >= 0; --i) {
            int range = i;
            this.memoryRangeRadioButtons[i].addActionListener(e -> this.setMemoryRange(range));
        }
    }

    private void initDocumentListeners() {
        this.aTextField.getDocument().addDocumentListener(GuiUtil.createDocumentListener(this::aTextFieldEdited));
        this.bTextField.getDocument().addDocumentListener(GuiUtil.createDocumentListener(this::bTextFieldEdited));
        GuiUtil.addLoseFocusListener((Window)this, this.aTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.bTextField);
    }

    private void initTable() {
        this.table.getSelectionModel().addListSelectionListener(e -> this.handleTableSelectionChanged());
        for (int i = this.rows.length - 1; i >= 0; --i) {
            this.rows[i] = new RamRow();
        }
        ArrayList<RamSearchTableRow> rs = new ArrayList<RamSearchTableRow>();
        for (int i = 0; i < 2048; ++i) {
            rs.add(new RamSearchTableRow(i, 0, 0, 0, 2, 0));
        }
        this.tableModel = new RamSearchTableModel(rs);
        this.table.setModel(this.tableModel);
        RamRowRenderer renderer = new RamRowRenderer();
        for (int i = 0; i < 4; ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        GuiUtil.resizeCellSizes(this.table, true, 10, false, "BBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB");
    }

    private void handleTableSelectionChanged() {
        this.selectedRowIndex = this.table.getSelectedRow();
        this.updateButtons();
    }

    private void updateFilter() {
        this.filter = !this.aValueAvailable && (this.filterIndex >= 5 && this.filterIndex <= 7 || this.filterIndex >= 10) || !this.bValueAvailable && this.filterIndex >= 6 && this.filterIndex <= 10 ? ALL_PASS_FILTER : FILTERS[this.wordSizeIndex][this.filterIndex];
    }

    private void setFilterIndex(int filterIndex) {
        this.filterIndex = filterIndex;
        this.updateFilter();
        this.updateAB();
    }

    private void setWordSizeIndex(int wordSizeIndex) {
        this.wordSizeIndex = wordSizeIndex;
        this.updateFilter();
        this.updateAB();
        this.resizeTable();
    }

    private void setValueFormat(int valueFormat) {
        this.valueFormat = valueFormat;
        this.updateAB();
        this.updateTableFormatting();
    }

    private void updateTableFormatting() {
        List<RamSearchTableRow> rows = this.tableModel.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            RamSearchTableRow row = rows.get(i);
            row.setWordSizeIndex(this.wordSizeIndex);
            row.setValueFormat(this.valueFormat);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void setMemoryRange(int memoryRange) {
        this.memoryRange = memoryRange;
        this.showAllRows();
    }

    private void updateAB() {
        this.aTextFieldEdited();
        this.bTextFieldEdited();
    }

    private void enableFilterRadioButtons() {
        this.filterRadioButtons[5].setEnabled(this.aValueAvailable);
        this.filterRadioButtons[6].setEnabled(this.aValueAvailable && this.bValueAvailable);
        this.filterRadioButtons[7].setEnabled(this.aValueAvailable && this.bValueAvailable);
        this.filterRadioButtons[8].setEnabled(this.bValueAvailable);
        this.filterRadioButtons[9].setEnabled(this.bValueAvailable);
        this.filterRadioButtons[10].setEnabled(this.aValueAvailable && this.bValueAvailable);
        this.filterRadioButtons[11].setEnabled(this.aValueAvailable);
        this.filterRadioButtons[12].setEnabled(this.aValueAvailable);
    }

    private void aTextFieldEdited() {
        Integer value = this.parseTextField(this.aTextField);
        if (value == null) {
            this.aValueAvailable = false;
        } else {
            this.aValueAvailable = true;
            this.aValue = value;
        }
        this.enableFilterRadioButtons();
    }

    private void bTextFieldEdited() {
        Integer value = this.parseTextField(this.bTextField);
        if (value == null) {
            this.bValueAvailable = false;
        } else {
            this.bValueAvailable = true;
            this.bValue = value;
        }
        this.enableFilterRadioButtons();
    }

    private void setTextField(JTextField textField, Integer value) {
        String text;
        if (value == null) {
            text = "";
        } else {
            block0 : switch (this.filterIndex) {
                case 11: {
                    text = String.format("%04X", value);
                    break;
                }
                case 12: {
                    text = Integer.toString(value);
                    break;
                }
                default: {
                    switch (this.wordSizeIndex) {
                        case 0: {
                            switch (this.valueFormat) {
                                case 0: {
                                    text = Byte.toString((byte)value.intValue());
                                    break block0;
                                }
                                case 1: {
                                    text = Integer.toString(value & 0xFF);
                                    break block0;
                                }
                            }
                            text = String.format("%02X", value & 0xFF);
                            break block0;
                        }
                        case 1: {
                            switch (this.valueFormat) {
                                case 0: {
                                    text = Short.toString((short)value.intValue());
                                    break block0;
                                }
                                case 1: {
                                    text = Integer.toString(value & 0xFFFF);
                                    break block0;
                                }
                            }
                            text = String.format("%04X", value & 0xFFFF);
                            break block0;
                        }
                    }
                    switch (this.valueFormat) {
                        case 0: {
                            text = Integer.toString(value);
                            break block0;
                        }
                        case 1: {
                            text = Integer.toUnsignedString(value);
                            break block0;
                        }
                    }
                    text = String.format("%08X", value);
                }
            }
        }
        textField.setText(text);
    }

    private Integer parseTextField(JTextField textField) {
        long maxValue;
        long minValue;
        block0 : switch (this.filterIndex) {
            case 11: {
                minValue = 0L;
                maxValue = 65535L;
                break;
            }
            case 12: {
                minValue = 0L;
                maxValue = Integer.MAX_VALUE;
                break;
            }
            default: {
                switch (this.wordSizeIndex) {
                    case 0: {
                        if (this.valueFormat == 0) {
                            minValue = -128L;
                            maxValue = 127L;
                            break block0;
                        }
                        minValue = 0L;
                        maxValue = 255L;
                        break block0;
                    }
                    case 1: {
                        if (this.valueFormat == 0) {
                            minValue = -32768L;
                            maxValue = 32767L;
                            break block0;
                        }
                        minValue = 0L;
                        maxValue = 65535L;
                        break block0;
                    }
                }
                if (this.valueFormat == 0) {
                    minValue = Integer.MIN_VALUE;
                    maxValue = Integer.MAX_VALUE;
                    break;
                }
                minValue = 0L;
                maxValue = 0xFFFFFFFFL;
            }
        }
        return StringUtil.parseInt(textField.getText(), this.filterIndex == 11 ? true : (this.filterIndex == 12 ? false : this.valueFormat == 2), minValue, maxValue);
    }

    private boolean hasWatches() {
        for (RamWatchRow row : GamePrefs.getInstance().getRamWatchGamePrefs().getRows()) {
            if (row.isSeparator()) continue;
            return true;
        }
        return false;
    }

    private void updateButtons() {
        if (EventQueue.isDispatchThread()) {
            Mapper m = this.mapper;
            boolean enabled = m != null;
            this.filterButton.setEnabled(enabled);
            this.showAllButton.setEnabled(enabled);
            this.showWatchesButton.setEnabled(enabled && this.hasWatches());
            this.resetCountsButton.setEnabled(enabled);
            this.autofilterCheckBox.setEnabled(enabled);
            this.saveSlotLabel.setEnabled(enabled);
            this.saveSlotComboBox.setEnabled(enabled);
            this.saveButton.setEnabled(enabled);
            this.pauseButton.setEnabled(enabled);
            boolean rowButtonsEnabled = enabled && this.selectedRowIndex >= 0;
            this.hideRowButton.setEnabled(rowButtonsEnabled);
            this.watchButton.setEnabled(rowButtonsEnabled);
            this.addCheatButton.setEnabled(rowButtonsEnabled);
            this.hexEditorButton.setEnabled(rowButtonsEnabled);
            this.updateLoadButton();
            this.nextFrameButton.setEnabled(this.pauseButton.isEnabled() && this.pauseButton.isSelected());
        } else {
            EventQueue.invokeLater(this::updateButtons);
        }
    }

    public final void setMachine(Machine machine) {
        if (machine == null) {
            this.mapper = null;
            this.clearRows();
        } else {
            this.mapper = machine.getMapper();
            this.resetCountsRequest = true;
        }
        this.showAllRows();
        this.updateButtons();
    }

    private void loadFields() {
        RamSearchPrefs prefs = AppPrefs.getInstance().getRamSearchAppPrefs();
        if (prefs.getAValue() == null) {
            this.aValueAvailable = false;
        } else {
            this.aValueAvailable = true;
            this.aValue = prefs.getAValue();
        }
        this.alignIndex = prefs.getAlignIndex();
        this.autofilter = prefs.getAutofilter();
        if (prefs.getBValue() == null) {
            this.bValueAvailable = false;
        } else {
            this.bValueAvailable = true;
            this.bValue = prefs.getBValue();
        }
        this.filterIndex = prefs.getFilterIndex();
        this.memoryRange = prefs.getMemoryRange();
        this.saveSlotIndex = prefs.getSaveSlotIndex();
        this.valueFormat = prefs.getValueFormat();
        this.wordSizeIndex = prefs.getWordSizeIndex();
        this.setTextField(this.aTextField, prefs.getAValue());
        this.alignComboBox.setSelectedIndex(this.alignIndex);
        this.autofilterCheckBox.setSelected(this.autofilter);
        this.setTextField(this.bTextField, prefs.getBValue());
        this.filterRadioButtons[this.filterIndex].setSelected(true);
        this.memoryRangeRadioButtons[this.memoryRange].setSelected(true);
        this.formatRadioButtons[this.valueFormat].setSelected(true);
        this.saveSlotComboBox.setSelectedIndex(this.saveSlotIndex);
        this.wordSizeRadioButtons[this.wordSizeIndex].setSelected(true);
        this.enableFilterRadioButtons();
    }

    private void saveFields() {
        RamSearchPrefs prefs = AppPrefs.getInstance().getRamSearchAppPrefs();
        prefs.setAValue(this.aValueAvailable ? Integer.valueOf(this.aValue) : null);
        prefs.setAlignIndex(this.alignIndex);
        prefs.setAutofilter(this.autofilter);
        prefs.setBValue(this.bValueAvailable ? Integer.valueOf(this.bValue) : null);
        prefs.setFilterIndex(this.filterIndex);
        prefs.setMemoryRange(this.memoryRange);
        prefs.setSaveSlotIndex(this.saveSlotIndex);
        prefs.setValueFormat(this.valueFormat);
        prefs.setWordSizeIndex(this.wordSizeIndex);
        AppPrefs.save();
    }

    public void update() {
        Mapper m = this.mapper;
        if (m == null) {
            return;
        }
        int[] addresses = this.watchAddresses;
        int wordSize = SIZES[this.wordSizeIndex];
        int mask = MASKS[this.wordSizeIndex];
        if (addresses != null) {
            for (int i = addresses.length - 1; i >= 0; --i) {
                int a = addresses[i];
                RamRow row = this.rows[a];
                int value = 0;
                if (wordSize == 1) {
                    value = m.peekCpuMemory(a);
                } else {
                    for (int j = wordSize - 1; j >= 0; --j) {
                        value <<= 8;
                        value |= m.peekCpuMemory(a + j & 0xFFFF);
                    }
                }
                if (row.current != value) {
                    row.prior = row.current;
                    row.current = value;
                    ++row.changes;
                } else {
                    row.prior &= mask;
                }
                if (this.resetCountsRequest) {
                    row.changes = 0;
                }
                row.flagged = !this.filter.filter(row.current, row.prior, row.changes, a, this.aValue, this.bValue);
            }
        } else {
            int a;
            int endAddress;
            int i;
            MemoryRange[] range = RANGES[this.memoryRange];
            for (i = range.length - 1; i >= 0; --i) {
                endAddress = range[i].endAddress;
                for (a = range[i].startAddress; a <= endAddress; ++a) {
                    this.memory[a] = m.peekCpuMemory(a);
                }
            }
            for (i = range.length - 1; i >= 0; --i) {
                endAddress = range[i].endAddress;
                for (a = range[i].startAddress; a <= endAddress; a += this.alignment) {
                    RamRow row = this.rows[a];
                    int value = 0;
                    if (wordSize == 1) {
                        value = this.memory[a];
                    } else {
                        for (int j = wordSize - 1; j >= 0; --j) {
                            value <<= 8;
                            value |= this.memory[a + j & 0xFFFF];
                        }
                    }
                    if (row.current != value) {
                        row.prior = row.current;
                        row.current = value;
                        ++row.changes;
                    } else {
                        row.prior &= mask;
                    }
                    if (this.resetCountsRequest) {
                        row.changes = 0;
                    }
                    row.flagged = !this.filter.filter(row.current, row.prior, row.changes, a, this.aValue, this.bValue);
                }
            }
        }
        this.resetCountsRequest = false;
        EventQueue.invokeLater(this::updateTable);
    }

    private void updateTable() {
        List<RamSearchTableRow> rs = this.tableModel.getRows();
        for (int i = rs.size() - 1; i >= 0; --i) {
            RamSearchTableRow tableRow = rs.get(i);
            RamRow ramRow = this.rows[tableRow.address];
            if (this.autofilter && ramRow.flagged) {
                rs.remove(i);
                this.tableModel.fireTableRowsDeleted(i, i);
                continue;
            }
            boolean rowChanged = false;
            if (tableRow.current != ramRow.current) {
                tableRow.setCurrent(ramRow.current);
                rowChanged = true;
            }
            if (tableRow.prior != ramRow.prior) {
                tableRow.setPrior(ramRow.prior);
                rowChanged = true;
            }
            if (tableRow.changes != ramRow.changes) {
                tableRow.setChanges(ramRow.changes);
                rowChanged = true;
            }
            if (tableRow.flagged != ramRow.flagged) {
                tableRow.setFlagged(ramRow.flagged);
                rowChanged = true;
            }
            if (!rowChanged) continue;
            this.tableModel.fireTableRowsUpdated(i, i);
        }
    }

    private void resizeTable() {
        MemoryRange[] ranges = RANGES[this.memoryRange];
        boolean[] addresses = new boolean[65536];
        List<RamSearchTableRow> tableRows = this.tableModel.getRows();
        for (RamSearchTableRow row : tableRows) {
            block1: for (int i = 3; i >= 0; --i) {
                int address = row.address + i;
                for (int j = ranges.length - 1; j >= 0; --j) {
                    if (ranges[j].startAddress > address || ranges[j].endAddress < address) continue;
                    addresses[address] = true;
                    continue block1;
                }
            }
        }
        ArrayList<RamSearchTableRow> tableRows2 = new ArrayList<RamSearchTableRow>();
        for (int address = 0; address <= 65535; address += this.alignment) {
            if (!addresses[address]) continue;
            RamSearchTableRow row = new RamSearchTableRow(this.rows[address]);
            row.setAddress(address);
            row.setWordSizeIndex(this.wordSizeIndex);
            row.setValueFormat(this.valueFormat);
            tableRows2.add(row);
        }
        this.tableModel.setRows(tableRows2);
        this.tableModel.fireTableDataChanged();
    }

    private void clearRows() {
        for (RamRow row : this.rows) {
            row.changes = 0;
            row.current = 0;
            row.flagged = false;
            row.prior = 0;
        }
    }

    private void showAllRows() {
        if (EventQueue.isDispatchThread()) {
            this.watchAddresses = null;
            ArrayList<RamSearchTableRow> tableRows = new ArrayList<RamSearchTableRow>();
            for (MemoryRange range : RANGES[this.memoryRange]) {
                for (int address = range.startAddress; address <= range.endAddress; address += this.alignment) {
                    RamSearchTableRow row = new RamSearchTableRow(this.rows[address]);
                    row.setAddress(address);
                    row.setWordSizeIndex(this.wordSizeIndex);
                    row.setValueFormat(this.valueFormat);
                    tableRows.add(row);
                }
            }
            this.tableModel.setRows(tableRows);
            this.tableModel.fireTableDataChanged();
        } else {
            EventQueue.invokeLater(this::showAllRows);
        }
    }

    public void onStepPausedChanged(boolean paused) {
        this.pauseButton.setText(paused ? "Resume" : "Pause");
        this.pauseButton.setSelected(paused);
        this.nextFrameButton.setEnabled(paused && this.mapper != null);
    }

    private void onQuickSaveChanged(List<QuickSaveStateInfo> quickSaveStateInfos) {
        this.quickSaveStateInfos = quickSaveStateInfos;
        this.updateLoadButton();
    }

    private void updateLoadButton() {
        this.saveSlotIndex = this.saveSlotComboBox.getSelectedIndex();
        if (this.mapper != null && this.quickSaveStateInfos != null && this.saveSlotIndex < this.quickSaveStateInfos.size()) {
            QuickSaveStateInfo info = this.quickSaveStateInfos.get(this.saveSlotIndex);
            this.loadButton.setEnabled(info.getFile().exists());
        } else {
            this.loadButton.setEnabled(false);
        }
    }

    public void onWatchesUpdated() {
        if (this.watchAddresses != null) {
            this.showWatches();
        }
        this.updateButtons();
    }

    public void showWatches() {
        HashSet<Integer> addresses = new HashSet<Integer>();
        for (RamWatchRow row : GamePrefs.getInstance().getRamWatchGamePrefs().getRows()) {
            if (row.isSeparator()) continue;
            addresses.add(row.getAddress());
        }
        if (addresses.isEmpty()) {
            this.showAllRows();
            return;
        }
        int[] as = new int[addresses.size()];
        int index = 0;
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            as[index++] = (Integer)i.next();
        }
        Arrays.sort(as);
        ArrayList<RamSearchTableRow> tableRows = new ArrayList<RamSearchTableRow>();
        for (int address : as) {
            RamSearchTableRow row = new RamSearchTableRow(this.rows[address]);
            row.setAddress(address);
            row.setWordSizeIndex(this.wordSizeIndex);
            row.setValueFormat(this.valueFormat);
            tableRows.add(row);
        }
        this.tableModel.setRows(tableRows);
        this.tableModel.fireTableDataChanged();
        this.watchAddresses = as;
    }

    private void initComponents() {
        this.filterCriteriaButtonGroup = new ButtonGroup();
        this.wordSizeButtonGroup = new ButtonGroup();
        this.formatButtonGroup = new ButtonGroup();
        this.memoryButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.jPanel1 = new JPanel();
        this.cGTpRadioButton = new JRadioButton();
        this.addressEaRadioButton = new JRadioButton();
        this.cEaRadioButton = new JRadioButton();
        this.cLTpRadioButton = new JRadioButton();
        this.abscModaEbRadioButton = new JRadioButton();
        this.bLabel = new JLabel();
        this.changesGEaRadioButton = new JRadioButton();
        this.cMpEbRadioButton = new JRadioButton();
        this.bTextField = new JTextField();
        this.cEacMpEbRadioButton = new JRadioButton();
        this.abscMpEbRadioButton = new JRadioButton();
        this.aTextField = new JTextField();
        this.cGEpRadioButton = new JRadioButton();
        this.cEapEbRadioButton = new JRadioButton();
        this.cNEpRadioButton = new JRadioButton();
        this.aLabel = new JLabel();
        this.cLEpRadioButton = new JRadioButton();
        this.autofilterCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.byte1RadioButton = new JRadioButton();
        this.byte2RadioButton = new JRadioButton();
        this.byte4RadioButton = new JRadioButton();
        this.alignLabel = new JLabel();
        this.alignComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.signedRadioButton = new JRadioButton();
        this.unsignedRadioButton = new JRadioButton();
        this.hexRadioButton = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.ramRadioButton = new JRadioButton();
        this.ramNvramRadioButton = new JRadioButton();
        this.romRadioButton = new JRadioButton();
        this.filterButton = new JButton();
        this.showAllButton = new JButton();
        this.resetCountsButton = new JButton();
        this.hideRowButton = new JButton();
        this.watchButton = new JButton();
        this.addCheatButton = new JButton();
        this.hexEditorButton = new JButton();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        this.nextFrameButton = new JButton();
        this.saveSlotLabel = new JLabel();
        this.saveSlotComboBox = new JComboBox();
        this.pauseButton = new JToggleButton();
        this.showWatchesButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("RAM Search");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RamSearchFrame.this.formWindowClosing(evt);
            }
        });
        this.scrollPane.setMaximumSize(null);
        this.scrollPane.setMinimumSize(null);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setSelectionMode(0);
        this.scrollPane.setViewportView(this.table);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Filter Criteria"));
        this.filterCriteriaButtonGroup.add(this.cGTpRadioButton);
        this.cGTpRadioButton.setText("<html>Current &gt; Prior</html>");
        this.cGTpRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.addressEaRadioButton);
        this.addressEaRadioButton.setText("<html>Address = A</html>");
        this.addressEaRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.cEaRadioButton);
        this.cEaRadioButton.setText("<html>Current = A</html>");
        this.cEaRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.cLTpRadioButton);
        this.cLTpRadioButton.setText("<html>Current &lt; Prior</html>");
        this.cLTpRadioButton.setActionCommand("");
        this.cLTpRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.abscModaEbRadioButton);
        this.abscModaEbRadioButton.setText("<html>| Current % A | = B</html>");
        this.abscModaEbRadioButton.setFocusPainted(false);
        this.bLabel.setText("B:");
        this.filterCriteriaButtonGroup.add(this.changesGEaRadioButton);
        this.changesGEaRadioButton.setText("<html>Changes &ge; A</html>");
        this.changesGEaRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.cMpEbRadioButton);
        this.cMpEbRadioButton.setText("<html>Current &minus; Prior = B</html>");
        this.cMpEbRadioButton.setFocusPainted(false);
        this.bTextField.setColumns(6);
        this.filterCriteriaButtonGroup.add(this.cEacMpEbRadioButton);
        this.cEacMpEbRadioButton.setText("<html>Current = A, Current &minus; Prior = B</html>");
        this.cEacMpEbRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.abscMpEbRadioButton);
        this.abscMpEbRadioButton.setText("<html>| Current &minus; Prior | = B</html>");
        this.abscMpEbRadioButton.setFocusPainted(false);
        this.aTextField.setColumns(6);
        this.filterCriteriaButtonGroup.add(this.cGEpRadioButton);
        this.cGEpRadioButton.setText("<html>Current &ge; Prior</html>");
        this.cGEpRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.cEapEbRadioButton);
        this.cEapEbRadioButton.setText("<html>Current = A, Prior = B</html>");
        this.cEapEbRadioButton.setFocusPainted(false);
        this.filterCriteriaButtonGroup.add(this.cNEpRadioButton);
        this.cNEpRadioButton.setSelected(true);
        this.cNEpRadioButton.setText("<html>Current &ne; Prior</html>");
        this.cNEpRadioButton.setFocusPainted(false);
        this.aLabel.setText("A:");
        this.filterCriteriaButtonGroup.add(this.cLEpRadioButton);
        this.cLEpRadioButton.setText("<html>Current &le; Prior</html>");
        this.cLEpRadioButton.setFocusPainted(false);
        this.autofilterCheckBox.setText("Auto-filter");
        this.autofilterCheckBox.setFocusPainted(false);
        this.autofilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.autofilterCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autofilterCheckBox).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.aLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.bLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTextField, -2, -1, -2)).addComponent(this.cNEpRadioButton, -2, -1, -2).addComponent(this.cLTpRadioButton, -2, -1, -2).addComponent(this.cGTpRadioButton, -2, -1, -2).addComponent(this.cEaRadioButton, -2, -1, -2).addComponent(this.cEapEbRadioButton, -2, -1, -2).addComponent(this.cEacMpEbRadioButton, -2, -1, -2).addComponent(this.cMpEbRadioButton, -2, -1, -2).addComponent(this.abscMpEbRadioButton, -2, -1, -2).addComponent(this.abscModaEbRadioButton, -2, -1, -2).addComponent(this.cLEpRadioButton, -2, -1, -2).addComponent(this.cGEpRadioButton, -2, -1, -2).addComponent(this.addressEaRadioButton, -2, -1, -2).addComponent(this.changesGEaRadioButton, -2, -1, -2)).addGap(10, 10, 10)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aLabel).addComponent(this.aTextField, -2, -1, -2).addComponent(this.bLabel).addComponent(this.bTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cNEpRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cLTpRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cGTpRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cLEpRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cGEpRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cEaRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cEapEbRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cEacMpEbRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cMpEbRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.abscMpEbRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.abscModaEbRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressEaRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changesGEaRadioButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.autofilterCheckBox).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Word Size"));
        this.wordSizeButtonGroup.add(this.byte1RadioButton);
        this.byte1RadioButton.setSelected(true);
        this.byte1RadioButton.setText("1 byte");
        this.byte1RadioButton.setFocusPainted(false);
        this.wordSizeButtonGroup.add(this.byte2RadioButton);
        this.byte2RadioButton.setText("2 bytes");
        this.byte2RadioButton.setFocusPainted(false);
        this.wordSizeButtonGroup.add(this.byte4RadioButton);
        this.byte4RadioButton.setText("4 bytes");
        this.byte4RadioButton.setFocusPainted(false);
        this.alignLabel.setText("Align:");
        this.alignComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "4"}));
        this.alignComboBox.setFocusable(false);
        this.alignComboBox.setMaximumSize(null);
        this.alignComboBox.setMinimumSize(null);
        this.alignComboBox.setPreferredSize(null);
        this.alignComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.alignComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.byte1RadioButton).addComponent(this.byte2RadioButton).addComponent(this.byte4RadioButton).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.alignLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alignComboBox, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.byte1RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byte2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byte4RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.alignLabel).addComponent(this.alignComboBox, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Format"));
        this.formatButtonGroup.add(this.signedRadioButton);
        this.signedRadioButton.setSelected(true);
        this.signedRadioButton.setText("Signed");
        this.signedRadioButton.setFocusPainted(false);
        this.formatButtonGroup.add(this.unsignedRadioButton);
        this.unsignedRadioButton.setText("Unsigned");
        this.unsignedRadioButton.setFocusPainted(false);
        this.formatButtonGroup.add(this.hexRadioButton);
        this.hexRadioButton.setText("Hex");
        this.hexRadioButton.setFocusPainted(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.signedRadioButton).addComponent(this.unsignedRadioButton).addComponent(this.hexRadioButton)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.signedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unsignedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexRadioButton).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Memory"));
        this.memoryButtonGroup.add(this.ramRadioButton);
        this.ramRadioButton.setSelected(true);
        this.ramRadioButton.setText("RAM");
        this.ramRadioButton.setFocusPainted(false);
        this.memoryButtonGroup.add(this.ramNvramRadioButton);
        this.ramNvramRadioButton.setText("RAM, NVRAM");
        this.ramNvramRadioButton.setFocusPainted(false);
        this.memoryButtonGroup.add(this.romRadioButton);
        this.romRadioButton.setText("ROM");
        this.romRadioButton.setFocusPainted(false);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ramRadioButton).addComponent(this.ramNvramRadioButton).addComponent(this.romRadioButton)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.ramRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ramNvramRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.romRadioButton).addContainerGap()));
        this.filterButton.setMnemonic('F');
        this.filterButton.setText("Filter");
        this.filterButton.setFocusPainted(false);
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.filterButtonActionPerformed(evt);
            }
        });
        this.showAllButton.setMnemonic('A');
        this.showAllButton.setText("Show All");
        this.showAllButton.setFocusPainted(false);
        this.showAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.showAllButtonActionPerformed(evt);
            }
        });
        this.resetCountsButton.setMnemonic('R');
        this.resetCountsButton.setText("Reset Counts");
        this.resetCountsButton.setFocusPainted(false);
        this.resetCountsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.resetCountsButtonActionPerformed(evt);
            }
        });
        this.hideRowButton.setMnemonic('H');
        this.hideRowButton.setText("Hide Row");
        this.hideRowButton.setFocusPainted(false);
        this.hideRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.hideRowButtonActionPerformed(evt);
            }
        });
        this.watchButton.setMnemonic('W');
        this.watchButton.setText("Watch");
        this.watchButton.setFocusPainted(false);
        this.watchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.watchButtonActionPerformed(evt);
            }
        });
        this.addCheatButton.setMnemonic('C');
        this.addCheatButton.setText("Add Cheat");
        this.addCheatButton.setFocusPainted(false);
        this.addCheatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.addCheatButtonActionPerformed(evt);
            }
        });
        this.hexEditorButton.setMnemonic('x');
        this.hexEditorButton.setText("Hex Editor");
        this.hexEditorButton.setFocusPainted(false);
        this.hexEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.hexEditorButtonActionPerformed(evt);
            }
        });
        this.loadButton.setMnemonic('L');
        this.loadButton.setText("Load");
        this.loadButton.setFocusPainted(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.loadButtonActionPerformed(evt);
            }
        });
        this.saveButton.setMnemonic('S');
        this.saveButton.setText("Save");
        this.saveButton.setFocusPainted(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.nextFrameButton.setMnemonic('m');
        this.nextFrameButton.setText("Frame+1");
        this.nextFrameButton.setFocusPainted(false);
        this.nextFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.nextFrameButtonActionPerformed(evt);
            }
        });
        this.saveSlotLabel.setText("Save slot:");
        this.saveSlotLabel.setMaximumSize(null);
        this.saveSlotLabel.setMinimumSize(null);
        this.saveSlotLabel.setPreferredSize(null);
        this.saveSlotComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.saveSlotComboBox.setFocusable(false);
        this.saveSlotComboBox.setMaximumSize(null);
        this.saveSlotComboBox.setMinimumSize(null);
        this.saveSlotComboBox.setPreferredSize(null);
        this.saveSlotComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.saveSlotComboBoxActionPerformed(evt);
            }
        });
        this.pauseButton.setMnemonic('P');
        this.pauseButton.setText("Pause");
        this.pauseButton.setFocusPainted(false);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.pauseButtonActionPerformed(evt);
            }
        });
        this.showWatchesButton.setText("Show Watches");
        this.showWatchesButton.setFocusPainted(false);
        this.showWatchesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RamSearchFrame.this.showWatchesButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, -2).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.saveSlotLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveSlotComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pauseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextFrameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.filterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showWatchesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetCountsButton)).addGroup(layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.hideRowButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.watchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addCheatButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexEditorButton))))).addContainerGap()));
        layout.linkSize(0, this.jPanel2, this.jPanel3, this.jPanel4);
        layout.linkSize(0, this.loadButton, this.nextFrameButton, this.pauseButton, this.saveButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hideRowButton).addComponent(this.watchButton).addComponent(this.addCheatButton).addComponent(this.hexEditorButton).addComponent(this.loadButton).addComponent(this.saveButton).addComponent(this.saveSlotLabel, -2, -1, -2).addComponent(this.saveSlotComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextFrameButton).addComponent(this.pauseButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterButton).addComponent(this.showAllButton).addComponent(this.resetCountsButton).addComponent(this.showWatchesButton))).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void alignComboBoxActionPerformed(ActionEvent evt) {
        this.alignIndex = this.alignComboBox.getSelectedIndex();
        if (this.alignIndex >= 0) {
            this.alignment = SIZES[this.alignIndex];
        }
        this.resizeTable();
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        List<RamSearchTableRow> rs = this.tableModel.getRows();
        for (int i = rs.size() - 1; i >= 0; --i) {
            RamSearchTableRow row = rs.get(i);
            if (!row.isFlagged()) continue;
            rs.remove(i);
            this.tableModel.fireTableRowsDeleted(i, i);
        }
    }

    private void showAllButtonActionPerformed(ActionEvent evt) {
        this.showAllRows();
    }

    private void resetCountsButtonActionPerformed(ActionEvent evt) {
        this.resetCountsRequest = true;
    }

    private void hideRowButtonActionPerformed(ActionEvent evt) {
        if (this.selectedRowIndex >= 0 && this.selectedRowIndex < this.tableModel.getRowCount()) {
            this.tableModel.getRows().remove(this.selectedRowIndex);
            this.tableModel.fireTableRowsDeleted(this.selectedRowIndex, this.selectedRowIndex);
        }
    }

    private void watchButtonActionPerformed(ActionEvent evt) {
        if (this.selectedRowIndex >= 0 && this.selectedRowIndex < this.tableModel.getRowCount()) {
            RamSearchTableRow row = this.tableModel.getRow(this.selectedRowIndex);
            App.createRamWatchFrame();
            RamWatchFrame frame = App.getRamWatchFrame();
            if (frame != null) {
                frame.addRamWatch(row.getAddress(), row.getWordSizeIndex(), row.getValueFormat());
            }
        }
    }

    private void addCheatButtonActionPerformed(ActionEvent evt) {
        if (this.selectedRowIndex >= 0 && this.selectedRowIndex < this.tableModel.getRowCount()) {
            RamSearchTableRow row = this.tableModel.getRow(this.selectedRowIndex);
            int value = row.current & 0xFF;
            Cheat cheat = new Cheat(row.address, value, value);
            cheat.generateDescription();
            App.setNoStepPause(true);
            CheatsDialog dialog = new CheatsDialog((Window)this);
            dialog.setNewCheat(cheat);
            dialog.setVisible(true);
            App.setNoStepPause(false);
        }
    }

    private void hexEditorButtonActionPerformed(ActionEvent evt) {
        if (this.selectedRowIndex >= 0 && this.selectedRowIndex < this.tableModel.getRowCount()) {
            RamSearchTableRow row = this.tableModel.getRow(this.selectedRowIndex);
            App.createHexEditorFrame();
            HexEditorFrame frame = App.getHexEditorFrame();
            frame.goToAddress(0, row.address);
        }
    }

    private void autofilterCheckBoxActionPerformed(ActionEvent evt) {
        this.autofilter = this.autofilterCheckBox.isSelected();
    }

    private void saveSlotComboBoxActionPerformed(ActionEvent evt) {
        this.updateLoadButton();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.saveSlotIndex = this.saveSlotComboBox.getSelectedIndex();
        this.imageFrame.quickSaveState(this.saveSlotIndex + 1);
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.saveSlotIndex = this.saveSlotComboBox.getSelectedIndex();
        this.imageFrame.quickLoadState(this.saveSlotIndex + 1);
    }

    private void nextFrameButtonActionPerformed(ActionEvent evt) {
        App.step(PauseStepType.Frame);
    }

    private void pauseButtonActionPerformed(ActionEvent evt) {
        App.setStepPause(this.pauseButton.isSelected());
    }

    private void showWatchesButtonActionPerformed(ActionEvent evt) {
        this.showWatches();
    }
}

