/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.patterntables;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.PPU;
import nintaco.gui.ImagePanel;
import nintaco.gui.MaxLengthDocument;
import nintaco.gui.patterntables.PatternTablesPrefs;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;

public class PatternTablesFrame
extends JFrame {
    private static final int[] GRAY_PALETTE = new int[]{0, 0xFFFFFF, 0xB2B2B2, 0x757575};
    private final int[] colorSet = new int[4];
    private final DocumentListener scanlineListener = GuiUtil.createDocumentListener(this::scanlineUpdated);
    private volatile MachineRunner machineRunner;
    private volatile Machine machine;
    private volatile PPU ppu;
    private volatile int sprite0Hits;
    private volatile int updateScanline;
    private volatile int colorSetIndex;
    private volatile int framesPerUpdate;
    private volatile int frames;
    private volatile int paletteBoxX;
    private volatile int lastPaletteBoxX = -1;
    private volatile int tileBoxX;
    private volatile int tileBoxY;
    private volatile int lastTileBoxX = -1;
    private volatile int lastTileBoxY = -1;
    private volatile boolean updateOnSprite0Hit;
    private int mouseX;
    private int mouseY;
    private int lastTile = -1;
    private int lastPalette = -1;
    private int lastColor = -1;
    private JButton closeButton;
    private JLabel colorLabel;
    private JLabel colorNameLabel;
    private JComboBox colorSetComboBox;
    private JLabel colorSetLabel;
    private JButton defaultsButton;
    private JComboBox framesPerUpdateComboBox;
    private JLabel framesPerUpdateLabel;
    private JLabel paletteLabel;
    private JLabel paletteNameLabel;
    private JPanel patternTablesPanel;
    private JButton resizeButton;
    private JLabel scanlineLabel;
    private JTextField scanlineTextField;
    private JCheckBox sprite0CheckBox;
    private JLabel tileLabel;
    private JLabel tileNameLabel;

    public PatternTablesFrame(MachineRunner machineRunner) {
        this.initComponents();
        this.scanlineTextField.setDocument(new MaxLengthDocument(3, this.scanlineListener));
        this.loadFields();
        this.setMachineRunner(machineRunner);
        this.patternTablesPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PatternTablesFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                PatternTablesFrame.this.mouseUpdated(e.getX(), e.getY());
            }
        });
        this.patternTablesPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PatternTablesFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PatternTablesFrame.this.mouseUpdated(e.getX(), e.getY());
                PatternTablesFrame.this.mouseButtonPressed(e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PatternTablesFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PatternTablesFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PatternTablesFrame.this.mouseOutOfBounds();
            }
        });
        GuiUtil.makeMonospaced(this.tileLabel);
        GuiUtil.makeMonospaced(this.paletteLabel);
        GuiUtil.makeMonospaced(this.colorLabel);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
        this.resizeButton.requestFocus();
    }

    private void setScanlineTextFieldText(String text) {
        this.scanlineTextField.getDocument().removeDocumentListener(this.scanlineListener);
        this.scanlineTextField.setText(text);
        this.scanlineTextField.getDocument().addDocumentListener(this.scanlineListener);
    }

    private void scanlineUpdated() {
        this.updateScanline = 0;
        try {
            int value = Integer.parseInt(this.scanlineTextField.getText().trim());
            Machine m = this.machine;
            if (value >= -1 && value < (m == null ? TVSystem.PAL.getScanlineCount() : m.getMapper().getTVSystem().getScanlineCount()) - 1) {
                this.updateScanline = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mouseButtonPressed(int x, int y) {
        if (y >= 136 && y < 152 && x >= 0 && x < 256) {
            this.colorSetComboBox.setSelectedIndex((x >> 6) + 1);
            MachineRunner r = this.machineRunner;
            if (r != null && r.isPaused()) {
                this.update(this.machine, this.ppu);
            }
        }
    }

    private void mouseUpdated(int x, int y) {
        if (this.mouseX == x && this.mouseY == y) {
            return;
        }
        this.mouseX = x;
        this.mouseY = y;
        PPU p = this.ppu;
        Machine m = this.machine;
        if (y >= 0 && y < 128) {
            int tile;
            this.tileBoxX = x & 0xF8;
            this.tileBoxY = y & 0x78;
            if (x >= 0 && x < 128) {
                tile = y >> 3 << 4 | x >> 3;
                if (this.lastTile != tile) {
                    this.tileLabel.setText(String.format("$0%02X", tile));
                    this.lastTile = tile;
                }
            } else if (x > 128 && x < 256) {
                tile = y >> 3 << 4 | x - 129 >> 3;
                if (this.lastTile != tile) {
                    this.tileLabel.setText(String.format("$1%02X", tile));
                    this.lastTile = tile;
                }
            } else if (this.lastTile != -1) {
                this.tileLabel.setText("-   ");
                this.lastTile = -1;
            }
            this.paletteBoxX = -1;
        } else {
            if (this.lastTile != -1) {
                this.tileLabel.setText("-   ");
                this.lastTile = -1;
            }
            if (y >= 136 && y < 168 && x >= 0 && x < 256) {
                int palette = y - 136 & 0xF0 | x >> 4;
                if (this.lastPalette != palette) {
                    this.paletteLabel.setText(String.format("$%02X", palette));
                    this.lastPalette = palette;
                }
                if (p == null) {
                    if (this.lastColor != -1) {
                        this.colorLabel.setText("-  ");
                        this.lastColor = -1;
                    }
                } else {
                    int color = p.getPaletteRAM()[palette];
                    if (this.lastColor != color) {
                        this.colorLabel.setText(String.format("$%02X", color));
                        this.lastColor = color;
                    }
                }
                this.paletteBoxX = y < 152 ? x & 0xC0 : -1;
            } else {
                if (this.lastPalette != -1) {
                    this.paletteLabel.setText("-  ");
                    this.lastPalette = -1;
                }
                if (this.lastColor != -1) {
                    this.colorLabel.setText("-  ");
                    this.lastColor = -1;
                }
                this.paletteBoxX = -1;
            }
            this.tileBoxY = -1;
            this.tileBoxX = -1;
        }
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(m, p);
        }
    }

    private void mouseOutOfBounds() {
        this.mouseX = -1;
        this.mouseY = -1;
        if (this.lastTile != -1) {
            this.tileLabel.setText("-   ");
            this.lastTile = -1;
        }
        if (this.lastPalette != -1) {
            this.paletteLabel.setText("-  ");
            this.lastPalette = -1;
        }
        if (this.lastColor != -1) {
            this.colorLabel.setText("-  ");
            this.lastColor = -1;
        }
        this.paletteBoxX = -1;
        this.tileBoxY = -1;
        this.tileBoxX = -1;
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(this.machine, this.ppu);
        }
    }

    public void destroy() {
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        App.destroyPatternTablesFrame();
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getPatternTablesPrefs());
    }

    private void loadFields(PatternTablesPrefs prefs) {
        this.updateScanline = prefs.getUpdateScanline();
        this.colorSetIndex = prefs.getColorSetIndex();
        this.framesPerUpdate = prefs.getFramesPerUpdate();
        this.updateOnSprite0Hit = prefs.isUpdateOnSprite0Hit();
        this.setScanlineTextFieldText(Integer.toString(this.updateScanline));
        this.colorSetComboBox.setSelectedIndex(this.colorSetIndex + 1);
        this.framesPerUpdateComboBox.setSelectedItem(Integer.toString(this.framesPerUpdate));
        this.sprite0CheckBox.setSelected(this.updateOnSprite0Hit);
        this.updateScanlineComponents();
    }

    private void saveFields() {
        PatternTablesPrefs prefs = AppPrefs.getInstance().getPatternTablesPrefs();
        prefs.setUpdateScanline(this.updateScanline);
        prefs.setColorSetIndex(this.colorSetIndex);
        prefs.setFramesPerUpdate(this.framesPerUpdate);
        prefs.setUpdateOnSprite0Hit(this.updateOnSprite0Hit);
        AppPrefs.save();
    }

    private void updateScanlineComponents() {
        boolean enabled = !this.sprite0CheckBox.isSelected();
        this.scanlineLabel.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
    }

    public final void setMachineRunner(MachineRunner machineRunner) {
        this.machineRunner = machineRunner;
        this.machine = machineRunner != null ? machineRunner.getMachine() : null;
        if (this.machine == null) {
            this.ppu = null;
            ((ImagePanel)this.patternTablesPanel).clearScreen();
        } else {
            this.ppu = this.machine.getPPU();
            if (machineRunner.isPaused()) {
                this.update(this.machine, this.ppu);
            }
        }
    }

    public void update(int scanline) {
        Machine m = this.machine;
        PPU p = this.ppu;
        if (m == null || p == null) {
            return;
        }
        if (this.updateOnSprite0Hit) {
            if (!p.isSprite0Hit()) {
                this.sprite0Hits = 0;
                return;
            }
            if (++this.sprite0Hits != 2) {
                return;
            }
        } else if (scanline != this.updateScanline) {
            return;
        }
        if (--this.frames > 0 && this.lastPaletteBoxX == this.paletteBoxX && this.lastTileBoxX == this.tileBoxX && this.lastTileBoxY == this.tileBoxY) {
            return;
        }
        this.frames = this.framesPerUpdate;
        this.update(m, p);
    }

    private synchronized void update(Machine m, PPU p) {
        int boxX;
        int i;
        int[] colors;
        ImagePanel imagePanel = (ImagePanel)this.patternTablesPanel;
        if (m == null || p == null) {
            imagePanel.clearScreen();
            return;
        }
        int[] palette = PaletteUtil.getExtendedPalette(m);
        if (this.colorSetIndex < 0) {
            colors = GRAY_PALETTE;
        } else {
            colors = this.colorSet;
            int offset = this.colorSetIndex << 2;
            for (i = 3; i >= 0; --i) {
                colors[i] = palette[p.getPaletteRamValue(offset | i)];
            }
        }
        int[] screen = imagePanel.getScreen();
        for (i = 0; i < 2; ++i) {
            int xOffset = i == 0 ? 0 : 128;
            int address = i == 0 ? 0 : 4096;
            for (int tileY = 0; tileY < 128; tileY += 8) {
                int tileX = 0;
                while (tileX < 128) {
                    int address1 = address | 8;
                    int screenX = xOffset | tileX;
                    for (int y = 0; y < 8; ++y) {
                        int b0 = p.peekVRAM(address + y);
                        int b1 = p.peekVRAM(address1 + y);
                        int index = (tileY | y) << 8 | screenX;
                        for (int x = 0; x < 8; ++x) {
                            int shift = 7 - x;
                            screen[index | x] = colors[(b1 >> shift & 1) << 1 | b0 >> shift & 1];
                        }
                    }
                    tileX += 8;
                    address += 16;
                }
            }
        }
        for (i = 16; i >= 0; i -= 16) {
            int yOffset = 136 + i;
            for (int j = 15; j >= 0; --j) {
                int xStart = (j & 3) == 3 ? 14 : 15;
                int color = palette[p.getPaletteRamValue(i | j)];
                int xOffset = j << 4;
                for (int y = 15; y >= 0; --y) {
                    int rowOffset = yOffset + y << 8 | xOffset;
                    for (int x = xStart; x >= 0; --x) {
                        screen[rowOffset | x] = color;
                    }
                }
            }
        }
        this.lastPaletteBoxX = boxX = this.paletteBoxX;
        if (boxX >= 0) {
            int i2;
            int row0 = 0x8800 | boxX;
            int row1 = 0x9700 | boxX;
            for (i2 = 62; i2 >= 0; --i2) {
                int n = row0 | i2;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n2 = row1 | i2;
                screen[n2] = screen[n2] ^ 0xFFFFFF;
            }
            for (i2 = 14; i2 >= 1; --i2) {
                int index;
                int n = index = 136 + i2 << 8 | boxX;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n3 = index + 62;
                screen[n3] = screen[n3] ^ 0xFFFFFF;
            }
        }
        int tx = this.tileBoxX;
        int ty = this.tileBoxY;
        this.lastTileBoxX = tx;
        this.lastTileBoxY = ty;
        if (tx >= 0 && ty >= 0) {
            int i3;
            int ox0 = ty << 8 | tx;
            int ox7 = ty + 7 << 8 | tx;
            for (i3 = 7; i3 >= 0; --i3) {
                int n = ox0 + i3;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n4 = ox7 + i3;
                screen[n4] = screen[n4] ^ 0xFFFFFF;
            }
            for (i3 = 6; i3 > 0; --i3) {
                int offset;
                int n = offset = ty + i3 << 8 | tx;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n5 = offset | 7;
                screen[n5] = screen[n5] ^ 0xFFFFFF;
            }
        }
        imagePanel.render();
        EventQueue.invokeLater(() -> this.mouseUpdated(this.mouseX, this.mouseY));
    }

    private void initComponents() {
        this.patternTablesPanel = new ImagePanel(256, 168, 2);
        this.paletteNameLabel = new JLabel();
        this.paletteLabel = new JLabel();
        this.tileNameLabel = new JLabel();
        this.tileLabel = new JLabel();
        this.scanlineLabel = new JLabel();
        this.scanlineTextField = new JTextField();
        this.framesPerUpdateLabel = new JLabel();
        this.framesPerUpdateComboBox = new JComboBox();
        this.resizeButton = new JButton();
        this.colorSetLabel = new JLabel();
        this.colorSetComboBox = new JComboBox();
        this.colorNameLabel = new JLabel();
        this.colorLabel = new JLabel();
        this.sprite0CheckBox = new JCheckBox();
        this.closeButton = new JButton();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Pattern Tables");
        this.setMinimumSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PatternTablesFrame.this.formWindowClosing(evt);
            }
        });
        this.patternTablesPanel.setMaximumSize(null);
        GroupLayout patternTablesPanelLayout = new GroupLayout(this.patternTablesPanel);
        this.patternTablesPanel.setLayout(patternTablesPanelLayout);
        patternTablesPanelLayout.setHorizontalGroup(patternTablesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        patternTablesPanelLayout.setVerticalGroup(patternTablesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 111, Short.MAX_VALUE));
        this.paletteNameLabel.setText("Palette:");
        this.paletteNameLabel.setMaximumSize(null);
        this.paletteNameLabel.setMinimumSize(null);
        this.paletteNameLabel.setPreferredSize(null);
        this.paletteLabel.setText("-");
        this.paletteLabel.setToolTipText("");
        this.paletteLabel.setMaximumSize(null);
        this.paletteLabel.setMinimumSize(null);
        this.paletteLabel.setPreferredSize(null);
        this.tileNameLabel.setText("Tile:");
        this.tileNameLabel.setMaximumSize(null);
        this.tileNameLabel.setMinimumSize(null);
        this.tileNameLabel.setPreferredSize(null);
        this.tileLabel.setText("-   ");
        this.tileLabel.setMaximumSize(null);
        this.tileLabel.setMinimumSize(null);
        this.tileLabel.setPreferredSize(null);
        this.scanlineLabel.setText("Update on scanline:");
        this.scanlineLabel.setToolTipText("");
        this.scanlineLabel.setMaximumSize(null);
        this.scanlineLabel.setMinimumSize(null);
        this.scanlineLabel.setPreferredSize(null);
        this.scanlineTextField.setColumns(4);
        this.scanlineTextField.setText("0");
        this.scanlineTextField.setPreferredSize(null);
        this.scanlineTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.scanlineTextFieldActionPerformed(evt);
            }
        });
        this.framesPerUpdateLabel.setText("Frames per update:");
        this.framesPerUpdateLabel.setMaximumSize(null);
        this.framesPerUpdateLabel.setMinimumSize(null);
        this.framesPerUpdateLabel.setPreferredSize(null);
        this.framesPerUpdateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "5", "15", "30", "60"}));
        this.framesPerUpdateComboBox.setFocusable(false);
        this.framesPerUpdateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.framesPerUpdateComboBoxActionPerformed(evt);
            }
        });
        this.resizeButton.setMnemonic('R');
        this.resizeButton.setText("Resize");
        this.resizeButton.setPreferredSize(null);
        this.resizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.resizeButtonActionPerformed(evt);
            }
        });
        this.colorSetLabel.setText("Color set:");
        this.colorSetLabel.setMaximumSize(null);
        this.colorSetLabel.setMinimumSize(null);
        this.colorSetLabel.setPreferredSize(null);
        this.colorSetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "0", "1", "2", "3"}));
        this.colorSetComboBox.setFocusable(false);
        this.colorSetComboBox.setMaximumSize(null);
        this.colorSetComboBox.setMinimumSize(null);
        this.colorSetComboBox.setPreferredSize(null);
        this.colorSetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.colorSetComboBoxActionPerformed(evt);
            }
        });
        this.colorNameLabel.setText("Color:");
        this.colorNameLabel.setMaximumSize(null);
        this.colorNameLabel.setMinimumSize(null);
        this.colorNameLabel.setPreferredSize(null);
        this.colorLabel.setText("-  ");
        this.colorLabel.setMaximumSize(null);
        this.colorLabel.setMinimumSize(null);
        this.colorLabel.setPreferredSize(null);
        this.sprite0CheckBox.setText("Update on sprite 0 hit");
        this.sprite0CheckBox.setMaximumSize(null);
        this.sprite0CheckBox.setMinimumSize(null);
        this.sprite0CheckBox.setPreferredSize(null);
        this.sprite0CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.sprite0CheckBoxActionPerformed(evt);
            }
        });
        this.closeButton.setMnemonic('C');
        this.closeButton.setText("Close");
        this.closeButton.setPreferredSize(null);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternTablesFrame.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternTablesPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tileNameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.paletteNameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paletteLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.colorNameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.colorSetLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorSetComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.framesPerUpdateLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.framesPerUpdateComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.sprite0CheckBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.scanlineLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineTextField, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resizeButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton, -2, -1, -2))).addContainerGap()));
        layout.linkSize(0, this.closeButton, this.defaultsButton, this.resizeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.patternTablesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paletteNameLabel, -2, -1, -2).addComponent(this.paletteLabel, -2, -1, -2).addComponent(this.tileNameLabel, -2, -1, -2).addComponent(this.tileLabel, -2, -1, -2).addComponent(this.colorNameLabel, -2, -1, -2).addComponent(this.colorLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.framesPerUpdateLabel, -2, -1, -2).addComponent(this.framesPerUpdateComboBox, -2, -1, -2).addComponent(this.colorSetLabel, -2, -1, -2).addComponent(this.colorSetComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanlineLabel, -2, -1, -2).addComponent(this.scanlineTextField, -2, -1, -2).addComponent(this.sprite0CheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resizeButton, -2, -1, -2).addComponent(this.closeButton, -2, -1, -2).addComponent(this.defaultsButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void resizeButtonActionPerformed(ActionEvent evt) {
        this.pack();
    }

    private void colorSetComboBoxActionPerformed(ActionEvent evt) {
        int value = this.colorSetComboBox.getSelectedIndex();
        this.colorSetIndex = value >= 0 ? value - 1 : -1;
        this.frames = 1;
    }

    private void framesPerUpdateComboBoxActionPerformed(ActionEvent evt) {
        Object item = this.framesPerUpdateComboBox.getSelectedItem();
        if (item != null) {
            try {
                this.framesPerUpdate = Integer.parseInt(item.toString().trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void scanlineTextFieldActionPerformed(ActionEvent evt) {
        this.requestFocusInWindow();
    }

    private void sprite0CheckBoxActionPerformed(ActionEvent evt) {
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        this.updateScanlineComponents();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new PatternTablesPrefs());
    }
}

