/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.palettes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import nintaco.gui.palettes.PaletteOptionsDialog;

public class PalettePanel
extends JPanel {
    private static final int PREFERRED_SQUARE_SIZE = 42;
    private static final Dimension PREFERRED_SIZE = new Dimension(672, 168);
    private final PaletteOptionsDialog paletteOptionsDialog;
    private int[] palette = new int[64];
    private int panelWidth;
    private int panelHeight;
    private int squareSize;
    private int imageX;
    private int imageY;
    private int imageWidth;
    private int imageHeight;
    private int selectedX;
    private int selectedY;
    private int selectedIndex = -1;

    public PalettePanel(final PaletteOptionsDialog paletteOptionsDialog) {
        this.paletteOptionsDialog = paletteOptionsDialog;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PalettePanel.this.panelResized();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Color newColor;
                PalettePanel.this.updateSelectedIndex(e.getX(), e.getY());
                if (PalettePanel.this.selectedIndex >= 0 && (newColor = JColorChooser.showDialog(PalettePanel.this, "Select Palette Color", new Color(PalettePanel.this.palette[PalettePanel.this.selectedIndex]))) != null) {
                    ((PalettePanel)PalettePanel.this).palette[((PalettePanel)PalettePanel.this).selectedIndex] = newColor.getRGB() & 0xFFFFFF;
                    paletteOptionsDialog.paletteSelectionChanged(PalettePanel.this.selectedIndex, PalettePanel.this.palette[PalettePanel.this.selectedIndex]);
                }
                PalettePanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PalettePanel.this.selectedIndex = -1;
                paletteOptionsDialog.paletteSelectionChanged(-1, -1);
                PalettePanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PalettePanel.this.updateSelectedIndex(e.getX(), e.getY());
                PalettePanel.this.repaint();
            }
        });
    }

    private void updateSelectedIndex(int mouseX, int mouseY) {
        int x = mouseX - this.imageX;
        int y = mouseY - this.imageY;
        if (x < 0 || y < 0 || x >= this.imageWidth || y >= this.imageHeight) {
            this.selectedIndex = -1;
        } else {
            int X = x / this.squareSize;
            int Y = y / this.squareSize;
            this.selectedIndex = Y << 4 | X;
            this.selectedX = this.imageX + this.squareSize * X;
            this.selectedY = this.imageY + this.squareSize * Y;
        }
        this.paletteOptionsDialog.paletteSelectionChanged(this.selectedIndex, this.selectedIndex < 0 ? -1 : this.palette[this.selectedIndex]);
    }

    private void panelResized() {
        this.panelWidth = this.getWidth();
        this.panelHeight = this.getHeight();
        this.squareSize = Math.min(this.panelWidth >> 4, this.panelHeight >> 2);
        this.imageWidth = this.squareSize << 4;
        this.imageHeight = this.squareSize << 2;
        this.imageX = this.panelWidth - this.imageWidth >> 1;
        this.imageY = this.panelHeight - this.imageHeight >> 1;
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void setPalette(int[] palette) {
        this.palette = palette == null ? new int[64] : palette;
        this.repaint();
    }

    public int[] getPalette() {
        return this.palette;
    }

    public void getPalette(int[] target) {
        System.arraycopy(this.palette, 0, target, 0, this.palette.length);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.panelResized();
        super.paintComponent(g);
        for (int y = 3; y >= 0; --y) {
            for (int x = 15; x >= 0; --x) {
                g.setColor(new Color(this.palette[y << 4 | x]));
                g.fillRect(this.imageX + this.squareSize * x, this.imageY + this.squareSize * y, this.squareSize, this.squareSize);
            }
        }
        g.setColor(Color.BLACK);
        g.drawRect(this.imageX, this.imageY, this.imageWidth - 1, this.imageHeight - 1);
        if (this.selectedIndex >= 0) {
            g.setXORMode(Color.WHITE);
            g.drawRect(this.selectedX, this.selectedY, this.squareSize - 1, this.squareSize - 1);
        }
    }
}

