/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.overscan;

import java.awt.Window;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nintaco.tv.ScreenBorders;
import nintaco.util.GuiUtil;

public class OverscanPanel
extends JPanel {
    private JLabel bottomLabel;
    private JSpinner bottomSpinner;
    private JLabel leftLabel;
    private JSpinner leftSpinner;
    private JLabel rightLabel;
    private JSpinner rightSpinner;
    private JLabel topLabel;
    private JSpinner topSpinner;

    public OverscanPanel() {
        this.initComponents();
    }

    public void init(Window window) {
        GuiUtil.addLoseFocusListener(window, this.topSpinner);
        GuiUtil.addLoseFocusListener(window, this.bottomSpinner);
        GuiUtil.addLoseFocusListener(window, this.leftSpinner);
        GuiUtil.addLoseFocusListener(window, this.rightSpinner);
    }

    public void setScreenBorders(ScreenBorders borders) {
        this.setTop(borders.getTop());
        this.setBottom(borders.getBottom());
        this.setLeft(borders.getLeft());
        this.setRight(borders.getRight());
    }

    public ScreenBorders getScreenBorders() {
        return new ScreenBorders(this.getTop(), this.getBottom(), this.getLeft(), this.getRight());
    }

    public void setTop(int top) {
        this.topSpinner.setValue(top);
    }

    public int getTop() {
        return (Integer)this.topSpinner.getValue();
    }

    public void setBottom(int bottom) {
        this.bottomSpinner.setValue(bottom);
    }

    public int getBottom() {
        return (Integer)this.bottomSpinner.getValue();
    }

    public void setLeft(int left) {
        this.leftSpinner.setValue(left);
    }

    public int getLeft() {
        return (Integer)this.leftSpinner.getValue();
    }

    public void setRight(int right) {
        this.rightSpinner.setValue(right);
    }

    public int getRight() {
        return (Integer)this.rightSpinner.getValue();
    }

    private void initComponents() {
        this.topLabel = new JLabel();
        this.bottomLabel = new JLabel();
        this.leftLabel = new JLabel();
        this.rightLabel = new JLabel();
        this.topSpinner = new JSpinner();
        this.bottomSpinner = new JSpinner();
        this.leftSpinner = new JSpinner();
        this.rightSpinner = new JSpinner();
        this.topLabel.setText("Top:");
        this.bottomLabel.setText("Bottom:");
        this.leftLabel.setText("Left:");
        this.rightLabel.setText("Right:");
        this.topSpinner.setModel(new SpinnerNumberModel(0, 0, 120, 1));
        this.bottomSpinner.setModel(new SpinnerNumberModel(0, 0, 120, 1));
        this.leftSpinner.setModel(new SpinnerNumberModel(0, 0, 128, 1));
        this.rightSpinner.setModel(new SpinnerNumberModel(0, 0, 128, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topLabel).addComponent(this.bottomLabel).addComponent(this.leftLabel).addComponent(this.rightLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topSpinner).addComponent(this.bottomSpinner).addComponent(this.leftSpinner).addComponent(this.rightSpinner)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topLabel).addComponent(this.topSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bottomLabel).addComponent(this.bottomSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.leftLabel).addComponent(this.leftSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rightLabel).addComponent(this.rightSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

