/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.overscan;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.gui.overscan.OverscanPanel;
import nintaco.gui.overscan.OverscanPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;

public class OverscanDialog
extends JDialog {
    private JButton cancelButton;
    private JButton defaultsButton;
    private OverscanPanel dendyPanel;
    private OverscanPanel ntscPanel;
    private JButton okButton;
    private OverscanPanel palPanel;

    public OverscanDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initOverscanPanels();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.okButton.requestFocus();
    }

    private void initOverscanPanels() {
        this.ntscPanel.init(this);
        this.palPanel.init(this);
        this.dendyPanel.init(this);
    }

    private void loadFields() {
        OverscanPrefs prefs = AppPrefs.getInstance().getOverscanPrefs();
        this.ntscPanel.setScreenBorders(prefs.getNtscBorders());
        this.palPanel.setScreenBorders(prefs.getPalBorders());
        this.dendyPanel.setScreenBorders(prefs.getDendyBorders());
    }

    private void captureFields() {
        OverscanPrefs prefs = AppPrefs.getInstance().getOverscanPrefs();
        prefs.setNtscBorders(this.ntscPanel.getScreenBorders());
        prefs.setPalBorders(this.palPanel.getScreenBorders());
        prefs.setDendyBorders(this.dendyPanel.getScreenBorders());
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.ntscPanel = new OverscanPanel();
        this.palPanel = new OverscanPanel();
        this.dendyPanel = new OverscanPanel();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Overscan");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OverscanDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverscanDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverscanDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.ntscPanel.setBorder(BorderFactory.createTitledBorder("NTSC"));
        this.palPanel.setBorder(BorderFactory.createTitledBorder("PAL"));
        this.dendyPanel.setBorder(BorderFactory.createTitledBorder("Dendy"));
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverscanDialog.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.ntscPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.palPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dendyPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.defaultsButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ntscPanel, -1, -1, Short.MAX_VALUE).addComponent(this.palPanel, -1, -1, Short.MAX_VALUE).addComponent(this.dendyPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.defaultsButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.captureFields();
        App.getImageFrame().getImagePane().updateScreenBorders();
        AppPrefs.save();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.ntscPanel.setScreenBorders(TVSystem.NTSC.getScreenBorders());
        this.palPanel.setScreenBorders(TVSystem.PAL.getScreenBorders());
        this.dendyPanel.setScreenBorders(TVSystem.Dendy.getScreenBorders());
    }
}

