/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.input.ports;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.gui.input.buttonmapping.ButtonMappingDialog;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.input.Ports;
import nintaco.input.other.SetPorts;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public class PortsDialog
extends JDialog {
    private final ActionListener componentsListener = e -> this.enableComponents();
    private JCheckBox autoConfigureCheckBox;
    private JButton cancelButton;
    private JPanel cardPanel;
    private JComboBox consoleComboBox;
    private JButton famicomConfigureExpansionPortButton;
    private JButton famicomConfigurePort1Button;
    private JButton famicomConfigurePort2Button;
    private JButton famicomConfigureTap1Button;
    private JButton famicomConfigureTap2Button;
    private JButton famicomConfigureTap3Button;
    private JButton famicomConfigureTap4Button;
    private JComboBox famicomExpansionPortComboBox;
    private JLabel famicomExpansionPortLabel;
    private JPanel famicomMultitapPanel;
    private JPanel famicomPanel;
    private JComboBox famicomPort1ComboBox;
    private JLabel famicomPort1Label;
    private JComboBox famicomPort2ComboBox;
    private JLabel famicomPort2Label;
    private JComboBox famicomTap1ComboBox;
    private JLabel famicomTap1Label;
    private JComboBox famicomTap2ComboBox;
    private JLabel famicomTap2Label;
    private JComboBox famicomTap3ComboBox;
    private JLabel famicomTap3Label;
    private JComboBox famicomTap4ComboBox;
    private JLabel famicomTap4Label;
    private JCheckBox multitapCheckBox;
    private JButton nesConfigurePort1Button;
    private JButton nesConfigurePort2Button;
    private JButton nesConfigureTap1Button;
    private JButton nesConfigureTap2Button;
    private JButton nesConfigureTap3Button;
    private JButton nesConfigureTap4Button;
    private JPanel nesMultitapPanel;
    private JPanel nesPanel;
    private JComboBox nesPort1ComboBox;
    private JLabel nesPort1Label;
    private JComboBox nesPort2ComboBox;
    private JLabel nesPort2Label;
    private JComboBox nesTap1ComboBox;
    private JLabel nesTap1Label;
    private JComboBox nesTap2ComboBox;
    private JLabel nesTap2Label;
    private JComboBox nesTap3ComboBox;
    private JLabel nesTap3Label;
    private JComboBox nesTap4ComboBox;
    private JLabel nesTap4Label;
    private JButton okButton;
    private JButton vsDualConfigureMain1Button;
    private JButton vsDualConfigureMain2Button;
    private JButton vsDualConfigureSub1Button;
    private JButton vsDualConfigureSub2Button;
    private JComboBox vsDualMain1ComboBox;
    private JLabel vsDualMain1Label;
    private JComboBox vsDualMain2ComboBox;
    private JLabel vsDualMain2Label;
    private JComboBox vsDualSub1ComboBox;
    private JLabel vsDualSub1Label;
    private JComboBox vsDualSub2ComboBox;
    private JLabel vsDualSub2Label;
    private JPanel vsDualSystemPanel;

    public PortsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initComboBoxes();
        this.initConfigureButtons();
        this.loadFields();
        this.enableComponents();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComboBoxes() {
        this.addDevices(this.nesPort1ComboBox, 0, -1, 0, 1, 2, 3, 9, 21, 25, 27, 28, 35);
        this.addDevices(this.nesPort2ComboBox, 1, -1, 0, 1, 2, 3, 4, 5, 10, 26, 27, 28, 29, 30, 33);
        this.addDevices(this.famicomPort1ComboBox, 0, 0, 1, 2, 3, 9);
        this.addDevices(this.famicomPort2ComboBox, 1, 0, 1, 2, 3, 10);
        this.addDevices(this.famicomExpansionPortComboBox, -1, -1, 4, 5, 6, 7, 8, 11, 12, 13, 14, 16, 15, 18, 19, 17, 20, 22, 23, 24, 31, 32, 34);
        this.addDevices(this.nesTap1ComboBox, 0, -1, 0, 1, 2, 3);
        this.addDevices(this.nesTap2ComboBox, 1, -1, 0, 1, 2, 3);
        this.addDevices(this.nesTap3ComboBox, 2, -1, 0, 1, 2, 3);
        this.addDevices(this.nesTap4ComboBox, 3, -1, 0, 1, 2, 3);
        this.addDevices(this.famicomTap1ComboBox, 0, 0, 1, 2, 3);
        this.addDevices(this.famicomTap2ComboBox, 1, 0, 1, 2, 3);
        this.addDevices(this.famicomTap3ComboBox, 2, 0, 1, 2, 3);
        this.addDevices(this.famicomTap4ComboBox, 3, 0, 1, 2, 3);
        this.addDevices(this.vsDualMain1ComboBox, 0, -1, 0, 1, 2, 3);
        this.addDevices(this.vsDualMain2ComboBox, 1, -1, 0, 1, 2, 3);
        this.addDevices(this.vsDualSub1ComboBox, 2, -1, 0, 1, 2, 3);
        this.addDevices(this.vsDualSub2ComboBox, 3, -1, 0, 1, 2, 3);
    }

    private void addDevices(JComboBox<DeviceDescriptor> comboBox, int defaultInputDevice, int ... inputDevices) {
        comboBox.removeActionListener(this.componentsListener);
        DefaultComboBoxModel<DeviceDescriptor> model = new DefaultComboBoxModel<DeviceDescriptor>();
        int targetIndex = 0;
        for (int inputDevice : inputDevices) {
            DeviceDescriptor element = DeviceDescriptor.getDescriptor(inputDevice);
            if (inputDevice == defaultInputDevice) {
                targetIndex = model.getSize();
            }
            model.addElement(element);
        }
        comboBox.setModel(model);
        comboBox.setSelectedIndex(targetIndex);
        comboBox.addActionListener(this.componentsListener);
    }

    private void initConfigureButtons() {
        this.addConfigListener(this.vsDualMain1ComboBox, this.vsDualConfigureMain1Button);
        this.addConfigListener(this.vsDualMain2ComboBox, this.vsDualConfigureMain2Button);
        this.addConfigListener(this.vsDualSub1ComboBox, this.vsDualConfigureSub1Button);
        this.addConfigListener(this.vsDualSub2ComboBox, this.vsDualConfigureSub2Button);
        this.addConfigListener(this.nesTap1ComboBox, this.nesConfigureTap1Button);
        this.addConfigListener(this.nesTap2ComboBox, this.nesConfigureTap2Button);
        this.addConfigListener(this.nesTap3ComboBox, this.nesConfigureTap3Button);
        this.addConfigListener(this.nesTap4ComboBox, this.nesConfigureTap4Button);
        this.addConfigListener(this.famicomTap1ComboBox, this.famicomConfigureTap1Button);
        this.addConfigListener(this.famicomTap2ComboBox, this.famicomConfigureTap2Button);
        this.addConfigListener(this.famicomTap3ComboBox, this.famicomConfigureTap3Button);
        this.addConfigListener(this.famicomTap4ComboBox, this.famicomConfigureTap4Button);
        this.addConfigListener(this.nesPort1ComboBox, this.nesConfigurePort1Button);
        this.addConfigListener(this.nesPort2ComboBox, this.nesConfigurePort2Button);
        this.addConfigListener(this.famicomPort1ComboBox, this.famicomConfigurePort1Button);
        this.addConfigListener(this.famicomPort2ComboBox, this.famicomConfigurePort2Button);
        this.addConfigListener(this.famicomExpansionPortComboBox, this.famicomConfigureExpansionPortButton);
    }

    private void addConfigListener(JComboBox<DeviceDescriptor> comboBox, JButton configButton) {
        configButton.addActionListener(e -> {
            int inputDevice = ((DeviceDescriptor)comboBox.getSelectedItem()).getInputDevice();
            if (inputDevice != -1) {
                ButtonMappingDialog dialog = new ButtonMappingDialog((Window)this);
                dialog.setInputDevice(inputDevice);
                dialog.setVisible(true);
            }
        });
    }

    private void loadFields() {
        Inputs inputs = AppPrefs.getInstance().getInputs();
        this.autoConfigureCheckBox.setSelected(inputs.isAutoConfigure());
        Ports ports = inputs.getPorts();
        if (ports.getConsoleType() == 2) {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.vsDualMain1ComboBox, ports.getDevice(0));
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.vsDualMain2ComboBox, ports.getDevice(1));
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.vsDualSub1ComboBox, ports.getDevice(2));
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.vsDualSub2ComboBox, ports.getDevice(3));
        } else if (ports.isMultitap()) {
            if (ports.getConsoleType() == 0) {
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesTap1ComboBox, ports.getDevice(0));
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesTap2ComboBox, ports.getDevice(1));
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesTap3ComboBox, ports.getDevice(2));
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesTap4ComboBox, ports.getDevice(3));
            } else {
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomTap1ComboBox, ports.getDevice(0));
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomTap2ComboBox, ports.getDevice(1));
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomTap3ComboBox, ports.getDevice(2));
                this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomTap4ComboBox, ports.getDevice(3));
            }
        } else if (ports.getConsoleType() == 0) {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesPort1ComboBox, ports.getDevice(0));
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesPort2ComboBox, ports.getDevice(1));
        } else {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomPort1ComboBox, ports.getDevice(0));
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomPort2ComboBox, ports.getDevice(1));
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomExpansionPortComboBox, ports.getDevice(4));
        }
        this.setComboBoxIndex(this.consoleComboBox, ports.getConsoleType());
        this.multitapCheckBox.removeActionListener(this.componentsListener);
        this.multitapCheckBox.setSelected(ports.isMultitap());
        this.multitapCheckBox.addActionListener(this.componentsListener);
        this.enableComponents();
    }

    private void setCard(String cardName) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, cardName);
    }

    private void setComboBoxIndex(JComboBox comboBox, int index) {
        comboBox.removeActionListener(this.componentsListener);
        comboBox.setSelectedIndex(index);
        comboBox.addActionListener(this.componentsListener);
    }

    private void setComboBoxValue(JComboBox<DeviceDescriptor> comboBox, int inputDevice) {
        this.setComboBoxValue(comboBox, DeviceDescriptor.getDescriptor(inputDevice));
    }

    private void setComboBoxValue(JComboBox<DeviceDescriptor> comboBox, DeviceDescriptor device) {
        comboBox.removeActionListener(this.componentsListener);
        comboBox.setSelectedItem(device);
        comboBox.addActionListener(this.componentsListener);
    }

    private void enableComponents() {
        this.multitapCheckBox.setVisible(this.consoleComboBox.getSelectedIndex() != 2);
        if (this.consoleComboBox.getSelectedIndex() == 2) {
            this.setCard("vsDualSystem");
            this.okButton.setEnabled(this.isUnique(this.vsDualMain1ComboBox, this.vsDualMain2ComboBox, this.vsDualSub1ComboBox, this.vsDualSub2ComboBox));
            this.enableButton(this.vsDualMain1ComboBox, this.vsDualConfigureMain1Button);
            this.enableButton(this.vsDualMain2ComboBox, this.vsDualConfigureMain2Button);
            this.enableButton(this.vsDualSub1ComboBox, this.vsDualConfigureSub1Button);
            this.enableButton(this.vsDualSub2ComboBox, this.vsDualConfigureSub2Button);
        } else if (this.multitapCheckBox.isSelected()) {
            if (this.consoleComboBox.getSelectedIndex() == 0) {
                this.setCard("nesMultitap");
                this.okButton.setEnabled(this.isUnique(this.nesTap1ComboBox, this.nesTap2ComboBox, this.nesTap3ComboBox, this.nesTap4ComboBox));
                this.enableButton(this.nesTap1ComboBox, this.nesConfigureTap1Button);
                this.enableButton(this.nesTap2ComboBox, this.nesConfigureTap2Button);
                this.enableButton(this.nesTap3ComboBox, this.nesConfigureTap3Button);
                this.enableButton(this.nesTap4ComboBox, this.nesConfigureTap4Button);
            } else {
                this.setCard("famicomMultitap");
                this.okButton.setEnabled(this.isUnique(this.famicomTap1ComboBox, this.famicomTap2ComboBox, this.famicomTap3ComboBox, this.famicomTap4ComboBox));
                this.enableButton(this.famicomTap1ComboBox, this.famicomConfigureTap1Button);
                this.enableButton(this.famicomTap2ComboBox, this.famicomConfigureTap2Button);
                this.enableButton(this.famicomTap3ComboBox, this.famicomConfigureTap3Button);
                this.enableButton(this.famicomTap4ComboBox, this.famicomConfigureTap4Button);
            }
        } else if (this.consoleComboBox.getSelectedIndex() == 0) {
            this.setCard("nes");
            this.okButton.setEnabled(this.isUnique(this.nesPort1ComboBox, this.nesPort2ComboBox));
            this.enableButton(this.nesPort1ComboBox, this.nesConfigurePort1Button);
            this.enableButton(this.nesPort2ComboBox, this.nesConfigurePort2Button);
        } else {
            this.setCard("famicom");
            this.okButton.setEnabled(this.isUnique(this.famicomPort1ComboBox, this.famicomPort2ComboBox, this.famicomExpansionPortComboBox));
            this.enableButton(this.famicomPort1ComboBox, this.famicomConfigurePort1Button);
            this.enableButton(this.famicomPort2ComboBox, this.famicomConfigurePort2Button);
            this.enableButton(this.famicomExpansionPortComboBox, this.famicomConfigureExpansionPortButton);
        }
    }

    private void enableButton(JComboBox<DeviceDescriptor> comboBox, JButton button) {
        button.setEnabled(((DeviceDescriptor)comboBox.getSelectedItem()).getInputDevice() != -1);
    }

    private boolean isUnique(JComboBox<DeviceDescriptor> ... comboBoxes) {
        HashSet<DeviceDescriptor> descriptors = new HashSet<DeviceDescriptor>();
        boolean deviceFound = false;
        for (JComboBox<DeviceDescriptor> comboBox : comboBoxes) {
            DeviceDescriptor descriptor = (DeviceDescriptor)comboBox.getSelectedItem();
            if (descriptor.getInputDevice() == -1) continue;
            deviceFound = true;
            if (descriptors.contains(descriptor)) {
                return false;
            }
            descriptors.add(descriptor);
        }
        return deviceFound;
    }

    private void saveChanges() {
        int[][] portDevices = this.consoleComboBox.getSelectedIndex() == 2 ? new int[][]{{0, this.getDevice(this.vsDualMain1ComboBox)}, {1, this.getDevice(this.vsDualMain2ComboBox)}, {2, this.getDevice(this.vsDualSub1ComboBox)}, {3, this.getDevice(this.vsDualSub2ComboBox)}} : (this.multitapCheckBox.isSelected() ? (this.consoleComboBox.getSelectedIndex() == 0 ? new int[][]{{0, this.getDevice(this.nesTap1ComboBox)}, {1, this.getDevice(this.nesTap2ComboBox)}, {2, this.getDevice(this.nesTap3ComboBox)}, {3, this.getDevice(this.nesTap4ComboBox)}} : new int[][]{{0, this.getDevice(this.famicomTap1ComboBox)}, {1, this.getDevice(this.famicomTap2ComboBox)}, {2, this.getDevice(this.famicomTap3ComboBox)}, {3, this.getDevice(this.famicomTap4ComboBox)}}) : (this.consoleComboBox.getSelectedIndex() == 0 ? new int[][]{{0, this.getDevice(this.nesPort1ComboBox)}, {1, this.getDevice(this.nesPort2ComboBox)}} : new int[][]{{0, this.getDevice(this.famicomPort1ComboBox)}, {1, this.getDevice(this.famicomPort2ComboBox)}, {4, this.getDevice(this.famicomExpansionPortComboBox)}}));
        SetPorts setPorts = new SetPorts(new Ports(portDevices, this.multitapCheckBox.isSelected(), MathUtil.clamp(this.consoleComboBox.getSelectedIndex(), 0, 2)));
        if (App.getMachineRunner() == null) {
            setPorts.run(null);
        } else {
            InputUtil.addOtherInput(setPorts);
        }
        Inputs inputs = AppPrefs.getInstance().getInputs();
        inputs.setAutoConfigure(this.autoConfigureCheckBox.isSelected());
        AppPrefs.save();
    }

    private int getDevice(JComboBox<DeviceDescriptor> comboBox) {
        return ((DeviceDescriptor)comboBox.getSelectedItem()).getInputDevice();
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.autoConfigureCheckBox = new JCheckBox();
        this.cardPanel = new JPanel();
        this.famicomPanel = new JPanel();
        this.famicomExpansionPortLabel = new JLabel();
        this.famicomExpansionPortComboBox = new JComboBox();
        this.famicomConfigureExpansionPortButton = new JButton();
        this.famicomPort1Label = new JLabel();
        this.famicomPort2Label = new JLabel();
        this.famicomPort1ComboBox = new JComboBox();
        this.famicomPort2ComboBox = new JComboBox();
        this.famicomConfigurePort1Button = new JButton();
        this.famicomConfigurePort2Button = new JButton();
        this.nesMultitapPanel = new JPanel();
        this.nesTap4ComboBox = new JComboBox();
        this.nesConfigureTap3Button = new JButton();
        this.nesConfigureTap4Button = new JButton();
        this.nesTap1Label = new JLabel();
        this.nesTap1ComboBox = new JComboBox();
        this.nesConfigureTap1Button = new JButton();
        this.nesTap2Label = new JLabel();
        this.nesTap2ComboBox = new JComboBox();
        this.nesConfigureTap2Button = new JButton();
        this.nesTap3Label = new JLabel();
        this.nesTap4Label = new JLabel();
        this.nesTap3ComboBox = new JComboBox();
        this.nesPanel = new JPanel();
        this.nesPort1Label = new JLabel();
        this.nesPort1ComboBox = new JComboBox();
        this.nesPort2ComboBox = new JComboBox();
        this.nesPort2Label = new JLabel();
        this.nesConfigurePort2Button = new JButton();
        this.nesConfigurePort1Button = new JButton();
        this.famicomMultitapPanel = new JPanel();
        this.famicomTap4ComboBox = new JComboBox();
        this.famicomConfigureTap3Button = new JButton();
        this.famicomConfigureTap4Button = new JButton();
        this.famicomTap1Label = new JLabel();
        this.famicomTap1ComboBox = new JComboBox();
        this.famicomConfigureTap1Button = new JButton();
        this.famicomTap2Label = new JLabel();
        this.famicomTap2ComboBox = new JComboBox();
        this.famicomConfigureTap2Button = new JButton();
        this.famicomTap3Label = new JLabel();
        this.famicomTap4Label = new JLabel();
        this.famicomTap3ComboBox = new JComboBox();
        this.vsDualSystemPanel = new JPanel();
        this.vsDualMain1Label = new JLabel();
        this.vsDualMain1ComboBox = new JComboBox();
        this.vsDualConfigureMain1Button = new JButton();
        this.vsDualMain2Label = new JLabel();
        this.vsDualMain2ComboBox = new JComboBox();
        this.vsDualConfigureMain2Button = new JButton();
        this.vsDualSub1Label = new JLabel();
        this.vsDualSub1ComboBox = new JComboBox();
        this.vsDualConfigureSub1Button = new JButton();
        this.vsDualSub2Label = new JLabel();
        this.vsDualSub2ComboBox = new JComboBox();
        this.vsDualConfigureSub2Button = new JButton();
        this.multitapCheckBox = new JCheckBox();
        this.consoleComboBox = new JComboBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Ports");
        this.setMinimumSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PortsDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.autoConfigureCheckBox.setSelected(true);
        this.autoConfigureCheckBox.setText("Auto-configure on open");
        this.autoConfigureCheckBox.setFocusPainted(false);
        this.autoConfigureCheckBox.setPreferredSize(null);
        this.cardPanel.setLayout(new CardLayout());
        this.famicomPanel.setName("");
        this.famicomExpansionPortLabel.setText("Expansion:");
        this.famicomExpansionPortLabel.setMaximumSize(null);
        this.famicomExpansionPortLabel.setMinimumSize(null);
        this.famicomExpansionPortLabel.setPreferredSize(null);
        this.famicomExpansionPortComboBox.setFocusable(false);
        this.famicomExpansionPortComboBox.setMaximumSize(null);
        this.famicomExpansionPortComboBox.setMinimumSize(null);
        this.famicomExpansionPortComboBox.setPreferredSize(null);
        this.famicomConfigureExpansionPortButton.setText("Configure...");
        this.famicomConfigureExpansionPortButton.setFocusPainted(false);
        this.famicomConfigureExpansionPortButton.setPreferredSize(null);
        this.famicomPort1Label.setText("Port 1:");
        this.famicomPort1Label.setMaximumSize(null);
        this.famicomPort1Label.setMinimumSize(null);
        this.famicomPort1Label.setPreferredSize(null);
        this.famicomPort2Label.setText("Port 2:");
        this.famicomPort2Label.setMaximumSize(null);
        this.famicomPort2Label.setMinimumSize(null);
        this.famicomPort2Label.setPreferredSize(null);
        this.famicomPort1ComboBox.setFocusable(false);
        this.famicomPort1ComboBox.setMaximumSize(null);
        this.famicomPort1ComboBox.setMinimumSize(null);
        this.famicomPort1ComboBox.setPreferredSize(null);
        this.famicomPort1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortsDialog.this.famicomPort1ComboBoxActionPerformed(evt);
            }
        });
        this.famicomPort2ComboBox.setFocusable(false);
        this.famicomPort2ComboBox.setMaximumSize(null);
        this.famicomPort2ComboBox.setMinimumSize(null);
        this.famicomPort2ComboBox.setPreferredSize(null);
        this.famicomPort2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortsDialog.this.famicomPort2ComboBoxActionPerformed(evt);
            }
        });
        this.famicomConfigurePort1Button.setText("Configure...");
        this.famicomConfigurePort1Button.setFocusPainted(false);
        this.famicomConfigurePort1Button.setPreferredSize(null);
        this.famicomConfigurePort2Button.setText("Configure...");
        this.famicomConfigurePort2Button.setFocusPainted(false);
        this.famicomConfigurePort2Button.setPreferredSize(null);
        GroupLayout famicomPanelLayout = new GroupLayout(this.famicomPanel);
        this.famicomPanel.setLayout(famicomPanelLayout);
        famicomPanelLayout.setHorizontalGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(famicomPanelLayout.createSequentialGroup().addContainerGap().addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.famicomPort1Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.famicomPort2Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.famicomExpansionPortLabel, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(famicomPanelLayout.createSequentialGroup().addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.famicomPort1ComboBox, -2, -1, -2).addComponent(this.famicomPort2ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.famicomConfigurePort1Button, -2, -1, -2).addComponent(this.famicomConfigurePort2Button, -2, -1, -2))).addGroup(famicomPanelLayout.createSequentialGroup().addComponent(this.famicomExpansionPortComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famicomConfigureExpansionPortButton, -2, -1, -2))).addContainerGap()));
        famicomPanelLayout.linkSize(0, this.famicomExpansionPortComboBox, this.famicomPort1ComboBox, this.famicomPort2ComboBox);
        famicomPanelLayout.linkSize(0, this.famicomConfigureExpansionPortButton, this.famicomConfigurePort1Button, this.famicomConfigurePort2Button);
        famicomPanelLayout.setVerticalGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, famicomPanelLayout.createSequentialGroup().addContainerGap().addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomPort1Label, -2, -1, -2).addComponent(this.famicomPort1ComboBox, -2, -1, -2).addComponent(this.famicomConfigurePort1Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomPort2Label, -2, -1, -2).addComponent(this.famicomPort2ComboBox, -2, -1, -2).addComponent(this.famicomConfigurePort2Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomExpansionPortLabel, -2, -1, -2).addComponent(this.famicomExpansionPortComboBox, -2, -1, -2).addComponent(this.famicomConfigureExpansionPortButton, -2, -1, -2)).addContainerGap()));
        this.cardPanel.add((Component)this.famicomPanel, "famicom");
        this.nesMultitapPanel.setName("");
        this.nesTap4ComboBox.setFocusable(false);
        this.nesTap4ComboBox.setMaximumSize(null);
        this.nesTap4ComboBox.setMinimumSize(null);
        this.nesTap4ComboBox.setPreferredSize(null);
        this.nesConfigureTap3Button.setText("Configure...");
        this.nesConfigureTap3Button.setFocusPainted(false);
        this.nesConfigureTap3Button.setFocusable(false);
        this.nesConfigureTap4Button.setText("Configure...");
        this.nesConfigureTap4Button.setFocusPainted(false);
        this.nesConfigureTap4Button.setFocusable(false);
        this.nesTap1Label.setText("Tap 1:");
        this.nesTap1Label.setMaximumSize(null);
        this.nesTap1Label.setMinimumSize(null);
        this.nesTap1Label.setPreferredSize(null);
        this.nesTap1ComboBox.setFocusable(false);
        this.nesTap1ComboBox.setMaximumSize(null);
        this.nesTap1ComboBox.setMinimumSize(null);
        this.nesTap1ComboBox.setPreferredSize(null);
        this.nesConfigureTap1Button.setText("Configure...");
        this.nesConfigureTap1Button.setFocusPainted(false);
        this.nesConfigureTap1Button.setPreferredSize(null);
        this.nesTap2Label.setText("Tap 2:");
        this.nesTap2Label.setMaximumSize(null);
        this.nesTap2Label.setMinimumSize(null);
        this.nesTap2Label.setPreferredSize(null);
        this.nesTap2ComboBox.setFocusable(false);
        this.nesTap2ComboBox.setMaximumSize(null);
        this.nesTap2ComboBox.setMinimumSize(null);
        this.nesTap2ComboBox.setPreferredSize(null);
        this.nesConfigureTap2Button.setText("Configure...");
        this.nesConfigureTap2Button.setFocusPainted(false);
        this.nesConfigureTap2Button.setPreferredSize(null);
        this.nesTap3Label.setText("Tap 3:");
        this.nesTap3Label.setMaximumSize(null);
        this.nesTap3Label.setMinimumSize(null);
        this.nesTap3Label.setPreferredSize(null);
        this.nesTap4Label.setText("Tap 4:");
        this.nesTap4Label.setMaximumSize(null);
        this.nesTap4Label.setMinimumSize(null);
        this.nesTap4Label.setPreferredSize(null);
        this.nesTap3ComboBox.setFocusable(false);
        this.nesTap3ComboBox.setMaximumSize(null);
        this.nesTap3ComboBox.setMinimumSize(null);
        this.nesTap3ComboBox.setPreferredSize(null);
        GroupLayout nesMultitapPanelLayout = new GroupLayout(this.nesMultitapPanel);
        this.nesMultitapPanel.setLayout(nesMultitapPanelLayout);
        nesMultitapPanelLayout.setHorizontalGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, nesMultitapPanelLayout.createSequentialGroup().addContainerGap().addGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nesTap4Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.nesTap3Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.nesTap2Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.nesTap1Label, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nesMultitapPanelLayout.createSequentialGroup().addComponent(this.nesTap1ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nesConfigureTap1Button, -2, -1, -2)).addGroup(nesMultitapPanelLayout.createSequentialGroup().addComponent(this.nesTap2ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nesConfigureTap2Button, -2, -1, -2)).addGroup(nesMultitapPanelLayout.createSequentialGroup().addComponent(this.nesTap3ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nesConfigureTap3Button)).addGroup(nesMultitapPanelLayout.createSequentialGroup().addComponent(this.nesTap4ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nesConfigureTap4Button))).addContainerGap()));
        nesMultitapPanelLayout.setVerticalGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, nesMultitapPanelLayout.createSequentialGroup().addContainerGap().addGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nesTap1Label, -2, -1, -2).addComponent(this.nesTap1ComboBox, -2, -1, -2).addComponent(this.nesConfigureTap1Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nesTap2Label, -2, -1, -2).addComponent(this.nesTap2ComboBox, -2, -1, -2).addComponent(this.nesConfigureTap2Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nesTap3Label, -2, -1, -2).addComponent(this.nesTap3ComboBox, -2, -1, -2).addComponent(this.nesConfigureTap3Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nesTap4Label, -2, -1, -2).addComponent(this.nesTap4ComboBox, -2, -1, -2).addComponent(this.nesConfigureTap4Button)).addContainerGap()));
        this.cardPanel.add((Component)this.nesMultitapPanel, "nesMultitap");
        this.nesPanel.setName("");
        this.nesPort1Label.setText("Port 1:");
        this.nesPort1Label.setMaximumSize(null);
        this.nesPort1Label.setMinimumSize(null);
        this.nesPort1Label.setPreferredSize(null);
        this.nesPort1ComboBox.setFocusable(false);
        this.nesPort1ComboBox.setMaximumSize(null);
        this.nesPort1ComboBox.setMinimumSize(null);
        this.nesPort1ComboBox.setPreferredSize(null);
        this.nesPort1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortsDialog.this.nesPort1ComboBoxActionPerformed(evt);
            }
        });
        this.nesPort2ComboBox.setFocusable(false);
        this.nesPort2ComboBox.setMaximumSize(null);
        this.nesPort2ComboBox.setMinimumSize(null);
        this.nesPort2ComboBox.setPreferredSize(null);
        this.nesPort2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortsDialog.this.nesPort2ComboBoxActionPerformed(evt);
            }
        });
        this.nesPort2Label.setText("Port 2:");
        this.nesPort2Label.setMaximumSize(null);
        this.nesPort2Label.setMinimumSize(null);
        this.nesPort2Label.setPreferredSize(null);
        this.nesConfigurePort2Button.setText("Configure...");
        this.nesConfigurePort2Button.setFocusPainted(false);
        this.nesConfigurePort2Button.setPreferredSize(null);
        this.nesConfigurePort1Button.setText("Configure...");
        this.nesConfigurePort1Button.setFocusPainted(false);
        this.nesConfigurePort1Button.setPreferredSize(null);
        GroupLayout nesPanelLayout = new GroupLayout(this.nesPanel);
        this.nesPanel.setLayout(nesPanelLayout);
        nesPanelLayout.setHorizontalGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nesPanelLayout.createSequentialGroup().addContainerGap().addGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nesPort1Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.nesPort2Label, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nesPort1ComboBox, -2, -1, -2).addComponent(this.nesPort2ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nesConfigurePort1Button, -2, -1, -2).addComponent(this.nesConfigurePort2Button, -2, -1, -2)).addContainerGap()));
        nesPanelLayout.linkSize(0, this.nesPort1ComboBox, this.nesPort2ComboBox);
        nesPanelLayout.linkSize(0, this.nesConfigurePort1Button, this.nesConfigurePort2Button);
        nesPanelLayout.setVerticalGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nesPanelLayout.createSequentialGroup().addContainerGap().addGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nesPort1Label, -2, -1, -2).addComponent(this.nesPort1ComboBox, -2, -1, -2).addComponent(this.nesConfigurePort1Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nesPort2Label, -2, -1, -2).addComponent(this.nesPort2ComboBox, -2, -1, -2).addComponent(this.nesConfigurePort2Button, -2, -1, -2)).addContainerGap()));
        this.cardPanel.add((Component)this.nesPanel, "nes");
        this.famicomMultitapPanel.setName("");
        this.famicomTap4ComboBox.setFocusable(false);
        this.famicomTap4ComboBox.setMaximumSize(null);
        this.famicomTap4ComboBox.setMinimumSize(null);
        this.famicomTap4ComboBox.setPreferredSize(null);
        this.famicomConfigureTap3Button.setText("Configure...");
        this.famicomConfigureTap3Button.setFocusPainted(false);
        this.famicomConfigureTap3Button.setPreferredSize(null);
        this.famicomConfigureTap4Button.setText("Configure...");
        this.famicomConfigureTap4Button.setFocusPainted(false);
        this.famicomConfigureTap4Button.setPreferredSize(null);
        this.famicomTap1Label.setText("Tap 1:");
        this.famicomTap1Label.setMaximumSize(null);
        this.famicomTap1Label.setMinimumSize(null);
        this.famicomTap1Label.setPreferredSize(null);
        this.famicomTap1ComboBox.setFocusable(false);
        this.famicomTap1ComboBox.setMaximumSize(null);
        this.famicomTap1ComboBox.setMinimumSize(null);
        this.famicomTap1ComboBox.setPreferredSize(null);
        this.famicomConfigureTap1Button.setText("Configure...");
        this.famicomConfigureTap1Button.setFocusPainted(false);
        this.famicomConfigureTap1Button.setPreferredSize(null);
        this.famicomTap2Label.setText("Tap 2:");
        this.famicomTap2Label.setMaximumSize(null);
        this.famicomTap2Label.setMinimumSize(null);
        this.famicomTap2Label.setPreferredSize(null);
        this.famicomTap2ComboBox.setFocusable(false);
        this.famicomTap2ComboBox.setMaximumSize(null);
        this.famicomTap2ComboBox.setMinimumSize(null);
        this.famicomTap2ComboBox.setPreferredSize(null);
        this.famicomConfigureTap2Button.setText("Configure...");
        this.famicomConfigureTap2Button.setFocusPainted(false);
        this.famicomConfigureTap2Button.setPreferredSize(null);
        this.famicomTap3Label.setText("Tap 3:");
        this.famicomTap3Label.setMaximumSize(null);
        this.famicomTap3Label.setMinimumSize(null);
        this.famicomTap3Label.setPreferredSize(null);
        this.famicomTap4Label.setText("Tap 4:");
        this.famicomTap4Label.setMaximumSize(null);
        this.famicomTap4Label.setMinimumSize(null);
        this.famicomTap4Label.setPreferredSize(null);
        this.famicomTap3ComboBox.setFocusable(false);
        this.famicomTap3ComboBox.setMaximumSize(null);
        this.famicomTap3ComboBox.setMinimumSize(null);
        this.famicomTap3ComboBox.setPreferredSize(null);
        GroupLayout famicomMultitapPanelLayout = new GroupLayout(this.famicomMultitapPanel);
        this.famicomMultitapPanel.setLayout(famicomMultitapPanelLayout);
        famicomMultitapPanelLayout.setHorizontalGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, famicomMultitapPanelLayout.createSequentialGroup().addContainerGap().addGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.famicomTap4Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.famicomTap3Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.famicomTap2Label, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.famicomTap1Label, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(famicomMultitapPanelLayout.createSequentialGroup().addComponent(this.famicomTap1ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famicomConfigureTap1Button, -2, -1, -2)).addGroup(famicomMultitapPanelLayout.createSequentialGroup().addComponent(this.famicomTap2ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famicomConfigureTap2Button, -2, -1, -2)).addGroup(famicomMultitapPanelLayout.createSequentialGroup().addComponent(this.famicomTap3ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famicomConfigureTap3Button, -2, -1, -2)).addGroup(famicomMultitapPanelLayout.createSequentialGroup().addComponent(this.famicomTap4ComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famicomConfigureTap4Button, -2, -1, -2))).addContainerGap()));
        famicomMultitapPanelLayout.setVerticalGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, famicomMultitapPanelLayout.createSequentialGroup().addContainerGap().addGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomTap1Label, -2, -1, -2).addComponent(this.famicomTap1ComboBox, -2, -1, -2).addComponent(this.famicomConfigureTap1Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomTap2Label, -2, -1, -2).addComponent(this.famicomTap2ComboBox, -2, -1, -2).addComponent(this.famicomConfigureTap2Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomTap3Label, -2, -1, -2).addComponent(this.famicomTap3ComboBox, -2, -1, -2).addComponent(this.famicomConfigureTap3Button, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(famicomMultitapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.famicomTap4Label, -2, -1, -2).addComponent(this.famicomTap4ComboBox, -2, -1, -2).addComponent(this.famicomConfigureTap4Button, -2, -1, -2)).addContainerGap()));
        this.cardPanel.add((Component)this.famicomMultitapPanel, "famicomMultitap");
        this.vsDualSystemPanel.setName("");
        this.vsDualMain1Label.setText("Main 1:");
        this.vsDualMain1ComboBox.setFocusable(false);
        this.vsDualMain1ComboBox.setPreferredSize(null);
        this.vsDualConfigureMain1Button.setText("Configure...");
        this.vsDualConfigureMain1Button.setFocusPainted(false);
        this.vsDualMain2Label.setText("Main 2:");
        this.vsDualMain2ComboBox.setFocusable(false);
        this.vsDualMain2ComboBox.setPreferredSize(null);
        this.vsDualConfigureMain2Button.setText("Configure...");
        this.vsDualConfigureMain2Button.setFocusPainted(false);
        this.vsDualSub1Label.setText("Sub 1:");
        this.vsDualSub1ComboBox.setFocusable(false);
        this.vsDualSub1ComboBox.setPreferredSize(null);
        this.vsDualConfigureSub1Button.setText("Configure...");
        this.vsDualConfigureSub1Button.setFocusPainted(false);
        this.vsDualSub2Label.setText("Sub 2:");
        this.vsDualSub2ComboBox.setFocusable(false);
        this.vsDualSub2ComboBox.setPreferredSize(null);
        this.vsDualConfigureSub2Button.setText("Configure...");
        this.vsDualConfigureSub2Button.setFocusPainted(false);
        GroupLayout vsDualSystemPanelLayout = new GroupLayout(this.vsDualSystemPanel);
        this.vsDualSystemPanel.setLayout(vsDualSystemPanelLayout);
        vsDualSystemPanelLayout.setHorizontalGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vsDualSystemPanelLayout.createSequentialGroup().addContainerGap().addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vsDualMain1Label, GroupLayout.Alignment.TRAILING).addComponent(this.vsDualMain2Label, GroupLayout.Alignment.TRAILING).addComponent(this.vsDualSub1Label, GroupLayout.Alignment.TRAILING).addComponent(this.vsDualSub2Label, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vsDualMain1ComboBox, -2, -1, -2).addComponent(this.vsDualMain2ComboBox, -2, -1, -2).addComponent(this.vsDualSub1ComboBox, -2, -1, -2).addComponent(this.vsDualSub2ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vsDualConfigureMain1Button).addComponent(this.vsDualConfigureMain2Button).addComponent(this.vsDualConfigureSub1Button).addComponent(this.vsDualConfigureSub2Button)).addContainerGap()));
        vsDualSystemPanelLayout.setVerticalGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vsDualSystemPanelLayout.createSequentialGroup().addContainerGap().addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vsDualMain1Label).addComponent(this.vsDualMain1ComboBox, -2, -1, -2).addComponent(this.vsDualConfigureMain1Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vsDualMain2Label).addComponent(this.vsDualMain2ComboBox, -2, -1, -2).addComponent(this.vsDualConfigureMain2Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vsDualSub1Label).addComponent(this.vsDualSub1ComboBox, -2, -1, -2).addComponent(this.vsDualConfigureSub1Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vsDualSystemPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vsDualSub2Label).addComponent(this.vsDualSub2ComboBox, -2, -1, -2).addComponent(this.vsDualConfigureSub2Button)).addContainerGap()));
        this.cardPanel.add((Component)this.vsDualSystemPanel, "vsDualSystem");
        this.multitapCheckBox.setText("Multitap");
        this.multitapCheckBox.setFocusPainted(false);
        this.multitapCheckBox.setPreferredSize(null);
        this.consoleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"NES", "Famicom", "VS. DualSystem"}));
        this.consoleComboBox.setFocusable(false);
        this.consoleComboBox.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addGap(10, 10, 10)).addComponent(this.cardPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.consoleComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.multitapCheckBox, -2, -1, -2)).addComponent(this.autoConfigureCheckBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.autoConfigureCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.consoleComboBox, -2, -1, -2).addComponent(this.multitapCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cardPanel, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.cancelButton, this.okButton);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveChanges();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void nesPort1ComboBoxActionPerformed(ActionEvent evt) {
        if (this.getDevice(this.nesPort1ComboBox) == 9) {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesPort2ComboBox, 10);
        }
    }

    private void nesPort2ComboBoxActionPerformed(ActionEvent evt) {
        if (this.getDevice(this.nesPort2ComboBox) == 10) {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.nesPort1ComboBox, 9);
        }
    }

    private void famicomPort1ComboBoxActionPerformed(ActionEvent evt) {
        if (this.getDevice(this.famicomPort1ComboBox) == 9) {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomPort2ComboBox, 10);
        }
    }

    private void famicomPort2ComboBoxActionPerformed(ActionEvent evt) {
        if (this.getDevice(this.famicomPort2ComboBox) == 10) {
            this.setComboBoxValue((JComboBox<DeviceDescriptor>)this.famicomPort1ComboBox, 9);
        }
    }
}

