/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.input.buttonmapping;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import nintaco.input.ButtonID;
import nintaco.input.InputUtil;
import nintaco.util.GuiUtil;

public class PressButtonDialog
extends JDialog {
    private final List<ButtonID> buttonIds = new ArrayList<ButtonID>();
    private final Set<ButtonID> heldButtons = new HashSet<ButtonID>();
    private final List<ButtonID> pressedButtons = new ArrayList<ButtonID>();
    private final Timer timer = new Timer(25, this::onTimerEvent);
    private boolean canceled;
    private boolean skipped;
    private JButton cancelButton;
    private JLabel pressLabel;
    private JButton skipButton;

    public PressButtonDialog(Window parent, boolean showSkipButton) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.skipButton.setVisible(showSkipButton);
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
        InputUtil.clearEventQueues();
        this.timer.start();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    private void onTimerEvent(ActionEvent e) {
        if (this.canceled || this.skipped) {
            return;
        }
        InputUtil.pollControllers(this.buttonIds);
        for (ButtonID buttonID : this.buttonIds) {
            this.processButtonID(buttonID);
        }
    }

    private void processButtonID(ButtonID buttonID) {
        if (buttonID.getValue() == 0) {
            String buttonName = buttonID.getName();
            if (buttonName.isEmpty()) {
                this.heldButtons.remove(new ButtonID(buttonID.getDevice(), "x", -1));
                this.heldButtons.remove(new ButtonID(buttonID.getDevice(), "x", 1));
                this.heldButtons.remove(new ButtonID(buttonID.getDevice(), "y", -1));
                this.heldButtons.remove(new ButtonID(buttonID.getDevice(), "y", 1));
            } else {
                this.heldButtons.remove(new ButtonID(buttonID.getDevice(), buttonName, -1));
                this.heldButtons.remove(new ButtonID(buttonID.getDevice(), buttonName, 1));
            }
        } else {
            this.heldButtons.add(buttonID);
            if (!this.pressedButtons.contains(buttonID)) {
                this.pressedButtons.add(buttonID);
            }
        }
        if (!this.pressedButtons.isEmpty()) {
            EventQueue.invokeLater(() -> {
                if (!this.canceled && !this.skipped) {
                    this.updatePressLabel();
                    if (this.heldButtons.isEmpty()) {
                        this.closeDialog();
                    }
                }
            });
        }
    }

    private void updatePressLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><center>");
        for (int i = 0; i < this.pressedButtons.size(); ++i) {
            ButtonID buttonID = this.pressedButtons.get(i);
            if (i > 0) {
                sb.append(" + ");
            }
            sb.append("<b>").append(buttonID).append("</b>");
        }
        sb.append("</center></html>");
        this.pressLabel.setText(sb.toString());
    }

    public void setButtonName(String buttonName) {
        this.pressLabel.setText("<html><center>Press <b>" + buttonName + "</b><br/><br/>Hold down multiple to create button combos.</center></html>");
    }

    private void cancel() {
        this.canceled = true;
        this.pressedButtons.clear();
        this.pressLabel.setText("");
    }

    private void skip() {
        this.skipped = true;
        this.pressedButtons.clear();
        this.pressLabel.setText("");
    }

    private void cancelDialog() {
        this.cancel();
        this.closeDialog();
    }

    private void closeDialog() {
        this.timer.stop();
        InputUtil.clearEventQueues();
        EventQueue.invokeLater(this::dispose);
    }

    public ButtonID[] getButtonIds() {
        if (this.canceled || this.skipped) {
            return new ButtonID[0];
        }
        ButtonID[] bs = new ButtonID[this.pressedButtons.size()];
        this.pressedButtons.toArray(bs);
        return bs;
    }

    private void initComponents() {
        this.pressLabel = new JLabel();
        this.cancelButton = new JButton();
        this.skipButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Map");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PressButtonDialog.this.formWindowClosing(evt);
            }
        });
        this.pressLabel.setHorizontalAlignment(0);
        this.pressLabel.setText(" ");
        this.pressLabel.setBorder(BorderFactory.createEmptyBorder(32, 32, 32, 32));
        this.pressLabel.setMaximumSize(null);
        this.pressLabel.setMinimumSize(null);
        this.pressLabel.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setFocusable(false);
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PressButtonDialog.this.cancelButtonMousePressed(evt);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PressButtonDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.skipButton.setMnemonic('S');
        this.skipButton.setText("Skip");
        this.skipButton.setFocusPainted(false);
        this.skipButton.setFocusable(false);
        this.skipButton.setMaximumSize(null);
        this.skipButton.setMinimumSize(null);
        this.skipButton.setPreferredSize(null);
        this.skipButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PressButtonDialog.this.skipButtonMousePressed(evt);
            }
        });
        this.skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PressButtonDialog.this.skipButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.skipButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addContainerGap()).addComponent(this.pressLabel, -1, -1, Short.MAX_VALUE));
        layout.linkSize(0, this.cancelButton, this.skipButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pressLabel, -1, -1, Short.MAX_VALUE).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.skipButton, -2, -1, -2)).addContainerGap()));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelDialog();
    }

    private void cancelButtonMousePressed(MouseEvent evt) {
        this.cancel();
    }

    private void skipButtonActionPerformed(ActionEvent evt) {
        this.skip();
        this.closeDialog();
    }

    private void skipButtonMousePressed(MouseEvent evt) {
        this.skip();
    }
}

