/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image.filters;

import nintaco.gui.image.filters.VideoFilter;

public final class xBRZ
extends VideoFilter {
    private ScalerCfg cfg;
    private ScaleSize scaleSize;
    private OutputMatrix outputMatrix;
    private final BlendResult blendResult = new BlendResult();
    private static final int redMask = 0xFF0000;
    private static final int greenMask = 65280;
    private static final int blueMask = 255;
    private IColorDist preProcessCorners_colorDist;
    private IColorEq scalePixel_colorEq;
    private IColorDist scalePixel_colorDist;
    private static final int maxRots = 4;
    private static final int maxScale = 5;
    private static final int maxScaleSq = 25;
    private static final IntPair[] matrixRotation = new IntPair[400];
    private static final Scaler Scaler2x;
    private static final Scaler Scaler3x;
    private static final Scaler Scaler4x;
    private static final Scaler Scaler5x;

    public xBRZ(xBRZ xbrz) {
        super(xbrz.getImage(), xbrz.getImageData());
        this.scaleSize = xbrz.scaleSize;
        this.cfg = new ScalerCfg();
    }

    public xBRZ(ScaleSize scaleSize) {
        super(scaleSize.size);
        this.scaleSize = scaleSize;
        this.cfg = new ScalerCfg();
    }

    @Override
    public final void filter(int[] in, int yFirst, int yLast) {
        this.scaleImage(in, this.out, 256, 240, yFirst, yLast);
    }

    private static void alphaBlend(int n, int m, IntPtr dstPtr, int col) {
        int dst = dstPtr.get();
        int redComponent = xBRZ.blendComponent(0xFF0000, n, m, dst, col);
        int greenComponent = xBRZ.blendComponent(65280, n, m, dst, col);
        int blueComponent = xBRZ.blendComponent(255, n, m, dst, col);
        int blend = redComponent | greenComponent | blueComponent;
        dstPtr.set(blend | 0xFF000000);
    }

    private static int blendComponent(int mask, int n, int m, int inPixel, int setPixel) {
        int inChan = inPixel & mask;
        int setChan = setPixel & mask;
        int blend = setChan * n + inChan * (m - n);
        int component = mask & blend / m;
        return component;
    }

    private static void fillBlock(int[] trg, int trgi, int pitch, int col, int blockSize) {
        int y = 0;
        while (y < blockSize) {
            for (int x = 0; x < blockSize; ++x) {
                trg[trgi + x] = col;
            }
            ++y;
            trgi += pitch;
        }
    }

    private static final double square(double value) {
        return value * value;
    }

    private static final double distYCbCr(int pix1, int pix2, double lumaWeight) {
        int r_diff = (pix1 & 0xFF0000) - (pix2 & 0xFF0000) >> 16;
        int g_diff = (pix1 & 0xFF00) - (pix2 & 0xFF00) >> 8;
        int b_diff = (pix1 & 0xFF) - (pix2 & 0xFF);
        double k_b = 0.0722;
        double k_r = 0.2126;
        double k_g = 0.7152;
        double scale_b = 0.5389092476826902;
        double scale_r = 0.63500127000254;
        double y = 0.2126 * (double)r_diff + 0.7152 * (double)g_diff + 0.0722 * (double)b_diff;
        double c_b = 0.5389092476826902 * ((double)b_diff - y);
        double c_r = 0.63500127000254 * ((double)r_diff - y);
        return xBRZ.square(lumaWeight * y) + xBRZ.square(c_b) + xBRZ.square(c_r);
    }

    private static final double colorDist(int pix1, int pix2, double luminanceWeight) {
        if (pix1 == pix2) {
            return 0.0;
        }
        return xBRZ.distYCbCr(pix1, pix2, luminanceWeight);
    }

    private final void preProcessCorners(Kernel_4x4 ker) {
        double fk;
        this.blendResult.reset();
        if (ker.f == ker.g && ker.j == ker.k || ker.f == ker.j && ker.g == ker.k) {
            return;
        }
        IColorDist dist = this.preProcessCorners_colorDist;
        int weight = 4;
        double jg = dist.D(ker.i, ker.f) + dist.D(ker.f, ker.c) + dist.D(ker.n, ker.k) + dist.D(ker.k, ker.h) + 4.0 * dist.D(ker.j, ker.g);
        if (jg < (fk = dist.D(ker.e, ker.j) + dist.D(ker.j, ker.o) + dist.D(ker.b, ker.g) + dist.D(ker.g, ker.l) + 4.0 * dist.D(ker.f, ker.k))) {
            boolean dominantGradient;
            boolean bl = dominantGradient = this.cfg.dominantDirectionThreshold * jg < fk;
            if (ker.f != ker.g && ker.f != ker.j) {
                this.blendResult.f = (char)(dominantGradient ? 2 : 1);
            }
            if (ker.k != ker.j && ker.k != ker.g) {
                this.blendResult.k = (char)(dominantGradient ? 2 : 1);
            }
        } else if (fk < jg) {
            boolean dominantGradient;
            boolean bl = dominantGradient = this.cfg.dominantDirectionThreshold * fk < jg;
            if (ker.j != ker.f && ker.j != ker.k) {
                this.blendResult.j = (char)(dominantGradient ? 2 : 1);
            }
            if (ker.g != ker.f && ker.g != ker.k) {
                this.blendResult.g = (char)(dominantGradient ? 2 : 1);
            }
        }
    }

    private final void scalePixel(Scaler scaler, int rotDeg, Kernel_3x3 ker, int[] trg, int trgi, int trgWidth, char blendInfo) {
        boolean haveSteepLine;
        double hc;
        int b = ker.K[Rot.R[4 + rotDeg]];
        int c = ker.K[Rot.R[8 + rotDeg]];
        int d = ker.K[Rot.R[12 + rotDeg]];
        int e = ker.K[Rot.R[16 + rotDeg]];
        int f = ker.K[Rot.R[20 + rotDeg]];
        int g = ker.K[Rot.R[24 + rotDeg]];
        int h = ker.K[Rot.R[28 + rotDeg]];
        int i = ker.K[Rot.R[32 + rotDeg]];
        char blend = BlendInfo.rotate(blendInfo, rotDeg);
        if (BlendInfo.getBottomR(blend) == '\u0000') {
            return;
        }
        IColorEq eq = this.scalePixel_colorEq;
        IColorDist dist = this.scalePixel_colorDist;
        boolean doLineBlend = BlendInfo.getBottomR(blend) >= '\u0002' ? true : (BlendInfo.getTopR(blend) != '\u0000' && !eq.E(e, g) ? false : (BlendInfo.getBottomL(blend) != '\u0000' && !eq.E(e, c) ? false : !eq.E(g, h) || !eq.E(h, i) || !eq.E(i, f) || !eq.E(f, c) || eq.E(e, i)));
        int px = dist.D(e, f) <= dist.D(e, h) ? f : h;
        OutputMatrix out = this.outputMatrix;
        out.move(rotDeg, trgi);
        if (!doLineBlend) {
            scaler.blendCorner(px, out);
            return;
        }
        double fg = dist.D(f, g);
        boolean haveShallowLine = this.cfg.steepDirectionThreshold * fg <= (hc = dist.D(h, c)) && e != g && d != g;
        boolean bl = haveSteepLine = this.cfg.steepDirectionThreshold * hc <= fg && e != c && b != c;
        if (haveShallowLine) {
            if (haveSteepLine) {
                scaler.blendLineSteepAndShallow(px, out);
            } else {
                scaler.blendLineShallow(px, out);
            }
        } else if (haveSteepLine) {
            scaler.blendLineSteep(px, out);
        } else {
            scaler.blendLineDiagonal(px, out);
        }
    }

    private final void scaleImage(int[] src, int[] trg, int srcWidth, int srcHeight, int yFirst, int yLast) {
        if ((yFirst = Math.max(yFirst, 0)) >= (yLast = Math.min(yLast, srcHeight)) || srcWidth <= 0) {
            return;
        }
        int trgWidth = srcWidth * this.scaleSize.size;
        char[] preProcBuffer = new char[srcWidth];
        Kernel_4x4 ker4 = new Kernel_4x4();
        this.preProcessCorners_colorDist = new IColorDist(){

            @Override
            public double D(int col1, int col2) {
                return xBRZ.colorDist(col1, col2, ((xBRZ)xBRZ.this).cfg.luminanceWeight);
            }
        };
        if (yFirst > 0) {
            int y = yFirst - 1;
            int s_m1 = srcWidth * Math.max(y - 1, 0);
            int s_0 = srcWidth * y;
            int s_p1 = srcWidth * Math.min(y + 1, srcHeight - 1);
            int s_p2 = srcWidth * Math.min(y + 2, srcHeight - 1);
            for (int x = 0; x < srcWidth; ++x) {
                int x_m1 = Math.max(x - 1, 0);
                int x_p1 = Math.min(x + 1, srcWidth - 1);
                int x_p2 = Math.min(x + 2, srcWidth - 1);
                ker4.a = src[s_m1 + x_m1];
                ker4.b = src[s_m1 + x];
                ker4.c = src[s_m1 + x_p1];
                ker4.d = src[s_m1 + x_p2];
                ker4.e = src[s_0 + x_m1];
                ker4.f = src[s_0 + x];
                ker4.g = src[s_0 + x_p1];
                ker4.h = src[s_0 + x_p2];
                ker4.i = src[s_p1 + x_m1];
                ker4.j = src[s_p1 + x];
                ker4.k = src[s_p1 + x_p1];
                ker4.l = src[s_p1 + x_p2];
                ker4.m = src[s_p2 + x_m1];
                ker4.n = src[s_p2 + x];
                ker4.o = src[s_p2 + x_p1];
                ker4.p = src[s_p2 + x_p2];
                this.preProcessCorners(ker4);
                preProcBuffer[x] = BlendInfo.setTopR(preProcBuffer[x], this.blendResult.j);
                if (x + 1 >= srcWidth) continue;
                preProcBuffer[x + 1] = BlendInfo.setTopL(preProcBuffer[x + 1], this.blendResult.k);
            }
        }
        final double eqColorThres = xBRZ.square(this.cfg.equalColorTolerance);
        this.scalePixel_colorEq = new IColorEq(){

            @Override
            public boolean E(int col1, int col2) {
                return xBRZ.colorDist(col1, col2, ((xBRZ)xBRZ.this).cfg.luminanceWeight) < eqColorThres;
            }
        };
        this.scalePixel_colorDist = new IColorDist(){

            @Override
            public double D(int col1, int col2) {
                return xBRZ.colorDist(col1, col2, ((xBRZ)xBRZ.this).cfg.luminanceWeight);
            }
        };
        this.outputMatrix = new OutputMatrix(this.scaleSize.size, trg, trgWidth);
        char blend_xy = '\u0000';
        char blend_xy1 = '\u0000';
        Kernel_3x3 ker3 = new Kernel_3x3();
        for (int y = yFirst; y < yLast; ++y) {
            int trgi = this.scaleSize.size * y * trgWidth;
            int s_m1 = srcWidth * Math.max(y - 1, 0);
            int s_0 = srcWidth * y;
            int s_p1 = srcWidth * Math.min(y + 1, srcHeight - 1);
            int s_p2 = srcWidth * Math.min(y + 2, srcHeight - 1);
            blend_xy1 = '\u0000';
            int x = 0;
            while (x < srcWidth) {
                int x_m1 = Math.max(x - 1, 0);
                int x_p1 = Math.min(x + 1, srcWidth - 1);
                int x_p2 = Math.min(x + 2, srcWidth - 1);
                ker4.a = src[s_m1 + x_m1];
                ker4.b = src[s_m1 + x];
                ker4.c = src[s_m1 + x_p1];
                ker4.d = src[s_m1 + x_p2];
                ker4.e = src[s_0 + x_m1];
                ker4.f = src[s_0 + x];
                ker4.g = src[s_0 + x_p1];
                ker4.h = src[s_0 + x_p2];
                ker4.i = src[s_p1 + x_m1];
                ker4.j = src[s_p1 + x];
                ker4.k = src[s_p1 + x_p1];
                ker4.l = src[s_p1 + x_p2];
                ker4.m = src[s_p2 + x_m1];
                ker4.n = src[s_p2 + x];
                ker4.o = src[s_p2 + x_p1];
                ker4.p = src[s_p2 + x_p2];
                this.preProcessCorners(ker4);
                blend_xy = BlendInfo.setBottomR(preProcBuffer[x], this.blendResult.f);
                preProcBuffer[x] = blend_xy1 = BlendInfo.setTopR(blend_xy1, this.blendResult.j);
                blend_xy1 = BlendInfo.setTopL('\u0000', this.blendResult.k);
                if (x + 1 < srcWidth) {
                    preProcBuffer[x + 1] = BlendInfo.setBottomL(preProcBuffer[x + 1], this.blendResult.g);
                }
                xBRZ.fillBlock(trg, trgi, trgWidth, src[s_0 + x], this.scaleSize.size);
                if (blend_xy != '\u0000') {
                    boolean a = false;
                    boolean b = true;
                    int c = 2;
                    int d = 3;
                    int e = 4;
                    int f = 5;
                    int g = 6;
                    int h = 7;
                    int i = 8;
                    ker3.K[0] = src[s_m1 + x_m1];
                    ker3.K[1] = src[s_m1 + x];
                    ker3.K[2] = src[s_m1 + x_p1];
                    ker3.K[3] = src[s_0 + x_m1];
                    ker3.K[4] = src[s_0 + x];
                    ker3.K[5] = src[s_0 + x_p1];
                    ker3.K[6] = src[s_p1 + x_m1];
                    ker3.K[7] = src[s_p1 + x];
                    ker3.K[8] = src[s_p1 + x_p1];
                    this.scalePixel(this.scaleSize.scaler, 0, ker3, trg, trgi, trgWidth, blend_xy);
                    this.scalePixel(this.scaleSize.scaler, 1, ker3, trg, trgi, trgWidth, blend_xy);
                    this.scalePixel(this.scaleSize.scaler, 2, ker3, trg, trgi, trgWidth, blend_xy);
                    this.scalePixel(this.scaleSize.scaler, 3, ker3, trg, trgi, trgWidth, blend_xy);
                }
                ++x;
                trgi += this.scaleSize.size;
            }
        }
    }

    private static final IntPair buildMatrixRotation(int rotDeg, int I, int J, int N) {
        int J_old;
        int I_old;
        if (rotDeg == 0) {
            I_old = I;
            J_old = J;
        } else {
            IntPair old = xBRZ.buildMatrixRotation(rotDeg - 1, I, J, N);
            I_old = N - 1 - old.J;
            J_old = old.I;
        }
        return new IntPair(I_old, J_old);
    }

    static /* synthetic */ Scaler access$000() {
        return Scaler2x;
    }

    static /* synthetic */ Scaler access$100() {
        return Scaler3x;
    }

    static /* synthetic */ Scaler access$200() {
        return Scaler4x;
    }

    static /* synthetic */ Scaler access$300() {
        return Scaler5x;
    }

    static {
        for (int n = 2; n < 6; ++n) {
            for (int r = 0; r < 4; ++r) {
                int nr = (n - 2) * 100 + r * 25;
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        xBRZ.matrixRotation[nr + i * 5 + j] = xBRZ.buildMatrixRotation(r, i, j, n);
                    }
                }
            }
        }
        Scaler2x = new Scaler(){
            private static final int scale = 2;

            @Override
            public int scale() {
                return 2;
            }

            @Override
            public final void blendLineShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(1, 0), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 1), col);
            }

            @Override
            public final void blendLineSteep(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(0, 1), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 1), col);
            }

            @Override
            public final void blendLineSteepAndShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(1, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(0, 1), col);
                xBRZ.alphaBlend(5, 6, out.ref(1, 1), col);
            }

            @Override
            public final void blendLineDiagonal(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 2, out.ref(1, 1), col);
            }

            @Override
            public final void blendCorner(int col, OutputMatrix out) {
                xBRZ.alphaBlend(21, 100, out.ref(1, 1), col);
            }
        };
        Scaler3x = new Scaler(){
            private static final int scale = 3;

            @Override
            public int scale() {
                return 3;
            }

            @Override
            public final void blendLineShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(2, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(1, 2), col);
                xBRZ.alphaBlend(3, 4, out.ref(2, 1), col);
                out.ref(2, 2).set(col);
            }

            @Override
            public final void blendLineSteep(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(0, 2), col);
                xBRZ.alphaBlend(1, 4, out.ref(2, 1), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 2), col);
                out.ref(2, 2).set(col);
            }

            @Override
            public final void blendLineSteepAndShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(2, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(0, 2), col);
                xBRZ.alphaBlend(3, 4, out.ref(2, 1), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 2), col);
                out.ref(2, 2).set(col);
            }

            @Override
            public final void blendLineDiagonal(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 8, out.ref(1, 2), col);
                xBRZ.alphaBlend(1, 8, out.ref(2, 1), col);
                xBRZ.alphaBlend(7, 8, out.ref(2, 2), col);
            }

            @Override
            public final void blendCorner(int col, OutputMatrix out) {
                xBRZ.alphaBlend(45, 100, out.ref(2, 2), col);
            }
        };
        Scaler4x = new Scaler(){
            private static final int scale = 4;

            @Override
            public int scale() {
                return 4;
            }

            @Override
            public final void blendLineShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(3, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(2, 2), col);
                xBRZ.alphaBlend(3, 4, out.ref(3, 1), col);
                xBRZ.alphaBlend(3, 4, out.ref(2, 3), col);
                out.ref(3, 2).set(col);
                out.ref(3, 3).set(col);
            }

            @Override
            public final void blendLineSteep(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(0, 3), col);
                xBRZ.alphaBlend(1, 4, out.ref(2, 2), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 3), col);
                xBRZ.alphaBlend(3, 4, out.ref(3, 2), col);
                out.ref(2, 3).set(col);
                out.ref(3, 3).set(col);
            }

            @Override
            public final void blendLineSteepAndShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(3, 4, out.ref(3, 1), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 3), col);
                xBRZ.alphaBlend(1, 4, out.ref(3, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(0, 3), col);
                xBRZ.alphaBlend(1, 3, out.ref(2, 2), col);
                out.ref(3, 3).set(col);
                out.ref(3, 2).set(col);
                out.ref(2, 3).set(col);
            }

            @Override
            public final void blendLineDiagonal(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 2, out.ref(3, 2), col);
                xBRZ.alphaBlend(1, 2, out.ref(2, 3), col);
                out.ref(3, 3).set(col);
            }

            @Override
            public final void blendCorner(int col, OutputMatrix out) {
                xBRZ.alphaBlend(68, 100, out.ref(3, 3), col);
                xBRZ.alphaBlend(9, 100, out.ref(3, 2), col);
                xBRZ.alphaBlend(9, 100, out.ref(2, 3), col);
            }
        };
        Scaler5x = new Scaler(){
            private static final int scale = 5;

            @Override
            public int scale() {
                return 5;
            }

            @Override
            public final void blendLineShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(4, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(3, 2), col);
                xBRZ.alphaBlend(1, 4, out.ref(2, 4), col);
                xBRZ.alphaBlend(3, 4, out.ref(4, 1), col);
                xBRZ.alphaBlend(3, 4, out.ref(3, 3), col);
                out.ref(4, 2).set(col);
                out.ref(4, 3).set(col);
                out.ref(4, 4).set(col);
                out.ref(3, 4).set(col);
            }

            @Override
            public final void blendLineSteep(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(0, 4), col);
                xBRZ.alphaBlend(1, 4, out.ref(2, 3), col);
                xBRZ.alphaBlend(1, 4, out.ref(4, 2), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 4), col);
                xBRZ.alphaBlend(3, 4, out.ref(3, 3), col);
                out.ref(2, 4).set(col);
                out.ref(3, 4).set(col);
                out.ref(4, 4).set(col);
                out.ref(4, 3).set(col);
            }

            @Override
            public final void blendLineSteepAndShallow(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 4, out.ref(0, 4), col);
                xBRZ.alphaBlend(1, 4, out.ref(2, 3), col);
                xBRZ.alphaBlend(3, 4, out.ref(1, 4), col);
                xBRZ.alphaBlend(1, 4, out.ref(4, 0), col);
                xBRZ.alphaBlend(1, 4, out.ref(3, 2), col);
                xBRZ.alphaBlend(3, 4, out.ref(4, 1), col);
                out.ref(2, 4).set(col);
                out.ref(3, 4).set(col);
                out.ref(4, 2).set(col);
                out.ref(4, 3).set(col);
                out.ref(4, 4).set(col);
                xBRZ.alphaBlend(2, 3, out.ref(3, 3), col);
            }

            @Override
            public final void blendLineDiagonal(int col, OutputMatrix out) {
                xBRZ.alphaBlend(1, 8, out.ref(4, 2), col);
                xBRZ.alphaBlend(1, 8, out.ref(3, 3), col);
                xBRZ.alphaBlend(1, 8, out.ref(2, 4), col);
                xBRZ.alphaBlend(7, 8, out.ref(4, 3), col);
                xBRZ.alphaBlend(7, 8, out.ref(3, 4), col);
                out.ref(4, 4).set(col);
            }

            @Override
            public final void blendCorner(int col, OutputMatrix out) {
                xBRZ.alphaBlend(86, 100, out.ref(4, 4), col);
                xBRZ.alphaBlend(23, 100, out.ref(4, 3), col);
                xBRZ.alphaBlend(23, 100, out.ref(3, 4), col);
            }
        };
    }

    private static interface Scaler {
        public int scale();

        public void blendLineSteep(int var1, OutputMatrix var2);

        public void blendLineSteepAndShallow(int var1, OutputMatrix var2);

        public void blendLineShallow(int var1, OutputMatrix var2);

        public void blendLineDiagonal(int var1, OutputMatrix var2);

        public void blendCorner(int var1, OutputMatrix var2);
    }

    private static final class IntPtr {
        private final int[] arr;
        private int ptr;

        public IntPtr(int[] intArray) {
            this.arr = intArray;
        }

        public final void position(int position) {
            this.ptr = position;
        }

        public final int get() {
            return this.arr[this.ptr];
        }

        public final void set(int val) {
            this.arr[this.ptr] = val;
        }
    }

    private static final class IntPair {
        public final int I;
        public final int J;

        public IntPair(int i, int j) {
            this.I = i;
            this.J = j;
        }
    }

    private static final class OutputMatrix {
        private final IntPtr out;
        private int outi;
        private final int outWidth;
        private final int n;
        private int nr;

        public OutputMatrix(int scale, int[] out, int outWidth) {
            this.n = (scale - 2) * 100;
            this.out = new IntPtr(out);
            this.outWidth = outWidth;
        }

        public void move(int rotDeg, int outi) {
            this.nr = this.n + rotDeg * 25;
            this.outi = outi;
        }

        public final IntPtr ref(int i, int j) {
            IntPair rot = matrixRotation[this.nr + i * 5 + j];
            this.out.position(this.outi + rot.J + rot.I * this.outWidth);
            return this.out;
        }
    }

    private static enum RotationDegree {

        public static final int ROT_0 = 0;
        public static final int ROT_90 = 1;
        public static final int ROT_180 = 2;
        public static final int ROT_270 = 3;
    }

    private static enum BlendInfo {


        public static final char getTopL(char b) {
            return (char)(b & 3);
        }

        public static final char getTopR(char b) {
            return (char)(b >> 2 & 3);
        }

        public static final char getBottomR(char b) {
            return (char)(b >> 4 & 3);
        }

        public static final char getBottomL(char b) {
            return (char)(b >> 6 & 3);
        }

        public static final char setTopL(char b, char bt) {
            return (char)(b | bt);
        }

        public static final char setTopR(char b, char bt) {
            return (char)(b | bt << 2);
        }

        public static final char setBottomR(char b, char bt) {
            return (char)(b | bt << 4);
        }

        public static final char setBottomL(char b, char bt) {
            return (char)(b | bt << 6);
        }

        public static final char rotate(char b, int rotDeg) {
            int l = rotDeg << 1;
            int r = 8 - l;
            return (char)(b << l | b >> r);
        }
    }

    private static interface IColorDist {
        public double D(int var1, int var2);
    }

    private static interface IColorEq {
        public boolean E(int var1, int var2);
    }

    private static enum Rot {

        public static int[] R = new int[36];

        static {
            boolean a = false;
            boolean b = true;
            int c = 2;
            int d = 3;
            int e = 4;
            int f = 5;
            int g = 6;
            int h = 7;
            int i = 8;
            int[] deg0 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
            int[] deg90 = new int[]{6, 3, 0, 7, 4, 1, 8, 5, 2};
            int[] deg180 = new int[]{8, 7, 6, 5, 4, 3, 2, 1, 0};
            int[] deg270 = new int[]{2, 5, 8, 1, 4, 7, 0, 3, 6};
            int[][] rotation = new int[][]{deg0, deg90, deg180, deg270};
            for (int rotDeg = 0; rotDeg < 4; ++rotDeg) {
                for (int x = 0; x < 9; ++x) {
                    Rot.R[(x << 2) + rotDeg] = rotation[rotDeg][x];
                }
            }
        }
    }

    private static final class Kernel_4x4 {
        public int a;
        public int b;
        public int c;
        public int d;
        public int e;
        public int f;
        public int g;
        public int h;
        public int i;
        public int j;
        public int k;
        public int l;
        public int m;
        public int n;
        public int o;
        public int p;

        private Kernel_4x4() {
        }
    }

    private static final class Kernel_3x3 {
        public final int[] K = new int[9];

        private Kernel_3x3() {
        }
    }

    private static final class BlendResult {
        public char f;
        public char g;
        public char j;
        public char k;

        private BlendResult() {
        }

        public final void reset() {
            this.k = '\u0000';
            this.j = '\u0000';
            this.g = '\u0000';
            this.f = '\u0000';
        }
    }

    private static enum BlendType {

        public static final char BLEND_NONE = '\u0000';
        public static final char BLEND_NORMAL = '\u0001';
        public static final char BLEND_DOMINANT = '\u0002';
    }

    public static class ScalerCfg {
        public double luminanceWeight = 1.0;
        public double equalColorTolerance = 30.0;
        public double dominantDirectionThreshold = 3.6;
        public double steepDirectionThreshold = 2.2;
    }

    public static enum ScaleSize {
        Times2(xBRZ.access$000()),
        Times3(xBRZ.access$100()),
        Times4(xBRZ.access$200()),
        Times5(xBRZ.access$300());

        private final Scaler scaler;
        public final int size;

        private ScaleSize(Scaler scaler) {
            this.scaler = scaler;
            this.size = scaler.scale();
        }

        public static final ScaleSize cast(int ordinal) {
            int ord1 = Math.max(ordinal, 0);
            int ord2 = Math.min(ord1, ScaleSize.values().length - 1);
            return ScaleSize.values()[ord2];
        }
    }
}

