/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image.filters;

import nintaco.gui.image.filters.VideoFilter;

public final class Scale3x
extends VideoFilter {
    public Scale3x() {
        super(3);
    }

    @Override
    public final void filter(int[] in, int yFirst, int yLast) {
        Scale3x.scale(in, this.out, yFirst, yLast);
    }

    private static void scale(int[] in, int[] out, int yFirst, int yLast) {
        for (int y = yLast - 1; y >= yFirst; --y) {
            int ys = y << 8;
            int ym = y == 0 ? 0 : y - 1 << 8;
            int yp = y == 239 ? 61184 : y + 1 << 8;
            int Y0 = 2304 * y;
            int Y1 = Y0 + 768;
            int Y2 = Y1 + 768;
            for (int x = 255; x >= 0; --x) {
                int x2 = 3 * x;
                int y0 = Y0 + x2;
                int y1 = Y1 + x2;
                int y2 = Y2 + x2;
                int xm = x == 0 ? 0 : x - 1;
                int xp = x == 255 ? 255 : x + 1;
                int a = in[ym + xm];
                int b = in[ym + x];
                int c = in[ym + xp];
                int d = in[ys + xm];
                int e = in[ys + x];
                int f = in[ys + xp];
                int g = in[yp + xm];
                int h = in[yp + x];
                int i = in[yp + xp];
                if (b != h && d != f) {
                    out[y0] = d == b ? d : e;
                    out[y0 + 1] = d == b && e != c || b == f && e != a ? b : e;
                    out[y0 + 2] = b == f ? f : e;
                    out[y1] = d == b && e != g || d == h && e != a ? d : e;
                    out[y1 + 1] = e;
                    out[y1 + 2] = b == f && e != i || h == f && e != c ? f : e;
                    out[y2] = d == h ? d : e;
                    out[y2 + 1] = d == h && e != i || h == f && e != g ? h : e;
                    out[y2 + 2] = h == f ? f : e;
                    continue;
                }
                int n = e;
                out[y2 + 2] = n;
                out[y2 + 1] = n;
                out[y2] = n;
                out[y1 + 2] = n;
                out[y1 + 1] = n;
                out[y1] = n;
                out[y0 + 2] = n;
                out[y0 + 1] = n;
                out[y0] = n;
            }
        }
    }
}

