/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.tasks;

import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.gui.historyeditor.HistoryEditorFrame;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.input.InputUtil;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.task.Task;
import nintaco.util.MathUtil;
import nintaco.util.StreamUtil;

public abstract class SaveStateTask
extends Task {
    protected final Movie movie;
    protected final int endFrameIndex;
    protected final HistoryEditorFrame historyEditorFrame;
    protected final HistoryTableModel historyTableModel;
    protected int frameIndex;
    protected int renderIndex;

    public SaveStateTask(Movie movie, int tailIndex, int endFrameIndex, HistoryTableModel historyTableModel, HistoryEditorFrame historyEditorFrame) {
        this(movie, tailIndex, endFrameIndex, historyTableModel, historyEditorFrame, 0);
    }

    public SaveStateTask(Movie movie, int tailIndex, int endFrameIndex, HistoryTableModel historyTableModel, HistoryEditorFrame historyEditorFrame, int frameIndexOffset) {
        this.movie = movie;
        this.endFrameIndex = Math.max(0, endFrameIndex);
        this.historyEditorFrame = historyEditorFrame;
        this.historyTableModel = historyTableModel;
        this.renderIndex = this.frameIndex = MathUtil.clamp(endFrameIndex - frameIndexOffset, 0, Math.max(0, tailIndex)) & 0xFFFFFFC0;
    }

    protected void saveState(MachineRunner machineRunner) {
        byte[] saveState = null;
        try {
            saveState = StreamUtil.toByteArrayOutputStream(machineRunner.getMachine()).toByteArray();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        machineRunner.dispose();
        if (saveState != null) {
            this.processSaveState(saveState);
        }
    }

    public abstract void processSaveState(byte[] var1);

    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public void loop() {
        Machine machine;
        if (!this.running || this.movie == null) {
            return;
        }
        int blockIndex = this.frameIndex >> Movie.BLOCK_SHIFT;
        MovieBlock movieBlock = this.movie.movieBlocks.get(blockIndex);
        if (movieBlock.saveState == null) {
            return;
        }
        try {
            machine = (Machine)StreamUtil.readObject(movieBlock.saveState);
        }
        catch (Throwable t) {
            return;
        }
        MachineRunner machineRunner = new MachineRunner(machine);
        Mapper mapper = machine.getMapper();
        InputUtil.setMachine(machine);
        mapper.restore(App.getCartFile());
        mapper.restore(App.getFdsFile());
        mapper.restore(App.getNsfFile());
        machine.getPPU().setScreenRenderer(this::render);
        if (this.movie.isVsDualSystem()) {
            ((MainCPU)machine.getCPU()).getSubPPU().setScreenRenderer(this::render2);
        }
        machine.getAPU().setAudioProcessor(this::processOutputSample);
        while (this.running && this.frameIndex <= this.endFrameIndex) {
            int buttonIndex = this.frameIndex & 0x3F;
            if (buttonIndex == 0) {
                blockIndex = this.frameIndex >> Movie.BLOCK_SHIFT;
                movieBlock = this.movie.movieBlocks.get(blockIndex);
            }
            MovieFrame movieFrame = this.movie.movieFrames[0x7F & this.frameIndex];
            movieFrame.frameIndex = this.frameIndex;
            movieFrame.audioLength = 0;
            machineRunner.runFrame(movieBlock, buttonIndex);
            this.historyEditorFrame.setProgressBar(this, this.frameIndex);
            ++this.frameIndex;
        }
        if (this.running) {
            this.saveState(machineRunner);
        }
    }

    protected void processOutputSample(int value) {
        this.movie.movieFrames[0x7F & this.frameIndex].processOutputSample(value);
    }

    protected int[] render() {
        return this.movie.movieFrames[0x7F & this.renderIndex++].screen;
    }

    protected int[] render2() {
        return this.movie.movieFrames[0x7F & this.renderIndex - 1].screen2;
    }
}

