/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.HistoryChange;
import nintaco.gui.historyeditor.change.InsertChange;

public class RunChange
extends HistoryChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int priorHeadIndex;
    private final int[] priorButtons;
    private final InsertChange insertChange;

    public RunChange(int priorHeadIndex, int currentHeadIndex, int[] priorButtons, InsertChange insertChange) {
        this.priorHeadIndex = priorHeadIndex;
        this.priorButtons = priorButtons;
        this.insertChange = insertChange;
        this.setDescription(HistoryTableModel.createRange("Run", priorHeadIndex, currentHeadIndex), new Object[0]);
    }

    private void swapButtons(HistoryTableModel model) {
        if (this.priorButtons != null) {
            for (int i = this.priorButtons.length - 1; i >= 0; --i) {
                int rowIndex = this.priorHeadIndex + i;
                int buttons = model.getButtons(rowIndex);
                model.setButtons(rowIndex, this.priorButtons[i]);
                this.priorButtons[i] = buttons;
            }
        }
    }

    @Override
    public int apply(HistoryTableModel model) {
        this.swapButtons(model);
        if (this.insertChange != null) {
            this.insertChange.apply(model);
        }
        return this.priorHeadIndex;
    }

    @Override
    public int revert(HistoryTableModel model) {
        if (this.insertChange != null) {
            this.insertChange.revert(model);
        }
        this.swapButtons(model);
        return this.priorHeadIndex;
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        hotCells.clear();
        return hotCells;
    }
}

