/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.DefaultTableModel;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.files.CartFile;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.InputDialog;
import nintaco.gui.ListChangedAdapter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.YesNoDialog;
import nintaco.gui.historyeditor.BookmarksModel;
import nintaco.gui.historyeditor.ChangeListCellRenderer;
import nintaco.gui.historyeditor.ChangeListModel;
import nintaco.gui.historyeditor.HistoryBookmark;
import nintaco.gui.historyeditor.HistoryBookmarkEditor;
import nintaco.gui.historyeditor.HistoryProject;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.HistoryTableRowRenderer;
import nintaco.gui.historyeditor.change.BookmarkAddedChange;
import nintaco.gui.historyeditor.change.BookmarkDeletedChange;
import nintaco.gui.historyeditor.change.BookmarkEditedChange;
import nintaco.gui.historyeditor.change.DeleteChange;
import nintaco.gui.historyeditor.change.InitializationChange;
import nintaco.gui.historyeditor.preferences.HistoryEditorPrefs;
import nintaco.gui.historyeditor.tasks.DisposeTask;
import nintaco.gui.historyeditor.tasks.FramePlayedListener;
import nintaco.gui.historyeditor.tasks.NewProjectTask;
import nintaco.gui.historyeditor.tasks.PlayMovieTask;
import nintaco.gui.historyeditor.tasks.RecordTask;
import nintaco.gui.historyeditor.tasks.RenderScreenTask;
import nintaco.gui.historyeditor.tasks.TrimTopTask;
import nintaco.gui.image.QuickSaveStateInfo;
import nintaco.gui.image.preferences.Paths;
import nintaco.movie.Movie;
import nintaco.preferences.AppPrefs;
import nintaco.task.Task;
import nintaco.task.TaskScheduler;
import nintaco.util.CollectionsUtil;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;

public class HistoryEditorFrame
extends JFrame
implements FramePlayedListener {
    public static final String LINE_SEPARATOR = "\n";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final FileExtensionFilter historyFileExtensionFilter = new FileExtensionFilter(0, "History files (*.history)", "history");
    private final BookmarksModel bookmarksModel = new BookmarksModel();
    private final ChangeListModel changeListModel = new ChangeListModel();
    private final HistoryTableModel historyTableModel = new HistoryTableModel(this.changeListModel, this.bookmarksModel);
    private final TaskScheduler taskScheduler = new TaskScheduler();
    private final HistoryTableRowRenderer historyTableRowRenderer = new HistoryTableRowRenderer();
    private final List<QuickSaveStateInfo> quickSaveStateInfos = new ArrayList<QuickSaveStateInfo>();
    private volatile Movie movie;
    private int lastClickedRowIndex;
    private RecordTask recordTask;
    private PlayMovieTask playMovieTask;
    private boolean executing;
    private int priorRowCount;
    private int priorHeadIndex;
    private String projectName;
    private boolean disking;
    private File priorSaveFile;
    private JButton addBookmarkButton;
    private JMenuItem appendCloneMenuItem;
    private JMenuItem appendFrameMenuItem;
    private JMenuItem appendFramesMenuItem;
    private JMenuItem appendPasteMenuItem;
    private JList bookmarksList;
    private JPanel bookmarksPanel;
    private JScrollPane bookmarksScrollPane;
    private JButton cancelButton;
    private JList changesList;
    private JScrollPane changesScrollPane;
    private JButton clearButton;
    private JMenuItem clearMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JButton deleteBookmarkButton;
    private JMenuItem deleteMenuItem;
    private JMenuItem deselectMenuItem;
    private JButton editBookmarkButton;
    private JMenu editMenu;
    private JCheckBox fastGenerationCheckBox;
    private JMenu fileMenu;
    private JButton headButton;
    private JPanel historyPanel;
    private JScrollPane historyScrollPane;
    private JTable historyTable;
    private JMenuItem insertCloneMenuItem;
    private JMenuItem insertFrameMenuItem;
    private JMenuItem insertFramesMenuItem;
    private JMenuItem insertPasteMenuItem;
    private JPanel jPanel1;
    private JButton loadButton;
    private JMenuItem loadMenuItem;
    private JMenuBar menuBar;
    private JCheckBox mergeButtonsCheckBox;
    private JMenuItem mergeMenuItem;
    private JMenuItem newMenuItem;
    private JMenuItem newestSlotMenuItem;
    private JButton nextBookmarkButton;
    private JButton nextFrameButton;
    private JMenuItem oldestSlotMenuItem;
    private JMenuItem pasteMenuItem;
    private JToggleButton pauseToggleButton;
    private JButton previousBookmarkButton;
    private JButton previousFrameButton;
    private JProgressBar progressBar;
    private JMenu quickLoadProjectMenu;
    private JPopupMenu.Separator quickLoadSeparator;
    private JMenu quickSaveProjectMenu;
    private JPopupMenu.Separator quickSaveSeparator;
    private JMenuItem recentDirectoriesClearMenuItem;
    private JCheckBoxMenuItem recentDirectoriesLockMenuItem;
    private JMenu recentDirectoriesMenu;
    private JPopupMenu.Separator recentDirectoriesSeparator;
    private JMenuItem recentProjectsClearMenuItem;
    private JCheckBoxMenuItem recentProjectsLockMenuItem;
    private JMenu recentProjectsMenu;
    private JPopupMenu.Separator recentProjectsSeparator;
    private JCheckBox record1PCheckBox;
    private JCheckBox record2PCheckBox;
    private JCheckBox record3PCheckBox;
    private JCheckBox record4PCheckBox;
    private JCheckBox recordOtherCheckBox;
    private JPanel recordPanel;
    private JButton redoButton;
    private JMenuItem redoMenuItem;
    private JCheckBox restorePositionCheckBox;
    private JPanel runPanel;
    private JMenuItem saveAsMenuItem;
    private JButton saveButton;
    private JMenuItem saveMenuItem;
    private JComboBox saveSlotsComboBox;
    private JButton seekBookmarkButton;
    private JMenuItem selectAllMenuItem;
    private JMenuItem selectBetweenBookmarksMenuItem;
    private JPopupMenu.Separator separator;
    private JPopupMenu.Separator separator1;
    private JPopupMenu.Separator separator2;
    private JPopupMenu.Separator separator3;
    private JPopupMenu.Separator separator4;
    private JPopupMenu.Separator separator5;
    private JPopupMenu.Separator separator6;
    private JPopupMenu.Separator separator7;
    private JPopupMenu.Separator separator8;
    private JPopupMenu.Separator separator9;
    private JPanel statesPanel;
    private JCheckBox trackCursorCheckBox;
    private JMenuItem trimBottomMenuItem;
    private JMenuItem trimTopMenuItem;
    private JButton undoButton;
    private JMenuItem undoMenuItem;
    private JCheckBox view1PCheckBox;
    private JCheckBox view2PCheckBox;
    private JCheckBox view3PCheckBox;
    private JCheckBox view4PCheckBox;
    private JPanel viewPanel;

    public HistoryEditorFrame(MachineRunner machineRunner) {
        this.initComponents();
        this.loadFields();
        this.initHistoryTable();
        this.initChangeList();
        this.initBookmarksList();
        this.enableComponents();
        GuiUtil.scaleFonts(this);
        this.initPreferredSizes();
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
        this.setMachineRunner(machineRunner);
    }

    private void initPreferredSizes() {
        this.runPanel.setPreferredSize(null);
        this.viewPanel.setPreferredSize(null);
        this.recordPanel.setPreferredSize(null);
        this.statesPanel.setPreferredSize(null);
        this.bookmarksPanel.setPreferredSize(null);
        this.historyPanel.setPreferredSize(null);
    }

    private void generateDefaultProjectName() {
        String gameName = FileUtil.getFileNameWithoutExtension(App.getEntryFileName());
        if (gameName != null) {
            this.setProjectName(String.format("%s-%s", gameName, dateFormatter.format(new Date())));
        }
    }

    public void setMachineRunner(MachineRunner machineRunner) {
        if (EventQueue.isDispatchThread()) {
            if (machineRunner == null || machineRunner.getMachine() == null) {
                this.closeProject();
            } else {
                this.cancelAllTasks();
                this.movie = machineRunner.getMovie();
                if (this.movie == null) {
                    this.movie = new Movie(false);
                    this.historyTableModel.setMovie(this.movie);
                    this.historyTableModel.clear(StreamUtil.toByteArrayOutputStream(machineRunner.getMachine()).toByteArray());
                } else {
                    this.historyTableModel.setMovie(this.movie);
                }
                machineRunner.dispose();
                App.updateFrames(null);
                App.setMachineRunner(null);
                this.priorSaveFile = null;
                this.resizeHistoryTableColumns();
                this.lastClickedRowIndex = this.historyTableModel.getHeadIndex();
                this.setExecuting(false);
                this.generateDefaultProjectName();
                this.createQuickMenus();
                this.createRecentProjectsMenu();
                this.resetProgressBar();
                this.saveSlotsComboBox.setSelectedIndex(0);
            }
        } else {
            EventQueue.invokeLater(() -> this.setMachineRunner(machineRunner));
        }
    }

    private void initHistoryTable() {
        GuiUtil.removeTransferActions(this.historyTable);
        this.historyTable.getSelectionModel().addListSelectionListener(e -> this.historyTableSelectionChanged());
        this.historyTable.getTableHeader().setReorderingAllowed(false);
        GuiUtil.addTableCellClickedListener(this.historyTable, this::historyTableMouseClicked);
        this.historyTable.setShowGrid(true);
        this.historyTable.setGridColor(new Color(0xF0F0F0));
        this.historyTable.setDefaultRenderer(String.class, this.historyTableRowRenderer);
        this.historyTable.setModel(this.historyTableModel);
        GuiUtil.centerTableHeaders(this.historyTable);
        this.resizeHistoryTableColumns();
        this.historyTableSelectionChanged();
    }

    private void initChangeList() {
        this.changesList.setCellRenderer(new ChangeListCellRenderer());
        this.changeListModel.addListDataListener(new ListChangedAdapter(this::changeListUpdated));
        this.changeListModel.addChange(new InitializationChange());
        this.changesList.setModel(this.changeListModel);
    }

    private void initBookmarksList() {
        this.bookmarksModel.addListDataListener(new ListChangedAdapter(this::enableBookmarkButtons));
        this.bookmarksList.setCellRenderer(new GuiUtil.NoBorderListCellRenderer());
        this.bookmarksList.setModel(this.bookmarksModel);
    }

    private void createQuickMenus() {
        this.quickLoadProjectMenu.removeAll();
        this.quickSaveProjectMenu.removeAll();
        this.quickSaveStateInfos.clear();
        String historiesDir = AppPrefs.getInstance().getPaths().getHistoriesDir();
        FileUtil.mkdir(historiesDir);
        for (int i = 1; i <= 9; ++i) {
            int index = i - 1;
            File file = this.createQuickSaveFile(historiesDir, this.projectName, i);
            boolean fileExists = file.exists();
            String name = fileExists ? FileUtil.getFileTimestamp(i, file) : String.format("%d  ...                     ", i);
            char key = Character.forDigit(i, 10);
            JMenuItem quickLoadMenuItem = new JMenuItem(name, key);
            GuiUtil.scaleMenuItemFont(quickLoadMenuItem);
            quickLoadMenuItem.setAccelerator(KeyStroke.getKeyStroke(key));
            quickLoadMenuItem.setEnabled(fileExists);
            quickLoadMenuItem.addActionListener(e -> this.quickLoadProject(index));
            this.quickLoadProjectMenu.add(quickLoadMenuItem);
            JMenuItem quickSaveMenuItem = new JMenuItem(name, key);
            GuiUtil.scaleMenuItemFont(quickSaveMenuItem);
            quickSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(key), 1));
            quickSaveMenuItem.addActionListener(e -> this.quickSaveProject(index));
            this.quickSaveProjectMenu.add(quickSaveMenuItem);
            this.quickSaveStateInfos.add(new QuickSaveStateInfo(i, file, file.lastModified(), quickLoadMenuItem, quickSaveMenuItem));
        }
        this.quickLoadProjectMenu.add(this.quickLoadSeparator);
        this.quickLoadProjectMenu.add(this.newestSlotMenuItem);
        this.quickSaveProjectMenu.add(this.quickSaveSeparator);
        this.quickSaveProjectMenu.add(this.oldestSlotMenuItem);
        this.findNewestAndOldestSaveSlots();
        this.enableSaveButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createRecentProjectsMenu() {
        this.recentProjectsMenu.removeAll();
        Paths paths = AppPrefs.getInstance().getPaths();
        List<String> fileNames = paths.getRecentHistoryProjects();
        if (fileNames.isEmpty()) {
            this.recentProjectsMenu.setEnabled(false);
        } else {
            this.recentProjectsMenu.setEnabled(true);
            Class<AppPrefs> clazz = AppPrefs.class;
            // MONITORENTER : nintaco.preferences.AppPrefs.class
            for (String fileName : fileNames) {
                JMenuItem menuItem = new JMenuItem(FileUtil.getFileName(fileName));
                GuiUtil.scaleMenuItemFont(menuItem);
                menuItem.addActionListener(e -> this.recentProjectMenuItemPressed(fileName));
                this.recentProjectsMenu.add(menuItem);
            }
            // MONITOREXIT : clazz
            this.recentProjectsMenu.add(this.recentProjectsSeparator);
            this.recentProjectsMenu.add(this.recentProjectsLockMenuItem);
            this.recentProjectsMenu.add(this.recentProjectsClearMenuItem);
        }
        this.recentProjectsLockMenuItem.setSelected(paths.isLockRecentHistoryProjects());
    }

    private void enableRecentDirectoriesMenu() {
        this.recentDirectoriesMenu.setEnabled(!AppPrefs.getInstance().getPaths().getRecentDirectories().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createRecentDirectoriesMenu() {
        this.recentDirectoriesMenu.removeAll();
        Paths paths = AppPrefs.getInstance().getPaths();
        List<String> directories = paths.getRecentDirectories();
        if (!directories.isEmpty()) {
            Class<AppPrefs> clazz = AppPrefs.class;
            // MONITORENTER : nintaco.preferences.AppPrefs.class
            for (String directory : directories) {
                JMenuItem menuItem = new JMenuItem(directory);
                GuiUtil.scaleMenuItemFont(menuItem);
                menuItem.addActionListener(e -> this.load(directory));
                this.recentDirectoriesMenu.add(menuItem);
            }
            // MONITOREXIT : clazz
            this.recentDirectoriesMenu.add(this.recentDirectoriesSeparator);
            this.recentDirectoriesMenu.add(this.recentDirectoriesLockMenuItem);
            this.recentDirectoriesMenu.add(this.recentDirectoriesClearMenuItem);
        }
        this.recentDirectoriesLockMenuItem.setSelected(paths.isLockRecentDirectories());
    }

    private void recentProjectMenuItemPressed(String fileName) {
        this.quickLoadProject(new File(fileName), App.getEntryFileName(), false);
    }

    private File createQuickSaveFile(String historiesDir, String projectName, int index) {
        return new File(historiesDir, String.format("%s.history-%d", projectName, index));
    }

    private void renameQuickSaveFiles(String newProjectName) {
        String historiesDir = AppPrefs.getInstance().getPaths().getHistoriesDir();
        FileUtil.mkdir(historiesDir);
        for (int i = this.quickSaveStateInfos.size() - 1; i >= 0; --i) {
            QuickSaveStateInfo info = this.quickSaveStateInfos.get(i);
            File oldFile = info.getFile();
            File newFile = this.createQuickSaveFile(historiesDir, newProjectName, info.getSlot());
            if (oldFile.exists() && !oldFile.equals(newFile)) {
                oldFile.renameTo(newFile);
            }
            this.quickSaveStateInfos.set(i, new QuickSaveStateInfo(info.getSlot(), newFile, info.getModifiedTime(), info.getLoadMenuItem(), info.getSaveMenuItem()));
        }
    }

    private void findNewestAndOldestSaveSlots() {
        QuickSaveStateInfo info;
        QuickSaveStateInfo newest = null;
        QuickSaveStateInfo oldest = null;
        for (QuickSaveStateInfo info2 : this.quickSaveStateInfos) {
            if (newest == null) {
                newest = info2;
                oldest = info2;
                continue;
            }
            if (info2.getModifiedTime() < oldest.getModifiedTime()) {
                oldest = info2;
            }
            if (info2.getModifiedTime() <= newest.getModifiedTime()) continue;
            newest = info2;
        }
        this.removeAllActionListeners(this.newestSlotMenuItem);
        if (newest.getModifiedTime() > 0L) {
            this.newestSlotMenuItem.setEnabled(true);
            info = newest;
            this.newestSlotMenuItem.addActionListener(e -> this.quickLoadProject(info.getSlot() - 1));
        } else {
            this.newestSlotMenuItem.setEnabled(false);
        }
        this.removeAllActionListeners(this.oldestSlotMenuItem);
        info = oldest;
        this.oldestSlotMenuItem.addActionListener(e -> this.quickSaveProject(info.getSlot() - 1));
    }

    private void removeAllActionListeners(AbstractButton button) {
        for (ActionListener listener : button.getActionListeners()) {
            button.removeActionListener(listener);
        }
    }

    private void resizeHistoryTableColumns() {
        Object[] prototypes = new Object[(this.historyTableModel.getPlayers() << 3) + 2];
        prototypes[0] = "\u25a0\u25ba\u25ba";
        prototypes[1] = "MMMMMMM";
        Arrays.fill(prototypes, 2, prototypes.length, "M");
        GuiUtil.resizeCellSizes(this.historyTable, false, true, 16, false, prototypes);
    }

    private boolean isBusy() {
        return this.executing || this.disking;
    }

    private void loadFields() {
        this.applyPreferences(AppPrefs.getInstance().getHistoryEditorPrefs());
    }

    private void applyPreferences(HistoryEditorPrefs prefs) {
        this.fastGenerationCheckBox.setSelected(prefs.getFastGeneration());
        this.mergeButtonsCheckBox.setSelected(prefs.getMerge());
        this.restorePositionCheckBox.setSelected(prefs.getRestorePosition());
        this.trackCursorCheckBox.setSelected(prefs.getTrackCursor());
        boolean[] recordPlayers = prefs.getRecordPlayers();
        this.record1PCheckBox.setSelected(recordPlayers[0]);
        this.record2PCheckBox.setSelected(recordPlayers[1]);
        this.record3PCheckBox.setSelected(recordPlayers[2]);
        this.record4PCheckBox.setSelected(recordPlayers[3]);
        boolean[] viewPlayers = prefs.getViewPlayers();
        this.view1PCheckBox.setSelected(viewPlayers[0]);
        this.view2PCheckBox.setSelected(viewPlayers[1]);
        this.view3PCheckBox.setSelected(viewPlayers[2]);
        this.view4PCheckBox.setSelected(viewPlayers[3]);
        this.historyTableModel.setViewPlayers(viewPlayers);
    }

    private void saveFields() {
        this.capturePreferences(AppPrefs.getInstance().getHistoryEditorPrefs());
        AppPrefs.save();
    }

    private void closeProject() {
        this.cancelAllTasks();
        int startIndex = this.historyTableModel.getTailIndex();
        int endIndex = this.historyTableModel.getHeadIndex();
        this.resetProgressBar(startIndex, endIndex);
        this.taskScheduler.add(new NewProjectTask(this.movie, startIndex, endIndex, this.historyTableModel, this));
    }

    public void createNewProject(byte[] saveState) {
        this.historyTableModel.clear(saveState);
        this.priorSaveFile = null;
        this.generateDefaultProjectName();
        this.resetProgressBar();
        this.saveSlotsComboBox.setSelectedIndex(0);
        this.createQuickMenus();
    }

    private HistoryEditorPrefs createHistoryEditorPrefs() {
        HistoryEditorPrefs prefs = new HistoryEditorPrefs();
        this.capturePreferences(prefs);
        return prefs;
    }

    private void capturePreferences(HistoryEditorPrefs prefs) {
        prefs.setFastGeneration(this.fastGenerationCheckBox.isSelected());
        prefs.setMerge(this.mergeButtonsCheckBox.isSelected());
        prefs.setRestorePosition(this.restorePositionCheckBox.isSelected());
        prefs.setTrackCursor(this.trackCursorCheckBox.isSelected());
        prefs.setRecordPlayers(this.getRecordPlayers());
        prefs.setViewPlayers(this.getViewPlayers());
    }

    private HistoryProject createHistoryProject() {
        HistoryProject project = new HistoryProject();
        this.captureHistoryProject(project);
        return project;
    }

    private void captureHistoryProject(HistoryProject project) {
        project.setEntryFileName(App.getEntryFileName());
        CartFile cartFile = App.getCartFile();
        project.setEntryFileCRC(cartFile != null ? cartFile.getFileCRC() : 0);
        project.setBookmarks(this.bookmarksModel.getBookmarks());
        project.setChanges(this.changeListModel.getChanges());
        project.setChangesIndex(this.changeListModel.getChangesIndex());
        project.setHistoryEditorPrefs(this.createHistoryEditorPrefs());
        project.setLastClickedRowIndex(this.lastClickedRowIndex);
        project.setMovie(this.movie);
        project.setHeadIndex(this.historyTableModel.getHeadIndex());
        project.setLastIndex(this.historyTableModel.getLastIndex());
        project.setTailIndex(this.historyTableModel.getTailIndex());
        project.setHistoryScrollValues(GuiUtil.getScrollValues(this.historyScrollPane));
        project.setBookmarksScrollValues(GuiUtil.getScrollValues(this.bookmarksScrollPane));
        project.setChangesScrollValues(GuiUtil.getScrollValues(this.changesScrollPane));
    }

    private void applyHistoryProject(HistoryProject project) {
        this.lastClickedRowIndex = project.getLastClickedRowIndex();
        this.movie = project.getMovie();
        this.changeListModel.setChanges(project.getChanges(), project.getChangesIndex());
        this.bookmarksModel.setBookmarks(project.getBookmarks());
        this.historyTableModel.setMovie(project.getMovie());
        this.historyTableModel.setHeadIndex(project.getHeadIndex());
        this.historyTableModel.setLastIndex(project.getLastIndex());
        this.historyTableModel.setTailIndex(project.getTailIndex());
        this.historyTableModel.setBookmarks(this.bookmarksModel.getBookmarkedRows());
        this.applyPreferences(project.getHistoryEditorPrefs());
        this.resizeHistoryTableColumns();
        GuiUtil.setScrollValues(this.historyScrollPane, project.getHistoryScrollValues());
        GuiUtil.setScrollValues(this.bookmarksScrollPane, project.getBookmarksScrollValues());
        GuiUtil.setScrollValues(this.changesScrollPane, project.getChangesScrollValues());
    }

    public void destroy() {
        this.saveFields();
        this.taskScheduler.dispose();
        this.dispose();
    }

    public void closeFrame() {
        App.destroyHistoryEditorFrame();
    }

    public void movieUpdated(int frameIndex) {
        if (EventQueue.isDispatchThread()) {
            this.historyTableModel.fireTableRowsUpdated(frameIndex, frameIndex);
        } else {
            EventQueue.invokeLater(() -> this.movieUpdated(frameIndex));
        }
    }

    private void updateViewPlayers() {
        boolean[] viewPlayers = new boolean[]{this.view1PCheckBox.isSelected(), this.view2PCheckBox.isSelected(), this.view3PCheckBox.isSelected(), this.view4PCheckBox.isSelected()};
        this.historyTableModel.setViewPlayers(viewPlayers);
        this.resizeHistoryTableColumns();
    }

    private void historyTableMouseClicked(int rowIndex, int columnIndex) {
        if (this.isBusy()) {
            return;
        }
        if (columnIndex == 0) {
            this.moveHeadToRow(rowIndex);
        } else if (columnIndex >= 2) {
            this.cancelAllTasks();
            this.historyTableModel.toggleButton(rowIndex, columnIndex);
            this.runToLastClickedRow(rowIndex);
        }
    }

    private void moveHeadToRow(int rowIndex) {
        if (this.isBusy()) {
            return;
        }
        this.cancelAllTasks();
        this.lastClickedRowIndex = rowIndex;
        if (rowIndex > this.historyTableModel.getTailIndex()) {
            this.resetProgressBar(this.historyTableModel.getTailIndex(), rowIndex);
            this.playMovieTask = new PlayMovieTask(this.movie, this.historyTableModel.getTailIndex(), rowIndex, !this.fastGenerationCheckBox.isSelected(), this);
            this.taskScheduler.add(this.playMovieTask);
        }
        this.taskScheduler.add(new RenderScreenTask(this.movie, rowIndex, true));
        this.taskScheduler.add(new RenderScreenTask(this.movie, rowIndex - 64, false));
        this.historyTableModel.setHeadIndex(rowIndex);
    }

    public void runToLastClickedRow(int modifiedRowIndex) {
        if (this.lastClickedRowIndex < 0 || this.lastClickedRowIndex >= this.historyTableModel.getRowCount()) {
            this.lastClickedRowIndex = this.historyTableModel.getRowCount() - 1;
        }
        if (modifiedRowIndex < 0 || modifiedRowIndex >= this.historyTableModel.getRowCount()) {
            modifiedRowIndex = this.historyTableModel.getRowCount() - 1;
        }
        if (this.historyTableModel.isEmpty()) {
            this.resetProgressBar();
        } else if (modifiedRowIndex <= this.lastClickedRowIndex) {
            this.historyTableModel.setLastIndex(this.lastClickedRowIndex);
            int lastRowIndex = this.restorePositionCheckBox.isSelected() ? this.lastClickedRowIndex : modifiedRowIndex;
            this.resetProgressBar(this.historyTableModel.getTailIndex(), lastRowIndex);
            this.playMovieTask = new PlayMovieTask(this.movie, this.historyTableModel.getTailIndex(), lastRowIndex, !this.fastGenerationCheckBox.isSelected(), this);
            this.taskScheduler.add(this.playMovieTask);
            this.taskScheduler.add(new RenderScreenTask(this.movie, lastRowIndex, true));
            this.taskScheduler.add(new RenderScreenTask(this.movie, lastRowIndex - 64, false));
        }
    }

    private void cancelAllTasks() {
        this.taskScheduler.cancelAll();
        this.taskScheduler.waitForReady();
        this.resetProgressBar();
    }

    private void resetProgressBar() {
        this.resetProgressBar(0, 100);
    }

    private void resetProgressBar(int min, int max) {
        this.progressBar.setMinimum(Math.max(0, min));
        this.progressBar.setMaximum(Math.max(0, max));
        this.progressBar.setValue(Math.max(0, min));
    }

    public void setProgressBar(Task task, int value) {
        if (EventQueue.isDispatchThread()) {
            if (!task.isCanceled()) {
                this.progressBar.setValue(value);
            }
        } else {
            EventQueue.invokeLater(() -> this.setProgressBar(task, value));
        }
    }

    @Override
    public void framePlayed(Task task, int frameIndex, MachineRunner machineRunner) {
        if (EventQueue.isDispatchThread()) {
            if (!task.isCanceled()) {
                this.progressBar.setValue(frameIndex);
                this.historyTableModel.setHeadIndex(frameIndex);
                if (this.historyTableModel.getTailIndex() < frameIndex) {
                    this.historyTableModel.setTailIndex(frameIndex);
                }
            }
        } else {
            EventQueue.invokeLater(() -> this.framePlayed(task, frameIndex, machineRunner));
        }
    }

    public void handleRewoundFrame(Task task, int frameIndex) {
        if (EventQueue.isDispatchThread()) {
            if (!task.isCanceled()) {
                this.historyTableModel.setHeadIndex(frameIndex);
                this.scrollTo(frameIndex);
            }
        } else {
            EventQueue.invokeLater(() -> this.handleRewoundFrame(task, frameIndex));
        }
    }

    public void handleRecordedFrame(Task task, int frameIndex, boolean newFrame) {
        if (EventQueue.isDispatchThread()) {
            if (!task.isCanceled()) {
                if (newFrame) {
                    this.historyTableModel.fireTableRowsInserted(frameIndex, frameIndex);
                }
                this.historyTableModel.setHeadIndex(frameIndex);
                this.historyTableModel.setTailIndex(frameIndex);
                this.scrollTo(frameIndex);
            }
        } else {
            EventQueue.invokeLater(() -> this.handleRecordedFrame(task, frameIndex, newFrame));
        }
    }

    private void toggleRecording() {
        this.cancelAllTasks();
        this.lastClickedRowIndex = -1;
        this.setExecuting(!this.executing);
        this.enableComponents();
        if (this.executing) {
            this.priorRowCount = this.historyTableModel.getRowCount();
            this.priorHeadIndex = this.historyTableModel.getHeadIndex();
            this.recordTask = new RecordTask(this.movie, this.priorHeadIndex, this);
            this.recordTask.setRecordOptions(this.getRecordPlayers(), this.recordOtherCheckBox.isSelected(), this.mergeButtonsCheckBox.isSelected());
            this.taskScheduler.add(this.recordTask);
            App.getImageFrame().requestFocus();
        } else {
            this.recordTask = null;
        }
    }

    public void handleEndRecord(int[] priorButtons) {
        if (EventQueue.isDispatchThread()) {
            this.historyTableModel.handleEndRecord(priorButtons, this.priorRowCount, this.priorHeadIndex);
            this.priorRowCount = this.historyTableModel.getRowCount();
            this.priorHeadIndex = this.historyTableModel.getHeadIndex();
        } else {
            EventQueue.invokeLater(() -> this.handleEndRecord(priorButtons));
        }
    }

    private boolean[] getRecordPlayers() {
        boolean[] recordPlayers = new boolean[]{this.record1PCheckBox.isSelected(), this.record2PCheckBox.isSelected(), this.record3PCheckBox.isSelected(), this.record4PCheckBox.isSelected()};
        return recordPlayers;
    }

    private boolean[] getViewPlayers() {
        boolean[] viewPlayers = new boolean[]{this.view1PCheckBox.isSelected(), this.view2PCheckBox.isSelected(), this.view3PCheckBox.isSelected(), this.view4PCheckBox.isSelected()};
        return viewPlayers;
    }

    private void enableComponents() {
        boolean notExecuting = !this.isBusy();
        boolean notEmpty = !this.historyTableModel.isEmpty();
        boolean notExecutingEmpty = notExecuting && notEmpty;
        this.cancelButton.setEnabled(notExecuting);
        this.progressBar.setEnabled(notExecuting);
        this.previousFrameButton.setEnabled(notExecutingEmpty);
        this.nextFrameButton.setEnabled(notExecutingEmpty);
        this.headButton.setEnabled(notExecutingEmpty);
        this.menuBar.setEnabled(notExecuting);
        this.enableFileMenuItems();
        this.enableEditMenuItems();
        this.enableBookmarkButtons();
        this.enableChangeButtons();
        this.enableSaveButtons();
    }

    private void enableFileMenuItems() {
        boolean notExecuting = !this.isBusy();
        boolean notEmpty = !this.historyTableModel.isEmpty();
        boolean notExecutingEmpty = notExecuting && notEmpty;
        this.fileMenu.setEnabled(notExecuting);
        this.loadMenuItem.setEnabled(notExecuting);
        this.saveMenuItem.setEnabled(notExecutingEmpty);
        this.saveAsMenuItem.setEnabled(notExecutingEmpty);
        this.enableRecentDirectoriesMenu();
    }

    private void enableEditMenuItems() {
        boolean notExecuting = !this.isBusy();
        boolean notEmpty = !this.historyTableModel.isEmpty();
        boolean notExecutingEmpty = notExecuting && notEmpty;
        boolean rowsSelected = this.historyTable.getSelectedRow() >= 0;
        String value = GuiUtil.getClipboardString();
        boolean copyEnabled = notExecutingEmpty && rowsSelected;
        boolean pasteEnabled = notExecutingEmpty && value != null && value.length() >= 32;
        this.editMenu.setEnabled(notExecuting);
        this.insertFrameMenuItem.setEnabled(notExecuting);
        this.insertFramesMenuItem.setEnabled(notExecuting);
        this.appendFrameMenuItem.setEnabled(notExecuting);
        this.appendFramesMenuItem.setEnabled(notExecuting);
        this.selectAllMenuItem.setEnabled(notExecutingEmpty);
        this.selectBetweenBookmarksMenuItem.setEnabled(notExecutingEmpty);
        this.deselectMenuItem.setEnabled(copyEnabled);
        this.trimTopMenuItem.setEnabled(copyEnabled);
        this.trimBottomMenuItem.setEnabled(copyEnabled);
        this.copyMenuItem.setEnabled(copyEnabled);
        this.cutMenuItem.setEnabled(copyEnabled);
        this.clearMenuItem.setEnabled(copyEnabled);
        this.deleteMenuItem.setEnabled(copyEnabled);
        this.insertCloneMenuItem.setEnabled(copyEnabled);
        this.appendCloneMenuItem.setEnabled(copyEnabled);
        this.pasteMenuItem.setEnabled(pasteEnabled);
        this.mergeMenuItem.setEnabled(pasteEnabled);
        this.insertPasteMenuItem.setEnabled(pasteEnabled);
        this.appendPasteMenuItem.setEnabled(pasteEnabled);
    }

    private void enableChangeButtons() {
        boolean notExecuting = !this.isBusy();
        boolean notEmpty = !this.historyTableModel.isEmpty();
        boolean notExecutingEmpty = notExecuting && notEmpty;
        int changesIndex = this.changeListModel.getChangesIndex();
        boolean undoEnabled = changesIndex > 1 && notExecutingEmpty;
        boolean redoEnabled = changesIndex < this.changeListModel.getSize() && notExecutingEmpty;
        this.historyPanel.setEnabled(notExecutingEmpty);
        this.changesList.setEnabled(notExecutingEmpty);
        this.clearButton.setEnabled(notExecutingEmpty && this.changeListModel.getSize() > 1);
        this.undoButton.setEnabled(undoEnabled);
        this.undoMenuItem.setEnabled(undoEnabled);
        this.redoButton.setEnabled(redoEnabled);
        this.redoMenuItem.setEnabled(redoEnabled);
    }

    private void enableSaveButtons() {
        boolean notExecuting = !this.isBusy();
        boolean notEmpty = !this.historyTableModel.isEmpty();
        boolean notExecutingEmpty = notExecuting && notEmpty;
        this.statesPanel.setEnabled(notExecutingEmpty);
        this.saveSlotsComboBox.setEnabled(notExecutingEmpty);
        this.saveButton.setEnabled(notExecutingEmpty);
        boolean fileExists = false;
        int index = this.saveSlotsComboBox.getSelectedIndex();
        if (index >= 0 && index < this.quickSaveStateInfos.size()) {
            fileExists = this.quickSaveStateInfos.get(index).getFile().exists();
        }
        this.loadButton.setEnabled(notExecutingEmpty && fileExists);
    }

    private void enableBookmarkButtons() {
        boolean notExecuting = !this.isBusy();
        boolean notEmpty = !this.historyTableModel.isEmpty();
        boolean notExecutingEmpty = notExecuting && notEmpty;
        int index = this.bookmarksList.getSelectedIndex();
        boolean hasBookmarks = !this.bookmarksModel.isEmpty() && notExecutingEmpty;
        boolean bookmarkSelected = index >= 0 && notExecutingEmpty;
        this.previousBookmarkButton.setEnabled(hasBookmarks);
        this.nextBookmarkButton.setEnabled(hasBookmarks);
        this.seekBookmarkButton.setEnabled(bookmarkSelected);
        this.addBookmarkButton.setEnabled(notExecutingEmpty);
        this.editBookmarkButton.setEnabled(bookmarkSelected);
        this.deleteBookmarkButton.setEnabled(bookmarkSelected);
        this.bookmarksList.setEnabled(notExecutingEmpty);
        this.bookmarksPanel.setEnabled(notExecutingEmpty);
    }

    private void setExecuting(boolean executing) {
        this.executing = executing;
        this.pauseToggleButton.setSelected(executing);
        this.pauseToggleButton.setText(executing ? "Pause" : "Resume");
        this.enableComponents();
    }

    private void modifyHeadIndex(int delta) {
        if (this.isBusy()) {
            return;
        }
        int rowCount = this.historyTableModel.getRowCount();
        if (rowCount == 0) {
            return;
        }
        int rowIndex = MathUtil.clamp(this.historyTableModel.getHeadIndex() + delta, 0, rowCount - 1);
        this.historyTableMouseClicked(rowIndex, 0);
        this.scrollTo(rowIndex);
    }

    private void scrollTo(int rowIndex) {
        if (this.trackCursorCheckBox.isSelected()) {
            GuiUtil.scrollToVisible(this.historyTable, rowIndex);
        }
    }

    private void historyTableSelectionChanged() {
        boolean rowsSelected = this.historyTable.getSelectedRowCount() > 0;
        this.cutMenuItem.setEnabled(rowsSelected);
        this.copyMenuItem.setEnabled(rowsSelected);
    }

    private void copySelectedRows() {
        if (this.isBusy()) {
            return;
        }
        int[] rows = this.historyTable.getSelectedRows();
        if (rows.length > 0) {
            Arrays.sort(rows);
            int minRow = rows[0];
            int maxRow = rows[rows.length - 1];
            StringBuilder sb = new StringBuilder();
            int r = 0;
            for (int i = minRow; i <= maxRow; ++i) {
                if (i == rows[r]) {
                    int buttons = this.historyTableModel.getButtons(i);
                    for (int j = 0; j < 32; ++j) {
                        sb.append((buttons & 1) == 1 ? HistoryTableModel.BUTTON_NAMES[j & 7] : "-");
                        buttons >>= 1;
                    }
                    ++r;
                }
                sb.append(LINE_SEPARATOR);
            }
            GuiUtil.setClipboardString(sb);
        }
    }

    private void clearSelectedRows() {
        if (this.isBusy()) {
            return;
        }
        int rowIndex = this.historyTable.getSelectedRow();
        if (rowIndex >= 0) {
            this.cancelAllTasks();
            this.historyTableModel.clearButtons(this.historyTable.getSelectedRows());
            this.runToLastClickedRow(rowIndex);
        }
    }

    private String[] getClipboardLines() {
        String value = GuiUtil.getClipboardString();
        if (value == null) {
            return null;
        }
        String[] lines = value.split("\\s");
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i];
            if (line.isEmpty() || line.length() == 32) continue;
            return null;
        }
        return lines;
    }

    private int convertClipboardLine(String line) {
        int b = 0;
        for (int j = 31; j >= 0; --j) {
            b = b << 1 | (line.charAt(j) != '-' ? 1 : 0);
        }
        return b;
    }

    private int[] getIntClipboardButtons() {
        String[] lines = this.getClipboardLines();
        int[] buttons = new int[lines.length];
        for (int i = buttons.length - 1; i >= 0; --i) {
            String line = lines[i];
            buttons[i] = line.isEmpty() ? 0 : this.convertClipboardLine(line);
        }
        return buttons;
    }

    private Integer[] getClipboardButtons() {
        String[] lines = this.getClipboardLines();
        if (lines == null) {
            return null;
        }
        Integer[] buttons = new Integer[lines.length];
        for (int i = buttons.length - 1; i >= 0; --i) {
            String line = lines[i];
            buttons[i] = line.isEmpty() ? null : Integer.valueOf(this.convertClipboardLine(line));
        }
        return buttons;
    }

    private void pasteRows(boolean merge) {
        if (this.isBusy()) {
            return;
        }
        int rowIndex = this.historyTable.getSelectedRow();
        if (rowIndex < 0 || rowIndex >= this.historyTableModel.getRowCount()) {
            return;
        }
        Integer[] buttons = this.getClipboardButtons();
        if (buttons == null) {
            return;
        }
        this.cancelAllTasks();
        this.historyTableModel.pasteButtons(rowIndex, buttons, merge);
        this.selectIntervals(rowIndex, buttons);
        this.runToLastClickedRow(rowIndex);
    }

    private void insertRows(int rowIndex, int rowCount) {
        if (this.isBusy() || rowCount == 0) {
            return;
        }
        if (rowIndex < 0) {
            rowIndex = this.historyTable.getRowCount();
        }
        this.cancelAllTasks();
        this.historyTableModel.insertButtons(rowIndex, rowCount);
        int lastRowIndex = rowIndex + rowCount - 1;
        this.historyTable.getSelectionModel().setSelectionInterval(rowIndex, lastRowIndex);
        EventQueue.invokeLater(() -> GuiUtil.scrollToVisible(this.historyTable, lastRowIndex));
        this.runToLastClickedRow(rowIndex);
    }

    private void insertRows() {
        this.insertRows(this.historyTable.getSelectedRow());
    }

    private void insertRows(int rowIndex) {
        Integer[] buttons;
        if (this.isBusy()) {
            return;
        }
        if (rowIndex < 0) {
            rowIndex = this.historyTable.getRowCount();
        }
        if ((buttons = this.getClipboardButtons()) == null) {
            return;
        }
        this.cancelAllTasks();
        this.historyTableModel.insertButtons(rowIndex, CollectionsUtil.toIntArray(buttons));
        this.selectIntervals(rowIndex, buttons);
        int lastRowIndex = rowIndex + buttons.length - 1;
        EventQueue.invokeLater(() -> GuiUtil.scrollToVisible(this.historyTable, lastRowIndex));
        this.runToLastClickedRow(rowIndex);
    }

    private void selectInterval(int rowIndex, int length) {
        ListSelectionModel selectionModel = this.historyTable.getSelectionModel();
        selectionModel.clearSelection();
        if (length > 0) {
            selectionModel.addSelectionInterval(rowIndex, rowIndex + length - 1);
        }
    }

    private void selectIntervals(int rowIndex, Integer[] buttons) {
        ListSelectionModel selectionModel = this.historyTable.getSelectionModel();
        selectionModel.clearSelection();
        int startIndex = -1;
        for (int i = 0; i <= buttons.length; ++i) {
            if (i == buttons.length || buttons[i] == null) {
                if (startIndex < 0) continue;
                selectionModel.addSelectionInterval(rowIndex + startIndex, rowIndex + i - 1);
                startIndex = -1;
                continue;
            }
            if (startIndex >= 0) continue;
            startIndex = i;
        }
    }

    private void deleteSelectedRows() {
        if (this.isBusy()) {
            return;
        }
        int rowIndex = this.historyTable.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        this.cancelAllTasks();
        DeleteChange deleteChange = this.historyTableModel.deleteButtons(this.historyTable.getSelectedRows());
        this.historyTable.clearSelection();
        if (deleteChange == null) {
            this.runToLastClickedRow(rowIndex);
        } else {
            this.resetProgressBar(deleteChange.getRowIndex(), deleteChange.getRowCount() - 1);
            int tailIndex = this.historyTableModel.getTailIndex();
            this.historyTableModel.setHeadIndex(-1);
            this.historyTableModel.setTailIndex(-1);
            this.taskScheduler.add(new TrimTopTask(this.movie, tailIndex, deleteChange.getRowCount() - 1, this.historyTableModel, this));
        }
    }

    private void trimTop() {
        if (this.isBusy()) {
            return;
        }
        int endFrameIndex = this.historyTable.getSelectedRow();
        if (endFrameIndex < 0) {
            return;
        }
        this.cancelAllTasks();
        this.historyTable.clearSelection();
        TrimTopTask task = new TrimTopTask(this.movie, this.historyTableModel.getTailIndex(), endFrameIndex, this.historyTableModel, this);
        this.resetProgressBar(task.getFrameIndex(), endFrameIndex);
        this.historyTableModel.setHeadIndex(-1);
        this.historyTableModel.setTailIndex(-1);
        this.taskScheduler.add(task);
    }

    private void trimBottom() {
        if (this.isBusy()) {
            return;
        }
        int rowIndex = this.historyTable.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        this.cancelAllTasks();
        this.historyTableModel.trimBottom(rowIndex);
        this.historyTable.clearSelection();
        this.runToLastClickedRow(rowIndex);
    }

    private void insertFrames(boolean insert) {
        block2: {
            int rowCount;
            if (this.isBusy()) {
                return;
            }
            while (true) {
                InputDialog dialog = new InputDialog((Window)this, "Enter the number of frames to " + (insert ? "insert" : "append") + ".", (insert ? "Insert" : "Append") + " Frames");
                dialog.setVisible(true);
                if (!dialog.isOk()) break block2;
                rowCount = StringUtil.parseInt(dialog.getInput());
                if (rowCount > 0) break;
                GuiUtil.displayError(this, "The number of frames entered is invalid.");
            }
            this.insertRows(insert ? this.historyTable.getSelectedRow() : -1, rowCount);
        }
    }

    private void insertClone(boolean insert) {
        if (this.isBusy()) {
            return;
        }
        int[] rows = this.historyTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        Arrays.sort(rows);
        int minRow = rows[0];
        int maxRow = rows[rows.length - 1];
        Integer[] buttons = new Integer[maxRow - minRow + 1];
        int r = 0;
        for (int i = minRow; i <= maxRow; ++i) {
            if (i != rows[r]) continue;
            buttons[i - minRow] = this.historyTableModel.getButtons(i);
            ++r;
        }
        this.cancelAllTasks();
        int rowIndex = insert ? minRow : this.historyTableModel.getRowCount();
        this.historyTableModel.insertButtons(rowIndex, CollectionsUtil.toIntArray(buttons));
        this.selectIntervals(rowIndex, buttons);
        int lastRowIndex = rowIndex + buttons.length - 1;
        EventQueue.invokeLater(() -> GuiUtil.scrollToVisible(this.historyTable, lastRowIndex));
        this.runToLastClickedRow(rowIndex);
    }

    private void undo(int undos) {
        if (this.isBusy() || undos < 1) {
            return;
        }
        this.cancelAllTasks();
        int rowIndex = Integer.MAX_VALUE;
        for (int i = 0; i < undos; ++i) {
            int row = this.historyTableModel.undo();
            if (row < 0 || row >= rowIndex) continue;
            rowIndex = row;
        }
        if (rowIndex >= 0) {
            this.historyTable.clearSelection();
            this.runToLastClickedRow(rowIndex);
        }
    }

    private void redo(int redos) {
        if (this.isBusy() || redos < 1) {
            return;
        }
        this.cancelAllTasks();
        int rowIndex = Integer.MAX_VALUE;
        for (int i = 0; i < redos; ++i) {
            int row = this.historyTableModel.redo();
            if (row < 0 || row >= rowIndex) continue;
            rowIndex = row;
        }
        if (rowIndex >= 0) {
            this.historyTable.clearSelection();
            this.runToLastClickedRow(rowIndex);
        }
    }

    private void changeListUpdated() {
        this.enableChangeButtons();
        int changesIndex = this.changeListModel.getChangesIndex();
        GuiUtil.scrollToVisible(this.changesList, changesIndex - 1);
    }

    private void goToSelectedBookmark() {
        if (this.isBusy()) {
            return;
        }
        int index = this.bookmarksList.getSelectedIndex();
        if (index >= 0 && index < this.bookmarksModel.getSize()) {
            this.goToBookmark(this.bookmarksModel.getElementAt(index));
        }
    }

    private void selectBookmark(int index) {
        this.bookmarksList.getSelectionModel().setSelectionInterval(index, index);
    }

    private void goToBookmark(HistoryBookmark bookmark) {
        if (this.isBusy() || bookmark == null) {
            return;
        }
        int rowIndex = bookmark.getFrame();
        if (rowIndex >= 0 && rowIndex < this.historyTableModel.getRowCount()) {
            GuiUtil.scrollToCenter(this.historyTable, rowIndex);
            this.moveHeadToRow(rowIndex);
        }
    }

    private void goToNextBookmark() {
        if (this.isBusy() || this.bookmarksModel.isEmpty()) {
            return;
        }
        int size = this.bookmarksModel.getSize();
        if (size == 1) {
            this.selectBookmark(0);
            return;
        }
        int headIndex = this.historyTableModel.getHeadIndex();
        int minFrame = Integer.MAX_VALUE;
        int minIndex = Integer.MIN_VALUE;
        int nextIndex = Integer.MIN_VALUE;
        int distance = Integer.MAX_VALUE;
        for (int i = size - 1; i >= 0; --i) {
            HistoryBookmark bookmark = this.bookmarksModel.getElementAt(i);
            int frame = bookmark.getFrame();
            if (frame < minFrame) {
                minIndex = i;
                minFrame = frame;
            }
            if (frame <= headIndex || frame - headIndex >= distance) continue;
            nextIndex = i;
            distance = frame - headIndex;
        }
        if (nextIndex >= 0) {
            this.selectBookmark(nextIndex);
        } else if (minIndex >= 0) {
            this.selectBookmark(minIndex);
        }
    }

    private void goToPreviousBookmark() {
        if (this.isBusy() || this.bookmarksModel.isEmpty()) {
            return;
        }
        int size = this.bookmarksModel.getSize();
        if (size == 1) {
            this.selectBookmark(0);
            return;
        }
        int headIndex = this.historyTableModel.getHeadIndex();
        int maxFrame = Integer.MIN_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        int previousIndex = Integer.MIN_VALUE;
        int distance = Integer.MAX_VALUE;
        for (int i = size - 1; i >= 0; --i) {
            HistoryBookmark bookmark = this.bookmarksModel.getElementAt(i);
            int frame = bookmark.getFrame();
            if (frame > maxFrame) {
                maxIndex = i;
                maxFrame = frame;
            }
            if (frame >= headIndex || headIndex - frame >= distance) continue;
            previousIndex = i;
            distance = headIndex - frame;
        }
        if (previousIndex >= 0) {
            this.selectBookmark(previousIndex);
        } else if (maxIndex >= 0) {
            this.selectBookmark(maxIndex);
        }
    }

    private void recordOptionsChanged() {
        if (this.isBusy() && this.recordTask != null && !this.recordTask.isCanceled()) {
            this.recordTask.setRecordOptions(this.getRecordPlayers(), this.recordOtherCheckBox.isSelected(), this.mergeButtonsCheckBox.isSelected());
        }
    }

    private void clearChanges() {
        this.historyTableModel.clearChanges();
    }

    private void setProjectName(String projectName) {
        if (!StringUtil.isBlank(projectName)) {
            this.projectName = projectName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHistoryProjectFile(PleaseWaitDialog pleaseWaitDialog, File file, HistoryProject project, boolean quickSave, Runnable runnable) {
        boolean failed = false;
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            out.writeObject(project);
        }
        catch (Throwable t) {
            failed = true;
        }
        finally {
            boolean showError = failed;
            pleaseWaitDialog.dispose();
            EventQueue.invokeLater(() -> {
                this.priorSaveFile = file;
                this.setDisking(false);
                if (showError) {
                    GuiUtil.displayError(this, "Failed to save history file.");
                } else {
                    if (!quickSave) {
                        AppPrefs.getInstance().getPaths().addRecentHistoryProject(file.getPath());
                        AppPrefs.save();
                    }
                    this.createRecentProjectsMenu();
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHistoryProjectFile(PleaseWaitDialog pleaseWaitDialog, File file, String entryFileName, boolean quickLoad) {
        HistoryProject p;
        boolean showError;
        boolean failed = false;
        HistoryProject project = null;
        try {
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
                project = (HistoryProject)in.readObject();
            }
            showError = failed;
            p = project;
            pleaseWaitDialog.dispose();
        }
        catch (Throwable t) {
            HistoryProject p2;
            boolean showError2;
            try {
                showError2 = failed = true;
                p2 = project;
                pleaseWaitDialog.dispose();
            }
            catch (Throwable throwable) {
                boolean showError3 = failed;
                HistoryProject p3 = project;
                pleaseWaitDialog.dispose();
                EventQueue.invokeLater(() -> {
                    this.priorSaveFile = file;
                    this.setDisking(false);
                    if (showError3) {
                        GuiUtil.displayError(this, "Failed to load history file.");
                    } else {
                        this.createRecentProjectsMenu();
                        this.restoreHistoryProject(p3, entryFileName, FileUtil.removeExtension(file.getName()), file, quickLoad);
                    }
                });
                throw throwable;
            }
            EventQueue.invokeLater(() -> {
                this.priorSaveFile = file;
                this.setDisking(false);
                if (showError3) {
                    GuiUtil.displayError(this, "Failed to load history file.");
                } else {
                    this.createRecentProjectsMenu();
                    this.restoreHistoryProject(p3, entryFileName, FileUtil.removeExtension(file.getName()), file, quickLoad);
                }
            });
        }
        EventQueue.invokeLater(() -> {
            this.priorSaveFile = file;
            this.setDisking(false);
            if (showError3) {
                GuiUtil.displayError(this, "Failed to load history file.");
            } else {
                this.createRecentProjectsMenu();
                this.restoreHistoryProject(p3, entryFileName, FileUtil.removeExtension(file.getName()), file, quickLoad);
            }
        });
    }

    private void quickLoadProject(int index) {
        this.saveSlotsComboBox.setSelectedIndex(index);
        this.quickLoadProject(this.quickSaveStateInfos.get(index).getFile(), App.getEntryFileName(), true);
    }

    private void quickLoadProject(File file, String entryFileName, boolean quickLoad) {
        if (this.isBusy()) {
            return;
        }
        this.cancelAllTasks();
        this.resetProgressBar();
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        pleaseWaitDialog.setMessage("Loading history file...");
        this.setDisking(true);
        new Thread(() -> this.loadHistoryProjectFile(pleaseWaitDialog, file, entryFileName, quickLoad)).start();
        pleaseWaitDialog.showAfterDelay();
    }

    private void quickSaveProject(int index) {
        if (this.isBusy()) {
            return;
        }
        this.saveSlotsComboBox.setSelectedIndex(index);
        QuickSaveStateInfo info = this.quickSaveStateInfos.get(index);
        this.save(info.getFile(), true, () -> {
            Date date = new Date();
            String name = FileUtil.getFileTimestamp(info.getSlot(), date);
            JMenuItem quickLoadMenuItem = info.getLoadMenuItem();
            JMenuItem quickSaveMenuItem = info.getSaveMenuItem();
            quickLoadMenuItem.setEnabled(true);
            quickLoadMenuItem.setText(name);
            quickSaveMenuItem.setText(name);
            this.quickSaveStateInfos.set(index, new QuickSaveStateInfo(info.getSlot(), info.getFile(), date.getTime(), quickLoadMenuItem, quickSaveMenuItem));
            this.findNewestAndOldestSaveSlots();
        });
    }

    private void restoreHistoryProject(HistoryProject project, String entryFileName, String loadedProjectName, File file, boolean quickLoad) {
        CartFile cartFile = App.getCartFile();
        if (cartFile != null && cartFile.getFileCRC() != project.getEntryFileCRC() || cartFile == null && project.getEntryFileCRC() != 0 || !entryFileName.equalsIgnoreCase(project.getEntryFileName())) {
            YesNoDialog dialog = new YesNoDialog((Window)this, String.format("History game file: <pre>%s</pre><br/>Current game file: <pre>%s</pre><br/>Load history anyway?", project.getEntryFileName(), entryFileName), "Game File Mismatch");
            dialog.setVisible(true);
            if (!dialog.isYes()) {
                return;
            }
        }
        if (!quickLoad) {
            AppPrefs.getInstance().getPaths().addRecentHistoryProject(file.getPath());
            AppPrefs.save();
        }
        this.setProjectName(loadedProjectName);
        this.createQuickMenus();
        this.createRecentProjectsMenu();
        this.applyHistoryProject(project);
    }

    private void setDisking(boolean disking) {
        this.disking = disking;
        this.enableComponents();
    }

    public void saveAs() {
        if (this.isBusy()) {
            return;
        }
        Paths paths = AppPrefs.getInstance().getPaths();
        String fileName = this.projectName + ".history";
        String historiesDir = paths.getHistoriesDir();
        FileUtil.mkdir(historiesDir);
        File file = GuiUtil.showSaveAsDialog(this, historiesDir, fileName, "history", historyFileExtensionFilter, true, "Save History File");
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setHistoriesDir(dir);
            AppPrefs.save();
            String newProjectName = FileUtil.removeExtension(file.getName());
            this.setProjectName(newProjectName);
            this.renameQuickSaveFiles(newProjectName);
            this.save(file);
        }
    }

    private void save(File file) {
        this.save(file, false, null);
    }

    private void save(File file, boolean quickSave, Runnable runnable) {
        if (file == null) {
            return;
        }
        HistoryProject project = this.createHistoryProject();
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        pleaseWaitDialog.setMessage("Saving history file...");
        this.setDisking(true);
        new Thread(() -> this.saveHistoryProjectFile(pleaseWaitDialog, file, project, quickSave, runnable)).start();
        pleaseWaitDialog.showAfterDelay();
    }

    public void load() {
        this.load(null);
    }

    private void load(String directory) {
        if (this.isBusy()) {
            return;
        }
        String entryFileName = App.getEntryFileName();
        if (StringUtil.isBlank(entryFileName)) {
            return;
        }
        Paths paths = AppPrefs.getInstance().getPaths();
        String historiesDir = paths.getHistoriesDir();
        FileUtil.mkdir(historiesDir);
        JFileChooser chooser = GuiUtil.createFileChooser("Load History File", directory != null ? directory : paths.getHistoriesDir(), historyFileExtensionFilter);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setHistoriesDir((String)d)) == 0) {
            this.quickLoadProject(chooser.getSelectedFile(), entryFileName, false);
        }
    }

    private void selectBetweenBookmarks() {
        if (this.isBusy()) {
            return;
        }
        if (this.bookmarksModel.isEmpty()) {
            this.historyTable.selectAll();
            return;
        }
        int selectedRowIndex = this.historyTable.getSelectedRow();
        if (!(selectedRowIndex >= 0 && selectedRowIndex < this.historyTableModel.getRowCount() || (selectedRowIndex = this.historyTableModel.getHeadIndex()) >= 0 && selectedRowIndex < this.historyTableModel.getRowCount())) {
            return;
        }
        int aboveIndex = -1;
        int belowIndex = -1;
        int aboveDistance = Integer.MAX_VALUE;
        int belowDistance = Integer.MAX_VALUE;
        int size = this.bookmarksModel.getSize();
        for (int i = size - 1; i >= -2; --i) {
            int rowIndex;
            switch (i) {
                case -1: {
                    rowIndex = this.historyTableModel.getRowCount();
                    break;
                }
                case -2: {
                    rowIndex = 0;
                    break;
                }
                default: {
                    rowIndex = this.bookmarksModel.getElementAt(i).getFrame();
                }
            }
            int distance = selectedRowIndex - rowIndex;
            if (distance >= 0 && distance < aboveDistance) {
                aboveDistance = distance;
                aboveIndex = rowIndex;
            }
            if (distance >= 0 || -distance >= belowDistance) continue;
            belowDistance = -distance;
            belowIndex = rowIndex;
        }
        this.historyTable.getSelectionModel().setSelectionInterval(aboveIndex, belowIndex - 1);
    }

    private void initComponents() {
        this.historyScrollPane = new JScrollPane();
        this.historyTable = new JTable();
        this.viewPanel = new JPanel();
        this.view1PCheckBox = new JCheckBox();
        this.view2PCheckBox = new JCheckBox();
        this.view3PCheckBox = new JCheckBox();
        this.view4PCheckBox = new JCheckBox();
        this.headButton = new JButton();
        this.recordPanel = new JPanel();
        this.record1PCheckBox = new JCheckBox();
        this.record2PCheckBox = new JCheckBox();
        this.record3PCheckBox = new JCheckBox();
        this.record4PCheckBox = new JCheckBox();
        this.mergeButtonsCheckBox = new JCheckBox();
        this.recordOtherCheckBox = new JCheckBox();
        this.runPanel = new JPanel();
        this.nextFrameButton = new JButton();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.pauseToggleButton = new JToggleButton();
        this.previousFrameButton = new JButton();
        this.trackCursorCheckBox = new JCheckBox();
        this.fastGenerationCheckBox = new JCheckBox();
        this.restorePositionCheckBox = new JCheckBox();
        this.statesPanel = new JPanel();
        this.saveSlotsComboBox = new JComboBox();
        this.saveButton = new JButton();
        this.loadButton = new JButton();
        this.bookmarksPanel = new JPanel();
        this.bookmarksScrollPane = new JScrollPane();
        this.bookmarksList = new JList();
        this.addBookmarkButton = new JButton();
        this.editBookmarkButton = new JButton();
        this.deleteBookmarkButton = new JButton();
        this.jPanel1 = new JPanel();
        this.previousBookmarkButton = new JButton();
        this.nextBookmarkButton = new JButton();
        this.seekBookmarkButton = new JButton();
        this.historyPanel = new JPanel();
        this.changesScrollPane = new JScrollPane();
        this.changesList = new JList();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.clearButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.separator8 = new JPopupMenu.Separator();
        this.loadMenuItem = new JMenuItem();
        this.separator7 = new JPopupMenu.Separator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.separator4 = new JPopupMenu.Separator();
        this.quickLoadProjectMenu = new JMenu();
        this.quickLoadSeparator = new JPopupMenu.Separator();
        this.newestSlotMenuItem = new JMenuItem();
        this.quickSaveProjectMenu = new JMenu();
        this.quickSaveSeparator = new JPopupMenu.Separator();
        this.oldestSlotMenuItem = new JMenuItem();
        this.separator1 = new JPopupMenu.Separator();
        this.recentProjectsMenu = new JMenu();
        this.recentProjectsSeparator = new JPopupMenu.Separator();
        this.recentProjectsLockMenuItem = new JCheckBoxMenuItem();
        this.recentProjectsClearMenuItem = new JMenuItem();
        this.recentDirectoriesMenu = new JMenu();
        this.recentDirectoriesSeparator = new JPopupMenu.Separator();
        this.recentDirectoriesLockMenuItem = new JCheckBoxMenuItem();
        this.recentDirectoriesClearMenuItem = new JMenuItem();
        this.separator9 = new JPopupMenu.Separator();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.separator2 = new JPopupMenu.Separator();
        this.deselectMenuItem = new JMenuItem();
        this.selectAllMenuItem = new JMenuItem();
        this.selectBetweenBookmarksMenuItem = new JMenuItem();
        this.separator3 = new JPopupMenu.Separator();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.mergeMenuItem = new JMenuItem();
        this.separator = new JPopupMenu.Separator();
        this.insertPasteMenuItem = new JMenuItem();
        this.insertFrameMenuItem = new JMenuItem();
        this.insertFramesMenuItem = new JMenuItem();
        this.insertCloneMenuItem = new JMenuItem();
        this.separator5 = new JPopupMenu.Separator();
        this.appendPasteMenuItem = new JMenuItem();
        this.appendFrameMenuItem = new JMenuItem();
        this.appendFramesMenuItem = new JMenuItem();
        this.appendCloneMenuItem = new JMenuItem();
        this.separator6 = new JPopupMenu.Separator();
        this.clearMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.trimTopMenuItem = new JMenuItem();
        this.trimBottomMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("History Editor");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HistoryEditorFrame.this.formWindowClosing(evt);
            }
        });
        this.historyScrollPane.setMaximumSize(null);
        this.historyScrollPane.setMinimumSize(null);
        this.historyTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.historyTable.setAutoResizeMode(0);
        this.historyScrollPane.setViewportView(this.historyTable);
        this.viewPanel.setBorder(BorderFactory.createTitledBorder("View"));
        this.view1PCheckBox.setSelected(true);
        this.view1PCheckBox.setText("1P");
        this.view1PCheckBox.setFocusPainted(false);
        this.view1PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.view1PCheckBoxActionPerformed(evt);
            }
        });
        this.view2PCheckBox.setSelected(true);
        this.view2PCheckBox.setText("2P");
        this.view2PCheckBox.setFocusPainted(false);
        this.view2PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.view2PCheckBoxActionPerformed(evt);
            }
        });
        this.view3PCheckBox.setText("3P");
        this.view3PCheckBox.setFocusPainted(false);
        this.view3PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.view3PCheckBoxActionPerformed(evt);
            }
        });
        this.view4PCheckBox.setText("4P");
        this.view4PCheckBox.setFocusPainted(false);
        this.view4PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.view4PCheckBoxActionPerformed(evt);
            }
        });
        this.headButton.setMnemonic('H');
        this.headButton.setText("Head");
        this.headButton.setFocusPainted(false);
        this.headButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.headButtonActionPerformed(evt);
            }
        });
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.view1PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.view2PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.view3PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.view4PCheckBox).addGap(18, 18, 18).addComponent(this.headButton).addContainerGap(95, Short.MAX_VALUE)));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.view1PCheckBox).addComponent(this.view2PCheckBox).addComponent(this.view3PCheckBox).addComponent(this.view4PCheckBox).addComponent(this.headButton)));
        this.recordPanel.setBorder(BorderFactory.createTitledBorder("Record"));
        this.record1PCheckBox.setSelected(true);
        this.record1PCheckBox.setText("1P");
        this.record1PCheckBox.setFocusPainted(false);
        this.record1PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.record1PCheckBoxActionPerformed(evt);
            }
        });
        this.record2PCheckBox.setSelected(true);
        this.record2PCheckBox.setText("2P");
        this.record2PCheckBox.setFocusPainted(false);
        this.record2PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.record2PCheckBoxActionPerformed(evt);
            }
        });
        this.record3PCheckBox.setText("3P");
        this.record3PCheckBox.setFocusPainted(false);
        this.record3PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.record3PCheckBoxActionPerformed(evt);
            }
        });
        this.record4PCheckBox.setText("4P");
        this.record4PCheckBox.setFocusPainted(false);
        this.record4PCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.record4PCheckBoxActionPerformed(evt);
            }
        });
        this.mergeButtonsCheckBox.setText("Merge");
        this.mergeButtonsCheckBox.setFocusPainted(false);
        this.mergeButtonsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.mergeButtonsCheckBoxActionPerformed(evt);
            }
        });
        this.recordOtherCheckBox.setText("Other");
        this.recordOtherCheckBox.setFocusPainted(false);
        this.recordOtherCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.recordOtherCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout recordPanelLayout = new GroupLayout(this.recordPanel);
        this.recordPanel.setLayout(recordPanelLayout);
        recordPanelLayout.setHorizontalGroup(recordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(recordPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.record1PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.record2PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.record3PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.record4PCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recordOtherCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 58, Short.MAX_VALUE).addComponent(this.mergeButtonsCheckBox).addContainerGap()));
        recordPanelLayout.setVerticalGroup(recordPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(recordPanelLayout.createSequentialGroup().addContainerGap().addGroup(recordPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.record1PCheckBox).addComponent(this.record2PCheckBox).addComponent(this.record3PCheckBox).addComponent(this.record4PCheckBox).addComponent(this.mergeButtonsCheckBox).addComponent(this.recordOtherCheckBox)).addContainerGap()));
        this.runPanel.setBorder(BorderFactory.createTitledBorder("Run"));
        this.runPanel.setMaximumSize(null);
        this.nextFrameButton.setText("Frame+1");
        this.nextFrameButton.setFocusPainted(false);
        this.nextFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.nextFrameButtonActionPerformed(evt);
            }
        });
        this.progressBar.setMaximumSize(null);
        this.progressBar.setMinimumSize(null);
        this.progressBar.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.pauseToggleButton.setText("Pause");
        this.pauseToggleButton.setFocusPainted(false);
        this.pauseToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.pauseToggleButtonActionPerformed(evt);
            }
        });
        this.previousFrameButton.setText("Frame-1");
        this.previousFrameButton.setFocusPainted(false);
        this.previousFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.previousFrameButtonActionPerformed(evt);
            }
        });
        this.trackCursorCheckBox.setSelected(true);
        this.trackCursorCheckBox.setText("Track cursor");
        this.trackCursorCheckBox.setFocusPainted(false);
        this.fastGenerationCheckBox.setSelected(true);
        this.fastGenerationCheckBox.setText("Fast generation");
        this.fastGenerationCheckBox.setFocusPainted(false);
        this.fastGenerationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.fastGenerationCheckBoxActionPerformed(evt);
            }
        });
        this.restorePositionCheckBox.setSelected(true);
        this.restorePositionCheckBox.setText("Restore position");
        this.restorePositionCheckBox.setFocusPainted(false);
        GroupLayout runPanelLayout = new GroupLayout(this.runPanel);
        this.runPanel.setLayout(runPanelLayout);
        runPanelLayout.setHorizontalGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runPanelLayout.createSequentialGroup().addContainerGap().addGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runPanelLayout.createSequentialGroup().addComponent(this.previousFrameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pauseToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextFrameButton)).addGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(runPanelLayout.createSequentialGroup().addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(runPanelLayout.createSequentialGroup().addComponent(this.trackCursorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fastGenerationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restorePositionCheckBox)))).addContainerGap(28, Short.MAX_VALUE)));
        runPanelLayout.linkSize(0, this.nextFrameButton, this.pauseToggleButton, this.previousFrameButton);
        runPanelLayout.setVerticalGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runPanelLayout.createSequentialGroup().addContainerGap().addGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previousFrameButton).addComponent(this.pauseToggleButton).addComponent(this.nextFrameButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trackCursorCheckBox).addComponent(this.fastGenerationCheckBox).addComponent(this.restorePositionCheckBox)).addGroup(runPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.progressBar, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, runPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        this.statesPanel.setBorder(BorderFactory.createTitledBorder("Slots"));
        this.saveSlotsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.saveSlotsComboBox.setFocusable(false);
        this.saveSlotsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.saveSlotsComboBoxActionPerformed(evt);
            }
        });
        this.saveButton.setMnemonic('S');
        this.saveButton.setText("Save");
        this.saveButton.setFocusPainted(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.loadButton.setMnemonic('L');
        this.loadButton.setText("Load");
        this.loadButton.setFocusPainted(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.loadButtonActionPerformed(evt);
            }
        });
        GroupLayout statesPanelLayout = new GroupLayout(this.statesPanel);
        this.statesPanel.setLayout(statesPanelLayout);
        statesPanelLayout.setHorizontalGroup(statesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveSlotsComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton).addContainerGap(161, Short.MAX_VALUE)));
        statesPanelLayout.linkSize(0, this.loadButton, this.saveButton);
        statesPanelLayout.setVerticalGroup(statesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statesPanelLayout.createSequentialGroup().addGroup(statesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveSlotsComboBox, -2, -1, -2).addComponent(this.saveButton).addComponent(this.loadButton)).addGap(0, 0, Short.MAX_VALUE)));
        this.bookmarksPanel.setBorder(BorderFactory.createTitledBorder("Bookmarks"));
        this.bookmarksPanel.setMaximumSize(null);
        this.bookmarksScrollPane.setMaximumSize(null);
        this.bookmarksScrollPane.setMinimumSize(null);
        this.bookmarksScrollPane.setPreferredSize(null);
        this.bookmarksList.setPreferredSize(null);
        this.bookmarksList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                HistoryEditorFrame.this.bookmarksListValueChanged(evt);
            }
        });
        this.bookmarksScrollPane.setViewportView(this.bookmarksList);
        this.addBookmarkButton.setMnemonic('A');
        this.addBookmarkButton.setText("Add...");
        this.addBookmarkButton.setFocusPainted(false);
        this.addBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.addBookmarkButtonActionPerformed(evt);
            }
        });
        this.editBookmarkButton.setMnemonic('E');
        this.editBookmarkButton.setText("Edit...");
        this.editBookmarkButton.setToolTipText("");
        this.editBookmarkButton.setFocusPainted(false);
        this.editBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.editBookmarkButtonActionPerformed(evt);
            }
        });
        this.deleteBookmarkButton.setMnemonic('D');
        this.deleteBookmarkButton.setText("Delete");
        this.deleteBookmarkButton.setFocusPainted(false);
        this.deleteBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.deleteBookmarkButtonActionPerformed(evt);
            }
        });
        this.previousBookmarkButton.setMnemonic('P');
        this.previousBookmarkButton.setText("Previous");
        this.previousBookmarkButton.setFocusPainted(false);
        this.previousBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.previousBookmarkButtonActionPerformed(evt);
            }
        });
        this.nextBookmarkButton.setMnemonic('N');
        this.nextBookmarkButton.setText("Next");
        this.nextBookmarkButton.setFocusPainted(false);
        this.nextBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.nextBookmarkButtonActionPerformed(evt);
            }
        });
        this.seekBookmarkButton.setMnemonic('k');
        this.seekBookmarkButton.setText("Seek");
        this.seekBookmarkButton.setFocusPainted(false);
        this.seekBookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.seekBookmarkButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.previousBookmarkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.seekBookmarkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextBookmarkButton).addGap(0, 0, 0)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previousBookmarkButton).addComponent(this.nextBookmarkButton).addComponent(this.seekBookmarkButton)).addGap(0, 0, 0)));
        GroupLayout bookmarksPanelLayout = new GroupLayout(this.bookmarksPanel);
        this.bookmarksPanel.setLayout(bookmarksPanelLayout);
        bookmarksPanelLayout.setHorizontalGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bookmarksPanelLayout.createSequentialGroup().addContainerGap().addGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bookmarksPanelLayout.createSequentialGroup().addComponent(this.bookmarksScrollPane, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addBookmarkButton).addComponent(this.editBookmarkButton).addComponent(this.deleteBookmarkButton))).addGroup(bookmarksPanelLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        bookmarksPanelLayout.linkSize(0, this.addBookmarkButton, this.deleteBookmarkButton, this.editBookmarkButton);
        bookmarksPanelLayout.setVerticalGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bookmarksPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bookmarksPanelLayout.createSequentialGroup().addComponent(this.addBookmarkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editBookmarkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteBookmarkButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(bookmarksPanelLayout.createSequentialGroup().addComponent(this.bookmarksScrollPane, -1, -1, Short.MAX_VALUE).addGap(6, 6, 6))).addContainerGap()));
        this.historyPanel.setBorder(BorderFactory.createTitledBorder("History"));
        this.changesScrollPane.setPreferredSize(null);
        this.changesList.setSelectionMode(0);
        this.changesList.setPreferredSize(null);
        this.changesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HistoryEditorFrame.this.changesListMousePressed(evt);
            }
        });
        this.changesScrollPane.setViewportView(this.changesList);
        this.undoButton.setMnemonic('U');
        this.undoButton.setText("Undo");
        this.undoButton.setFocusPainted(false);
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.undoButtonActionPerformed(evt);
            }
        });
        this.redoButton.setMnemonic('R');
        this.redoButton.setText("Redo");
        this.redoButton.setFocusPainted(false);
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.redoButtonActionPerformed(evt);
            }
        });
        this.clearButton.setMnemonic('r');
        this.clearButton.setText("Clear");
        this.clearButton.setFocusPainted(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout historyPanelLayout = new GroupLayout(this.historyPanel);
        this.historyPanel.setLayout(historyPanelLayout);
        historyPanelLayout.setHorizontalGroup(historyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(historyPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.changesScrollPane, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.undoButton).addComponent(this.redoButton).addComponent(this.clearButton)).addContainerGap()));
        historyPanelLayout.linkSize(0, this.clearButton, this.redoButton, this.undoButton);
        historyPanelLayout.setVerticalGroup(historyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(historyPanelLayout.createSequentialGroup().addContainerGap().addGroup(historyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(historyPanelLayout.createSequentialGroup().addComponent(this.undoButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.redoButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearButton)).addComponent(this.changesScrollPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                HistoryEditorFrame.this.fileMenuMenuSelected(evt);
            }
        });
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.setMnemonic('N');
        this.newMenuItem.setText("New Project");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.fileMenu.add(this.separator8);
        this.loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.loadMenuItem.setMnemonic('L');
        this.loadMenuItem.setText("Load Project...");
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.loadMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.fileMenu.add(this.separator7);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save Project");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setMnemonic('A');
        this.saveAsMenuItem.setText("Save Project As...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.separator4);
        this.quickLoadProjectMenu.setMnemonic('o');
        this.quickLoadProjectMenu.setText("Quick Load Project");
        this.quickLoadProjectMenu.add(this.quickLoadSeparator);
        this.newestSlotMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 0));
        this.newestSlotMenuItem.setMnemonic('N');
        this.newestSlotMenuItem.setText("Newest Slot");
        this.quickLoadProjectMenu.add(this.newestSlotMenuItem);
        this.fileMenu.add(this.quickLoadProjectMenu);
        this.quickSaveProjectMenu.setMnemonic('v');
        this.quickSaveProjectMenu.setText("Quick Save Project");
        this.quickSaveProjectMenu.add(this.quickSaveSeparator);
        this.oldestSlotMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 1));
        this.oldestSlotMenuItem.setMnemonic('O');
        this.oldestSlotMenuItem.setText("Oldest Slot");
        this.quickSaveProjectMenu.add(this.oldestSlotMenuItem);
        this.fileMenu.add(this.quickSaveProjectMenu);
        this.fileMenu.add(this.separator1);
        this.recentProjectsMenu.setMnemonic('P');
        this.recentProjectsMenu.setText("Recent Projects");
        this.recentProjectsMenu.add(this.recentProjectsSeparator);
        this.recentProjectsLockMenuItem.setMnemonic('L');
        this.recentProjectsLockMenuItem.setText("Lock");
        this.recentProjectsLockMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.recentProjectsLockMenuItemActionPerformed(evt);
            }
        });
        this.recentProjectsMenu.add(this.recentProjectsLockMenuItem);
        this.recentProjectsClearMenuItem.setMnemonic('C');
        this.recentProjectsClearMenuItem.setText("Clear");
        this.recentProjectsClearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.recentProjectsClearMenuItemActionPerformed(evt);
            }
        });
        this.recentProjectsMenu.add(this.recentProjectsClearMenuItem);
        this.fileMenu.add(this.recentProjectsMenu);
        this.recentDirectoriesMenu.setMnemonic('D');
        this.recentDirectoriesMenu.setText("Recent Directories");
        this.recentDirectoriesMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                HistoryEditorFrame.this.recentDirectoriesMenuMenuSelected(evt);
            }
        });
        this.recentDirectoriesMenu.add(this.recentDirectoriesSeparator);
        this.recentDirectoriesLockMenuItem.setMnemonic('L');
        this.recentDirectoriesLockMenuItem.setText("Lock");
        this.recentDirectoriesLockMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.recentDirectoriesLockMenuItemActionPerformed(evt);
            }
        });
        this.recentDirectoriesMenu.add(this.recentDirectoriesLockMenuItem);
        this.recentDirectoriesClearMenuItem.setMnemonic('C');
        this.recentDirectoriesClearMenuItem.setText("Clear");
        this.recentDirectoriesClearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.recentDirectoriesClearMenuItemActionPerformed(evt);
            }
        });
        this.recentDirectoriesMenu.add(this.recentDirectoriesClearMenuItem);
        this.fileMenu.add(this.recentDirectoriesMenu);
        this.fileMenu.add(this.separator9);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.closeMenuItem.setMnemonic('C');
        this.closeMenuItem.setText("Close");
        this.fileMenu.add(this.closeMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                HistoryEditorFrame.this.editMenuMenuSelected(evt);
            }
        });
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.setMnemonic('U');
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.setMnemonic('R');
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.redoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.add(this.separator2);
        this.deselectMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.deselectMenuItem.setMnemonic('D');
        this.deselectMenuItem.setText("Deselect");
        this.deselectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.deselectMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deselectMenuItem);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllMenuItem.setMnemonic('A');
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.selectBetweenBookmarksMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.selectBetweenBookmarksMenuItem.setText("Select Between Bookmarks");
        this.selectBetweenBookmarksMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.selectBetweenBookmarksMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.selectBetweenBookmarksMenuItem);
        this.editMenu.add(this.separator3);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setMnemonic('t');
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setMnemonic('y');
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setMnemonic('P');
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.mergeMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.mergeMenuItem.setMnemonic('M');
        this.mergeMenuItem.setText("Merge");
        this.mergeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.mergeMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.mergeMenuItem);
        this.editMenu.add(this.separator);
        this.insertPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 3));
        this.insertPasteMenuItem.setMnemonic('I');
        this.insertPasteMenuItem.setText("Insert Paste");
        this.insertPasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.insertPasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.insertPasteMenuItem);
        this.insertFrameMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 3));
        this.insertFrameMenuItem.setMnemonic('F');
        this.insertFrameMenuItem.setText("Insert Frame");
        this.insertFrameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.insertFrameMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.insertFrameMenuItem);
        this.insertFramesMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        this.insertFramesMenuItem.setMnemonic('n');
        this.insertFramesMenuItem.setText("Insert Frames...");
        this.insertFramesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.insertFramesMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.insertFramesMenuItem);
        this.insertCloneMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 2));
        this.insertCloneMenuItem.setMnemonic('C');
        this.insertCloneMenuItem.setText("Insert Clone");
        this.insertCloneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.insertCloneMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.insertCloneMenuItem);
        this.editMenu.add(this.separator5);
        this.appendPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.appendPasteMenuItem.setText("Append Paste");
        this.appendPasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.appendPasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.appendPasteMenuItem);
        this.appendFrameMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.appendFrameMenuItem.setText("Append Frame");
        this.appendFrameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.appendFrameMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.appendFrameMenuItem);
        this.appendFramesMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.appendFramesMenuItem.setText("Append Frames...");
        this.appendFramesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.appendFramesMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.appendFramesMenuItem);
        this.appendCloneMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.appendCloneMenuItem.setText("Append Clone");
        this.appendCloneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.appendCloneMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.appendCloneMenuItem);
        this.editMenu.add(this.separator6);
        this.clearMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.clearMenuItem.setMnemonic('l');
        this.clearMenuItem.setText("Clear");
        this.clearMenuItem.setToolTipText("");
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.clearMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.clearMenuItem);
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        this.deleteMenuItem.setMnemonic('e');
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.trimTopMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 3));
        this.trimTopMenuItem.setMnemonic('o');
        this.trimTopMenuItem.setText("Trim Top");
        this.trimTopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.trimTopMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.trimTopMenuItem);
        this.trimBottomMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 3));
        this.trimBottomMenuItem.setMnemonic('B');
        this.trimBottomMenuItem.setText("Trim Bottom");
        this.trimBottomMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryEditorFrame.this.trimBottomMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.trimBottomMenuItem);
        this.menuBar.add(this.editMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.historyScrollPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.recordPanel, -1, -1, -2).addComponent(this.historyPanel, -1, -1, -2).addComponent(this.runPanel, -1, -1, -2).addComponent(this.viewPanel, -2, -1, -2).addComponent(this.statesPanel, -1, -1, -2).addComponent(this.bookmarksPanel, -2, -1, -2)).addContainerGap()));
        layout.linkSize(0, this.bookmarksPanel, this.historyPanel, this.recordPanel, this.runPanel, this.statesPanel, this.viewPanel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.runPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recordPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bookmarksPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.historyPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.historyScrollPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelAllTasks();
        this.taskScheduler.add(new DisposeTask(this.movie, this.historyTableModel.getTailIndex(), this.historyTableModel.getHeadIndex(), this.historyTableModel, this));
    }

    private void view1PCheckBoxActionPerformed(ActionEvent evt) {
        this.updateViewPlayers();
    }

    private void view2PCheckBoxActionPerformed(ActionEvent evt) {
        this.updateViewPlayers();
    }

    private void view3PCheckBoxActionPerformed(ActionEvent evt) {
        this.updateViewPlayers();
    }

    private void view4PCheckBoxActionPerformed(ActionEvent evt) {
        this.updateViewPlayers();
    }

    private void pauseToggleButtonActionPerformed(ActionEvent evt) {
        this.toggleRecording();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelAllTasks();
    }

    private void previousFrameButtonActionPerformed(ActionEvent evt) {
        this.modifyHeadIndex(-1);
    }

    private void nextFrameButtonActionPerformed(ActionEvent evt) {
        this.modifyHeadIndex(1);
    }

    private void headButtonActionPerformed(ActionEvent evt) {
        GuiUtil.scrollToCenter(this.historyTable, this.historyTableModel.getHeadIndex());
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        this.copySelectedRows();
        this.clearSelectedRows();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.copySelectedRows();
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        this.pasteRows(false);
    }

    private void editMenuMenuSelected(MenuEvent evt) {
        this.enableEditMenuItems();
    }

    private void mergeMenuItemActionPerformed(ActionEvent evt) {
        this.pasteRows(true);
    }

    private void clearMenuItemActionPerformed(ActionEvent evt) {
        this.clearSelectedRows();
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        this.historyTable.selectAll();
    }

    private void deselectMenuItemActionPerformed(ActionEvent evt) {
        this.historyTable.clearSelection();
    }

    private void insertPasteMenuItemActionPerformed(ActionEvent evt) {
        this.insertRows();
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        this.deleteSelectedRows();
    }

    private void trimBottomMenuItemActionPerformed(ActionEvent evt) {
        this.trimBottom();
    }

    private void insertFrameMenuItemActionPerformed(ActionEvent evt) {
        this.insertRows(this.historyTable.getSelectedRow(), 1);
    }

    private void insertFramesMenuItemActionPerformed(ActionEvent evt) {
        this.insertFrames(true);
    }

    private void appendPasteMenuItemActionPerformed(ActionEvent evt) {
        this.insertRows(-1);
    }

    private void appendFrameMenuItemActionPerformed(ActionEvent evt) {
        this.insertRows(-1, 1);
    }

    private void appendFramesMenuItemActionPerformed(ActionEvent evt) {
        this.insertFrames(false);
    }

    private void insertCloneMenuItemActionPerformed(ActionEvent evt) {
        this.insertClone(true);
    }

    private void appendCloneMenuItemActionPerformed(ActionEvent evt) {
        this.insertClone(false);
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        this.undo(1);
    }

    private void redoMenuItemActionPerformed(ActionEvent evt) {
        this.redo(1);
    }

    private void changesListMousePressed(MouseEvent evt) {
        int delta = this.changesList.locationToIndex(evt.getPoint()) + 1 - this.changeListModel.getChangesIndex();
        if (delta > 0) {
            this.redo(delta);
        } else if (delta < 0) {
            this.undo(-delta);
        }
    }

    private void undoButtonActionPerformed(ActionEvent evt) {
        this.undo(1);
    }

    private void redoButtonActionPerformed(ActionEvent evt) {
        this.redo(1);
    }

    private void addBookmarkButtonActionPerformed(ActionEvent evt) {
        HistoryBookmark bookmark;
        HistoryBookmarkEditor dialog = new HistoryBookmarkEditor((Window)this, this.historyTableModel);
        dialog.setMode(false);
        int frame = this.historyTable.getSelectedRow();
        if (frame >= 0) {
            bookmark = this.bookmarksModel.findBookmark(frame);
            if (bookmark == null) {
                dialog.setHistoryBookmark("", frame);
            } else {
                dialog.setMode(true);
                dialog.setHistoryBookmark(bookmark);
            }
        }
        dialog.setVisible(true);
        if (dialog.isOk()) {
            bookmark = dialog.getBookmark();
            int index = this.bookmarksModel.indexOf(bookmark);
            if (index >= 0) {
                this.historyTableModel.addChange(new BookmarkEditedChange(this.bookmarksModel.getElementAt(index), bookmark));
            } else {
                this.historyTableModel.addChange(new BookmarkAddedChange(bookmark));
            }
            GuiUtil.scrollToVisible(this.bookmarksList, this.bookmarksModel.indexOf(bookmark));
        }
    }

    private void editBookmarkButtonActionPerformed(ActionEvent evt) {
        int index = this.bookmarksList.getSelectedIndex();
        if (index >= 0 && index < this.bookmarksModel.getSize()) {
            HistoryBookmarkEditor dialog = new HistoryBookmarkEditor((Window)this, this.historyTableModel);
            dialog.setMode(true);
            HistoryBookmark priorBookmark = this.bookmarksModel.getElementAt(index);
            dialog.setHistoryBookmark(priorBookmark);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                HistoryBookmark newBookmark = dialog.getBookmark();
                this.historyTableModel.addChange(new BookmarkEditedChange(priorBookmark, newBookmark));
                GuiUtil.scrollToVisible(this.bookmarksList, this.bookmarksModel.indexOf(newBookmark));
            }
        }
    }

    private void deleteBookmarkButtonActionPerformed(ActionEvent evt) {
        int index = this.bookmarksList.getSelectedIndex();
        if (index >= 0 && index < this.bookmarksModel.getSize()) {
            this.bookmarksList.clearSelection();
            this.historyTableModel.addChange(new BookmarkDeletedChange(this.bookmarksModel.getElementAt(index)));
        }
    }

    private void bookmarksListValueChanged(ListSelectionEvent evt) {
        this.enableBookmarkButtons();
        this.goToSelectedBookmark();
    }

    private void seekBookmarkButtonActionPerformed(ActionEvent evt) {
        this.goToSelectedBookmark();
    }

    private void previousBookmarkButtonActionPerformed(ActionEvent evt) {
        this.goToPreviousBookmark();
    }

    private void nextBookmarkButtonActionPerformed(ActionEvent evt) {
        this.goToNextBookmark();
    }

    private void trimTopMenuItemActionPerformed(ActionEvent evt) {
        this.trimTop();
    }

    private void record1PCheckBoxActionPerformed(ActionEvent evt) {
        this.recordOptionsChanged();
    }

    private void record2PCheckBoxActionPerformed(ActionEvent evt) {
        this.recordOptionsChanged();
    }

    private void record3PCheckBoxActionPerformed(ActionEvent evt) {
        this.recordOptionsChanged();
    }

    private void record4PCheckBoxActionPerformed(ActionEvent evt) {
        this.recordOptionsChanged();
    }

    private void mergeButtonsCheckBoxActionPerformed(ActionEvent evt) {
        this.recordOptionsChanged();
    }

    private void fastGenerationCheckBoxActionPerformed(ActionEvent evt) {
        if (this.playMovieTask != null && !this.playMovieTask.isCanceled()) {
            this.playMovieTask.setRealtime(!this.fastGenerationCheckBox.isSelected());
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clearChanges();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void loadMenuItemActionPerformed(ActionEvent evt) {
        this.load();
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (this.priorSaveFile == null) {
            this.saveAs();
        } else {
            this.save(this.priorSaveFile);
        }
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        this.enableFileMenuItems();
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        this.closeProject();
    }

    private void saveSlotsComboBoxActionPerformed(ActionEvent evt) {
        this.enableSaveButtons();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        int index = this.saveSlotsComboBox.getSelectedIndex();
        if (index >= 0) {
            this.quickSaveProject(index);
        }
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        int index = this.saveSlotsComboBox.getSelectedIndex();
        if (index >= 0) {
            this.quickLoadProject(index);
        }
    }

    private void recentProjectsClearMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().clearRecentHistoryProjects();
        this.createRecentProjectsMenu();
        AppPrefs.save();
    }

    private void recentProjectsLockMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().setLockRecentHistoryProjects(this.recentProjectsLockMenuItem.isSelected());
        AppPrefs.save();
    }

    private void recentDirectoriesMenuMenuSelected(MenuEvent evt) {
        this.createRecentDirectoriesMenu();
    }

    private void recentDirectoriesLockMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().setLockRecentDirectories(this.recentDirectoriesLockMenuItem.isSelected());
        AppPrefs.save();
    }

    private void recentDirectoriesClearMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().clearRecentDirectories();
        AppPrefs.save();
    }

    private void selectBetweenBookmarksMenuItemActionPerformed(ActionEvent evt) {
        this.selectBetweenBookmarks();
    }

    private void recordOtherCheckBoxActionPerformed(ActionEvent evt) {
        this.recordOptionsChanged();
    }
}

