/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import nintaco.gui.CustomFocusTraversalPolicy;
import nintaco.gui.InformationDialog;
import nintaco.gui.hexeditor.CharTable;
import nintaco.gui.hexeditor.HexEditorView;
import nintaco.gui.hexeditor.SearchQuery;
import nintaco.gui.hexeditor.SearchText;
import nintaco.gui.hexeditor.Searcher;
import nintaco.gui.hexeditor.preferences.Search;
import nintaco.preferences.AppPrefs;

public class SearchDialog
extends JDialog {
    private static final int MAX_REPLACES = 10000;
    private static final String PROTOTYPE_DISPLAY_VALUE = "00 11 22 33 44 55 66 77 88 99 AA BB CC DD EE FF 00";
    private HexEditorView hexEditorView;
    private CharTable charTable;
    private boolean hexSelected = true;
    private SearchText findText;
    private SearchText replaceText;
    private JRadioButton allViewsRadioButton;
    private JButton closeButton;
    private JRadioButton currentViewRadioButton;
    private ButtonGroup dataButtonGroup;
    private ButtonGroup directionButtonGroup;
    private JRadioButton downRadioButton;
    private JComboBox findComboBox;
    private JButton findNextButton;
    private JLabel findWhatLabel;
    private JRadioButton hexRadioButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox regExCheckBox;
    private JButton replaceAllButton;
    private JComboBox replaceComboBox;
    private JButton replaceNextButton;
    private JLabel replaceWithLabel;
    private ButtonGroup scopeButtonGroup;
    private JRadioButton selectionRadioButton;
    private JRadioButton textRadioButton;
    private JRadioButton upRadioButton;
    private JCheckBox wrapSearchesCheckBox;

    public SearchDialog(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.findComboBox.setPrototypeDisplayValue(PROTOTYPE_DISPLAY_VALUE);
        this.replaceComboBox.setPrototypeDisplayValue(PROTOTYPE_DISPLAY_VALUE);
        this.addComboBoxListener(this.findComboBox, this::findComboBoxEdited);
        this.addComboBoxListener(this.replaceComboBox, this::replaceComboBoxEdited);
        this.getRootPane().setDefaultButton(this.findNextButton);
    }

    public void setData(SearchQuery.Data data) {
        if (data == SearchQuery.Data.Hex) {
            this.hexRadioButton.setSelected(true);
        } else {
            this.textRadioButton.setSelected(true);
        }
        this.setConditionsMode(data == SearchQuery.Data.Text);
    }

    public void setScope(SearchQuery.Scope scope) {
        switch (scope) {
            case CurrentView: {
                this.currentViewRadioButton.setSelected(true);
                break;
            }
            case Selection: {
                this.selectionRadioButton.setSelected(true);
                break;
            }
            case AllViews: {
                this.allViewsRadioButton.setSelected(true);
            }
        }
    }

    public void setFindWhat(String findWhat) {
        this.setComboBoxText(this.findComboBox, findWhat);
    }

    public void setReplaceWith(String replaceWith) {
        this.setComboBoxText(this.replaceComboBox, replaceWith);
    }

    private void setComboBoxText(JComboBox comboBox, String text) {
        comboBox.setSelectedItem(text);
        comboBox.getEditor().selectAll();
        comboBox.requestFocus();
    }

    private void updateComboBoxModel(JComboBox comboBox, List<SearchText> values) {
        boolean hexString = this.hexRadioButton.isSelected();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (SearchText value : values) {
            model.addElement(value.toString(hexString, this.charTable));
        }
        comboBox.setModel(model);
    }

    private String getComboBoxText(JComboBox comboBox) {
        Object selectedItem = comboBox.getSelectedItem();
        return selectedItem == null ? "" : selectedItem.toString();
    }

    private void findComboBoxEdited(String value) {
        this.findText = null;
        this.comboBoxesEdited(value, this.getComboBoxText(this.replaceComboBox));
    }

    private void replaceComboBoxEdited(String value) {
        this.replaceText = null;
        this.comboBoxesEdited(this.getComboBoxText(this.findComboBox), value);
    }

    private void comboBoxesEdited(String findValue, String replaceValue) {
        this.findNextButton.setEnabled(!findValue.isEmpty());
        boolean replaceEnabled = !findValue.isEmpty() && !replaceValue.isEmpty();
        this.replaceAllButton.setEnabled(replaceEnabled);
        this.replaceNextButton.setEnabled(replaceEnabled);
    }

    private void addComboBoxListener(JComboBox comboBox, final TextListener listener) {
        comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                String value = ((JTextComponent)((JComboBox)((Component)event.getSource()).getParent()).getEditor().getEditorComponent()).getText();
                if (SearchDialog.this.hexRadioButton.isSelected()) {
                    value = value.trim();
                }
                listener.handleText(value);
            }
        });
    }

    public final void setShowReplace(boolean replace) {
        CustomFocusTraversalPolicy policy = new CustomFocusTraversalPolicy();
        this.replaceWithLabel.setVisible(replace);
        this.replaceComboBox.setVisible(replace);
        this.replaceNextButton.setVisible(replace);
        this.replaceAllButton.setVisible(replace);
        this.setTitle(replace ? "Replace" : "Find");
        policy.add(this.findComboBox);
        if (replace) {
            policy.add(this.replaceComboBox);
        }
        policy.add(this.hexRadioButton);
        policy.add(this.textRadioButton);
        policy.add(this.matchCaseCheckBox);
        policy.add(this.regExCheckBox);
        policy.add(this.wrapSearchesCheckBox);
        policy.add(this.upRadioButton);
        policy.add(this.downRadioButton);
        policy.add(this.currentViewRadioButton);
        policy.add(this.selectionRadioButton);
        policy.add(this.allViewsRadioButton);
        policy.add(this.findNextButton);
        if (replace) {
            policy.add(this.replaceNextButton);
            policy.add(this.replaceAllButton);
        }
        policy.add(this.closeButton);
        this.getContentPane().setFocusCycleRoot(true);
        this.getContentPane().setFocusTraversalPolicy(policy);
        this.revalidate();
        this.pack();
        this.repaint();
    }

    public void setCharTable(CharTable charTable) {
        if (EventQueue.isDispatchThread()) {
            this.charTable = charTable;
            Search search = AppPrefs.getInstance().getHexEditorPrefs().getSearch();
            this.updateComboBoxModel(this.findComboBox, search.getRecentFinds());
            this.updateComboBoxModel(this.replaceComboBox, search.getRecentReplaces());
        } else {
            EventQueue.invokeLater(() -> this.setCharTable(charTable));
        }
    }

    public void setHexEditorView(HexEditorView hexEditorView) {
        this.hexEditorView = hexEditorView;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void setConditionsMode(boolean text) {
        String value;
        this.matchCaseCheckBox.setEnabled(text);
        this.regExCheckBox.setEnabled(text);
        if (this.findComboBox.getSelectedIndex() >= 0) {
            this.findText = null;
        } else if (this.findText == null && !(value = this.getComboBoxText(this.findComboBox)).isEmpty()) {
            this.findText = new SearchText(value, this.hexSelected);
        }
        if (this.replaceComboBox.getSelectedIndex() >= 0) {
            this.replaceText = null;
        } else if (this.replaceText == null && !(value = this.getComboBoxText(this.replaceComboBox)).isEmpty()) {
            this.replaceText = new SearchText(value, this.hexSelected);
        }
        Search search = AppPrefs.getInstance().getHexEditorPrefs().getSearch();
        this.updateComboBoxModel(this.findComboBox, search.getRecentFinds());
        this.updateComboBoxModel(this.replaceComboBox, search.getRecentReplaces());
        boolean bl = this.hexSelected = !text;
        if (this.findText != null) {
            this.findComboBox.setSelectedItem(this.findText.toString(this.hexSelected, this.charTable));
        }
        if (this.replaceText != null) {
            this.replaceComboBox.setSelectedItem(this.replaceText.toString(this.hexSelected, this.charTable));
        }
    }

    private void updateComboBoxModels() {
        Search search = AppPrefs.getInstance().getHexEditorPrefs().getSearch();
        boolean hex = this.hexRadioButton.isSelected();
        boolean save = false;
        String value = this.getComboBoxText(this.findComboBox);
        if (!value.isEmpty()) {
            save = true;
            search.addRecentFind(new SearchText(value, hex));
            this.updateComboBoxModel(this.findComboBox, search.getRecentFinds());
        }
        if (!(value = this.getComboBoxText(this.replaceComboBox)).isEmpty()) {
            save = true;
            search.addRecentReplace(new SearchText(value, hex));
            this.updateComboBoxModel(this.replaceComboBox, search.getRecentReplaces());
        }
        if (save) {
            AppPrefs.save();
        }
    }

    private void search(SearchQuery.Type type) {
        Search search = AppPrefs.getInstance().getHexEditorPrefs().getSearch();
        SearchQuery query = new SearchQuery(type, search.getMostRecentFind(), search.getMostRecentReplace(), this.hexRadioButton.isSelected() ? SearchQuery.Data.Hex : SearchQuery.Data.Text, this.upRadioButton.isSelected() ? SearchQuery.Direction.Up : SearchQuery.Direction.Down, this.currentViewRadioButton.isSelected() ? SearchQuery.Scope.CurrentView : (this.selectionRadioButton.isSelected() ? SearchQuery.Scope.Selection : SearchQuery.Scope.AllViews), this.matchCaseCheckBox.isSelected(), this.regExCheckBox.isSelected(), this.wrapSearchesCheckBox.isSelected());
        if (query.getFindWhat() == null || type != SearchQuery.Type.FindNext && query.getReplaceWith() == null) {
            return;
        }
        boolean showItemNotFound = true;
        if (query.getType() == SearchQuery.Type.ReplaceAll) {
            int count = 0;
            if (query.getScope() == SearchQuery.Scope.Selection || !query.isWrapSearches()) {
                while (this.hexEditorView.search(query) != Searcher.NOT_FOUND && ++count < 10000) {
                    showItemNotFound = false;
                }
            } else {
                SearchQuery query2 = new SearchQuery(SearchQuery.Type.FindNext, query.getFindWhat(), query.getReplaceWith(), query.getData(), query.getDirection(), query.getScope(), query.isMatchCase(), query.isRegularExpression(), query.isWrapSearches());
                Searcher.Result result2 = this.hexEditorView.search(query2);
                if (result2 != Searcher.NOT_FOUND) {
                    Searcher.Result result;
                    showItemNotFound = false;
                    while (++count < 10000 && !(result = this.hexEditorView.search(query)).equals(result2)) {
                    }
                }
            }
        } else {
            boolean bl = showItemNotFound = this.hexEditorView.search(query) == Searcher.NOT_FOUND;
        }
        if (showItemNotFound) {
            new InformationDialog((Window)this, "End of view reached. The search item was not found.", "Search Result", InformationDialog.IconType.INFORMATION).setVisible(true);
        }
    }

    public void find() {
        this.updateComboBoxModels();
        if (!this.getComboBoxText(this.findComboBox).isEmpty()) {
            this.search(SearchQuery.Type.FindNext);
        }
    }

    private void initComponents() {
        this.directionButtonGroup = new ButtonGroup();
        this.dataButtonGroup = new ButtonGroup();
        this.scopeButtonGroup = new ButtonGroup();
        this.findWhatLabel = new JLabel();
        this.findComboBox = new JComboBox();
        this.findNextButton = new JButton();
        this.jPanel1 = new JPanel();
        this.hexRadioButton = new JRadioButton();
        this.textRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.upRadioButton = new JRadioButton();
        this.downRadioButton = new JRadioButton();
        this.closeButton = new JButton();
        this.replaceWithLabel = new JLabel();
        this.replaceComboBox = new JComboBox();
        this.replaceNextButton = new JButton();
        this.replaceAllButton = new JButton();
        this.jPanel3 = new JPanel();
        this.currentViewRadioButton = new JRadioButton();
        this.selectionRadioButton = new JRadioButton();
        this.allViewsRadioButton = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.matchCaseCheckBox = new JCheckBox();
        this.regExCheckBox = new JCheckBox();
        this.wrapSearchesCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Find");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SearchDialog.this.formWindowClosing(evt);
            }
        });
        this.findWhatLabel.setText("Find what:");
        this.findComboBox.setEditable(true);
        this.findComboBox.setMinimumSize(null);
        this.findComboBox.setPreferredSize(null);
        this.findComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.findComboBoxActionPerformed(evt);
            }
        });
        this.findNextButton.setMnemonic('F');
        this.findNextButton.setText("Find Next");
        this.findNextButton.setEnabled(false);
        this.findNextButton.setFocusPainted(false);
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.findNextButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataButtonGroup.add(this.hexRadioButton);
        this.hexRadioButton.setMnemonic('H');
        this.hexRadioButton.setSelected(true);
        this.hexRadioButton.setText("Hex");
        this.hexRadioButton.setFocusPainted(false);
        this.hexRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.hexRadioButtonActionPerformed(evt);
            }
        });
        this.dataButtonGroup.add(this.textRadioButton);
        this.textRadioButton.setMnemonic('T');
        this.textRadioButton.setText("Text");
        this.textRadioButton.setFocusPainted(false);
        this.textRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.textRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.hexRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textRadioButton).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hexRadioButton).addComponent(this.textRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.directionButtonGroup.add(this.upRadioButton);
        this.upRadioButton.setMnemonic('U');
        this.upRadioButton.setText("Up");
        this.upRadioButton.setFocusPainted(false);
        this.directionButtonGroup.add(this.downRadioButton);
        this.downRadioButton.setMnemonic('D');
        this.downRadioButton.setSelected(true);
        this.downRadioButton.setText("Down");
        this.downRadioButton.setFocusPainted(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.upRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.downRadioButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upRadioButton).addComponent(this.downRadioButton)).addContainerGap()));
        this.closeButton.setMnemonic('C');
        this.closeButton.setText("Close");
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.replaceWithLabel.setText("Replace with:");
        this.replaceComboBox.setEditable(true);
        this.replaceComboBox.setMinimumSize(null);
        this.replaceComboBox.setPreferredSize(null);
        this.replaceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.replaceComboBoxActionPerformed(evt);
            }
        });
        this.replaceNextButton.setMnemonic('R');
        this.replaceNextButton.setText("Replace Next");
        this.replaceNextButton.setEnabled(false);
        this.replaceNextButton.setFocusPainted(false);
        this.replaceNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.replaceNextButtonActionPerformed(evt);
            }
        });
        this.replaceAllButton.setMnemonic('A');
        this.replaceAllButton.setText("Replace All");
        this.replaceAllButton.setEnabled(false);
        this.replaceAllButton.setFocusPainted(false);
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.replaceAllButtonActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Scope"));
        this.scopeButtonGroup.add(this.currentViewRadioButton);
        this.currentViewRadioButton.setSelected(true);
        this.currentViewRadioButton.setText("Current view");
        this.currentViewRadioButton.setFocusPainted(false);
        this.scopeButtonGroup.add(this.selectionRadioButton);
        this.selectionRadioButton.setText("Selection");
        this.selectionRadioButton.setFocusPainted(false);
        this.scopeButtonGroup.add(this.allViewsRadioButton);
        this.allViewsRadioButton.setText("All views");
        this.allViewsRadioButton.setFocusPainted(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.currentViewRadioButton).addComponent(this.selectionRadioButton).addComponent(this.allViewsRadioButton)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.currentViewRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allViewsRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Conditions"));
        this.matchCaseCheckBox.setMnemonic('c');
        this.matchCaseCheckBox.setSelected(true);
        this.matchCaseCheckBox.setText("Match case");
        this.matchCaseCheckBox.setEnabled(false);
        this.matchCaseCheckBox.setFocusPainted(false);
        this.regExCheckBox.setMnemonic('e');
        this.regExCheckBox.setText("Regular expression");
        this.regExCheckBox.setEnabled(false);
        this.regExCheckBox.setFocusPainted(false);
        this.wrapSearchesCheckBox.setMnemonic('s');
        this.wrapSearchesCheckBox.setSelected(true);
        this.wrapSearchesCheckBox.setText("Wrap searches");
        this.wrapSearchesCheckBox.setFocusPainted(false);
        this.wrapSearchesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.wrapSearchesCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchCaseCheckBox).addComponent(this.regExCheckBox).addComponent(this.wrapSearchesCheckBox)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.matchCaseCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regExCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrapSearchesCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeButton).addComponent(this.replaceAllButton, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findWhatLabel).addComponent(this.replaceWithLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.replaceComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findNextButton).addComponent(this.replaceNextButton)))).addContainerGap()));
        layout.linkSize(0, this.closeButton, this.findNextButton, this.replaceAllButton, this.replaceNextButton);
        layout.linkSize(0, this.jPanel1, this.jPanel5);
        layout.linkSize(0, this.jPanel2, this.jPanel3);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.findWhatLabel).addComponent(this.findComboBox, -2, -1, -2).addComponent(this.findNextButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.replaceWithLabel).addComponent(this.replaceComboBox, -2, -1, -2).addComponent(this.replaceNextButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(69, 69, 69).addComponent(this.replaceAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeButton).addGap(11, 11, 11)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void findNextButtonActionPerformed(ActionEvent evt) {
        this.find();
    }

    private void replaceNextButtonActionPerformed(ActionEvent evt) {
        this.updateComboBoxModels();
        if (!this.getComboBoxText(this.findComboBox).isEmpty() && !this.getComboBoxText(this.replaceComboBox).isEmpty()) {
            this.search(SearchQuery.Type.ReplaceNext);
        }
    }

    private void replaceAllButtonActionPerformed(ActionEvent evt) {
        this.updateComboBoxModels();
        if (!this.getComboBoxText(this.findComboBox).isEmpty() && !this.getComboBoxText(this.replaceComboBox).isEmpty()) {
            this.search(SearchQuery.Type.ReplaceAll);
        }
    }

    private void hexRadioButtonActionPerformed(ActionEvent evt) {
        this.setConditionsMode(false);
    }

    private void textRadioButtonActionPerformed(ActionEvent evt) {
        this.setConditionsMode(true);
    }

    private void wrapSearchesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.wrapSearchesCheckBox.isSelected()) {
            this.allViewsRadioButton.setEnabled(true);
        } else {
            if (this.allViewsRadioButton.isSelected()) {
                this.currentViewRadioButton.setSelected(true);
            }
            this.allViewsRadioButton.setEnabled(false);
        }
    }

    private void findComboBoxActionPerformed(ActionEvent evt) {
        this.comboBoxesEdited(this.getComboBoxText(this.findComboBox), this.getComboBoxText(this.replaceComboBox));
    }

    private void replaceComboBoxActionPerformed(ActionEvent evt) {
        this.comboBoxesEdited(this.getComboBoxText(this.findComboBox), this.getComboBoxText(this.replaceComboBox));
    }

    private static interface TextListener {
        public void handleText(String var1);
    }
}

