/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import nintaco.PPU;
import nintaco.gui.hexeditor.DataSource;

public class PpuDataSource
extends DataSource {
    private final PPU ppu;

    public PpuDataSource(PPU ppu) {
        super(16384);
        this.ppu = ppu;
    }

    @Override
    public int peek(int address) {
        try {
            return address < 0 ? 0 : this.ppu.peekVRAM(address);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public void write(int address, int value) {
        if (address >= 0) {
            this.ppu.writeVRAM(address, value & 0xFF);
        }
    }

    @Override
    public int getIndex() {
        return 1;
    }
}

