/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.familybasic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import nintaco.App;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.ImagePanel;
import nintaco.gui.InputTextAreaDialog;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.image.preferences.Paths;
import nintaco.input.familybasic.FamilyBasicUtil;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class BackgroundEditorFrame
extends JFrame {
    public static final FileExtensionFilter[] BackgroundFileExtensionFilters = new FileExtensionFilter[]{new FileExtensionFilter(0, "Background files (*.background)", "background"), new FileExtensionFilter(1, "All files (*.*)")};
    private static final int NAMETABLE_ADDRESS = 9216;
    private static final int BACKGROUND_WIDTH = 224;
    private static final int BACKGROUND_HEIGHT = 168;
    private final DrawAndFillListener drawAndFillListener = new DrawAndFillListener();
    private final SelectAndCopyListener selectAndCopyListener = new SelectAndCopyListener();
    private final PasteListener pasteListener = new PasteListener();
    private final DocumentListener graphicListener = GuiUtil.createDocumentListener(this::graphicEdited);
    private final List<int[]> history = new ArrayList<int[]>();
    private final int[][] colors = new int[4][4];
    private final int[][] attributes = new int[16][16];
    private final int[][] tiles = new int[32][32];
    private final int[][] attributesCopy = new int[16][16];
    private final int[][] tilesCopy = new int[32][32];
    private final Fill[][] fills = new Fill[32][32];
    private volatile Machine machine;
    private volatile PPU ppu;
    private int historyIndex;
    private int patternTableBoxX;
    private int patternTableBoxY;
    private boolean patternTableDrawBox;
    private int selectedPattern;
    private int paletteBoxY;
    private boolean paletteDrawBox;
    private int selectedPalette;
    private int backgroundBoxX;
    private int backgroundBoxY;
    private boolean backgroundDrawBox;
    private int selectX0 = -1;
    private int selectY0;
    private int selectX1;
    private int selectY1;
    private int copyImageWidth;
    private int copyImageHeight;
    private int copyOffsetX;
    private int copyOffsetY;
    private int copyImageX;
    private int copyImageY;
    private int[] copyScreen;
    private boolean drawCopy;
    private String copyMessage;
    private Mode mode;
    private MouseMotionListener mouseMotionListener;
    private MouseListener mouseListener;
    private static File backgroundFile;
    private JLabel backgroundLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JMenuItem closeMenuItem;
    private JLabel coordinatesLabel;
    private JRadioButton drawRadioButton;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JRadioButton fillRadioButton;
    private JLabel graphicLabel;
    private JTextField graphicTextField;
    private JPanel jPanel1;
    private JPopupMenu.Separator jSeparator1;
    private JMenuBar menuBar;
    private ButtonGroup modeButtonGroup;
    private JLabel modeLabel;
    private JPanel modePanel;
    private JMenuItem openMenuItem;
    private JLabel paletteLabel;
    private JPanel palettePanel;
    private JRadioButton pasteRadioButton;
    private JLabel patternLabel;
    private JPanel patternPanel;
    private JLabel patternTableLabel;
    private JPanel patternTablePanel;
    private JMenuItem redoMenuItem;
    private JButton resizeButton;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JRadioButton selectAndCopyRadioButton;
    private JButton textButton;
    private JMenuItem undoMenuItem;

    public BackgroundEditorFrame(Machine machine) {
        this.initComponents();
        this.initImagePanels();
        this.setMachine(machine);
        GuiUtil.addLoseFocusListener((Window)this, this.graphicTextField);
        this.graphicTextField.getDocument().addDocumentListener(this.graphicListener);
        GuiUtil.makeMonospaced(this.graphicTextField);
        GuiUtil.makeMonospaced(this.coordinatesLabel);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initImagePanels() {
        this.initPatternPanel();
        this.initBackgroundPanel();
        this.initPalettePanel();
        this.initPatternTablePanel();
    }

    private void initPatternPanel() {
        ImagePanel panel = (ImagePanel)this.patternPanel;
        panel.setBlackBars(false);
        panel.setCentered(false);
    }

    private void initBackgroundPanel() {
        ImagePanel panel = (ImagePanel)this.backgroundPanel;
        panel.setBlackBars(false);
        panel.setCentered(false);
        this.setMode(Mode.Draw);
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        this.backgroundPanel.removeMouseMotionListener(this.mouseMotionListener);
        this.backgroundPanel.removeMouseListener(this.mouseListener);
        switch (mode) {
            case Draw: {
                this.drawRadioButton.setSelected(true);
                this.mouseMotionListener = this.drawAndFillListener;
                this.mouseListener = this.drawAndFillListener;
                break;
            }
            case Fill: {
                this.fillRadioButton.setSelected(true);
                this.mouseMotionListener = this.drawAndFillListener;
                this.mouseListener = this.drawAndFillListener;
                break;
            }
            case SelectAndCopy: {
                this.selectAndCopyRadioButton.setSelected(true);
                this.selectX0 = -1;
                this.copyScreen = null;
                this.copyMessage = null;
                this.mouseMotionListener = this.selectAndCopyListener;
                this.mouseListener = this.selectAndCopyListener;
                this.pasteRadioButton.setEnabled(false);
                break;
            }
            case Paste: {
                this.pasteRadioButton.setSelected(true);
                this.mouseMotionListener = this.pasteListener;
                this.mouseListener = this.pasteListener;
            }
        }
        this.backgroundPanel.addMouseMotionListener(this.mouseMotionListener);
        this.backgroundPanel.addMouseListener(this.mouseListener);
        this.renderBackground();
    }

    private void initPalettePanel() {
        ImagePanel panel = (ImagePanel)this.palettePanel;
        panel.setBlackBars(false);
        panel.setCentered(false);
        panel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMousePressed(e.getX(), e.getY());
            }
        });
        panel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMousePressed(e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BackgroundEditorFrame.this.paletteMouseOutOfBounds();
            }
        });
    }

    private void initPatternTablePanel() {
        ImagePanel panel = (ImagePanel)this.patternTablePanel;
        panel.setBlackBars(false);
        panel.setCentered(false);
        panel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMousePressed(e.getX(), e.getY());
            }
        });
        panel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMousePressed(e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BackgroundEditorFrame.this.patternTableMouseOutOfBounds();
            }
        });
    }

    public void destroy() {
        this.dispose();
    }

    private void closeFrame() {
        App.destroyBackgroundEditorFrame();
    }

    public final void setMachine(Machine machine) {
        this.machine = machine;
        this.ppu = machine == null ? null : machine.getPPU();
        EventQueue.invokeLater(() -> {
            if (this.ppu == null) {
                ((ImagePanel)this.patternTablePanel).clearScreen();
                ((ImagePanel)this.backgroundPanel).clearScreen();
                ((ImagePanel)this.patternPanel).clearScreen();
                ((ImagePanel)this.palettePanel).clearScreen();
                return;
            }
            this.renderPatternTable();
            this.renderBackground();
            this.drawPattern();
            this.initHistory();
            this.enableComponents();
        });
    }

    private void renderPalette() {
        PPU p = this.ppu;
        if (p != null) {
            ImagePanel panel = (ImagePanel)this.palettePanel;
            this.drawPalette(panel.getScreen());
            panel.render();
        }
    }

    private void renderPatternTable() {
        Machine m = this.machine;
        PPU p = this.ppu;
        if (m != null && p != null) {
            this.updateColors(m, p);
            ImagePanel panel = (ImagePanel)this.patternTablePanel;
            this.drawPatternTable(p, panel.getScreen(), this.selectedPalette);
            panel.render();
        }
    }

    private void renderBackground() {
        Machine m = this.machine;
        PPU p = this.ppu;
        if (m != null && p != null) {
            this.updateColors(m, p);
            ImagePanel panel = (ImagePanel)this.backgroundPanel;
            this.drawBackground(p, panel.getScreen());
            panel.render();
        }
    }

    private void updateColors(Machine machine, PPU ppu) {
        if (machine != null) {
            int[] palette = PaletteUtil.getExtendedPalette(machine);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.colors[i][j] = palette[ppu.getPaletteRamValue(i << 2 | j)];
                }
            }
            this.renderPalette();
        }
    }

    private void drawPattern() {
        ImagePanel patternPan = (ImagePanel)this.patternPanel;
        int[] patternScreen = patternPan.getScreen();
        ImagePanel patternTablePan = (ImagePanel)this.patternTablePanel;
        int[] patternTableScreen = patternTablePan.getScreen();
        int tileX = (this.selectedPattern & 0xF) << 3;
        int tileY = (this.selectedPattern & 0xF0) >> 1;
        for (int y = 0; y < 8; ++y) {
            System.arraycopy(patternTableScreen, (tileY | y) << 7 | tileX, patternScreen, y << 3, 8);
        }
        patternPan.render();
    }

    private void drawPalette(int[] screen) {
        for (int i = 3; i >= 0; --i) {
            int j;
            int[] cols = this.colors[i];
            int y = i << 8;
            for (j = 3; j >= 0; --j) {
                int color = cols[j];
                int offset = y | j << 3;
                for (int k = 0; k < 8; ++k) {
                    screen[offset | k] = color;
                }
            }
            for (j = 6; j >= 0; --j) {
                System.arraycopy(screen, y, screen, y | j << 5, 32);
            }
        }
        if (this.paletteDrawBox) {
            int i;
            int y0 = this.paletteBoxY;
            int y1 = y0 | 0xC0;
            for (i = 31; i >= 0; --i) {
                int n = y0 | i;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n2 = y1 | i;
                screen[n2] = screen[n2] ^ 0xFFFFFF;
            }
            for (i = 5; i >= 1; --i) {
                int y;
                int n = y = y0 | i << 5;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n3 = y | 0x1F;
                screen[n3] = screen[n3] ^ 0xFFFFFF;
            }
        }
    }

    private void drawPatternTable(PPU ppu, int[] screen, int palette) {
        int address = 4096;
        for (int tileY = 0; tileY < 128; tileY += 8) {
            int tileX = 0;
            while (tileX < 128) {
                int address1 = address | 8;
                for (int y = 0; y < 8; ++y) {
                    int b0 = ppu.peekVRAM(address + y);
                    int b1 = ppu.peekVRAM(address1 + y);
                    int index = (tileY | y) << 7 | tileX;
                    for (int x = 0; x < 8; ++x) {
                        int shift = 7 - x;
                        screen[index | x] = this.colors[palette][(b1 >> shift & 1) << 1 | b0 >> shift & 1];
                    }
                }
                tileX += 8;
                address += 16;
            }
        }
        if (this.patternTableDrawBox) {
            int i;
            int boxX = this.patternTableBoxX;
            int boxY = this.patternTableBoxY;
            int y0 = boxY << 7;
            int y1 = boxY + 7 << 7;
            for (i = 7; i >= 0; --i) {
                int n = y0 | boxX | i;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n2 = y1 | boxX | i;
                screen[n2] = screen[n2] ^ 0xFFFFFF;
            }
            for (i = 6; i >= 1; --i) {
                int y = boxY + i << 7;
                int n = y | boxX;
                screen[n] = screen[n] ^ 0xFFFFFF;
                int n3 = y | boxX | 7;
                screen[n3] = screen[n3] ^ 0xFFFFFF;
            }
        }
    }

    private int readAttribute(PPU ppu, int tileX, int tileY) {
        return ppu.peekVRAM(0x27C0 | tileY >> 2 << 3 | tileX >> 2) >> ((tileY & 2 | tileX >> 1 & 1) << 1) & 3;
    }

    private void writeAttribute(PPU ppu, int tileX, int tileY, int attribute) {
        int address = 0x27C0 | tileY >> 2 << 3 | tileX >> 2;
        int shift = (tileY & 2 | tileX >> 1 & 1) << 1;
        ppu.writeVRAM(address, ppu.peekVRAM(address) & ~(3 << shift) | (attribute & 3) << shift);
    }

    private int readTile(PPU ppu, int tileX, int tileY) {
        return ppu.peekVRAM(0x2400 | tileY << 5 | tileX);
    }

    private void writeTile(PPU ppu, int tileX, int tileY, int value) {
        ppu.writeVRAM(0x2400 | tileY << 5 | tileX, value);
    }

    private void copy(String message) {
        int i;
        if (StringUtil.isBlank(message)) {
            this.copyMessage = null;
            return;
        }
        String[] lines = StringUtil.replaceNewlines(message).split("\n");
        int width = 0;
        int height = Math.min(lines.length, 30);
        for (i = height - 1; i >= 0; --i) {
            lines[i] = lines[i].trim();
            width = Math.max(width, lines[i].length());
        }
        width = Math.min(width, 32);
        this.selectX0 = 0;
        this.selectY0 = 0;
        this.selectX1 = width - 1;
        this.selectY1 = height - 1;
        for (i = this.tilesCopy.length - 1; i >= 0; --i) {
            for (int j = this.tilesCopy[i].length - 1; j >= 0; --j) {
                this.tilesCopy[i][j] = -1;
            }
        }
        this.copyOffsetX = 0;
        this.copyOffsetY = 0;
        this.copyImageWidth = width << 3;
        this.copyImageHeight = height << 3;
        this.copyScreen = new int[this.copyImageWidth * this.copyImageHeight];
        for (i = this.copyScreen.length - 1; i >= 0; --i) {
            this.copyScreen[i] = -1;
        }
        this.renderPatternTable();
        int[] screen = ((ImagePanel)this.patternTablePanel).getScreen();
        for (int i2 = height - 1; i2 >= 0; --i2) {
            int i22 = i2 >> 1;
            int I = i2 << 3;
            String line = lines[i2];
            for (int j = Math.min(width, line.length()) - 1; j >= 0; --j) {
                int J = j << 3;
                this.attributesCopy[i22][j >> 1] = this.selectedPalette;
                int value = FamilyBasicUtil.charToHex(line.charAt(j));
                this.tilesCopy[i2][j] = value >= 0 ? value : 0;
                int tile = this.tilesCopy[i2][j];
                if (tile < 0) continue;
                int X = (tile & 0xF) << 3;
                int Y = (tile & 0xF0) >> 1;
                for (int y = 7; y >= 0; --y) {
                    System.arraycopy(screen, (Y | y) << 7 | X, this.copyScreen, (I + y) * this.copyImageWidth + J, 8);
                }
            }
        }
        this.copyMessage = message;
        this.pasteRadioButton.setEnabled(true);
    }

    private void copy() {
        int i;
        int temp;
        PPU p = this.ppu;
        if (p == null) {
            return;
        }
        if (this.selectX0 > this.selectX1) {
            temp = this.selectX0;
            this.selectX0 = this.selectX1;
            this.selectX1 = temp;
            this.copyOffsetX = 0;
        } else {
            this.copyOffsetX = this.selectX0 - this.selectX1;
        }
        if (this.selectY0 > this.selectY1) {
            temp = this.selectY0;
            this.selectY0 = this.selectY1;
            this.selectY1 = temp;
            this.copyOffsetY = 0;
        } else {
            this.copyOffsetY = this.selectY0 - this.selectY1;
        }
        this.readNametable(p, this.attributesCopy, this.tilesCopy);
        this.copyImageWidth = this.selectX1 - this.selectX0 + 1 << 3;
        this.copyImageHeight = this.selectY1 - this.selectY0 + 1 << 3;
        this.copyScreen = new int[this.copyImageWidth * this.copyImageHeight];
        this.drawNametable(p, this.selectX0, this.selectY0, this.selectX1, this.selectY1, this.attributesCopy, this.tilesCopy, this.copyScreen, this.copyImageWidth);
        int offsetY = (this.copyImageHeight - 1) * this.copyImageWidth;
        for (i = this.copyImageWidth - 1; i >= 0; --i) {
            int n = i;
            this.copyScreen[n] = this.copyScreen[n] ^ 0xFFFFFF;
            int n2 = offsetY + i;
            this.copyScreen[n2] = this.copyScreen[n2] ^ 0xFFFFFF;
        }
        for (i = this.copyImageHeight - 2; i >= 1; --i) {
            int offset;
            int n = offset = this.copyImageWidth * i;
            this.copyScreen[n] = this.copyScreen[n] ^ 0xFFFFFF;
            int n3 = offset + this.copyImageWidth - 1;
            this.copyScreen[n3] = this.copyScreen[n3] ^ 0xFFFFFF;
        }
        this.copyMessage = null;
        this.pasteRadioButton.setEnabled(true);
    }

    private void paste(int x, int y) {
        PPU p = this.ppu;
        if (p != null) {
            for (int i = this.selectY0; i <= this.selectY1; ++i) {
                int i2 = i >> 1;
                int I = y + i;
                if (I < 0 || I >= 30) continue;
                int ai = I >> 1;
                for (int j = this.selectX0; j <= this.selectX1; ++j) {
                    int J = x + j;
                    if (J < 0 || J >= 32) continue;
                    int aj = J >> 1;
                    int tile = this.tilesCopy[i][j];
                    if (tile < 0) continue;
                    this.tiles[I][J] = tile;
                    this.attributes[ai][aj] = this.attributesCopy[i2][j >> 1];
                }
            }
            this.writeNametable(p);
            this.saveState();
        }
    }

    private void initHistory() {
        this.history.clear();
        this.historyIndex = 0;
        this.saveState();
    }

    private void saveState() {
        PPU p = this.ppu;
        if (p != null) {
            int[] nametable = new int[1024];
            for (int i = nametable.length - 1; i >= 0; --i) {
                nametable[i] = p.peekVRAM(0x2400 | i);
            }
            while (this.history.size() > this.historyIndex) {
                this.history.remove(this.history.size() - 1);
            }
            this.history.add(nametable);
            this.historyIndex = this.history.size();
            this.enableComponents();
        }
    }

    private void undo() {
        PPU p = this.ppu;
        if (p != null && this.historyIndex > 1) {
            --this.historyIndex;
            int[] nametable = this.history.get(this.historyIndex - 1);
            for (int i = nametable.length - 1; i >= 0; --i) {
                p.writeVRAM(0x2400 | i, nametable[i]);
            }
            this.enableComponents();
            this.renderBackground();
        }
    }

    private void redo() {
        PPU p = this.ppu;
        if (p != null && this.historyIndex < this.history.size()) {
            ++this.historyIndex;
            int[] nametable = this.history.get(this.historyIndex - 1);
            for (int i = nametable.length - 1; i >= 0; --i) {
                p.writeVRAM(0x2400 | i, nametable[i]);
            }
            this.enableComponents();
            this.renderBackground();
        }
    }

    private void enableComponents() {
        if (this.ppu == null) {
            this.undoMenuItem.setEnabled(false);
            this.redoMenuItem.setEnabled(false);
        } else {
            this.undoMenuItem.setEnabled(this.historyIndex > 1);
            this.redoMenuItem.setEnabled(this.historyIndex < this.history.size());
        }
    }

    private void readNametable(PPU ppu) {
        this.readNametable(ppu, this.attributes, this.tiles);
    }

    private void readNametable(PPU ppu, int[][] attributes, int[][] tiles) {
        int tileY;
        int address = 9216;
        int attributeAddress = address | 0x3C0;
        for (tileY = 0; tileY < 16; tileY += 2) {
            int tileX = 0;
            while (tileX < 16) {
                int attribute = ppu.peekVRAM(attributeAddress);
                for (int y = 0; y < 2; ++y) {
                    int yOffset = tileY | y;
                    for (int x = 0; x < 2; ++x) {
                        attributes[yOffset][tileX | x] = attribute & 3;
                        attribute >>= 2;
                    }
                }
                tileX += 2;
                ++attributeAddress;
            }
        }
        address += 66;
        for (tileY = 2; tileY < 23; ++tileY) {
            int tileX = 2;
            while (tileX < 30) {
                tiles[tileY][tileX] = ppu.peekVRAM(address);
                ++tileX;
                ++address;
            }
            address += 4;
        }
    }

    private void drawNametable(PPU ppu, int x0, int y0, int x1, int y1, int[][] attributes, int[][] tiles, int[] screen, int width) {
        int backgroundPatternTableAddress = ppu.getBackgroundPatternTableAddress();
        for (int tileY = y0; tileY <= y1; ++tileY) {
            int tileY2 = tileY >> 1;
            int yOffset = tileY - y0 << 3;
            for (int tileX = x0; tileX <= x1; ++tileX) {
                int xOffset = tileX - x0 << 3;
                int[] cols = this.colors[attributes[tileY2][tileX >> 1]];
                int address0 = backgroundPatternTableAddress | tiles[tileY][tileX] << 4;
                int address1 = address0 + 8;
                for (int y = 0; y < 8; ++y) {
                    int yOff = width * (yOffset + y);
                    int b0 = ppu.peekVRAM(address0 + y);
                    int b1 = ppu.peekVRAM(address1 + y);
                    for (int x = 0; x < 8; ++x) {
                        int shift = 7 - x;
                        screen[yOff + xOffset + x] = cols[(b1 >> shift & 1) << 1 | b0 >> shift & 1];
                    }
                }
            }
        }
    }

    private void writeNametable(PPU ppu) {
        int tileY;
        int address = 9216;
        int attributeAddress = address | 0x3C0;
        for (tileY = 0; tileY < 16; tileY += 2) {
            int tileX = 0;
            while (tileX < 16) {
                int attribute = 0;
                for (int y = 1; y >= 0; --y) {
                    for (int x = 1; x >= 0; --x) {
                        attribute = attribute << 2 | this.attributes[tileY | y][tileX | x];
                    }
                }
                ppu.writeVRAM(attributeAddress, attribute);
                tileX += 2;
                ++attributeAddress;
            }
        }
        address += 66;
        for (tileY = 2; tileY < 23; ++tileY) {
            int tileX = 2;
            while (tileX < 30) {
                ppu.writeVRAM(address, this.tiles[tileY][tileX]);
                ++tileX;
                ++address;
            }
            address += 4;
        }
    }

    private void drawBackground(PPU ppu, int[] screen) {
        block10: {
            block9: {
                int temp;
                int y1;
                this.readNametable(ppu);
                this.drawNametable(ppu, 2, 2, 29, 22, this.attributes, this.tiles, screen, 224);
                if (this.backgroundDrawBox) {
                    int i;
                    int boxY;
                    int boxX = this.backgroundBoxX;
                    int y0 = boxY = this.backgroundBoxY;
                    y1 = boxY + 1568;
                    for (i = 7; i >= 0; --i) {
                        int n = y0 + boxX + i;
                        screen[n] = screen[n] ^ 0xFFFFFF;
                        int n2 = y1 + boxX + i;
                        screen[n2] = screen[n2] ^ 0xFFFFFF;
                    }
                    for (i = 6; i >= 1; --i) {
                        int offset;
                        int n = offset = boxY + 224 * i + boxX;
                        screen[n] = screen[n] ^ 0xFFFFFF;
                        int n3 = offset + 7;
                        screen[n3] = screen[n3] ^ 0xFFFFFF;
                    }
                }
                if (this.mode != Mode.SelectAndCopy || this.selectX0 < 0) break block9;
                int x0 = this.selectX0 - 2;
                int y0 = this.selectY0 - 2;
                int x1 = this.selectX1 - 2;
                y1 = this.selectY1 - 2;
                if (x0 > x1) {
                    temp = x0;
                    x0 = x1;
                    x1 = temp;
                }
                if (y0 > y1) {
                    temp = y0;
                    y0 = y1;
                    y1 = temp;
                }
                x1 = (x1 << 3) + 7;
                y1 = (y1 << 3) + 7;
                int Y0 = 224 * (y0 <<= 3);
                int Y1 = 224 * y1;
                for (int x = x0 <<= 3; x <= x1; ++x) {
                    int n = Y0 + x;
                    screen[n] = screen[n] ^ 0xFFFFFF;
                    int n4 = Y1 + x;
                    screen[n4] = screen[n4] ^ 0xFFFFFF;
                }
                for (int y = y0 + 1; y < y1; ++y) {
                    int Y = 224 * y;
                    int n = Y + x0;
                    screen[n] = screen[n] ^ 0xFFFFFF;
                    int n5 = Y + x1;
                    screen[n5] = screen[n5] ^ 0xFFFFFF;
                }
                break block10;
            }
            if (this.mode != Mode.Paste || this.copyScreen == null || !this.drawCopy) break block10;
            for (int y = this.copyImageHeight - 1; y >= 0; --y) {
                int Y = this.copyImageY + y;
                if (Y < 0 || Y >= 168) continue;
                int offsetY = 224 * Y;
                int oy = this.copyImageWidth * y;
                for (int x = this.copyImageWidth - 1; x >= 0; --x) {
                    int pixel;
                    int X = this.copyImageX + x;
                    if (X < 0 || X >= 224 || (pixel = this.copyScreen[oy + x]) < 0) continue;
                    screen[offsetY + X] = pixel;
                }
            }
        }
    }

    private void setPatternTableDrawBox(int x, int y) {
        this.patternTableBoxX = x & 0x78;
        this.patternTableBoxY = y & 0x78;
        this.patternTableDrawBox = true;
        this.renderPatternTable();
    }

    private void patternTableMouseUpdated(int x, int y) {
        this.setPatternTableDrawBox(x, y);
    }

    private void patternTableMousePressed(int x, int y) {
        this.selectedPattern = y >> 3 << 4 | x >> 3;
        this.patternTableDrawBox = false;
        this.renderPatternTable();
        this.drawPattern();
        this.setPatternTableDrawBox(x, y);
        this.updateGraphic();
    }

    private void patternTableMouseOutOfBounds() {
        this.patternTableDrawBox = false;
        this.renderPatternTable();
    }

    private void setPaletteDrawBox(int y) {
        this.paletteBoxY = (y & 0x18) << 5;
        this.paletteDrawBox = true;
        this.renderPalette();
    }

    private void paletteMouseUpdated(int x, int y) {
        this.setPaletteDrawBox(y);
    }

    private void paletteMousePressed(int x, int y) {
        this.selectedPalette = y >> 3;
        this.patternTableDrawBox = false;
        this.renderPatternTable();
        this.drawPattern();
        this.setPaletteDrawBox(y);
        this.updateGraphic();
        if (this.copyMessage != null) {
            this.copy(this.copyMessage);
        }
    }

    private void paletteMouseOutOfBounds() {
        this.paletteDrawBox = false;
        this.renderPalette();
    }

    private void setBackgroundDrawBox(int x, int y) {
        this.backgroundBoxX = x & 0xF8;
        this.backgroundBoxY = 224 * (y & 0xF8);
        this.backgroundDrawBox = true;
        this.coordinatesLabel.setText(String.format("X: %02d, Y: %02d", x >> 3, y >> 3));
        this.renderBackground();
    }

    private void backgroundMouseUpdated(int x, int y) {
        this.setBackgroundDrawBox(x, y);
    }

    private void backgroundMousePressed(int x, int y) {
        PPU p = this.ppu;
        if (p != null) {
            int tileX = 2 + (x >> 3);
            int tileY = 2 + (y >> 3);
            switch (this.mode) {
                case Draw: {
                    this.draw(p, tileX, tileY);
                    break;
                }
                case Fill: {
                    this.fill(p, tileX, tileY);
                }
            }
            this.setBackgroundDrawBox(x, y);
        }
    }

    private void draw(PPU ppu, int tileX, int tileY) {
        this.writeAttribute(ppu, tileX, tileY, this.selectedPalette);
        this.writeTile(ppu, tileX, tileY, this.selectedPattern);
        this.saveState();
    }

    private void fill(PPU ppu, int tileX, int tileY) {
        this.readNametable(ppu);
        int targetAttribute = this.attributes[tileY >> 1][tileX >> 1];
        int targetTile = this.tiles[tileY][tileX];
        if (targetAttribute != this.selectedPalette || targetTile != this.selectedPattern) {
            int j;
            int i2;
            int i;
            for (i = 31; i >= 0; --i) {
                i2 = i >> 1;
                for (j = 31; j >= 0; --j) {
                    this.fills[i][j] = this.attributes[i2][j >> 1] == targetAttribute && this.tiles[i][j] == targetTile ? Fill.Target : Fill.Empty;
                }
            }
            this.floodFill(ppu, tileX, tileY);
            for (i = 31; i >= 0; --i) {
                i2 = i >> 1;
                for (j = 31; j >= 0; --j) {
                    if (this.fills[i][j] != Fill.Filled) continue;
                    this.attributes[i2][j >> 1] = this.selectedPalette;
                    this.tiles[i][j] = this.selectedPattern;
                }
            }
            this.writeNametable(ppu);
            this.renderBackground();
            this.saveState();
        }
    }

    private void floodFill(PPU ppu, int tileX, int tileY) {
        int x;
        int x1;
        int x0;
        if (tileY < 0 || tileY > 29 || tileX < 0 || tileX > 31 || this.fills[tileY][tileX] != Fill.Target) {
            return;
        }
        for (x0 = tileX - 1; x0 >= 0 && this.fills[tileY][x0] == Fill.Target; --x0) {
        }
        ++x0;
        for (x1 = tileX + 1; x1 < 32 && this.fills[tileY][x1] == Fill.Target; ++x1) {
        }
        for (x = x0; x < x1; ++x) {
            this.fills[tileY][x] = Fill.Filled;
        }
        for (x = x0; x < x1; ++x) {
            this.floodFill(ppu, x, tileY - 1);
        }
        for (x = x0; x < x1; ++x) {
            this.floodFill(ppu, x, tileY + 1);
        }
    }

    private void backgroundMouseOutOfBounds() {
        this.backgroundDrawBox = false;
        this.clearCoordinatesLabel();
        this.renderBackground();
    }

    private void clearCoordinatesLabel() {
        this.coordinatesLabel.setText("");
    }

    private void updateGraphic() {
        int graphic = -1;
        if (this.selectedPattern < 32) {
            graphic = this.selectedPattern;
        } else if (this.selectedPattern >= 184) {
            graphic = this.selectedPattern - 152;
        }
        if (graphic >= 0) {
            this.setGraphic(String.format("%c%c%c", Character.valueOf((char)(65 + (graphic >> 3))), Character.valueOf((char)(48 + (graphic & 7))), Character.valueOf((char)(48 + this.selectedPalette))));
        } else {
            this.setGraphic("");
        }
    }

    private void setGraphic(String graphic) {
        this.graphicTextField.getDocument().removeDocumentListener(this.graphicListener);
        this.graphicTextField.setText(graphic);
        this.graphicTextField.getDocument().addDocumentListener(this.graphicListener);
        this.requestFocusInWindow();
    }

    private void graphicEdited() {
        String name = this.graphicTextField.getText().trim();
        if (name.length() == 3) {
            char c0 = Character.toUpperCase(name.charAt(0));
            char c1 = name.charAt(1);
            char c2 = name.charAt(2);
            if (c0 >= 'A' && c0 <= 'M' && c1 >= '0' && c1 <= '7' && c2 >= '0' && c2 <= '3') {
                int index = c0 - 65 << 3 | c1 - 48;
                this.selectedPattern = index < 32 ? index : index + 152;
                this.selectedPalette = c2 - 48;
                this.renderPatternTable();
                this.renderBackground();
                this.drawPattern();
            }
        }
    }

    private static void loadBackground(Window parent, File file, PleaseWaitDialog pleaseWaitDialog) {
        if (GuiUtil.executeMessageTask(parent, pleaseWaitDialog, () -> FamilyBasicUtil.loadBackground(file))) {
            backgroundFile = file;
            if (parent instanceof BackgroundEditorFrame) {
                BackgroundEditorFrame frame = (BackgroundEditorFrame)parent;
                frame.renderBackground();
                frame.saveState();
            }
        }
    }

    private static void saveBackground(Window parent, File file, PleaseWaitDialog pleaseWaitDialog) {
        if (GuiUtil.executeMessageTask(parent, pleaseWaitDialog, () -> FamilyBasicUtil.saveBackground(file))) {
            backgroundFile = file;
        }
    }

    public static void open(Window parent) {
        BackgroundEditorFrame.open(parent, null);
    }

    public static void open(Window parent, Component source) {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Load Background", AppPrefs.getInstance().getPaths().getBackgroundDir(), (FileFilter[])BackgroundFileExtensionFilters);
        if (GuiUtil.showOpenDialog(parent, chooser, (p, d) -> p.setBackgroundDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog(parent);
            new Thread(() -> BackgroundEditorFrame.loadBackground(parent, selectedFile, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    public static void saveAs(Window parent) {
        BackgroundEditorFrame.saveAs(parent, null);
    }

    public static void saveAs(Window parent, Component source) {
        App.setNoStepPause(true);
        AppPrefs prefs = AppPrefs.getInstance();
        Paths paths = prefs.getPaths();
        File file = GuiUtil.showSaveAsDialog(parent, paths.getBackgroundDir(), backgroundFile == null ? null : backgroundFile.getName(), "background", BackgroundFileExtensionFilters[0], true);
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setBackgroundDir(dir);
            AppPrefs.save();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog(parent);
            new Thread(() -> BackgroundEditorFrame.saveBackground(parent, file, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void initComponents() {
        this.modeButtonGroup = new ButtonGroup();
        this.backgroundPanel = new ImagePanel(224, 168, 2);
        this.patternTablePanel = new ImagePanel(128, 128, 4);
        this.backgroundLabel = new JLabel();
        this.patternTableLabel = new JLabel();
        this.patternLabel = new JLabel();
        this.patternPanel = new ImagePanel(8, 8, 16);
        this.paletteLabel = new JLabel();
        this.palettePanel = new ImagePanel(32, 32, 4);
        this.modePanel = new JPanel();
        this.drawRadioButton = new JRadioButton();
        this.fillRadioButton = new JRadioButton();
        this.selectAndCopyRadioButton = new JRadioButton();
        this.pasteRadioButton = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.closeButton = new JButton();
        this.resizeButton = new JButton();
        this.graphicLabel = new JLabel();
        this.graphicTextField = new JTextField();
        this.textButton = new JButton();
        this.coordinatesLabel = new JLabel();
        this.modeLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Family BASIC Background Editor");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BackgroundEditorFrame.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setMaximumSize(null);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 359, Short.MAX_VALUE));
        this.patternTablePanel.setMaximumSize(null);
        this.patternTablePanel.setPreferredSize(new Dimension(128, 512));
        GroupLayout patternTablePanelLayout = new GroupLayout(this.patternTablePanel);
        this.patternTablePanel.setLayout(patternTablePanelLayout);
        patternTablePanelLayout.setHorizontalGroup(patternTablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        patternTablePanelLayout.setVerticalGroup(patternTablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.backgroundLabel.setText("Background");
        this.backgroundLabel.setMaximumSize(null);
        this.backgroundLabel.setMinimumSize(null);
        this.backgroundLabel.setPreferredSize(null);
        this.patternTableLabel.setText("Pattern Table");
        this.patternTableLabel.setMaximumSize(null);
        this.patternTableLabel.setMinimumSize(null);
        this.patternTableLabel.setPreferredSize(null);
        this.patternLabel.setText("Pattern");
        this.patternLabel.setMaximumSize(null);
        this.patternLabel.setMinimumSize(null);
        this.patternLabel.setPreferredSize(null);
        this.patternPanel.setMaximumSize(null);
        this.patternPanel.setPreferredSize(new Dimension(128, 128));
        GroupLayout patternPanelLayout = new GroupLayout(this.patternPanel);
        this.patternPanel.setLayout(patternPanelLayout);
        patternPanelLayout.setHorizontalGroup(patternPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        patternPanelLayout.setVerticalGroup(patternPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.paletteLabel.setText("Palette");
        this.paletteLabel.setMaximumSize(null);
        this.paletteLabel.setMinimumSize(null);
        this.paletteLabel.setPreferredSize(null);
        this.palettePanel.setMaximumSize(null);
        this.palettePanel.setPreferredSize(new Dimension(128, 128));
        GroupLayout palettePanelLayout = new GroupLayout(this.palettePanel);
        this.palettePanel.setLayout(palettePanelLayout);
        palettePanelLayout.setHorizontalGroup(palettePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        palettePanelLayout.setVerticalGroup(palettePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 127, Short.MAX_VALUE));
        this.modeButtonGroup.add(this.drawRadioButton);
        this.drawRadioButton.setSelected(true);
        this.drawRadioButton.setText("Draw");
        this.drawRadioButton.setFocusPainted(false);
        this.drawRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.drawRadioButtonActionPerformed(evt);
            }
        });
        this.modeButtonGroup.add(this.fillRadioButton);
        this.fillRadioButton.setText("Fill");
        this.fillRadioButton.setFocusPainted(false);
        this.fillRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.fillRadioButtonActionPerformed(evt);
            }
        });
        this.modeButtonGroup.add(this.selectAndCopyRadioButton);
        this.selectAndCopyRadioButton.setText("Select & Copy");
        this.selectAndCopyRadioButton.setFocusPainted(false);
        this.selectAndCopyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.selectAndCopyRadioButtonActionPerformed(evt);
            }
        });
        this.modeButtonGroup.add(this.pasteRadioButton);
        this.pasteRadioButton.setText("Paste");
        this.pasteRadioButton.setEnabled(false);
        this.pasteRadioButton.setFocusPainted(false);
        this.pasteRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.pasteRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout modePanelLayout = new GroupLayout(this.modePanel);
        this.modePanel.setLayout(modePanelLayout);
        modePanelLayout.setHorizontalGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modePanelLayout.createSequentialGroup().addContainerGap().addGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drawRadioButton).addComponent(this.fillRadioButton).addComponent(this.selectAndCopyRadioButton).addComponent(this.pasteRadioButton)).addContainerGap()));
        modePanelLayout.setVerticalGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.drawRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fillRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAndCopyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pasteRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setMaximumSize(null);
        this.closeButton.setMnemonic('C');
        this.closeButton.setText("Close");
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.resizeButton.setMnemonic('R');
        this.resizeButton.setText("Resize");
        this.resizeButton.setFocusPainted(false);
        this.resizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.resizeButtonActionPerformed(evt);
            }
        });
        this.graphicLabel.setText("Graphic:");
        this.graphicTextField.setColumns(4);
        this.graphicTextField.setText("A00");
        this.textButton.setMnemonic('T');
        this.textButton.setText("Text");
        this.textButton.setFocusPainted(false);
        this.textButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.textButtonActionPerformed(evt);
            }
        });
        this.coordinatesLabel.setText("             ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.graphicLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphicTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.coordinatesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.textButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resizeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()));
        jPanel1Layout.linkSize(0, this.closeButton, this.resizeButton, this.textButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.graphicLabel).addComponent(this.graphicTextField, -2, -1, -2).addComponent(this.resizeButton).addComponent(this.closeButton).addComponent(this.textButton).addComponent(this.coordinatesLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.modeLabel.setText("Mode:");
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open...");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.saveAsMenuItem.setMnemonic('A');
        this.saveAsMenuItem.setText("Save As...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.closeMenuItem.setMnemonic('C');
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.setMnemonic('U');
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.setMnemonic('R');
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundEditorFrame.this.redoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.menuBar.add(this.editMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternPanel, -1, -1, -2).addComponent(this.patternLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.palettePanel, -1, -1, -2).addComponent(this.paletteLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modeLabel).addComponent(this.modePanel, -2, -1, -2)))).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternTableLabel, -2, -1, -2).addComponent(this.patternTablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.backgroundLabel, -2, -1, -2).addComponent(this.patternTableLabel, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.patternTablePanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternLabel, -2, -1, -2).addComponent(this.paletteLabel, -2, -1, -2).addComponent(this.modeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modePanel, -1, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.palettePanel, GroupLayout.Alignment.LEADING, -1, 127, Short.MAX_VALUE).addComponent(this.patternPanel, GroupLayout.Alignment.LEADING, -1, 127, Short.MAX_VALUE))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, -2)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void drawRadioButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.Draw);
    }

    private void fillRadioButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.Fill);
    }

    private void selectAndCopyRadioButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.SelectAndCopy);
    }

    private void pasteRadioButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.Paste);
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        this.undo();
    }

    private void redoMenuItemActionPerformed(ActionEvent evt) {
        this.redo();
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void resizeButtonActionPerformed(ActionEvent evt) {
        this.pack();
    }

    private void textButtonActionPerformed(ActionEvent evt) {
        InputTextAreaDialog dialog = new InputTextAreaDialog((Window)this, "Enter a message, press OK and then click on the background to paste.", "Text Entry");
        dialog.setTextRequired();
        dialog.setDimensions(28, 5);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.copy(dialog.getInput());
            this.setMode(Mode.Paste);
        }
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        BackgroundEditorFrame.saveAs(this);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (backgroundFile == null) {
            BackgroundEditorFrame.saveAs(this);
        } else {
            App.setNoStepPause(true);
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> BackgroundEditorFrame.saveBackground(this, backgroundFile, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        BackgroundEditorFrame.open(this, this.menuBar);
    }

    private class PasteListener
    implements MouseMotionListener,
    MouseListener {
        private PasteListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BackgroundEditorFrame.this.drawCopy = false;
            BackgroundEditorFrame.this.backgroundDrawBox = false;
            BackgroundEditorFrame.this.renderBackground();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BackgroundEditorFrame.this.drawCopy = true;
            BackgroundEditorFrame.this.backgroundDrawBox = false;
            BackgroundEditorFrame.this.copyImageX = (e.getX() >> 3) + BackgroundEditorFrame.this.copyOffsetX << 3;
            BackgroundEditorFrame.this.copyImageY = (e.getY() >> 3) + BackgroundEditorFrame.this.copyOffsetY << 3;
            BackgroundEditorFrame.this.renderBackground();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BackgroundEditorFrame.this.drawCopy = false;
            BackgroundEditorFrame.this.backgroundDrawBox = false;
            BackgroundEditorFrame.this.paste(2 + (e.getX() >> 3) + BackgroundEditorFrame.this.copyOffsetX - BackgroundEditorFrame.this.selectX0, 2 + (e.getY() >> 3) + BackgroundEditorFrame.this.copyOffsetY - BackgroundEditorFrame.this.selectY0);
            BackgroundEditorFrame.this.renderBackground();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class SelectAndCopyListener
    implements MouseMotionListener,
    MouseListener {
        private SelectAndCopyListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BackgroundEditorFrame.this.selectX1 = 2 + (e.getX() >> 3);
            BackgroundEditorFrame.this.selectY1 = 2 + (e.getY() >> 3);
            BackgroundEditorFrame.this.backgroundDrawBox = false;
            BackgroundEditorFrame.this.renderBackground();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BackgroundEditorFrame.this.setBackgroundDrawBox(e.getX(), e.getY());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BackgroundEditorFrame.this.selectX0 = (BackgroundEditorFrame.this.selectX1 = 2 + (e.getX() >> 3));
            BackgroundEditorFrame.this.selectY0 = (BackgroundEditorFrame.this.selectY1 = 2 + (e.getY() >> 3));
            BackgroundEditorFrame.this.backgroundDrawBox = false;
            BackgroundEditorFrame.this.renderBackground();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            BackgroundEditorFrame.this.selectX1 = 2 + (e.getX() >> 3);
            BackgroundEditorFrame.this.selectY1 = 2 + (e.getY() >> 3);
            BackgroundEditorFrame.this.copy();
            BackgroundEditorFrame.this.setMode(Mode.Paste);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BackgroundEditorFrame.this.setBackgroundDrawBox(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundDrawBox = false;
            BackgroundEditorFrame.this.renderBackground();
        }
    }

    private class DrawAndFillListener
    implements MouseMotionListener,
    MouseListener {
        private DrawAndFillListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMouseUpdated(e.getX(), e.getY());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMousePressed(e.getX(), e.getY());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMouseUpdated(e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMousePressed(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMouseUpdated(e.getX(), e.getY());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMouseUpdated(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BackgroundEditorFrame.this.backgroundMouseOutOfBounds();
        }
    }

    private static enum Fill {
        Empty,
        Target,
        Filled;

    }

    private static enum Mode {
        Draw,
        Fill,
        SelectAndCopy,
        Paste;

    }
}

