/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.exportmedia;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import nintaco.App;
import nintaco.gui.exportmedia.preferences.ExportMediaFilePrefs;
import nintaco.gui.exportmedia.preferences.FramesOption;
import nintaco.gui.image.filters.VideoFilter;
import nintaco.gui.image.filters.VideoFilterDescriptor;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.PixelAspectRatio;
import nintaco.tv.ScreenBorders;
import nintaco.tv.TVSystem;
import nintaco.util.ThreadUtil;

public class ImageConverter {
    private final ExportMediaFilePrefs prefs;
    private final TVSystem tvSystem;
    private final int[][] palettes = new int[2][512];
    private final boolean applyPalette;
    private final VideoFilter[] videoFilters;
    private final FilterThread[] filterThreads;
    private final BufferedImage scaleImage;
    private final int[] scaleData;
    private final Graphics2D scaleGraphics;
    private final BufferedImage mergeImage;
    private final int[] mergeData;
    private final FramesOption framesOption;
    private final int sx1;
    private final int sy1;
    private final int sx2;
    private final int sy2;
    private int runningThreads;
    private boolean oddFrame = true;
    private volatile BufferedImage image;
    private volatile int[] screen;
    private volatile boolean running = true;

    public ImageConverter(ExportMediaFilePrefs prefs, TVSystem tvSystem, boolean multithreaded) {
        int height;
        int width;
        double filterScaleY;
        double filterScaleX;
        int scale;
        this.prefs = new ExportMediaFilePrefs(prefs);
        this.tvSystem = tvSystem;
        this.framesOption = prefs.getFileType() == 2 ? FramesOption.SaveAll : prefs.getFramesOption();
        boolean crop = prefs.isCropBorders();
        ScreenBorders borders = tvSystem.getScreenBorders();
        PixelAspectRatio pixelAspectRatio = tvSystem.getPixelAspectRatio();
        double aspectRatio = prefs.isUseTvAspectRatio() ? (double)pixelAspectRatio.horizontal / (double)pixelAspectRatio.vertical : 1.0;
        VideoFilterDescriptor filterDescriptor = prefs.getVideoFilter();
        if (filterDescriptor == VideoFilterDescriptor.Current) {
            filterDescriptor = App.getImageFrame().getImagePane().getVideoFilterDescriptor();
            if (filterDescriptor == null) {
                filterDescriptor = VideoFilterDescriptor.NoFilter;
                scale = 1;
            } else {
                scale = filterDescriptor.getScale();
            }
        } else {
            scale = prefs.getScale();
        }
        this.applyPalette = filterDescriptor != VideoFilterDescriptor.Ntsc;
        String paletteName = prefs.getPalette();
        if ("[current]".equals(paletteName)) {
            int[][] extendedPalettes = PaletteUtil.getExtendedPalettes();
            System.arraycopy(extendedPalettes[0], 0, this.palettes[0], 0, this.palettes[0].length);
            System.arraycopy(extendedPalettes[1], 0, this.palettes[1], 0, this.palettes[1].length);
        } else {
            int[] pal = new int[64];
            AppPrefs.getInstance().getPalettes().getPalette(paletteName, pal);
            PaletteUtil.extendPalette(pal, this.palettes);
        }
        if (filterDescriptor != VideoFilterDescriptor.NoFilter) {
            this.videoFilters = filterDescriptor.createFilters(Math.max(1, multithreaded ? Runtime.getRuntime().availableProcessors() : 1), this.palettes);
            if (!multithreaded) {
                this.videoFilters[0].setGhosting(false);
            }
            filterScaleX = (double)filterDescriptor.getWidth() / 256.0;
            filterScaleY = (double)filterDescriptor.getHeight() / 240.0;
            if (multithreaded) {
                this.filterThreads = new FilterThread[this.videoFilters.length];
                int scanlines = 240 / this.filterThreads.length;
                for (int i = this.filterThreads.length - 1; i >= 0; --i) {
                    this.filterThreads[i] = new FilterThread(this.videoFilters[i], i * scanlines, i == this.filterThreads.length - 1 ? 240 : (i + 1) * scanlines);
                    this.filterThreads[i].start();
                }
            } else {
                this.filterThreads = null;
            }
        } else {
            this.videoFilters = null;
            this.filterThreads = null;
            filterScaleY = 1.0;
            filterScaleX = 1.0;
        }
        if (crop) {
            this.sx1 = (int)Math.round(filterScaleX * (double)borders.getLeft());
            this.sy1 = (int)Math.round(filterScaleY * (double)borders.getTop());
            this.sx2 = (int)Math.round(filterScaleX * (double)(256 - borders.getRight()));
            this.sy2 = (int)Math.round(filterScaleY * (double)(240 - borders.getBottom()));
        } else {
            this.sx1 = 0;
            this.sy1 = 0;
            this.sx2 = (int)Math.round(filterScaleX * 256.0);
            this.sy2 = (int)Math.round(filterScaleY * 240.0);
        }
        if (scale != 1 || filterDescriptor != VideoFilterDescriptor.NoFilter && (filterScaleX != (double)scale || filterScaleY != (double)scale) || aspectRatio != 1.0 || crop) {
            if (crop) {
                width = (int)Math.round(aspectRatio * (double)scale * (double)(256 - borders.getLeft() - borders.getRight()));
                height = scale * (240 - borders.getTop() - borders.getBottom());
            } else {
                width = (int)Math.round(aspectRatio * (double)scale * 256.0);
                height = scale * 240;
            }
            this.scaleImage = new BufferedImage(width, height, 1);
            this.scaleGraphics = this.scaleImage.createGraphics();
            if (prefs.isSmoothScaling()) {
                this.scaleGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
        } else {
            this.scaleImage = null;
            this.scaleGraphics = null;
        }
        if (this.framesOption == FramesOption.Interlace || this.framesOption == FramesOption.Merge) {
            if (this.scaleImage != null) {
                width = this.scaleImage.getWidth();
                height = this.scaleImage.getHeight();
            } else if (this.videoFilters != null) {
                BufferedImage img = this.videoFilters[0].getImage();
                width = img.getWidth();
                height = img.getHeight();
            } else {
                width = 256;
                height = 240;
            }
            this.mergeImage = new BufferedImage(width, height, 1);
            this.mergeData = ((DataBufferInt)this.mergeImage.getRaster().getDataBuffer()).getData();
            this.scaleData = ((DataBufferInt)this.scaleImage.getRaster().getDataBuffer()).getData();
        } else {
            this.mergeImage = null;
            this.mergeData = null;
            this.scaleData = null;
        }
    }

    public TVSystem getTvSystem() {
        return this.tvSystem;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.screen = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BufferedImage convert() {
        boolean bl = this.oddFrame = !this.oddFrame;
        if (this.applyPalette) {
            PaletteUtil.applyPalette(this.screen, this.palettes[this.tvSystem == TVSystem.NTSC ? 0 : 1]);
        }
        BufferedImage img = this.image;
        if (this.videoFilters != null) {
            if (this.filterThreads == null) {
                this.videoFilters[0].filter(this.screen, 0, 240);
            } else {
                Class<FilterThread> clazz = FilterThread.class;
                // MONITORENTER : nintaco.gui.exportmedia.ImageConverter$FilterThread.class
                this.runningThreads = this.filterThreads.length;
                for (int i = this.filterThreads.length - 1; i >= 0; --i) {
                    this.filterThreads[i].execute();
                }
                while (this.runningThreads != 0 && this.running) {
                    ThreadUtil.threadWait(FilterThread.class);
                }
                if (!this.running) {
                    // MONITOREXIT : clazz
                    return img;
                }
                // MONITOREXIT : clazz
            }
            img = this.videoFilters[0].getImage();
        }
        if (this.scaleGraphics != null) {
            try {
                this.scaleGraphics.drawImage(img, 0, 0, this.scaleImage.getWidth(), this.scaleImage.getHeight(), this.sx1, this.sy1, this.sx2, this.sy2, null);
                img = this.scaleImage;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.framesOption == FramesOption.Interlace) {
            int y;
            int n = y = this.oddFrame ? 1 : 0;
            while (y < this.scaleImage.getHeight()) {
                int offset = y * this.scaleImage.getWidth();
                System.arraycopy(this.scaleData, offset, this.mergeData, offset, this.scaleImage.getWidth());
                y += 2;
            }
            img = this.mergeImage;
        } else if (this.framesOption == FramesOption.Merge) {
            if (this.oddFrame) {
                for (int i = this.mergeData.length - 1; i >= 0; --i) {
                    int m = this.mergeData[i];
                    int rm = m >> 16 & 0xFF;
                    int gm = m >> 8 & 0xFF;
                    int bm = m & 0xFF;
                    int s = this.scaleData[i];
                    int rs = s >> 16 & 0xFF;
                    int gs = s >> 8 & 0xFF;
                    int bs = s & 0xFF;
                    this.mergeData[i] = rm + rs >> 1 << 16 | gm + gs >> 1 << 8 | bm + bs >> 1;
                }
                img = this.mergeImage;
            } else {
                System.arraycopy(this.scaleData, 0, this.mergeData, 0, this.scaleData.length);
            }
        }
        if (this.framesOption != FramesOption.SaveAll && !this.oddFrame) {
            return null;
        }
        BufferedImage bufferedImage = img;
        return bufferedImage;
    }

    public int getWidth() {
        if (this.scaleImage != null) {
            return this.scaleImage.getWidth();
        }
        if (this.videoFilters != null) {
            return this.videoFilters[0].getImage().getWidth();
        }
        return this.image.getWidth();
    }

    public int getHeight() {
        if (this.scaleImage != null) {
            return this.scaleImage.getHeight();
        }
        if (this.videoFilters != null) {
            return this.videoFilters[0].getImage().getHeight();
        }
        return this.image.getHeight();
    }

    public ExportMediaFilePrefs getPrefs() {
        return this.prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<FilterThread> clazz = FilterThread.class;
        synchronized (FilterThread.class) {
            this.running = false;
            FilterThread.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.filterThreads != null) {
                for (int i = this.filterThreads.length - 1; i >= 0; --i) {
                    this.filterThreads[i].dispose();
                }
            }
            if (this.videoFilters != null) {
                for (int i = this.videoFilters.length - 1; i >= 0; --i) {
                    this.videoFilters[i].dispose();
                }
            }
            if (this.scaleGraphics != null) {
                this.scaleGraphics.dispose();
            }
            if (this.scaleImage != null) {
                this.scaleImage.flush();
            }
            return;
        }
    }

    private class FilterThread
    extends Thread {
        private final VideoFilter videoFilter;
        private final int yFirst;
        private final int yLast;
        private boolean execute;

        public FilterThread(VideoFilter videoFilter, int yFirst, int yLast) {
            this.videoFilter = videoFilter;
            this.yFirst = yFirst;
            this.yLast = yLast;
        }

        public synchronized void execute() {
            this.execute = true;
            this.notifyAll();
        }

        private synchronized void waitForExecute() {
            while (!this.execute && ImageConverter.this.running) {
                ThreadUtil.threadWait(this);
            }
            this.execute = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (ImageConverter.this.running) {
                this.waitForExecute();
                if (!ImageConverter.this.running) continue;
                this.videoFilter.filter(ImageConverter.this.screen, this.yFirst, this.yLast);
                Class<FilterThread> clazz = FilterThread.class;
                // MONITORENTER : nintaco.gui.exportmedia.ImageConverter$FilterThread.class
                ImageConverter.this.runningThreads--;
                FilterThread.class.notifyAll();
                // MONITOREXIT : clazz
            }
        }

        public synchronized void dispose() {
            this.notifyAll();
        }
    }
}

