/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.logger;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.disassembler.LogPrefs;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.debugger.logger.LoggerAppPrefs;
import nintaco.gui.image.preferences.Paths;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class LoggerDialog
extends JDialog {
    private final DocumentListener textFieldListener = GuiUtil.createDocumentListener(this::updateOkButton);
    private boolean ok;
    private JCheckBox aCheckBox;
    private JLabel addressLabel;
    private JCheckBox addressLabelsCheckBox;
    private JTextField addressesTextField;
    private JCheckBox apuStatusCheckBox;
    private JCheckBox bankCheckBox;
    private JComboBox branchesComboBox;
    private JButton browseButton;
    private JButton cancelButton;
    private JCheckBox controller1CheckBox;
    private JCheckBox controller2CheckBox;
    private JPanel countersPanel;
    private JCheckBox cpuCounterCheckBox;
    private JPanel cpuRegistersPanel;
    private JCheckBox dotCheckBox;
    private JPanel executionPanel;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JCheckBox fineXCheckBox;
    private JPanel formattingPanel;
    private JCheckBox frameCounterCheckBox;
    private JCheckBox inspectionsCheckBox;
    private JCheckBox instructionCheckBox;
    private JCheckBox instructionCounterCheckBox;
    private JComboBox logOrderComboBox;
    private JCheckBox machineCodeCheckBox;
    private JLabel maxLinesLabel;
    private JTextField maxLinesTextField;
    private JCheckBox oamDataCheckBox;
    private JButton okButton;
    private JPanel otherRegistersPanel;
    private JComboBox pComboBox;
    private JComboBox pcComboBox;
    private JCheckBox ppuDataCheckBox;
    private JPanel ppuRegistersPanel;
    private JCheckBox ppuStatusCheckBox;
    private JCheckBox scanlineCheckBox;
    private JComboBox spComboBox;
    private JCheckBox tCheckBox;
    private JCheckBox tabBySpCheckBox;
    private JCheckBox vCheckBox;
    private JCheckBox wCheckBox;
    private JCheckBox xCheckBox;
    private JCheckBox yCheckBox;

    public LoggerDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.loadFields();
        this.initTextFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initTextFields() {
        GuiUtil.addLoseFocusListener((Window)this, this.fileTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.maxLinesTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.addressesTextField);
        this.fileTextField.getDocument().addDocumentListener(this.textFieldListener);
        this.maxLinesTextField.getDocument().addDocumentListener(this.textFieldListener);
    }

    public boolean isOk() {
        return this.ok;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void loadFields() {
        LoggerAppPrefs appPrefs = AppPrefs.getInstance().getLoggerAppPrefs();
        this.maxLinesTextField.setText(Integer.toString(appPrefs.getMaxLines()));
        LogPrefs prefs = appPrefs.getLogPrefs();
        this.frameCounterCheckBox.setSelected(prefs.frameCounter);
        this.cpuCounterCheckBox.setSelected(prefs.cpuCounter);
        this.instructionCounterCheckBox.setSelected(prefs.instructionCounter);
        this.scanlineCheckBox.setSelected(prefs.scanline);
        this.dotCheckBox.setSelected(prefs.dot);
        this.logOrderComboBox.setSelectedIndex(prefs.logBeforeExecute ? 0 : 1);
        this.bankCheckBox.setSelected(prefs.bank);
        this.machineCodeCheckBox.setSelected(prefs.machineCode);
        this.instructionCheckBox.setSelected(prefs.instruction);
        this.inspectionsCheckBox.setSelected(prefs.inspections);
        this.pcComboBox.setSelectedIndex(prefs.logPCType);
        this.aCheckBox.setSelected(prefs.A);
        this.xCheckBox.setSelected(prefs.X);
        this.yCheckBox.setSelected(prefs.Y);
        this.pComboBox.setSelectedIndex(prefs.logPType);
        this.spComboBox.setSelectedIndex(prefs.logSType);
        this.vCheckBox.setSelected(prefs.v);
        this.tCheckBox.setSelected(prefs.t);
        this.fineXCheckBox.setSelected(prefs.x);
        this.wCheckBox.setSelected(prefs.w);
        this.addressLabelsCheckBox.setSelected(prefs.addressLabels);
        this.tabBySpCheckBox.setSelected(prefs.tabBySP);
        this.branchesComboBox.setSelectedIndex(prefs.branchesType);
        HashSet<Integer> addresses = new HashSet<Integer>();
        if (prefs.addresses != null) {
            for (int address : prefs.addresses) {
                addresses.add(address);
            }
        }
        this.ppuStatusCheckBox.setSelected(addresses.contains(8194));
        this.oamDataCheckBox.setSelected(addresses.contains(8196));
        this.ppuDataCheckBox.setSelected(addresses.contains(8199));
        this.apuStatusCheckBox.setSelected(addresses.contains(16405));
        this.controller1CheckBox.setSelected(addresses.contains(16406));
        this.controller2CheckBox.setSelected(addresses.contains(16406));
        addresses.remove(8194);
        addresses.remove(8196);
        addresses.remove(8199);
        addresses.remove(16405);
        addresses.remove(16406);
        addresses.remove(16406);
        int[] as = new int[addresses.size()];
        int i = 0;
        Iterator iterator = addresses.iterator();
        while (iterator.hasNext()) {
            int address;
            address = (Integer)iterator.next();
            as[i++] = address;
        }
        Arrays.sort(as);
        StringBuilder sb = new StringBuilder();
        for (int address : as) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            StringUtil.append(sb, "%04X", address);
        }
        this.addressesTextField.setText(sb.toString());
        this.fileTextField.setText(GamePrefs.getInstance().getLoggerGamePrefs().getFileName());
    }

    private void saveFields() {
        String addressesText;
        LoggerAppPrefs appPrefs = AppPrefs.getInstance().getLoggerAppPrefs();
        appPrefs.setMaxLines(this.parseMaxLinesTextField());
        LogPrefs prefs = appPrefs.getLogPrefs();
        prefs.frameCounter = this.frameCounterCheckBox.isSelected();
        prefs.cpuCounter = this.cpuCounterCheckBox.isSelected();
        prefs.instructionCounter = this.instructionCounterCheckBox.isSelected();
        prefs.scanline = this.scanlineCheckBox.isSelected();
        prefs.dot = this.dotCheckBox.isSelected();
        prefs.logBeforeExecute = this.logOrderComboBox.getSelectedIndex() == 0;
        prefs.bank = this.bankCheckBox.isSelected();
        prefs.machineCode = this.machineCodeCheckBox.isSelected();
        prefs.instruction = this.instructionCheckBox.isSelected();
        prefs.inspections = this.inspectionsCheckBox.isSelected();
        prefs.logPCType = this.pcComboBox.getSelectedIndex();
        prefs.A = this.aCheckBox.isSelected();
        prefs.X = this.xCheckBox.isSelected();
        prefs.Y = this.yCheckBox.isSelected();
        prefs.logPType = this.pComboBox.getSelectedIndex();
        prefs.logSType = this.spComboBox.getSelectedIndex();
        prefs.v = this.vCheckBox.isSelected();
        prefs.t = this.tCheckBox.isSelected();
        prefs.x = this.fineXCheckBox.isSelected();
        prefs.w = this.wCheckBox.isSelected();
        prefs.addressLabels = this.addressLabelsCheckBox.isSelected();
        prefs.tabBySP = this.tabBySpCheckBox.isSelected();
        prefs.branchesType = this.branchesComboBox.getSelectedIndex();
        HashSet<Integer> addresses = new HashSet<Integer>();
        if (this.ppuStatusCheckBox.isSelected()) {
            addresses.add(8194);
        }
        if (this.oamDataCheckBox.isSelected()) {
            addresses.add(8196);
        }
        if (this.ppuDataCheckBox.isSelected()) {
            addresses.add(8199);
        }
        if (this.apuStatusCheckBox.isSelected()) {
            addresses.add(16405);
        }
        if (this.controller1CheckBox.isSelected()) {
            addresses.add(16406);
        }
        if (this.controller2CheckBox.isSelected()) {
            addresses.add(16406);
        }
        if (!(addressesText = this.addressesTextField.getText().trim()).isEmpty()) {
            for (String s : addressesText.split("[^0-9a-fA-F]+")) {
                int address = StringUtil.parseInt(s, true, 65535L);
                if (address < 0) continue;
                addresses.add(address);
            }
        }
        int[] as = new int[addresses.size()];
        int i = 0;
        Iterator iterator = addresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            as[i++] = address;
        }
        Arrays.sort(as);
        prefs.addresses = (int[])(as.length > 0 ? as : null);
        AppPrefs.save();
        GamePrefs.getInstance().getLoggerGamePrefs().setFileName(this.fileTextField.getText().trim());
        GamePrefs.save();
    }

    private int parseMaxLinesTextField() {
        Integer value = StringUtil.parseInt(this.maxLinesTextField.getText(), false, 1L, 10000000L);
        return value == null ? -1 : value;
    }

    private void updateOkButton() {
        this.okButton.setEnabled(!StringUtil.isBlank(this.fileTextField.getText()) && this.parseMaxLinesTextField() >= 1);
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.browseButton = new JButton();
        this.fileTextField = new JTextField();
        this.countersPanel = new JPanel();
        this.frameCounterCheckBox = new JCheckBox();
        this.cpuCounterCheckBox = new JCheckBox();
        this.scanlineCheckBox = new JCheckBox();
        this.dotCheckBox = new JCheckBox();
        this.instructionCounterCheckBox = new JCheckBox();
        this.executionPanel = new JPanel();
        this.machineCodeCheckBox = new JCheckBox();
        this.instructionCheckBox = new JCheckBox();
        this.inspectionsCheckBox = new JCheckBox();
        this.bankCheckBox = new JCheckBox();
        this.logOrderComboBox = new JComboBox();
        this.cpuRegistersPanel = new JPanel();
        this.aCheckBox = new JCheckBox();
        this.xCheckBox = new JCheckBox();
        this.yCheckBox = new JCheckBox();
        this.pComboBox = new JComboBox();
        this.spComboBox = new JComboBox();
        this.pcComboBox = new JComboBox();
        this.formattingPanel = new JPanel();
        this.addressLabelsCheckBox = new JCheckBox();
        this.tabBySpCheckBox = new JCheckBox();
        this.branchesComboBox = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.maxLinesLabel = new JLabel();
        this.maxLinesTextField = new JTextField();
        this.otherRegistersPanel = new JPanel();
        this.apuStatusCheckBox = new JCheckBox();
        this.controller1CheckBox = new JCheckBox();
        this.controller2CheckBox = new JCheckBox();
        this.addressLabel = new JLabel();
        this.addressesTextField = new JTextField();
        this.ppuRegistersPanel = new JPanel();
        this.ppuStatusCheckBox = new JCheckBox();
        this.oamDataCheckBox = new JCheckBox();
        this.ppuDataCheckBox = new JCheckBox();
        this.vCheckBox = new JCheckBox();
        this.tCheckBox = new JCheckBox();
        this.fineXCheckBox = new JCheckBox();
        this.wCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Logger Configuration");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoggerDialog.this.formWindowClosing(evt);
            }
        });
        this.fileLabel.setText("File:");
        this.fileLabel.setMaximumSize(null);
        this.fileLabel.setMinimumSize(null);
        this.fileLabel.setPreferredSize(null);
        this.browseButton.setText("Browse...");
        this.browseButton.setMaximumSize(null);
        this.browseButton.setMinimumSize(null);
        this.browseButton.setPreferredSize(null);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileTextField.setMaximumSize(null);
        this.fileTextField.setMinimumSize(null);
        this.fileTextField.setPreferredSize(null);
        this.countersPanel.setBorder(BorderFactory.createTitledBorder("Counters"));
        this.countersPanel.setMaximumSize(null);
        this.frameCounterCheckBox.setText("Frames");
        this.frameCounterCheckBox.setMaximumSize(null);
        this.frameCounterCheckBox.setMinimumSize(null);
        this.frameCounterCheckBox.setPreferredSize(null);
        this.cpuCounterCheckBox.setText("CPU Cycles");
        this.cpuCounterCheckBox.setMaximumSize(null);
        this.cpuCounterCheckBox.setMinimumSize(null);
        this.cpuCounterCheckBox.setPreferredSize(null);
        this.scanlineCheckBox.setText("Scanline");
        this.scanlineCheckBox.setMaximumSize(null);
        this.scanlineCheckBox.setMinimumSize(null);
        this.scanlineCheckBox.setPreferredSize(null);
        this.dotCheckBox.setText("Dot");
        this.dotCheckBox.setMaximumSize(null);
        this.dotCheckBox.setMinimumSize(null);
        this.dotCheckBox.setPreferredSize(null);
        this.instructionCounterCheckBox.setText("Instructions");
        this.instructionCounterCheckBox.setMaximumSize(null);
        this.instructionCounterCheckBox.setMinimumSize(null);
        this.instructionCounterCheckBox.setPreferredSize(null);
        GroupLayout countersPanelLayout = new GroupLayout(this.countersPanel);
        this.countersPanel.setLayout(countersPanelLayout);
        countersPanelLayout.setHorizontalGroup(countersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(countersPanelLayout.createSequentialGroup().addContainerGap().addGroup(countersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.frameCounterCheckBox, -2, -1, -2).addComponent(this.cpuCounterCheckBox, -2, -1, -2).addComponent(this.instructionCounterCheckBox, -2, -1, -2).addComponent(this.scanlineCheckBox, -2, -1, -2).addComponent(this.dotCheckBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        countersPanelLayout.setVerticalGroup(countersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(countersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.frameCounterCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionCounterCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cpuCounterCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dotCheckBox, -2, -1, -2).addContainerGap(54, Short.MAX_VALUE)));
        this.executionPanel.setBorder(BorderFactory.createTitledBorder("Execution"));
        this.executionPanel.setMaximumSize(null);
        this.machineCodeCheckBox.setText("Machine code");
        this.machineCodeCheckBox.setMaximumSize(null);
        this.machineCodeCheckBox.setMinimumSize(null);
        this.machineCodeCheckBox.setPreferredSize(null);
        this.instructionCheckBox.setText("Instruction");
        this.instructionCheckBox.setMaximumSize(null);
        this.instructionCheckBox.setMinimumSize(null);
        this.instructionCheckBox.setPreferredSize(null);
        this.inspectionsCheckBox.setText("Inspections");
        this.bankCheckBox.setText("Bank");
        this.bankCheckBox.setMaximumSize(null);
        this.bankCheckBox.setMinimumSize(null);
        this.bankCheckBox.setPreferredSize(null);
        this.logOrderComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Log before execute", "Log after execute"}));
        this.logOrderComboBox.setMaximumSize(null);
        this.logOrderComboBox.setMinimumSize(null);
        this.logOrderComboBox.setPreferredSize(null);
        GroupLayout executionPanelLayout = new GroupLayout(this.executionPanel);
        this.executionPanel.setLayout(executionPanelLayout);
        executionPanelLayout.setHorizontalGroup(executionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(executionPanelLayout.createSequentialGroup().addContainerGap().addGroup(executionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.machineCodeCheckBox, -2, -1, -2).addComponent(this.instructionCheckBox, -2, -1, -2).addComponent(this.inspectionsCheckBox).addComponent(this.bankCheckBox, -2, -1, -2).addComponent(this.logOrderComboBox, -2, -1, -2)).addContainerGap()));
        executionPanelLayout.setVerticalGroup(executionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(executionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.logOrderComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bankCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.machineCodeCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inspectionsCheckBox).addContainerGap(51, Short.MAX_VALUE)));
        this.cpuRegistersPanel.setBorder(BorderFactory.createTitledBorder("CPU Registers"));
        this.cpuRegistersPanel.setMaximumSize(null);
        this.aCheckBox.setText("A");
        this.aCheckBox.setMaximumSize(null);
        this.aCheckBox.setMinimumSize(null);
        this.aCheckBox.setPreferredSize(null);
        this.xCheckBox.setText("X");
        this.xCheckBox.setMaximumSize(null);
        this.xCheckBox.setMinimumSize(null);
        this.xCheckBox.setPreferredSize(null);
        this.yCheckBox.setText("Y");
        this.yCheckBox.setMaximumSize(null);
        this.yCheckBox.setMinimumSize(null);
        this.yCheckBox.setPreferredSize(null);
        this.pComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"P:HH", "P:NVUBDIZC", "No P"}));
        this.pComboBox.setMaximumSize(null);
        this.pComboBox.setMinimumSize(null);
        this.pComboBox.setPreferredSize(null);
        this.spComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"S", "SP", "No SP"}));
        this.spComboBox.setMaximumSize(null);
        this.spComboBox.setMinimumSize(null);
        this.spComboBox.setPreferredSize(null);
        this.pcComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"PC", "$PC", "No PC"}));
        this.pcComboBox.setMaximumSize(null);
        this.pcComboBox.setMinimumSize(null);
        this.pcComboBox.setPreferredSize(null);
        GroupLayout cpuRegistersPanelLayout = new GroupLayout(this.cpuRegistersPanel);
        this.cpuRegistersPanel.setLayout(cpuRegistersPanelLayout);
        cpuRegistersPanelLayout.setHorizontalGroup(cpuRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cpuRegistersPanelLayout.createSequentialGroup().addContainerGap().addGroup(cpuRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spComboBox, -2, -1, -2).addComponent(this.pComboBox, -2, -1, -2).addComponent(this.yCheckBox, -2, -1, -2).addComponent(this.xCheckBox, -2, -1, -2).addComponent(this.aCheckBox, -2, -1, -2).addComponent(this.pcComboBox, -2, -1, -2)).addContainerGap()));
        cpuRegistersPanelLayout.setVerticalGroup(cpuRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cpuRegistersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pcComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spComboBox, -2, -1, -2).addContainerGap(26, Short.MAX_VALUE)));
        this.formattingPanel.setBorder(BorderFactory.createTitledBorder("Formatting"));
        this.formattingPanel.setMaximumSize(null);
        this.addressLabelsCheckBox.setText("Address labels");
        this.addressLabelsCheckBox.setMaximumSize(null);
        this.addressLabelsCheckBox.setMinimumSize(null);
        this.addressLabelsCheckBox.setPreferredSize(null);
        this.tabBySpCheckBox.setText("Tab by SP");
        this.tabBySpCheckBox.setMaximumSize(null);
        this.tabBySpCheckBox.setMinimumSize(null);
        this.tabBySpCheckBox.setPreferredSize(null);
        this.branchesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Absolute branches", "Hex branches", "Decimal branches"}));
        this.branchesComboBox.setMaximumSize(null);
        this.branchesComboBox.setMinimumSize(null);
        this.branchesComboBox.setPreferredSize(null);
        GroupLayout formattingPanelLayout = new GroupLayout(this.formattingPanel);
        this.formattingPanel.setLayout(formattingPanelLayout);
        formattingPanelLayout.setHorizontalGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formattingPanelLayout.createSequentialGroup().addContainerGap().addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressLabelsCheckBox, -2, -1, -2).addComponent(this.tabBySpCheckBox, -2, -1, -2).addComponent(this.branchesComboBox, -2, -1, -2)).addContainerGap()));
        formattingPanelLayout.setVerticalGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formattingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addressLabelsCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabBySpCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.branchesComboBox, -2, -1, -2).addContainerGap(101, Short.MAX_VALUE)));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("  Cancel  ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.maxLinesLabel.setText("Max lines:");
        this.maxLinesLabel.setMaximumSize(null);
        this.maxLinesLabel.setMinimumSize(null);
        this.maxLinesLabel.setPreferredSize(null);
        this.maxLinesTextField.setColumns(8);
        this.maxLinesTextField.setMaximumSize(null);
        this.maxLinesTextField.setMinimumSize(null);
        this.maxLinesTextField.setPreferredSize(null);
        this.otherRegistersPanel.setBorder(BorderFactory.createTitledBorder("Other Registers"));
        this.otherRegistersPanel.setMaximumSize(null);
        this.apuStatusCheckBox.setText("APUSTATUS ($4015)");
        this.apuStatusCheckBox.setMaximumSize(null);
        this.apuStatusCheckBox.setMinimumSize(null);
        this.apuStatusCheckBox.setPreferredSize(null);
        this.controller1CheckBox.setText("CONTROLLER1 ($4016)");
        this.controller1CheckBox.setMaximumSize(null);
        this.controller1CheckBox.setMinimumSize(null);
        this.controller1CheckBox.setPreferredSize(null);
        this.controller2CheckBox.setText("CONTROLLER2 ($4017)");
        this.controller2CheckBox.setMaximumSize(null);
        this.controller2CheckBox.setMinimumSize(null);
        this.controller2CheckBox.setPreferredSize(null);
        GroupLayout otherRegistersPanelLayout = new GroupLayout(this.otherRegistersPanel);
        this.otherRegistersPanel.setLayout(otherRegistersPanelLayout);
        otherRegistersPanelLayout.setHorizontalGroup(otherRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(otherRegistersPanelLayout.createSequentialGroup().addContainerGap().addGroup(otherRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.apuStatusCheckBox, -2, -1, -2).addComponent(this.controller1CheckBox, -2, -1, -2).addComponent(this.controller2CheckBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        otherRegistersPanelLayout.setVerticalGroup(otherRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(otherRegistersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.apuStatusCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controller1CheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controller2CheckBox, -2, -1, -2).addContainerGap(100, Short.MAX_VALUE)));
        this.addressLabel.setText("Addresses:");
        this.addressLabel.setMaximumSize(null);
        this.addressLabel.setMinimumSize(null);
        this.addressLabel.setPreferredSize(null);
        this.addressesTextField.setMaximumSize(null);
        this.addressesTextField.setMinimumSize(null);
        this.addressesTextField.setPreferredSize(null);
        this.ppuRegistersPanel.setBorder(BorderFactory.createTitledBorder("PPU Registers"));
        this.ppuStatusCheckBox.setText("PPUSTATUS ($2002)");
        this.ppuStatusCheckBox.setMaximumSize(null);
        this.ppuStatusCheckBox.setMinimumSize(null);
        this.ppuStatusCheckBox.setPreferredSize(null);
        this.oamDataCheckBox.setText("OAMDATA ($2004)");
        this.oamDataCheckBox.setMaximumSize(null);
        this.oamDataCheckBox.setMinimumSize(null);
        this.oamDataCheckBox.setPreferredSize(null);
        this.ppuDataCheckBox.setText("PPUDATA ($2007)");
        this.ppuDataCheckBox.setMaximumSize(null);
        this.ppuDataCheckBox.setMinimumSize(null);
        this.ppuDataCheckBox.setPreferredSize(null);
        this.vCheckBox.setText("VRAM address (v)");
        this.vCheckBox.setMaximumSize(null);
        this.vCheckBox.setMinimumSize(null);
        this.vCheckBox.setPreferredSize(null);
        this.tCheckBox.setText("Temp VRAM addr (t)");
        this.tCheckBox.setMaximumSize(null);
        this.tCheckBox.setMinimumSize(null);
        this.tCheckBox.setPreferredSize(null);
        this.fineXCheckBox.setText("Fine X scroll (x)");
        this.fineXCheckBox.setMaximumSize(null);
        this.fineXCheckBox.setMinimumSize(null);
        this.fineXCheckBox.setPreferredSize(null);
        this.wCheckBox.setText("Write toggle (w)");
        this.wCheckBox.setMaximumSize(null);
        this.wCheckBox.setMinimumSize(null);
        this.wCheckBox.setPreferredSize(null);
        GroupLayout ppuRegistersPanelLayout = new GroupLayout(this.ppuRegistersPanel);
        this.ppuRegistersPanel.setLayout(ppuRegistersPanelLayout);
        ppuRegistersPanelLayout.setHorizontalGroup(ppuRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ppuRegistersPanelLayout.createSequentialGroup().addContainerGap().addGroup(ppuRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ppuStatusCheckBox, -2, -1, -2).addComponent(this.oamDataCheckBox, -2, -1, -2).addComponent(this.ppuDataCheckBox, -2, -1, -2).addComponent(this.vCheckBox, -2, -1, -2).addComponent(this.tCheckBox, -2, -1, -2).addComponent(this.fineXCheckBox, -2, -1, -2).addComponent(this.wCheckBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        ppuRegistersPanelLayout.setVerticalGroup(ppuRegistersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ppuRegistersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.vCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fineXCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppuStatusCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oamDataCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppuDataCheckBox, -2, -1, -2).addContainerGap(8, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, 79, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.maxLinesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxLinesTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.addressLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressesTextField, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.countersPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cpuRegistersPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppuRegistersPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.otherRegistersPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formattingPanel, -2, -1, -2))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel, -2, -1, -2).addComponent(this.browseButton, -2, -1, -2).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxLinesLabel, -2, -1, -2).addComponent(this.maxLinesTextField, -2, -1, -2).addComponent(this.addressLabel, -2, -1, -2).addComponent(this.addressesTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.countersPanel, -1, -1, Short.MAX_VALUE).addComponent(this.executionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.formattingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.cpuRegistersPanel, -1, -1, Short.MAX_VALUE).addComponent(this.otherRegistersPanel, -1, -1, -2).addComponent(this.ppuRegistersPanel, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.countersPanel, this.cpuRegistersPanel, this.executionPanel, this.formattingPanel, this.otherRegistersPanel, this.ppuRegistersPanel);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (GuiUtil.confirmOverwrite(this, this.fileTextField.getText())) {
            this.ok = true;
            this.saveFields();
            this.closeDialog();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String logsDir;
        String inputFileName;
        Paths paths = AppPrefs.getInstance().getPaths();
        String fileName = this.fileTextField.getText().trim();
        if (fileName.isEmpty()) {
            String entryFileName = App.getEntryFileName();
            inputFileName = (StringUtil.isBlank(entryFileName) ? "trace" : FileUtil.getFileNameWithoutExtension(entryFileName)) + ".log";
            logsDir = paths.getLogsDir();
        } else {
            File f = new File(fileName);
            inputFileName = f.getName();
            logsDir = f.getParent();
            if (StringUtil.isBlank(logsDir)) {
                logsDir = paths.getLogsDir();
            }
        }
        FileUtil.mkdir(logsDir);
        File file = GuiUtil.showSaveAsDialog(this, logsDir, inputFileName, "log", new FileExtensionFilter(0, "Log files (*.log)", "log"), false, "Choose Log File");
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setLogsDir(dir);
            AppPrefs.save();
            this.fileTextField.setText(file.getPath());
        }
    }
}

