/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.addresslabel;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import nintaco.App;
import nintaco.disassembler.AddressLabel;
import nintaco.disassembler.AddressTextRange;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.ToolTipsTable;
import nintaco.gui.debugger.addresslabel.AddressLabelTableModel;
import nintaco.gui.debugger.addresslabel.CreateAddressLabelDialog;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.table.TableDialog;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.CsvUtil;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class AddressLabelDialog
extends TableDialog {
    public static final FileExtensionFilter[] FILE_FILTERS = new FileExtensionFilter[]{new FileExtensionFilter(0, "Comma-separated values files (*.csv)", "csv"), new FileExtensionFilter(1, "All files (*.*)")};
    private AddressLabelTableModel tableModel;
    private boolean ok;
    private AddressTextRange range;

    public AddressLabelDialog(Window parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.setTitle("Address Labels");
        this.tableModel = new AddressLabelTableModel();
        this.tableModel.setRowsCopy(GamePrefs.getInstance().getDebuggerGamePrefs().getAddressLabels());
        this.table.setModel(this.tableModel);
        GuiUtil.setCellRenderer(this.table, 0, GuiUtil.NO_BORDER_BOOLEAN_RENDERER);
        GuiUtil.setCellRenderer(this.table, 1, GuiUtil.NO_BORDER_BOOLEAN_RENDERER);
        GuiUtil.setCellRenderer(this.table, 2, GuiUtil.NO_BORDER_MONOSPACED_RENDERER);
        GuiUtil.setCellRenderer(this.table, 3, GuiUtil.NO_BORDER_MONOSPACED_RENDERER);
        GuiUtil.setCellRenderer(this.table, 4, GuiUtil.NO_BORDER_LABEL_RENDERER);
        GuiUtil.setCellRenderer(this.table, 5, GuiUtil.NO_BORDER_LABEL_RENDERER);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().toggleSortOrder(3);
        GuiUtil.resizeCellSizes(this.table, true, 8, false, true, true, "MMM", "MMMMM", "MMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
        ((ToolTipsTable)this.table).setColumnToolTips("Code", "Bookmark", "Bank", "Address", "Label", "Comment");
    }

    public void setRange(AddressTextRange range) {
        this.range = range;
    }

    public boolean isOk() {
        return this.ok;
    }

    @Override
    protected void handleShown() {
        if (this.range != null) {
            List<AddressLabel> rows = this.tableModel.getRows();
            for (int i = rows.size() - 1; i >= 0; --i) {
                AddressLabel row = rows.get(i);
                if (row.getBank() != this.range.getBank() || row.getAddress() != this.range.getAddress()) continue;
                this.editButtonPressed(i);
                return;
            }
            CreateAddressLabelDialog dialog = new CreateAddressLabelDialog((Window)this);
            dialog.setTitle("New Address Label");
            dialog.setAddressLabel(new AddressLabel(this.range.getBank(), this.range.getAddress(), "", "", true, true));
            dialog.selectLabel();
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.setSelectedRow(this.tableModel.add(dialog.getAddressLabel()));
            }
        }
    }

    @Override
    protected void okButtonPressed() {
        GamePrefs.getInstance().getDebuggerGamePrefs().setAddressLabels(this.tableModel.getRows());
        GamePrefs.save();
        this.ok = true;
        this.closeDialog();
    }

    @Override
    protected void cancelButtonPressed() {
        this.closeDialog();
    }

    @Override
    protected void clearButtonPressed() {
        this.tableModel.clear();
    }

    @Override
    protected void exportButtonPressed() {
        App.setNoStepPause(true);
        Paths paths = AppPrefs.getInstance().getPaths();
        String recentDir = paths.getAddressLabelsDir();
        FileUtil.mkdir(recentDir);
        File file = GuiUtil.showSaveAsDialog(this, recentDir, FileUtil.getFileNameWithoutExtension(App.getEntryFileName()) + ".csv", "csv", FILE_FILTERS[0], true);
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setAddressLabelsDir(dir);
            AppPrefs.save();
            List<AddressLabel> addressLabels = this.tableModel.getRows();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.exportFile(pleaseWaitDialog, file, addressLabels)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void exportFile(PleaseWaitDialog pleaseWaitDialog, File file, List<AddressLabel> addressLabels) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (AddressLabel addressLabel : addressLabels) {
            ArrayList<String> row = new ArrayList<String>();
            rows.add(row);
            row.add(Boolean.toString(addressLabel.isCode()));
            row.add(Boolean.toString(addressLabel.isBookmark()));
            row.add(String.format("%02X", addressLabel.getBank()));
            row.add(String.format("%04X", addressLabel.getAddress()));
            row.add(addressLabel.getLabel());
            row.add(addressLabel.getComment());
        }
        boolean error = false;
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));){
            CsvUtil.write(out, rows);
        }
        catch (Throwable t) {
            error = true;
        }
        pleaseWaitDialog.dispose();
        if (error) {
            GuiUtil.displayError(this, "Failed to export address labels.");
        }
        App.setNoStepPause(false);
    }

    @Override
    protected void importButtonPressed() {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Import Address Labels", AppPrefs.getInstance().getPaths().getAddressLabelsDir(), (FileFilter[])FILE_FILTERS);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setAddressLabelsDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.importFile(pleaseWaitDialog, selectedFile)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void importFile(PleaseWaitDialog pleaseWaitDialog, File selectedFile) {
        ArrayList<AddressLabel> rows = new ArrayList<AddressLabel>();
        List<List<String>> values = null;
        try (BufferedReader br = new BufferedReader(new FileReader(selectedFile));){
            values = CsvUtil.read(br);
            for (List<String> list : values) {
                if (list.size() < 6) continue;
                boolean code = Boolean.parseBoolean(list.get(0));
                boolean bookmark = Boolean.parseBoolean(list.get(1));
                int bank = StringUtil.parseInt(list.get(2), true, 255L);
                int address = StringUtil.parseInt(list.get(3), true, 65535L);
                String label = list.get(4);
                String comment = list.get(5);
                if (address < 0 || StringUtil.isBlank(label) && StringUtil.isBlank(comment)) continue;
                rows.add(new AddressLabel(bank, address, label, comment, code, bookmark));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pleaseWaitDialog.dispose();
        if (values == null) {
            GuiUtil.displayError(this, "Failed to import address labels file.");
        } else if (rows.isEmpty()) {
            GuiUtil.displayError(this, "The file does not contain any valid address labels.");
        } else {
            EventQueue.invokeLater(() -> {
                this.tableModel.setRows(rows);
                this.selectionChanged();
                this.updateClearButton();
            });
        }
        App.setNoStepPause(false);
    }

    @Override
    protected void deleteButtonPressed(int index) {
        this.tableModel.delete(index);
    }

    @Override
    protected void editButtonPressed(int index) {
        CreateAddressLabelDialog dialog = new CreateAddressLabelDialog((Window)this);
        dialog.setTitle("Edit Address Label");
        dialog.setAddressLabel(this.tableModel.getRows().get(index));
        dialog.selectLabel();
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.tableModel.delete(index);
            this.setSelectedRow(this.tableModel.add(dialog.getAddressLabel()));
        }
    }

    @Override
    protected void newButtonPressed() {
        CreateAddressLabelDialog dialog = new CreateAddressLabelDialog((Window)this);
        dialog.setTitle("New Address Label");
        dialog.selectAddress();
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.setSelectedRow(this.tableModel.add(dialog.getAddressLabel()));
        }
    }
}

