/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.contentdirectory;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.LayoutStyle;
import nintaco.files.FileUtil;
import nintaco.gui.BrowsePanel;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class ContentDirectoryDialog
extends JDialog {
    private BrowsePanel browsePanel;
    private JButton cancelButton;
    private JButton okButton;
    private JButton resetButton;

    public ContentDirectoryDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initBrowsePanel();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initBrowsePanel() {
        this.browsePanel.setFileName(AppPrefs.getInstance().getPaths().getContentDirectory());
        this.browsePanel.setWindow(this);
        this.browsePanel.setShowOpenFileChooser(true);
        this.browsePanel.setFileSelectionMode(1);
        this.browsePanel.setFileNameSetListener(this::fileNameChanged);
        this.fileNameChanged();
    }

    private void fileNameChanged() {
        String dir = this.browsePanel.getFileName().trim();
        this.okButton.setEnabled(!dir.isEmpty());
        this.resetButton.setEnabled(!FileUtil.getWorkingDirectory().equalsIgnoreCase(dir));
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.browsePanel = new BrowsePanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.resetButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Change Generated Content Directory");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ContentDirectoryDialog.this.formWindowClosing(evt);
            }
        });
        this.browsePanel.setMaximumSize(null);
        this.browsePanel.setMinimumSize(null);
        this.browsePanel.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentDirectoryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentDirectoryDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.resetButton.setMnemonic('R');
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentDirectoryDialog.this.resetButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addContainerGap()).addComponent(this.browsePanel, -1, -1, Short.MAX_VALUE));
        layout.linkSize(0, this.cancelButton, this.okButton, this.resetButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.browsePanel, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2).addComponent(this.resetButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String directory = this.browsePanel.getFileName().trim();
        if (directory.isEmpty()) {
            return;
        }
        File dir = FileUtil.mkdir(directory);
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            GuiUtil.displayError("Invalid Directory", this, "The specified path is not a valid directory.");
        } else {
            AppPrefs.getInstance().getPaths().setContentDirectory(dir.getPath());
            AppPrefs.save();
            this.closeDialog();
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.browsePanel.setFileName(FileUtil.getWorkingDirectory());
    }
}

