/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats.search;

import nintaco.gui.cheats.search.RamTableModel;

public final class RamTableRow {
    public static final int DECIMAL = 0;
    public static final int HEXIDECIMAL = 1;
    private final String[][] values = new String[2][RamTableModel.COLUMN_NAMES.length];
    private final int[] r = new int[2];
    private int address;

    public RamTableRow() {
    }

    public RamTableRow(int address, int r0, int r1) {
        this.setAddress(address);
        this.setR(0, r0);
        this.setR(1, r1);
    }

    public RamTableRow(RamTableRow row) {
        this(row.address, row.r[0], row.r[1]);
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
        String string = String.format("%04X", address);
        this.values[1][0] = string;
        this.values[0][0] = string;
    }

    public int getR(int index) {
        return this.r[index];
    }

    public void setR(int index, int value) {
        this.r[index] = value;
        this.values[1][++index] = String.format("%02X", value);
        this.values[0][index] = Integer.toString(value);
    }

    public Object getValueAt(int columnIndex, int base) {
        return this.values[base][columnIndex];
    }
}

