/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.table.AbstractTableModel;
import nintaco.cheats.Cheat;
import nintaco.gui.cheats.CheatsTableModel;

public class CheatSearchTableModel
extends AbstractTableModel {
    private final List<Cheat> cheats;
    private boolean modified;

    public CheatSearchTableModel(List<Cheat> cheats) {
        this.cheats = cheats;
    }

    public void setCheats(List<Cheat> cheats) {
        this.cheats.clear();
        this.cheats.addAll(cheats);
        this.modified = false;
        this.fireTableDataChanged();
    }

    public List<Cheat> getCheatsCopy() {
        ArrayList<Cheat> cs = new ArrayList<Cheat>();
        for (Cheat cheat : this.cheats) {
            cs.add(new Cheat(cheat));
        }
        return cs;
    }

    public boolean isEmpty() {
        return this.cheats.isEmpty();
    }

    @Override
    public int getRowCount() {
        return this.cheats.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public int add(Cheat cheat) {
        return this.add(cheat, true, false);
    }

    public int add(Cheat cheat, boolean fireChangedEvent, boolean removeDuplicates) {
        if (cheat == null) {
            return 0;
        }
        if (removeDuplicates) {
            for (int i = this.cheats.size() - 1; i >= 0; --i) {
                Cheat c = this.cheats.get(i);
                if (!c.effectivelyEquals(cheat)) continue;
                this.cheats.remove(i);
            }
        }
        this.cheats.add(cheat);
        this.modified = true;
        if (fireChangedEvent) {
            this.fireTableDataChanged();
        }
        return this.cheats.size() - 1;
    }

    public void add(List<Cheat> cheats, boolean removeDuplicates) {
        for (Cheat cheat : cheats) {
            this.add(cheat, false, removeDuplicates);
        }
        this.fireTableDataChanged();
    }

    public void update(int rowIndex, Cheat cheat) {
        if (cheat == null || rowIndex < 0 || rowIndex >= this.cheats.size()) {
            return;
        }
        this.modified = true;
        Cheat row = this.cheats.get(rowIndex);
        cheat.setEnabled(row.isEnabled());
        this.cheats.set(rowIndex, cheat);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void removeRow(int rowIndex) {
        this.cheats.remove(rowIndex);
        this.modified = true;
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public Cheat getRow(int rowIndex) {
        return this.cheats.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Cheat cheat = this.cheats.get(rowIndex);
        if (columnIndex == 0) {
            return cheat.isEnabled();
        }
        return cheat.getDescription();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Matcher matcher;
        Cheat cheat = this.cheats.get(rowIndex);
        this.modified = true;
        if (columnIndex == 0 && (matcher = CheatsTableModel.MULTI_PATTERN.matcher(this.cheats.get(rowIndex).getDescription())).find()) {
            String prefix = matcher.group(1);
            for (int i = this.cheats.size() - 1; i >= 0; --i) {
                if (i != rowIndex && !this.cheats.get(i).getDescription().startsWith(prefix)) continue;
                this.cheats.get(i).setEnabled((Boolean)value);
                this.fireTableRowsUpdated(i, i);
            }
            return;
        }
        if (columnIndex == 0) {
            cheat.setEnabled((Boolean)value);
        } else {
            cheat.setDescription((String)value);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        return "Description";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void clear() {
        this.modified = true;
        this.cheats.clear();
        this.fireTableDataChanged();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

