/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.cheats.Cheat;
import nintaco.cheats.GameGenie;
import nintaco.cheats.ProActionRocky;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class CreateCheatDialog
extends JDialog {
    private static String[] CARDS = new String[]{"gameGenieCard", "proActionRockyCard", "rawCard"};
    private final DocumentListener gameGenieDocListener = GuiUtil.createDocumentListener(this::updateGameGenieOkButton);
    private final DocumentListener proActionRockyDocListener = GuiUtil.createDocumentListener(this::updateProActionRockyOkButton);
    private final DocumentListener rawDocListener = GuiUtil.createDocumentListener(this::updateRawOkButton);
    private String lastGameGenieCode;
    private String lastProActionRockyCode;
    private Cheat result;
    private JLabel addressLabel;
    private JTextField addressTextField;
    private JButton cancelButton;
    private JPanel cardPanel;
    private JLabel compareLabel;
    private JTextField compareTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JCheckBox enabledCheckBox;
    private JLabel gameGenieCodeLabel;
    private JPanel gameGeniePanel;
    private JTextField gameGenieTextField;
    private JButton okButton;
    private JLabel proActionRockCodeLabel;
    private JPanel proActionRockyPanel;
    private JTextField proActionRockyTextField;
    private JPanel rawPanel;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JPanel typePanel;
    private JLabel valueLabel;
    private JTextField valueTextField;

    public CreateCheatDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.addDocumentListeners();
        GuiUtil.scaleFonts(this);
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, CARDS[0]);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public Cheat getCheat() {
        return this.result;
    }

    private void addDocumentListeners() {
        this.gameGenieTextField.getDocument().addDocumentListener(this.gameGenieDocListener);
        this.proActionRockyTextField.getDocument().addDocumentListener(this.proActionRockyDocListener);
        this.addressTextField.getDocument().addDocumentListener(this.rawDocListener);
        this.valueTextField.getDocument().addDocumentListener(this.rawDocListener);
        this.compareTextField.getDocument().addDocumentListener(this.rawDocListener);
    }

    private void removeDocumentListeners() {
        this.gameGenieTextField.getDocument().removeDocumentListener(this.gameGenieDocListener);
        this.proActionRockyTextField.getDocument().removeDocumentListener(this.proActionRockyDocListener);
        this.addressTextField.getDocument().removeDocumentListener(this.rawDocListener);
        this.valueTextField.getDocument().removeDocumentListener(this.rawDocListener);
        this.compareTextField.getDocument().removeDocumentListener(this.rawDocListener);
    }

    public void setCheat(Cheat cheat) {
        this.setCheat(cheat, 0);
    }

    public void setCheat(Cheat cheat, int cheatCard) {
        if (cheat == null) {
            this.descriptionTextField.setText("");
            this.enabledCheckBox.setSelected(true);
        } else {
            this.descriptionTextField.setText(cheat.getDescription());
            this.enabledCheckBox.setSelected(cheat.isEnabled());
        }
        this.updateGameGenieTextField(cheat);
        this.updateProActionRockyTextField(cheat);
        this.updateRawTextFields(cheat);
        this.updateOkButton();
        this.typeComboBox.setSelectedIndex(cheatCard);
        switch (cheatCard) {
            case 0: {
                this.gameGenieTextField.requestFocus();
                this.gameGenieTextField.selectAll();
                break;
            }
            case 1: {
                this.proActionRockyTextField.requestFocus();
                this.proActionRockyTextField.selectAll();
                break;
            }
            case 2: {
                this.valueTextField.requestFocus();
                this.valueTextField.selectAll();
            }
        }
    }

    private void updateGameGenieTextField(Cheat cheat) {
        this.removeDocumentListeners();
        this.gameGenieTextField.setText(StringUtil.replaceBlank(GameGenie.convert(cheat), ""));
        this.lastGameGenieCode = this.gameGenieTextField.getText();
        this.addDocumentListeners();
    }

    private void updateProActionRockyTextField(Cheat cheat) {
        this.removeDocumentListeners();
        this.proActionRockyTextField.setText(StringUtil.replaceBlank(ProActionRocky.convert(cheat), ""));
        this.lastProActionRockyCode = this.proActionRockyTextField.getText();
        this.addDocumentListeners();
    }

    private void updateRawTextFields(Cheat cheat) {
        this.removeDocumentListeners();
        if (cheat == null) {
            this.addressTextField.setText("");
            this.valueTextField.setText("");
            this.compareTextField.setText("");
        } else {
            this.addressTextField.setText(String.format("$%04X", cheat.getAddress()));
            this.valueTextField.setText(Integer.toString(cheat.getDataValue()));
            this.compareTextField.setText(cheat.hasCompareValue() ? Integer.toString(cheat.getCompareValue()) : "");
        }
        this.addDocumentListeners();
    }

    private void closeDialog() {
        if (this.result != null) {
            this.result.setEnabled(this.enabledCheckBox.isSelected());
            this.result.setDescription(this.descriptionTextField.getText().trim());
        }
        this.dispose();
    }

    private void updateOkButton() {
        switch (this.typeComboBox.getSelectedIndex()) {
            case 0: {
                this.updateGameGenieOkButton();
                break;
            }
            case 1: {
                this.updateProActionRockyOkButton();
                break;
            }
            case 2: {
                this.updateRawOkButton();
            }
        }
    }

    private void updateGameGenieOkButton() {
        String code = this.gameGenieTextField.getText().trim();
        Cheat cheat = GameGenie.convert(code);
        this.okButton.setEnabled(cheat != null);
        if (cheat != null && !code.equals(this.lastGameGenieCode)) {
            this.lastGameGenieCode = code;
            this.updateProActionRockyTextField(cheat);
            this.updateRawTextFields(cheat);
        }
    }

    private void updateProActionRockyOkButton() {
        String code = this.proActionRockyTextField.getText().trim();
        Cheat cheat = ProActionRocky.convert(code);
        this.okButton.setEnabled(cheat != null);
        if (cheat != null && !code.equals(this.lastProActionRockyCode)) {
            this.lastProActionRockyCode = code;
            this.updateGameGenieTextField(cheat);
            this.updateRawTextFields(cheat);
        }
    }

    private void updateRawOkButton() {
        int address = StringUtil.parseInt(this.addressTextField.getText(), true, 65535L);
        int value = StringUtil.parseInt(this.valueTextField.getText(), false, 255L);
        int compare = StringUtil.parseInt(this.compareTextField.getText(), false, 255L);
        if (address >= 0 && value >= 0 && compare >= -1) {
            this.okButton.setEnabled(true);
            Cheat cheat = new Cheat(address, value, compare);
            this.updateGameGenieTextField(cheat);
            this.updateProActionRockyTextField(cheat);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void okGameGenie() {
        String code = this.gameGenieTextField.getText().trim();
        this.result = GameGenie.convert(code);
        if (this.descriptionTextField.getText().trim().isEmpty()) {
            this.descriptionTextField.setText(code);
        }
        this.closeDialog();
    }

    private void okProActionRocky() {
        String code = this.proActionRockyTextField.getText().trim();
        this.result = ProActionRocky.convert(code);
        if (this.descriptionTextField.getText().trim().isEmpty()) {
            this.descriptionTextField.setText(code);
        }
        this.closeDialog();
    }

    private void okRaw() {
        this.result = new Cheat(StringUtil.parseInt(this.addressTextField.getText(), true, 65535L), StringUtil.parseInt(this.valueTextField.getText(), false, 255L), StringUtil.parseInt(this.compareTextField.getText(), false, 255L));
        if (this.descriptionTextField.getText().trim().isEmpty()) {
            this.result.generateDescription();
            this.descriptionTextField.setText(this.result.getDescription());
        }
        this.closeDialog();
    }

    private void initComponents() {
        this.cardPanel = new JPanel();
        this.gameGeniePanel = new JPanel();
        this.gameGenieCodeLabel = new JLabel();
        this.gameGenieTextField = new JTextField();
        this.proActionRockyPanel = new JPanel();
        this.proActionRockCodeLabel = new JLabel();
        this.proActionRockyTextField = new JTextField();
        this.rawPanel = new JPanel();
        this.addressLabel = new JLabel();
        this.addressTextField = new JTextField();
        this.valueLabel = new JLabel();
        this.valueTextField = new JTextField();
        this.compareLabel = new JLabel();
        this.compareTextField = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.typePanel = new JPanel();
        this.typeComboBox = new JComboBox();
        this.typeLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.descriptionTextField = new JTextField();
        this.enabledCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CreateCheatDialog.this.formWindowClosing(evt);
            }
        });
        this.cardPanel.setLayout(new CardLayout());
        this.gameGenieCodeLabel.setText("Code:");
        this.gameGenieTextField.setColumns(12);
        this.gameGenieTextField.setPreferredSize(null);
        GroupLayout gameGeniePanelLayout = new GroupLayout(this.gameGeniePanel);
        this.gameGeniePanel.setLayout(gameGeniePanelLayout);
        gameGeniePanelLayout.setHorizontalGroup(gameGeniePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gameGeniePanelLayout.createSequentialGroup().addComponent(this.gameGenieCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gameGenieTextField, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        gameGeniePanelLayout.setVerticalGroup(gameGeniePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gameGeniePanelLayout.createSequentialGroup().addContainerGap().addGroup(gameGeniePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gameGenieCodeLabel).addComponent(this.gameGenieTextField, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.gameGeniePanel, "gameGenieCard");
        this.proActionRockCodeLabel.setText("Code:");
        this.proActionRockyTextField.setColumns(12);
        this.proActionRockyTextField.setPreferredSize(null);
        GroupLayout proActionRockyPanelLayout = new GroupLayout(this.proActionRockyPanel);
        this.proActionRockyPanel.setLayout(proActionRockyPanelLayout);
        proActionRockyPanelLayout.setHorizontalGroup(proActionRockyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proActionRockyPanelLayout.createSequentialGroup().addComponent(this.proActionRockCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proActionRockyTextField, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        proActionRockyPanelLayout.setVerticalGroup(proActionRockyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proActionRockyPanelLayout.createSequentialGroup().addContainerGap().addGroup(proActionRockyPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.proActionRockCodeLabel).addComponent(this.proActionRockyTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.proActionRockyPanel, "proActionRockyCard");
        this.addressLabel.setText("Address:");
        this.addressTextField.setColumns(7);
        this.addressTextField.setPreferredSize(null);
        this.valueLabel.setText("Value:");
        this.valueTextField.setColumns(5);
        this.valueTextField.setPreferredSize(null);
        this.compareLabel.setText("Compare:");
        this.compareTextField.setColumns(5);
        this.compareTextField.setPreferredSize(null);
        GroupLayout rawPanelLayout = new GroupLayout(this.rawPanel);
        this.rawPanel.setLayout(rawPanelLayout);
        rawPanelLayout.setHorizontalGroup(rawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rawPanelLayout.createSequentialGroup().addComponent(this.addressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.valueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.compareLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.compareTextField, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        rawPanelLayout.setVerticalGroup(rawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rawPanelLayout.createSequentialGroup().addContainerGap().addGroup(rawPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.addressLabel).addComponent(this.addressTextField, -2, -1, -2).addComponent(this.valueLabel).addComponent(this.valueTextField, -2, -1, -2).addComponent(this.compareLabel).addComponent(this.compareTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.rawPanel, "rawCard");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateCheatDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateCheatDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Game Genie", "Pro Action Rocky", "Raw"}));
        this.typeComboBox.setFocusable(false);
        this.typeComboBox.setMinimumSize(null);
        this.typeComboBox.setPreferredSize(null);
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateCheatDialog.this.typeComboBoxActionPerformed(evt);
            }
        });
        this.typeLabel.setText("Type:");
        this.descriptionLabel.setText("Description:");
        this.descriptionTextField.setColumns(40);
        GroupLayout typePanelLayout = new GroupLayout(this.typePanel);
        this.typePanel.setLayout(typePanelLayout);
        typePanelLayout.setHorizontalGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typePanelLayout.createSequentialGroup().addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionTextField, -2, 0, Short.MAX_VALUE)).addGroup(typePanelLayout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        typePanelLayout.setVerticalGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typePanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.descriptionLabel).addComponent(this.descriptionTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addGap(0, 0, 0)));
        this.enabledCheckBox.setText("Enabled");
        this.enabledCheckBox.setFocusPainted(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cardPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.typePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.typePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cardPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enabledCheckBox).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, CARDS[this.typeComboBox.getSelectedIndex()]);
        this.updateOkButton();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        switch (this.typeComboBox.getSelectedIndex()) {
            case 0: {
                this.okGameGenie();
                break;
            }
            case 1: {
                this.okProActionRocky();
                break;
            }
            case 2: {
                this.okRaw();
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

