/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import nintaco.cheats.Cheat;
import nintaco.gui.cheats.CheatRow;

public class CheatsTableModel
extends AbstractTableModel {
    static final String[] COLUMN_NAMES = new String[]{"", "Description", "Address", "Value", "Compare", "Game Genie", "Pro Action Rocky"};
    public static final Pattern MULTI_PATTERN = Pattern.compile("^(.*)(\\[\\d+\\s+of\\s+\\d+\\])$");
    private final List<CheatRow> cheatRows = new ArrayList<CheatRow>();
    private boolean showHex;
    private boolean modified;

    public CheatsTableModel(List<Cheat> cheats) {
        for (Cheat cheat : cheats) {
            CheatRow row = new CheatRow(cheat);
            row.setShowHex(this.showHex);
            this.cheatRows.add(row);
            this.modified = true;
        }
    }

    public List<Cheat> getCheats() {
        ArrayList<Cheat> cheats = new ArrayList<Cheat>();
        for (CheatRow row : this.cheatRows) {
            cheats.add(new Cheat(row.getCheat()));
        }
        return cheats;
    }

    public void setShowHex(boolean showHex) {
        this.showHex = showHex;
        for (CheatRow row : this.cheatRows) {
            row.setShowHex(showHex);
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        this.modified = true;
        this.cheatRows.clear();
        this.fireTableDataChanged();
    }

    public void deleteCheat(int rowIndex) {
        this.modified = true;
        Matcher matcher = MULTI_PATTERN.matcher((String)this.cheatRows.get(rowIndex).getValueAt(1));
        if (matcher.find()) {
            String prefix = matcher.group(1);
            for (int i = this.cheatRows.size() - 1; i >= 0; --i) {
                if (i != rowIndex && !((String)this.cheatRows.get(i).getValueAt(1)).startsWith(prefix)) continue;
                this.cheatRows.remove(i);
                this.fireTableRowsDeleted(i, i);
            }
            return;
        }
        this.cheatRows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void updateCheat(Cheat cheat, int rowIndex) {
        this.modified = true;
        CheatRow row = new CheatRow(cheat);
        row.setShowHex(this.showHex);
        this.cheatRows.set(rowIndex, row);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void addCheat(Cheat cheat) {
        this.addCheat(cheat, true, false);
    }

    private void addCheat(Cheat cheat, boolean fireChangedEvent, boolean removeDuplicates) {
        this.modified = true;
        if (removeDuplicates) {
            for (int i = this.cheatRows.size() - 1; i >= 0; --i) {
                Cheat c = this.cheatRows.get(i).getCheat();
                if (!c.effectivelyEquals(cheat)) continue;
                this.cheatRows.remove(i);
            }
        }
        CheatRow row = new CheatRow(cheat);
        row.setShowHex(this.showHex);
        this.cheatRows.add(row);
        if (fireChangedEvent) {
            this.fireTableDataChanged();
        }
    }

    public void addCheats(List<Cheat> cheats, boolean removeDuplicates) {
        for (Cheat cheat : cheats) {
            this.addCheat(cheat, false, removeDuplicates);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.cheatRows.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    public CheatRow getRow(int rowIndex) {
        return this.cheatRows.get(rowIndex);
    }

    public Cheat getCheat(int rowIndex) {
        return this.cheatRows.get(rowIndex).getCheat();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.cheatRows.get(rowIndex).getValueAt(columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Matcher matcher;
        this.modified = true;
        if (columnIndex == 0 && (matcher = MULTI_PATTERN.matcher((String)this.cheatRows.get(rowIndex).getValueAt(1))).find()) {
            String prefix = matcher.group(1);
            for (int i = this.cheatRows.size() - 1; i >= 0; --i) {
                if (i != rowIndex && !((String)this.cheatRows.get(i).getValueAt(1)).startsWith(prefix)) continue;
                this.cheatRows.get(i).setValueAt(value, 0);
                this.fireTableRowsUpdated(i, i);
            }
            return;
        }
        this.cheatRows.get(rowIndex).setValueAt(value, columnIndex);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    static interface Indices {
        public static final int ENABLED = 0;
        public static final int DESCRIPTION = 1;
        public static final int ADDRESS = 2;
        public static final int VALUE = 3;
        public static final int COMPARE = 4;
        public static final int GAME_GENIE = 5;
        public static final int PRO_ACTION_ROCKY = 6;
    }
}

