/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.asmdasm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.MessageException;
import nintaco.assembler.Assembler;
import nintaco.disassembler.Disassembler;
import nintaco.disassembler.Instruction;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class AsmDasmFrame
extends JFrame {
    private JButton assembleButton;
    private JLabel assembleLabel;
    private JPanel assemblePanel;
    private JScrollPane assembleScrollPane;
    private JTextArea assembleTextArea;
    private JButton disassembleButton;
    private JLabel disassembleLabel;
    private JPanel disassemblePanel;
    private JScrollPane disassembleScrollPane;
    private JTextArea disassembleTextArea;

    public AsmDasmFrame() {
        this.initComponents();
        GuiUtil.makeMonospaced(this.assembleTextArea);
        GuiUtil.makeMonospaced(this.disassembleTextArea);
        GuiUtil.scaleFonts(this);
        GuiUtil.setTextAreaSize(this.assembleTextArea, 40, 40);
        GuiUtil.setTextAreaSize(this.disassembleTextArea, 40, 40);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    public void destroy() {
        this.dispose();
    }

    private void closeFrame() {
        App.destroyAsmDasmFrame();
    }

    public void setMachineCode(String machineCode) {
        this.disassembleTextArea.setText(machineCode);
        this.disassembleTextArea.setCaretPosition(0);
    }

    public void setMachineCode(int[] machineCode) {
        StringBuilder sb = new StringBuilder();
        for (int code : machineCode) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(String.format("%02X", code));
        }
        this.setMachineCode(sb.toString());
    }

    public void assemble() {
        try {
            int[] bytes = Assembler.assemble(this.assembleTextArea.getText());
            StringBuilder sb = new StringBuilder();
            for (int b : bytes) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02X", b));
            }
            this.disassembleTextArea.setText(sb.toString());
        }
        catch (MessageException e) {
            GuiUtil.displayError(this, e.getMessage());
        }
        this.disassembleTextArea.setCaretPosition(0);
    }

    public void disassemble() {
        String text = this.disassembleTextArea.getText().replaceAll("\\s+", "");
        int[] bytes = new int[text.length() >> 1];
        for (int i = 0; i < bytes.length; ++i) {
            int index = i << 1;
            boolean error = false;
            if (!StringUtil.isHexDigit(text.charAt(index)) || !StringUtil.isHexDigit(text.charAt(index + 1))) {
                error = true;
            } else {
                try {
                    bytes[i] = Integer.parseInt(text.substring(index, index + 2), 16);
                }
                catch (Throwable t) {
                    error = true;
                }
            }
            if (!error) continue;
            GuiUtil.displayError(this, "Invalid hex value: %s", text.substring(index, index + 2));
            return;
        }
        List<Instruction> instructions = Disassembler.disassemble(bytes, false);
        StringBuilder sb = new StringBuilder();
        for (Instruction instruction : instructions) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(instruction);
        }
        this.assembleTextArea.setText(sb.toString());
        this.assembleTextArea.setCaretPosition(0);
    }

    private void initComponents() {
        this.assemblePanel = new JPanel();
        this.assembleLabel = new JLabel();
        this.assembleScrollPane = new JScrollPane();
        this.assembleTextArea = new JTextArea();
        this.disassemblePanel = new JPanel();
        this.disassembleLabel = new JLabel();
        this.disassembleScrollPane = new JScrollPane();
        this.disassembleTextArea = new JTextArea();
        this.assembleButton = new JButton();
        this.disassembleButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Assembler-Disassembler");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AsmDasmFrame.this.formWindowClosing(evt);
            }
        });
        this.assemblePanel.setMaximumSize(null);
        this.assemblePanel.setPreferredSize(null);
        this.assembleLabel.setText("Assembly code");
        this.assembleLabel.setMaximumSize(null);
        this.assembleLabel.setMinimumSize(null);
        this.assembleLabel.setPreferredSize(null);
        this.assembleScrollPane.setMaximumSize(null);
        this.assembleScrollPane.setMinimumSize(null);
        this.assembleScrollPane.setPreferredSize(null);
        this.assembleTextArea.setMaximumSize(null);
        this.assembleTextArea.setMinimumSize(null);
        this.assembleTextArea.setPreferredSize(null);
        this.assembleScrollPane.setViewportView(this.assembleTextArea);
        GroupLayout assemblePanelLayout = new GroupLayout(this.assemblePanel);
        this.assemblePanel.setLayout(assemblePanelLayout);
        assemblePanelLayout.setHorizontalGroup(assemblePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.assembleScrollPane, GroupLayout.Alignment.CENTER, -1, -1, Short.MAX_VALUE).addGroup(assemblePanelLayout.createSequentialGroup().addComponent(this.assembleLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        assemblePanelLayout.setVerticalGroup(assemblePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(assemblePanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.assembleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assembleScrollPane, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.disassemblePanel.setMaximumSize(null);
        this.disassemblePanel.setPreferredSize(null);
        this.disassembleLabel.setText("Machine code");
        this.disassembleLabel.setMaximumSize(null);
        this.disassembleLabel.setMinimumSize(null);
        this.disassembleLabel.setPreferredSize(null);
        this.disassembleScrollPane.setMaximumSize(null);
        this.disassembleScrollPane.setMinimumSize(null);
        this.disassembleScrollPane.setPreferredSize(null);
        this.disassembleTextArea.setWrapStyleWord(true);
        this.disassembleTextArea.setMaximumSize(null);
        this.disassembleTextArea.setPreferredSize(null);
        this.disassembleScrollPane.setViewportView(this.disassembleTextArea);
        GroupLayout disassemblePanelLayout = new GroupLayout(this.disassemblePanel);
        this.disassemblePanel.setLayout(disassemblePanelLayout);
        disassemblePanelLayout.setHorizontalGroup(disassemblePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disassembleScrollPane, -1, -1, Short.MAX_VALUE).addGroup(disassemblePanelLayout.createSequentialGroup().addComponent(this.disassembleLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        disassemblePanelLayout.setVerticalGroup(disassemblePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disassemblePanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.disassembleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disassembleScrollPane, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.assembleButton.setText("Assemble >");
        this.assembleButton.setMaximumSize(null);
        this.assembleButton.setMinimumSize(null);
        this.assembleButton.setPreferredSize(null);
        this.assembleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsmDasmFrame.this.assembleButtonActionPerformed(evt);
            }
        });
        this.disassembleButton.setText("< Disassemble");
        this.disassembleButton.setMaximumSize(null);
        this.disassembleButton.setMinimumSize(null);
        this.disassembleButton.setPreferredSize(null);
        this.disassembleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsmDasmFrame.this.disassembleButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.assembleButton, -2, -1, -2).addComponent(this.assemblePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.disassembleButton, -2, -1, -2).addComponent(this.disassemblePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.assembleButton, this.disassembleButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disassemblePanel, -1, -1, Short.MAX_VALUE).addComponent(this.assemblePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disassembleButton, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.assembleButton, -2, -1, -2).addContainerGap()))));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void assembleButtonActionPerformed(ActionEvent evt) {
        this.assemble();
    }

    private void disassembleButtonActionPerformed(ActionEvent evt) {
        this.disassemble();
    }
}

