/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import nintaco.util.GuiUtil;

public class YesNoDialog
extends JDialog {
    private boolean yes;
    private JButton noButton;
    private JLabel questionLabel;
    private JButton yesButton;

    public YesNoDialog(Window parent, String message, String title) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.yesButton);
        GuiUtil.scaleFonts(this);
        this.setQuestion(message, title);
    }

    public final void setQuestion(String message, String title) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.questionLabel.setText(message);
        this.questionLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isNo() {
        return !this.yes;
    }

    public boolean isYes() {
        return this.yes;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.questionLabel = new JLabel();
        this.noButton = new JButton();
        this.yesButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                YesNoDialog.this.formWindowClosing(evt);
            }
        });
        this.questionLabel.setText(" ");
        this.questionLabel.setIconTextGap(16);
        this.noButton.setMnemonic('N');
        this.noButton.setText("No");
        this.noButton.setFocusPainted(false);
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                YesNoDialog.this.noButtonActionPerformed(evt);
            }
        });
        this.yesButton.setMnemonic('Y');
        this.yesButton.setText("   Yes   ");
        this.yesButton.setFocusPainted(false);
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                YesNoDialog.this.yesButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.questionLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 90, Short.MAX_VALUE).addComponent(this.yesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noButton))).addGap(15, 15, 15)));
        layout.linkSize(0, this.noButton, this.yesButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.questionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noButton).addComponent(this.yesButton)).addGap(15, 15, 15)));
    }

    private void yesButtonActionPerformed(ActionEvent evt) {
        this.yes = true;
        this.closeDialog();
    }

    private void noButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

