/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import nintaco.preferences.AppPrefs;

public abstract class VectorIcon
implements Icon {
    private static final int SIZE = 16;
    private final double sizeScale;
    private final boolean flippedHorizontally;
    private final boolean flippedVertically;

    public VectorIcon() {
        this(1.0, false, false);
    }

    public VectorIcon(double sizeScale) {
        this(sizeScale, false, false);
    }

    public VectorIcon(double sizeScale, boolean flippedHorizontally, boolean flippedVertically) {
        this.sizeScale = sizeScale;
        this.flippedHorizontally = flippedHorizontally;
        this.flippedVertically = flippedVertically;
    }

    @Override
    public void paintIcon(Component c, Graphics G, int x, int y) {
        double sy;
        double sx;
        double ty;
        double tx;
        double scale;
        Graphics2D g = (Graphics2D)G;
        RenderingHints renderingHints = g.getRenderingHints();
        AffineTransform transform = g.getTransform();
        double paintWidth = this.getPaintWidth();
        double paintHeight = this.getPaintHeight();
        double side = this.getIconWidth();
        if (paintHeight > paintWidth) {
            scale = side / paintHeight;
            tx = (double)x + (side - paintWidth * scale) / 2.0;
            ty = y;
        } else {
            scale = side / paintWidth;
            tx = x;
            ty = (double)y + (side - paintHeight * scale) / 2.0;
        }
        if (this.flippedHorizontally) {
            sx = -scale;
            tx += side;
        } else {
            sx = scale;
        }
        if (this.flippedVertically) {
            sy = -scale;
            ty += side;
        } else {
            sy = scale;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(tx, ty);
        g.scale(sx, sy);
        this.paintIcon(c.isEnabled(), g);
        g.setTransform(transform);
        g.setRenderingHints(renderingHints);
    }

    protected abstract double getPaintWidth();

    protected abstract double getPaintHeight();

    protected abstract void paintIcon(boolean var1, Graphics2D var2);

    protected void renderPath(boolean enabled, Graphics2D g, Path2D.Double path, double x, double y) {
        AffineTransform transform = g.getTransform();
        g.translate(x, y);
        if (enabled) {
            g.setColor(Color.WHITE);
            g.fill(path);
        }
        g.setColor(enabled ? Color.BLACK : Color.GRAY);
        g.draw(path);
        g.setTransform(transform);
    }

    @Override
    public int getIconWidth() {
        return (int)Math.ceil(16.0 * this.sizeScale * (double)AppPrefs.getInstance().getView().getFontScale());
    }

    @Override
    public int getIconHeight() {
        return this.getIconWidth();
    }
}

