/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class RadioSelectionDialog
extends JDialog {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton[] radioButtons;
    private boolean ok;
    private int selectedIndex = -1;
    private JButton cancelButton;
    private JLabel iconLabel;
    private JPanel iconPanel;
    private JButton okButton;
    private JLabel promptLabel;
    private JPanel promptPanel;
    private JPanel radioButtonPanel;

    public RadioSelectionDialog(Window parent, String message, String title, int defaultOption, String ... options) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initRadioButtons(options, defaultOption);
        this.setPrompt(message, title);
    }

    public boolean isOk() {
        return this.ok;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(visible);
    }

    private void initRadioButtons(String[] options, int defaultOption) {
        GroupLayout radioButtonPanelLayout = new GroupLayout(this.radioButtonPanel);
        this.radioButtonPanel.setLayout(radioButtonPanelLayout);
        GroupLayout.ParallelGroup parallelGroup = radioButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup sequentialGroup = radioButtonPanelLayout.createSequentialGroup();
        this.radioButtons = new JRadioButton[options.length];
        for (int i = 0; i < options.length; ++i) {
            this.radioButtons[i] = new JRadioButton(options[i]);
            this.buttonGroup.add(this.radioButtons[i]);
            parallelGroup.addComponent(this.radioButtons[i]);
            if (i > 0) {
                sequentialGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            }
            sequentialGroup.addComponent(this.radioButtons[i]);
        }
        sequentialGroup.addGap(0, 0, Short.MAX_VALUE);
        radioButtonPanelLayout.setHorizontalGroup(radioButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(radioButtonPanelLayout.createSequentialGroup().addGroup(parallelGroup).addGap(0, 0, Short.MAX_VALUE)));
        radioButtonPanelLayout.setVerticalGroup(radioButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequentialGroup));
        this.radioButtons[defaultOption].setSelected(true);
    }

    public final void setPrompt(String message, String title) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.promptLabel.setText(message);
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
    }

    public void setOkButtonMnemonic(char mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public void setCancelButtonMnemonic(char mnemonic) {
        this.cancelButton.setMnemonic(mnemonic);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.iconPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.promptPanel = new JPanel();
        this.promptLabel = new JLabel();
        this.radioButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RadioSelectionDialog.this.formWindowClosing(evt);
            }
        });
        this.iconLabel.setText(" ");
        this.iconLabel.setPreferredSize(null);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel, -1, -1, Short.MAX_VALUE));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addComponent(this.iconLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.promptLabel.setText(" ");
        this.promptLabel.setPreferredSize(null);
        GroupLayout radioButtonPanelLayout = new GroupLayout(this.radioButtonPanel);
        this.radioButtonPanel.setLayout(radioButtonPanelLayout);
        radioButtonPanelLayout.setHorizontalGroup(radioButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        radioButtonPanelLayout.setVerticalGroup(radioButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 127, Short.MAX_VALUE));
        GroupLayout promptPanelLayout = new GroupLayout(this.promptPanel);
        this.promptPanel.setLayout(promptPanelLayout);
        promptPanelLayout.setHorizontalGroup(promptPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.promptLabel, -1, -1, Short.MAX_VALUE).addComponent(this.radioButtonPanel, -1, -1, Short.MAX_VALUE));
        promptPanelLayout.setVerticalGroup(promptPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(promptPanelLayout.createSequentialGroup().addComponent(this.promptLabel, -2, -1, -2).addGap(15, 15, 15).addComponent(this.radioButtonPanel, -1, -1, Short.MAX_VALUE)));
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RadioSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RadioSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.iconPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.promptPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addGap(15, 15, 15)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.promptPanel, -1, -1, Short.MAX_VALUE).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton))).addComponent(this.iconPanel, -1, -1, Short.MAX_VALUE)).addGap(15, 15, 15)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        for (int i = this.radioButtons.length - 1; i >= 0; --i) {
            if (!this.radioButtons[i].isSelected()) continue;
            this.selectedIndex = i;
            break;
        }
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

