/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import nintaco.util.GuiUtil;

public class ProgressDialog
extends JDialog {
    private final Runnable cancelListener;
    private JButton cancelButton;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    public ProgressDialog(Window parent, Runnable cancelListener) {
        super(parent);
        this.setModal(true);
        this.cancelListener = cancelListener;
        this.initComponents();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setMessage(String message) {
        if (EventQueue.isDispatchThread()) {
            this.messageLabel.setText(message);
        } else {
            EventQueue.invokeLater(() -> this.setMessage(message));
        }
    }

    public void setMinimum(int minimum) {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setMinimum(minimum);
        } else {
            EventQueue.invokeLater(() -> this.setMinimum(minimum));
        }
    }

    public void setMaximum(int maximum) {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setMaximum(maximum);
        } else {
            EventQueue.invokeLater(() -> this.setMaximum(maximum));
        }
    }

    public void setValue(int value) {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setValue(value);
        } else {
            EventQueue.invokeLater(() -> this.setValue(value));
        }
    }

    @Override
    public void dispose() {
        if (EventQueue.isDispatchThread()) {
            super.dispose();
        } else {
            EventQueue.invokeLater(this::dispose);
        }
    }

    private void cancel() {
        if (this.cancelListener != null) {
            this.cancelListener.run();
        }
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialog.this.formWindowClosing(evt);
            }
        });
        this.messageLabel.setText("Please wait...");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.progressBar, -1, 513, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }
}

