/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nintaco.App;
import nintaco.preferences.AppPrefs;

public final class PauseMenuListener
implements MenuListener {
    private static final PauseMenuListener INSTANCE = new PauseMenuListener();
    private int selectedMenus;
    private boolean paused;

    public static void addPauseMenuListener(JMenuBar menuBar) {
        for (Component c : menuBar.getComponents()) {
            ((JMenu)c).addMenuListener(INSTANCE);
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.menuSelectionChanged(1);
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        EventQueue.invokeLater(() -> this.menuSelectionChanged(-1));
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    private void menuSelectionChanged(int delta) {
        if (this.selectedMenus == 0 && delta > 0) {
            if (AppPrefs.getInstance().getUserInterfacePrefs().isPauseMenu()) {
                this.paused = true;
                App.setNoStepPause(true);
            }
        } else if (this.selectedMenus + delta == 0 && this.paused) {
            this.paused = false;
            App.setNoStepPause(false);
        }
        this.selectedMenus += delta;
    }

    private PauseMenuListener() {
    }
}

