/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import nintaco.util.GuiUtil;

public class InputTextAreaDialog
extends JDialog {
    private boolean ok;
    private String input;
    private boolean textRequired;
    private DocumentListener documentListener;
    private JButton cancelButton;
    private JLabel iconLabel;
    private JPanel inputPanel;
    private JButton okButton;
    private JLabel promptLabel;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public InputTextAreaDialog(Window parent, String message, String title) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initDocumentListener();
        this.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.scaleFonts(this);
        this.setPrompt(message, title);
    }

    private void initDocumentListener() {
        this.documentListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.textArea.getDocument().addDocumentListener(this.documentListener);
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(visible);
    }

    public void makeMonospaced() {
        GuiUtil.makeMonospaced(this.textArea);
    }

    public void setDimensions(int columns, int rows) {
        this.textArea.setColumns(columns);
        this.textArea.setRows(rows);
    }

    public void setInput(String input) {
        if (input == null) {
            return;
        }
        this.textArea.getDocument().removeDocumentListener(this.documentListener);
        this.textArea.setText(input);
        this.textArea.getDocument().addDocumentListener(this.documentListener);
        this.textArea.selectAll();
        this.enableComponents();
        this.textArea.requestFocus();
    }

    private void enableComponents() {
        this.okButton.setEnabled(!this.textRequired || !this.textArea.getText().isEmpty());
    }

    public void setTextRequired() {
        this.textRequired = true;
        this.enableComponents();
    }

    public final void setPrompt(String message, String title) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.promptLabel.setText(message);
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.textArea.requestFocus();
    }

    public void setOkButtonMnemonic(char mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public void setCancelButtonMnemonic(char mnemonic) {
        this.cancelButton.setMnemonic(mnemonic);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public String getInput() {
        return this.input;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.inputPanel = new JPanel();
        this.promptLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.iconLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InputTextAreaDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setLabel("   Cancel   ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputTextAreaDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputTextAreaDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.promptLabel.setText(" ");
        this.scrollPane.setMaximumSize(null);
        this.scrollPane.setMinimumSize(null);
        this.textArea.setColumns(28);
        this.textArea.setRows(5);
        this.textArea.setMaximumSize(null);
        this.textArea.setMinimumSize(null);
        this.textArea.setPreferredSize(null);
        this.scrollPane.setViewportView(this.textArea);
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputPanelLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addComponent(this.promptLabel, -1, -1, Short.MAX_VALUE)).addGap(1, 1, 1)));
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.iconLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.iconLabel, -2, 50, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addGap(15, 15, 15)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addGap(15, 15, 15)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.input = this.textArea.getText();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

