/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import nintaco.util.GuiUtil;

public class FourButtonDialog
extends JDialog {
    private int selection;
    private JButton button0;
    private JButton button1;
    private JButton button2;
    private JButton button3;
    private JLabel messageLabel;

    public FourButtonDialog(Window parent, String message, String title) {
        this(parent, message, title, IconType.QUESTION);
    }

    public FourButtonDialog(Window parent, String message, String title, IconType iconType) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.button0);
        this.setMessage(message, title, iconType);
        GuiUtil.scaleFonts(this);
    }

    public void setButtonText(int index, String name, int mnemonic) {
        JButton button = null;
        switch (index) {
            case 0: {
                button = this.button0;
                break;
            }
            case 1: {
                button = this.button1;
                break;
            }
            case 2: {
                button = this.button2;
                break;
            }
            case 3: {
                button = this.button3;
            }
        }
        if (button != null) {
            button.setText(name);
            button.setMnemonic(mnemonic);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(visible);
    }

    public final void setMessage(String message, String title) {
        this.setMessage(message, title, IconType.QUESTION);
    }

    public final void setMessage(String message, String title, IconType iconType) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.messageLabel.setText(message);
        if (iconType == null) {
            this.messageLabel.setIcon(null);
        } else {
            String iconName;
            switch (iconType) {
                case ERROR: {
                    iconName = "OptionPane.errorIcon";
                    break;
                }
                case WARNING: {
                    iconName = "OptionPane.warningIcon";
                    break;
                }
                case INFORMATION: {
                    iconName = "OptionPane.informationIcon";
                    break;
                }
                default: {
                    iconName = "OptionPane.questionIcon";
                }
            }
            this.messageLabel.setIcon(UIManager.getIcon(iconName));
        }
    }

    public int getSelection() {
        return this.selection;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.button1 = new JButton();
        this.button0 = new JButton();
        this.button2 = new JButton();
        this.button3 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FourButtonDialog.this.formWindowClosing(evt);
            }
        });
        this.messageLabel.setText(" ");
        this.messageLabel.setIconTextGap(16);
        this.button1.setMnemonic('1');
        this.button1.setText("Button 1");
        this.button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FourButtonDialog.this.button1ActionPerformed(evt);
            }
        });
        this.button0.setMnemonic('0');
        this.button0.setText("Button 0");
        this.button0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FourButtonDialog.this.button0ActionPerformed(evt);
            }
        });
        this.button2.setMnemonic('2');
        this.button2.setText("Button 2");
        this.button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FourButtonDialog.this.button2ActionPerformed(evt);
            }
        });
        this.button3.setMnemonic('3');
        this.button3.setText("Button 3");
        this.button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FourButtonDialog.this.button3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.button0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.button1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.button2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.button3))).addGap(15, 15, 15)));
        layout.linkSize(0, this.button0, this.button1, this.button2, this.button3);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.messageLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button1).addComponent(this.button0).addComponent(this.button2).addComponent(this.button3)).addContainerGap(15, Short.MAX_VALUE)));
    }

    private void button0ActionPerformed(ActionEvent evt) {
        this.selection = 0;
        this.closeDialog();
    }

    private void button1ActionPerformed(ActionEvent evt) {
        this.selection = 1;
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.selection = -1;
        this.closeDialog();
    }

    private void button2ActionPerformed(ActionEvent evt) {
        this.selection = 2;
        this.closeDialog();
    }

    private void button3ActionPerformed(ActionEvent evt) {
        this.selection = 3;
        this.closeDialog();
    }

    public static enum IconType {
        QUESTION,
        INFORMATION,
        ERROR,
        WARNING;

    }
}

