/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nintaco.util.GuiUtil;

public class FontSizeDialog
extends JDialog {
    private final Font defaultFont;
    private float fontScale = 1.0f;
    private boolean fontScaleChanged;
    private JButton cancelButton;
    private JButton okButton;
    private JButton restoreDefaultButton;
    private JSlider sizeSlider;
    private JLabel textLabel;

    public FontSizeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.defaultFont = this.textLabel.getFont();
        this.initTextLabel();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initTextLabel() {
        FontMetrics metrics = this.textLabel.getFontMetrics(this.textLabel.getFont());
        this.textLabel.setPreferredSize(new Dimension(100 * metrics.charWidth('M'), metrics.getHeight() * 10));
    }

    private void closeDialog() {
        this.dispose();
    }

    public boolean isFontScaleChanged() {
        return this.fontScaleChanged;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
        this.sizeSlider.setValue((int)(1000.0f * fontScale));
        this.updateTextLabel();
    }

    public float getFontScale() {
        return this.fontScale;
    }

    private void updateTextLabel() {
        this.textLabel.setText(String.format("<html><center>Adjust the slider below to change the font size.<br/>(%d%%)</center></html>", Math.round(100.0f * this.fontScale)));
        this.textLabel.setFont(this.defaultFont.deriveFont(this.defaultFont.getSize2D() * this.fontScale));
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.sizeSlider = new JSlider();
        this.cancelButton = new JButton();
        this.restoreDefaultButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Font Size");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FontSizeDialog.this.formWindowClosing(evt);
            }
        });
        this.textLabel.setHorizontalAlignment(0);
        this.textLabel.setText("<html>Adjust the slider below to change the font size.</html>");
        this.textLabel.setMaximumSize(null);
        this.textLabel.setMinimumSize(null);
        this.textLabel.setPreferredSize(null);
        this.sizeSlider.setMajorTickSpacing(200);
        this.sizeSlider.setMaximum(3000);
        this.sizeSlider.setMinimum(1000);
        this.sizeSlider.setPaintTicks(true);
        this.sizeSlider.setFocusable(false);
        this.sizeSlider.setMaximumSize(null);
        this.sizeSlider.setMinimumSize(null);
        this.sizeSlider.setPreferredSize(null);
        this.sizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FontSizeDialog.this.sizeSliderStateChanged(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSizeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.restoreDefaultButton.setMnemonic('R');
        this.restoreDefaultButton.setText("Reset");
        this.restoreDefaultButton.setFocusPainted(false);
        this.restoreDefaultButton.setMaximumSize(null);
        this.restoreDefaultButton.setMinimumSize(null);
        this.restoreDefaultButton.setPreferredSize(null);
        this.restoreDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSizeDialog.this.restoreDefaultButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSizeDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLabel, -1, -1, Short.MAX_VALUE).addComponent(this.sizeSlider, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.restoreDefaultButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton, this.restoreDefaultButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.textLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sizeSlider, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.restoreDefaultButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
    }

    private void sizeSliderStateChanged(ChangeEvent evt) {
        this.fontScale = (float)this.sizeSlider.getValue() / 1000.0f;
        this.updateTextLabel();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.fontScaleChanged = true;
        this.closeDialog();
    }

    private void restoreDefaultButtonActionPerformed(ActionEvent evt) {
        this.sizeSlider.setValue(1000);
        this.fontScale = 1.0f;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

