/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import nintaco.files.ArchiveEntry;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.archive.ArchiveFileChooser;
import nintaco.gui.image.preferences.Paths;
import nintaco.util.GuiUtil;

public class BrowsePanel
extends JPanel {
    private Window window;
    private String fileChooserTitle;
    private String defaultDirectory;
    private String fileExtension;
    private boolean showOpenFileChooser;
    private BiConsumer<Paths, String> saveDirectoryConsumer;
    private FileFilter[] fileFilters;
    private Runnable browseButtonListener;
    private Runnable fileNameSetListener;
    private int fileSelectionMode = 0;
    private JButton browseButton;
    private JTextField fileTextField;

    public BrowsePanel(Window window) {
        this();
        this.setWindow(window);
    }

    public BrowsePanel() {
        this.initComponents();
        this.setPreferredSize(null);
        this.fileTextField.setColumns(60);
        GuiUtil.addTextFieldEditListener(this.fileTextField, this::textFieldEdited);
    }

    private void textFieldEdited() {
        if (this.fileNameSetListener != null) {
            this.fileNameSetListener.run();
        }
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setWindow(Window window) {
        this.window = window;
        GuiUtil.addLoseFocusListener(window, this.fileTextField);
    }

    public String getFileName() {
        return this.fileTextField.getText().trim();
    }

    public void setFileName(String fileName) {
        this.fileTextField.setText(fileName);
    }

    public void setBrowseButtonListener(Runnable browseButtonListener) {
        this.browseButtonListener = browseButtonListener;
    }

    public Runnable getBrowseButtonListener() {
        return this.browseButtonListener;
    }

    public Runnable getFileNameSetListener() {
        return this.fileNameSetListener;
    }

    public void setFileNameSetListener(Runnable fileNameSetListener) {
        this.fileNameSetListener = fileNameSetListener;
    }

    public void addFileTextFieldEditedListener(Runnable runnable) {
        GuiUtil.addTextFieldEditListener(this.fileTextField, runnable);
    }

    public FileFilter[] getFileFilters() {
        return this.fileFilters;
    }

    public void setFileFilters(FileFilter ... fileFilters) {
        this.fileFilters = fileFilters;
    }

    public BiConsumer<Paths, String> getSaveDirectoryConsumer() {
        return this.saveDirectoryConsumer;
    }

    public void setSaveDirectoryConsumer(BiConsumer<Paths, String> saveDirectoryConsumer) {
        this.saveDirectoryConsumer = saveDirectoryConsumer;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileChooserTitle() {
        return this.fileChooserTitle;
    }

    public void setFileChooserTitle(String fileChooserTitle) {
        this.fileChooserTitle = fileChooserTitle;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(String defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    public boolean isShowOpenFileChooser() {
        return this.showOpenFileChooser;
    }

    public void setShowOpenFileChooser(boolean showOpenFileChooser) {
        this.showOpenFileChooser = showOpenFileChooser;
    }

    private void displaySaveAsFileChooser(String enteredDir, String enteredFile) {
        File file = GuiUtil.showSaveAsDialog(this.window, enteredDir, enteredFile, this.fileExtension, this.fileFilters == null ? null : this.fileFilters[0], false, this.fileChooserTitle);
        if (file != null) {
            this.fileTextField.setText(file.getPath());
            if (this.browseButtonListener != null) {
                this.browseButtonListener.run();
            }
            if (this.fileNameSetListener != null) {
                this.fileNameSetListener.run();
            }
        }
    }

    private void displayOpenFileChooser(String enteredDir) {
        JFileChooser chooser = GuiUtil.createFileChooser(this.fileChooserTitle, enteredDir, this.fileFilters);
        chooser.setFileSelectionMode(this.fileSelectionMode);
        if (GuiUtil.showOpenDialog(this, chooser, this.saveDirectoryConsumer) == 0) {
            String fileName = chooser.getSelectedFile().toString();
            if (this.fileSelectionMode != 1 && !FileUtil.isDirectory(fileName) && FileUtil.isArchiveFile(fileName)) {
                PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog(this.window);
                pleaseWaitDialog.setMessage("Opening archive file...");
                new Thread(() -> this.openArchiveFile(fileName, pleaseWaitDialog)).start();
                pleaseWaitDialog.showAfterDelay();
            } else {
                this.fileTextField.setText(fileName);
                if (this.browseButtonListener != null) {
                    this.browseButtonListener.run();
                }
                if (this.fileNameSetListener != null) {
                    this.fileNameSetListener.run();
                }
            }
        }
    }

    private void openArchiveFile(String archiveFileName, PleaseWaitDialog pleaseWaitDialog) {
        List<String> entries = null;
        try {
            entries = ArchiveEntry.toNames(FileUtil.getArchiveEntries(archiveFileName, null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List<String> files = entries;
        pleaseWaitDialog.dispose();
        if (files == null) {
            GuiUtil.displayError(this.window, "Failed to open archive file.");
        } else {
            switch (files.size()) {
                case 0: {
                    GuiUtil.displayError(this.window, "The archive does not contain any files.");
                    break;
                }
                case 1: {
                    EventQueue.invokeLater(() -> {
                        this.fileTextField.setText(new FilePath((String)files.get(0), archiveFileName).toLongString());
                        if (this.browseButtonListener != null) {
                            this.browseButtonListener.run();
                        }
                        if (this.fileNameSetListener != null) {
                            this.fileNameSetListener.run();
                        }
                    });
                    break;
                }
                default: {
                    EventQueue.invokeLater(() -> this.showArchiveFileChooser(archiveFileName, files));
                }
            }
        }
    }

    private void showArchiveFileChooser(String archiveFileName, List<String> files) {
        ArchiveFileChooser archiveChooser = new ArchiveFileChooser(this.window, files, -1);
        archiveChooser.setVisible(true);
        String entryFileName = archiveChooser.getSelectedFile();
        if (entryFileName != null) {
            this.fileTextField.setText(new FilePath(entryFileName, archiveFileName).toLongString());
            if (this.browseButtonListener != null) {
                this.browseButtonListener.run();
            }
            if (this.fileNameSetListener != null) {
                this.fileNameSetListener.run();
            }
        }
    }

    private void initComponents() {
        this.fileTextField = new JTextField();
        this.browseButton = new JButton();
        this.fileTextField.setColumns(60);
        this.fileTextField.setMaximumSize(null);
        this.fileTextField.setMinimumSize(null);
        this.fileTextField.setPreferredSize(null);
        this.browseButton.setText("Browse...");
        this.browseButton.setMaximumSize(null);
        this.browseButton.setMinimumSize(null);
        this.browseButton.setPreferredSize(null);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowsePanel.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.browseButton, -2, -1, -2)).addContainerGap()));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String enteredDir;
        String enteredFile = "";
        String enteredFilePath = this.fileTextField.getText().trim();
        if (!enteredFilePath.isEmpty()) {
            int lt = enteredFilePath.indexOf(60);
            if (lt >= 0) {
                int gt = enteredFilePath.indexOf(62, lt + 1);
                enteredFile = gt >= 0 ? enteredFilePath.substring(lt + 1, gt) : enteredFilePath.substring(lt + 1);
                enteredFilePath = enteredFilePath.substring(0, lt);
            } else if (!FileUtil.isDirectory(enteredFilePath)) {
                enteredFile = FileUtil.getFileName(enteredFilePath);
            }
            enteredDir = FileUtil.getDirectoryPath(enteredFilePath);
        } else {
            enteredDir = null;
        }
        if (enteredDir == null) {
            enteredDir = this.defaultDirectory;
        }
        if (this.showOpenFileChooser) {
            this.displayOpenFileChooser(enteredDir);
        } else {
            this.displaySaveAsFileChooser(enteredDir, enteredFile);
        }
    }
}

