/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import nintaco.files.NesFile;
import nintaco.util.BitUtil;
import nintaco.util.StreamUtil;

public class MutableNesFile
extends NesFile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;

    public MutableNesFile(DataInputStream in, long fileSize) throws Throwable {
        this(in, fileSize, "", "");
    }

    public MutableNesFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName) throws Throwable {
        super(in, fileSize, entryFileName, archiveFileName, false);
    }

    @Override
    protected void readROMs(DataInputStream in, long fileSize) throws Throwable {
        this.trainer = new int[0];
        this.chrROM = new int[0];
        this.prgROM = new int[(int)(fileSize - (long)this.header.length)];
        StreamUtil.readBytes(in, this.prgROM);
    }

    public void write(String fileName) throws Throwable {
        this.write(new File(fileName));
    }

    public void write(File file) throws Throwable {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            this.write(out);
        }
    }

    public void write(DataOutputStream out) throws Throwable {
        StreamUtil.writeString(out, "NES\u001a");
        out.write(this.prgRomPages);
        out.write(this.chrRomPages);
        int _6 = (this.mapperNumber & 0xF) << 4;
        _6 = BitUtil.setBit(_6, 1, this.nonVolatilePrgRamPresent);
        _6 = BitUtil.setBit(_6, 2, this.trainerPresent);
        if (this.mirroring == 0) {
            _6 = BitUtil.setBit(_6, 0);
        } else if (this.mirroring == 4) {
            _6 = BitUtil.setBit(_6, 3);
        }
        out.write(_6);
        int _7 = this.mapperNumber & 0xF0 | this.console & 3;
        _7 = BitUtil.setBit(_7, 3, this.nes20Format);
        out.write(_7);
        if (this.nes20Format) {
            int D;
            out.write((this.submapperNumber & 0xF) << 4 | this.mapperNumber >> 8 & 0xF);
            out.write(this.chrRomPages >> 4 & 0xF0 | this.prgRomPages >> 8 & 0xF);
            out.write((this.encodeRamSize(this.nonVolatilePrgRamSize) & 0xF) << 4 | this.encodeRamSize(this.prgRamSize) & 0xF);
            out.write((this.encodeRamSize(this.nonVolatileChrRamSize) & 0xF) << 4 | this.encodeRamSize(this.chrRamSize) & 0xF);
            out.write(this.cpuPpuTiming & 3);
            switch (this.console) {
                case 1: {
                    D = (this.vsHardware & 0xF) << 4 | this.vsPPU & 0xF;
                    break;
                }
                default: {
                    D = this.extendedConsole & 0xF;
                }
            }
            out.write(D);
            out.write(this.miscellaneousROMs & 3);
            out.write(this.defaultExpansionDevice & 0x3F);
        } else {
            out.write(this.prgRamSize / 8192);
            out.write(this.cpuPpuTiming == 1 ? 1 : 0);
            out.write(new byte[6]);
        }
        StreamUtil.writeBytes(out, this.prgROM);
    }

    private int encodeRamSize(int ramSize) {
        if (ramSize == 0) {
            return 0;
        }
        return BitUtil.log2(ramSize) - 6;
    }

    public void setChrRomPages(int chrRomPages) {
        this.chrRomPages = chrRomPages;
    }

    public void setPrgRomPages(int prgRomPages) {
        this.prgRomPages = prgRomPages;
    }

    public void setPrgRamSize(int prgRamSize) {
        this.prgRamSize = prgRamSize;
    }

    public void setSubmapperNumber(int submapperNumber) {
        this.submapperNumber = submapperNumber;
    }

    public void setMirroring(int mirroring) {
        this.mirroring = mirroring;
    }

    public void setNonVolatilePrgRamSize(int NonVolatilePrgRamSize) {
        this.nonVolatilePrgRamSize = NonVolatilePrgRamSize;
    }

    public void setNonVolatileChrRamSize(int NonVolatileChrRamSize) {
        this.nonVolatileChrRamSize = NonVolatileChrRamSize;
    }

    public void setChrRamSize(int chrRamSize) {
        this.chrRamSize = chrRamSize;
    }

    public void setPrgRamPages(int prgRamPages) {
        this.prgRamPages = prgRamPages;
    }

    public void setTrainerPresent(boolean trainerPresent) {
        this.trainerPresent = trainerPresent;
    }

    public void setCpuPpuTiming(int cpuPpuTiming) {
        this.cpuPpuTiming = cpuPpuTiming;
    }

    public void setVsPPU(int vsPPU) {
        this.vsPPU = vsPPU;
    }

    public void setVsHardware(int vsHardware) {
        this.vsHardware = vsHardware;
    }

    public void setNonVolatilePrgRamPresent(boolean sramPresent) {
        this.nonVolatilePrgRamPresent = sramPresent;
    }

    public void setConsole(int console) {
        this.console = console;
    }

    public void setExtendedConsole(int extendedConsole) {
        this.extendedConsole = extendedConsole;
    }

    public void setMiscellaneousROMs(int miscellaneousROMs) {
        this.miscellaneousROMs = miscellaneousROMs;
    }

    public void setDefaultExpansionDevice(int defaultExpansionDevice) {
        this.defaultExpansionDevice = defaultExpansionDevice;
    }

    public void setNes20Format(boolean nintaco20Format) {
        this.nes20Format = nintaco20Format;
    }

    public void setMapperNumber(int mapperNumber) {
        this.mapperNumber = mapperNumber;
    }

    public MutableNesFile copy() {
        try {
            return (MutableNesFile)this.clone();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

