/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import nintaco.MessageException;
import nintaco.files.FileUtil;
import nintaco.files.IFile;
import nintaco.util.MathUtil;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;

public class FdsFile
implements IFile,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final String HEADER_ID = "FDS\u001a";
    public static final String DISK_VERIFICATION = "*NINTENDO-HVC*";
    public static final int SIDE_SIZE = 65500;
    private final String fileName;
    private String entryFileName;
    private String archiveFileName;
    private final String description;
    private transient int[][] diskData;
    private transient int[] bios;
    private int[] header;
    private long fileSize;

    public FdsFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName, int[] bios) throws Throwable {
        int totalSides;
        this.fileSize = fileSize;
        this.bios = bios;
        this.entryFileName = entryFileName;
        this.archiveFileName = archiveFileName;
        this.fileName = FileUtil.getFileName(entryFileName).toLowerCase(Locale.ENGLISH);
        in.mark(256);
        this.header = new int[16];
        StreamUtil.readByteArray(in, this.header, 0, this.header.length, true);
        if (StringUtil.compareStrings(HEADER_ID, this.header)) {
            totalSides = MathUtil.clamp(this.header[4], 1, 8);
        } else {
            this.header = new int[0];
            in.reset();
            in.skipBytes(1);
            if (!DISK_VERIFICATION.equals(StreamUtil.readString(in, DISK_VERIFICATION.length()))) {
                throw new MessageException("Not Family Computer Disk System file format.");
            }
            totalSides = MathUtil.clamp((int)(Math.max(65500L, fileSize) / 65500L), 1, 8);
            in.reset();
        }
        this.diskData = new int[totalSides][65536];
        for (int i = 0; i < totalSides; ++i) {
            StreamUtil.readByteArray(in, this.diskData[i], 0, 65500, true);
        }
        StringBuilder sb = new StringBuilder();
        if (archiveFileName != null) {
            StringUtil.appendLine(sb, "File name: %s <%s>", FileUtil.getFileName(archiveFileName), FileUtil.getFileName(entryFileName));
            StringUtil.appendLine(sb, "Directory: %s", FileUtil.getDirectoryPath(archiveFileName));
        } else {
            StringUtil.appendLine(sb, "File name: %s", FileUtil.getFileName(entryFileName));
            StringUtil.appendLine(sb, "Directory: %s", FileUtil.getDirectoryPath(entryFileName));
        }
        StringUtil.appendLine(sb, "File format: FDS", new Object[0]);
        StringUtil.appendLine(sb, "Disk sides: %d", this.diskData.length);
        this.description = sb.toString();
    }

    public String getEntryFileName() {
        return this.entryFileName;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int[][] getDiskData() {
        return this.diskData;
    }

    public int[] getBios() {
        return this.bios;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getFileType() {
        return 2;
    }

    public String toString() {
        return this.description;
    }

    public int[] getFileContents() {
        int length;
        int[] data = new int[(int)this.fileSize];
        System.arraycopy(this.header, 0, data, 0, this.header.length);
        int side = 0;
        int offset = this.header.length;
        while (side < this.diskData.length && (length = Math.min(data.length - offset, 65500)) > 0) {
            System.arraycopy(this.diskData[side], 0, data, offset, length);
            ++side;
            offset += 65500;
        }
        return data;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bios = StreamUtil.readByteArray(in);
        this.diskData = StreamUtil.read2DByteArray(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        StreamUtil.writeByteArray(out, this.bios);
        StreamUtil.write2DByteArray(out, this.diskData);
    }
}

