/*
 * Decompiled with CFR 0.152.
 */
package nintaco.assembler;

public class InstructionKey
implements Comparable<InstructionKey> {
    private String mnemonic;
    private int patternIndex;
    private int labelType;
    private int hash;

    public InstructionKey() {
    }

    public InstructionKey(String mnemonic, int patternIndex, int labelType) {
        this.mnemonic = mnemonic;
        this.patternIndex = patternIndex;
        this.labelType = labelType;
        this.updateHash();
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
        this.updateHash();
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    public void setPatternIndex(int patternIndex) {
        this.patternIndex = patternIndex;
        this.updateHash();
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int labelType) {
        this.labelType = labelType;
        this.updateHash();
    }

    private void updateHash() {
        this.hash = this.mnemonic.hashCode() ^ this.patternIndex << 8 ^ this.labelType;
    }

    public boolean equals(Object obj) {
        InstructionKey key = (InstructionKey)obj;
        return this.patternIndex == key.patternIndex && this.labelType == key.labelType && this.mnemonic.equals(key.mnemonic);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(InstructionKey key) {
        int v = this.mnemonic.compareTo(key.mnemonic);
        if (v == 0) {
            v = Integer.compare(this.patternIndex, key.patternIndex);
            if (v == 0) {
                return Integer.compare(this.labelType, key.labelType);
            }
            return v;
        }
        return v;
    }
}

