/*
 * Decompiled with CFR 0.152.
 */
package nintaco;

import nintaco.PPU;

public class PPU2C05
extends PPU {
    private final int ppuStatusID;

    public PPU2C05(int ppuStatusID) {
        this.ppuStatusID = ppuStatusID;
    }

    @Override
    public void writeRegister(int register, int value) {
        switch (register) {
            case 8192: {
                super.writeRegister(8193, value);
                break;
            }
            case 8193: {
                super.writeRegister(8192, value);
                break;
            }
            default: {
                super.writeRegister(register, value);
            }
        }
    }

    private int applyStatusID(int register, int value) {
        return register == 8194 ? value & 0xC0 | this.ppuStatusID : value;
    }

    @Override
    public int peekRegister(int register) {
        return this.applyStatusID(register, super.peekRegister(register));
    }

    @Override
    public int readRegister(int register) {
        return this.applyStatusID(register, super.readRegister(register));
    }
}

